/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.misc.MiscConfig;
import at.hannibal2.skyhanni.data.jsonobjects.repo.CarryTrackerJson;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.data.repo.RepoManager;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.entity.slayer.SlayerDeathEvent;
import at.hannibal2.skyhanni.features.slayer.SlayerType;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.KeyboardManager;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004Z[\\]B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001b\u0010\u0015\u001a\u00020\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0019\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0017\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b \u0010!J\u001b\u0010$\u001a\u00020#*\u00020\u00182\u0006\u0010\"\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b&\u0010\u0003J%\u0010+\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u001f2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020)0(H\u0002\u00a2\u0006\u0004\b+\u0010,J\u0015\u0010/\u001a\u0004\u0018\u00010.*\u00020-H\u0002\u00a2\u0006\u0004\b/\u00100J\u0019\u00102\u001a\u00020\u00132\b\u00101\u001a\u0004\u0018\u00010.H\u0002\u00a2\u0006\u0004\b2\u00103J\u0019\u00105\u001a\u0004\u0018\u00010\u00182\u0006\u00104\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b5\u0010\u001aJ\u0019\u00108\u001a\u0004\u0018\u0001072\u0006\u00106\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b8\u00109R\u001c\u0010>\u001a\n ;*\u0004\u0018\u00010:0:8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u001a\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001f0(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u0010@R \u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00180A8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bB\u0010CR(\u0010F\u001a\u0014\u0012\u0004\u0012\u000207\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130E0D8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bF\u0010CR\u001c\u0010G\u001a\b\u0012\u0004\u0012\u00020)0E8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bG\u0010@R\u0014\u0010I\u001a\u00020H8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bI\u0010JR\u001b\u0010P\u001a\u00020K8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bL\u0010M\u001a\u0004\bN\u0010OR\u001b\u0010S\u001a\u00020K8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bQ\u0010M\u001a\u0004\bR\u0010OR\"\u0010T\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bT\u0010U\u001a\u0004\bV\u0010W\"\u0004\bX\u0010Y\u00a8\u0006^"}, d2={"Lat/hannibal2/skyhanni/features/misc/CarryTracker;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/entity/slayer/SlayerDeathEvent;", "event", "", "onSlayerDeath", "(Lat/hannibal2/skyhanni/events/entity/slayer/SlayerDeathEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent;)V", "", "", "args", "onCommand", "([Ljava/lang/String;)V", "rawType", "Lat/hannibal2/skyhanni/features/misc/CarryTracker$CarryType;", "getCarryType", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/features/misc/CarryTracker$CarryType;", "rawPrice", "setPrice", "(Ljava/lang/String;Ljava/lang/String;)V", "customerName", "Lat/hannibal2/skyhanni/features/misc/CarryTracker$Customer;", "getCustomer", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/features/misc/CarryTracker$Customer;", "other", "", "sameType", "(Lat/hannibal2/skyhanni/features/misc/CarryTracker$CarryType;Lat/hannibal2/skyhanni/features/misc/CarryTracker$CarryType;)Z", "update", "customer", "", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "list", "addCustomerName", "(Lat/hannibal2/skyhanni/features/misc/CarryTracker$Customer;Ljava/util/List;)V", "Lat/hannibal2/skyhanni/features/misc/CarryTracker$Carry;", "", "getCost", "(Lat/hannibal2/skyhanni/features/misc/CarryTracker$Carry;)Ljava/lang/Double;", "totalCost", "formatCost", "(Ljava/lang/Double;)Ljava/lang/String;", "input", "createCarryType", "name", "Lat/hannibal2/skyhanni/features/slayer/SlayerType;", "getSlayerType", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/features/slayer/SlayerType;", "Lat/hannibal2/skyhanni/config/features/misc/MiscConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/misc/MiscConfig;", "config", "customers", "Ljava/util/List;", "", "carryTypes", "Ljava/util/Map;", "", "", "slayerNames", "display", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "tradeCompletedPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getTradeCompletedPattern", "()Ljava/util/regex/Pattern;", "tradeCompletedPattern", "rawNamePattern$delegate", "getRawNamePattern", "rawNamePattern", "lastTradedPlayer", "Ljava/lang/String;", "getLastTradedPlayer", "()Ljava/lang/String;", "setLastTradedPlayer", "(Ljava/lang/String;)V", "Customer", "Carry", "CarryType", "SlayerCarryType", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nCarryTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CarryTracker.kt\nat/hannibal2/skyhanni/features/misc/CarryTracker\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 RepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/RepositoryReloadEvent\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,327:1\n8#2:328\n8#2:330\n1#3:329\n1#3:331\n1#3:355\n12#4,7:332\n477#5:339\n423#5:340\n381#5,7:345\n1246#6,4:341\n2632#6,3:352\n*S KotlinDebug\n*F\n+ 1 CarryTracker.kt\nat/hannibal2/skyhanni/features/misc/CarryTracker\n*L\n98#1:328\n102#1:330\n98#1:329\n102#1:331\n111#1:332,7\n112#1:339\n112#1:340\n171#1:345,7\n112#1:341,4\n202#1:352,3\n*E\n"})
public final class CarryTracker {
    @NotNull
    public static final CarryTracker INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final List<Customer> customers;
    @NotNull
    private static final Map<String, CarryType> carryTypes;
    @NotNull
    private static Map<SlayerType, ? extends List<String>> slayerNames;
    @NotNull
    private static List<? extends Renderable> display;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern tradeCompletedPattern$delegate;
    @NotNull
    private static final RepoPattern rawNamePattern$delegate;
    @NotNull
    private static String lastTradedPlayer;

    private CarryTracker() {
    }

    private final MiscConfig getConfig() {
        return SkyHanniMod.feature.misc;
    }

    private final Pattern getTradeCompletedPattern() {
        return (Pattern)tradeCompletedPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getRawNamePattern() {
        return (Pattern)rawNamePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    @HandleEvent
    public final void onSlayerDeath(@NotNull SlayerDeathEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        SlayerType slayerType = event.getSlayerType();
        int tier = event.getTier();
        String owner = event.getOwner();
        for (Customer customer : customers) {
            if (!StringsKt.equals(customer.getName(), owner, true)) continue;
            for (Carry carry : customer.getCarries()) {
                CarryType carryType = carry.getType();
                SlayerCarryType slayerCarryType = carryType instanceof SlayerCarryType ? (SlayerCarryType)carryType : null;
                if (slayerCarryType == null) {
                    return;
                }
                SlayerCarryType type2 = slayerCarryType;
                if (type2.getSlayerType() != slayerType || type2.getTier() != tier) continue;
                int n = carry.getDone();
                carry.setDone(n + 1);
                if (carry.getDone() == carry.getRequested()) {
                    ChatUtils.chat$default(ChatUtils.INSTANCE, "Carry done for " + customer.getName() + '!', false, null, 6, null);
                    LorenzUtils.sendTitle-dWUq8MI$default(LorenzUtils.INSTANCE, "\u00a7eCarry done!", DurationKt.toDuration(3, DurationUnit.SECONDS), 0.0, 0.0f, 12, null);
                }
                this.update();
            }
        }
    }

    @NotNull
    public final String getLastTradedPlayer() {
        return lastTradedPlayer;
    }

    public final void setLastTradedPlayer(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        lastTradedPlayer = string2;
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        Pattern $this$matchMatcher$iv;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = this.getTradeCompletedPattern();
        String text$iv = event.getMessage();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u240 = it$iv;
            boolean bl2 = false;
            String string2 = $this$onChat_u24lambda_u240.group("name");
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            lastTradedPlayer = StringUtils.cleanPlayerName$default(StringUtils.INSTANCE, string2, false, 1, null);
        }
        RegexUtils this_$iv = RegexUtils.INSTANCE;
        $this$matchMatcher$iv = this.getRawNamePattern();
        text$iv = event.getMessage();
        $i$f$matchMatcher = false;
        it$iv = $this$matchMatcher$iv.matcher(text$iv);
        bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u241 = it$iv;
            boolean bl3 = false;
            String string3 = $this$onChat_u24lambda_u241.group("coins");
            Intrinsics.checkNotNullExpressionValue(string3, "group(...)");
            double coinsGained = NumberUtil.INSTANCE.formatDouble(string3);
            Customer customer = INSTANCE.getCustomer(lastTradedPlayer);
            customer.setAlreadyPaid(customer.getAlreadyPaid() + coinsGained);
            INSTANCE.update();
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        void $this$mapKeysTo$iv$iv;
        CarryTrackerJson carryTrackerJson;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String constant$iv = "CarryTracker";
        Type type$iv = null;
        Object gson$iv = event.getGson();
        boolean $i$f$getConstant = false;
        try {
            RepoManager.Companion.setLastConstant(constant$iv);
            if (!event.getRepoLocation().exists()) {
                throw new RepoError("Repo folder does not exist!");
            }
            carryTrackerJson = RepoUtils.INSTANCE.getConstant(event.getRepoLocation(), constant$iv, (Gson)gson$iv, CarryTrackerJson.class, type$iv);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv);
        }
        CarryTrackerJson data2 = carryTrackerJson;
        Map<String, List<String>> $this$mapKeys$iv = data2.getSlayerNames();
        boolean $i$f$mapKeys = false;
        gson$iv = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            SlayerType slayerType = SlayerType.valueOf((String)it.getKey());
            Map map3 = map2;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            map3.put(slayerType, entry);
        }
        slayerNames = destination$iv$iv;
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        Position position = this.getConfig().carryPosition;
        Intrinsics.checkNotNullExpressionValue(position, "carryPosition");
        RenderUtils.renderRenderables$default(RenderUtils.INSTANCE, position, display, 0, "Carry Tracker", false, 10, null);
    }

    public final void onCommand(@NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        if (args2.length < 2 || args2.length > 3) {
            ChatUtils.INSTANCE.userError("Usage:\n\u00a7c/shcarry <customer name> <type> <amount requested>\n\u00a7c/shcarry <type> <price per>");
            return;
        }
        if (args2.length == 2) {
            this.setPrice(args2[0], args2[1]);
            return;
        }
        String customerName = args2[0];
        String rawType = args2[1];
        CarryType carryType = this.getCarryType(rawType);
        if (carryType == null) {
            return;
        }
        CarryType carryType2 = carryType;
        Integer n = NumberUtil.INSTANCE.formatIntOrUserError(args2[2]);
        if (n == null) {
            return;
        }
        int amountRequested = n;
        Carry newCarry = new Carry(carryType2, amountRequested, 0, 4, null);
        for (Customer customer : customers) {
            if (!StringsKt.equals(customer.getName(), customerName, true)) continue;
            List<Carry> carries = customer.getCarries();
            for (Carry carry : CollectionsKt.toList((Iterable)carries)) {
                if (!this.sameType(newCarry.getType(), carry.getType())) continue;
                int newAmountRequested = carry.getRequested() + amountRequested;
                if (newAmountRequested < 1) {
                    ChatUtils.INSTANCE.userError("New carry amount requested must be positive!");
                    return;
                }
                carries.remove(carry);
                Carry updatedCarry = new Carry(carryType2, newAmountRequested, 0, 4, null);
                updatedCarry.setDone(carry.getDone());
                carries.add(updatedCarry);
                this.update();
                ChatUtils.chat$default(ChatUtils.INSTANCE, "Updated carry: \u00a7b" + customerName + " \u00a78x" + newAmountRequested + ' ' + newCarry.getType(), false, null, 6, null);
                return;
            }
        }
        if (amountRequested < 1) {
            ChatUtils.INSTANCE.userError("Carry amount requested must be positive!");
            return;
        }
        Customer customer = this.getCustomer(customerName);
        customer.getCarries().add(newCarry);
        this.update();
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Started carry: \u00a7b" + customerName + " \u00a78x" + amountRequested + ' ' + newCarry.getType(), false, null, 6, null);
    }

    private final CarryType getCarryType(String rawType) {
        CarryType carryType;
        Map<String, CarryType> $this$getOrPut$iv = carryTypes;
        boolean $i$f$getOrPut = false;
        CarryType value$iv = $this$getOrPut$iv.get(rawType);
        if (value$iv == null) {
            boolean bl = false;
            CarryType carryType2 = INSTANCE.createCarryType(rawType);
            if (carryType2 == null) {
                CarryTracker $this$getCarryType_u24lambda_u244_u24lambda_u243 = INSTANCE;
                boolean bl2 = false;
                ChatUtils.INSTANCE.userError("Unknown carry type: '" + rawType + "'! Use e.g. rev5, sven4, eman3, blaze2..");
                return null;
            }
            CarryType answer$iv = carryType2;
            $this$getOrPut$iv.put(rawType, answer$iv);
            carryType = answer$iv;
        } else {
            carryType = value$iv;
        }
        return carryType;
    }

    private final void setPrice(String rawType, String rawPrice) {
        CarryType carryType = this.getCarryType(rawType);
        if (carryType == null) {
            return;
        }
        CarryType carryType2 = carryType;
        Double d = NumberUtil.INSTANCE.formatDoubleOrUserError(rawPrice);
        if (d == null) {
            return;
        }
        double price = d;
        carryType2.setPricePer(price);
        this.update();
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Set carry price for " + carryType2 + " \u00a7eto \u00a76" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, price, false, 1, null) + " coins.", false, null, 6, null);
    }

    private final Customer getCustomer(String customerName) {
        for (Customer customer : customers) {
            if (!StringsKt.equals(customer.getName(), customerName, true)) continue;
            return customer;
        }
        Customer customer = new Customer(customerName, 0.0, null, 6, null);
        customers.add(customer);
        return customer;
    }

    private final boolean sameType(CarryType $this$sameType, CarryType other) {
        return Intrinsics.areEqual($this$sameType.getName(), other.getName()) && $this$sameType.getTier() == other.getTier();
    }

    /*
     * WARNING - void declaration
     */
    private final void update() {
        boolean bl;
        List list;
        block10: {
            list = new ArrayList();
            Iterable $this$none$iv = customers;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Customer it = (Customer)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = !((Collection)it.getCarries()).isEmpty();
                    if (!bl3) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        if (bl) {
            display = CollectionsKt.emptyList();
            return;
        }
        CollectionUtils.addString$default(CollectionUtils.INSTANCE, list, "\u00a7c\u00a7lCarries", null, null, 6, null);
        for (Customer customer : customers) {
            if (customer.getCarries().isEmpty()) continue;
            this.addCustomerName(customer, list);
            List<Carry> carries = customer.getCarries();
            for (Carry carry : carries) {
                boolean bl4;
                void $this$update_u24lambda_u247;
                List list2;
                Double d;
                Object object;
                int requested = carry.getRequested();
                int done = carry.getDone();
                int missing = requested - done;
                String color = done > requested ? "\u00a7c" : (done == requested ? "\u00a7a" : "\u00a7e");
                CarryTracker carryTracker = this;
                Double d2 = carry.getType().getPricePer();
                if (d2 != null) {
                    void it;
                    double d3 = ((Number)d2).doubleValue();
                    object = carryTracker;
                    boolean bl5 = false;
                    d = (double)(it * (double)requested);
                    carryTracker = object;
                } else {
                    d = null;
                }
                String cost = carryTracker.formatCost(d);
                String text = color + done + "\u00a78/" + color + requested + ' ' + cost;
                List it = list2 = CollectionsKt.createListBuilder();
                Renderable renderable2 = Renderable.Companion.string$default(Renderable.Companion, "  " + carry.getType() + ' ' + text, 0.0, null, null, null, 30, null);
                Renderable.Companion companion = Renderable.Companion;
                object = list;
                boolean bl6 = false;
                $this$update_u24lambda_u247.add("\u00a7b" + customer.getName() + "' " + carry.getType() + " \u00a7cCarry");
                $this$update_u24lambda_u247.add("");
                $this$update_u24lambda_u247.add("\u00a77Requested: \u00a7e" + requested);
                $this$update_u24lambda_u247.add("\u00a77Done: \u00a7e" + done);
                $this$update_u24lambda_u247.add("\u00a77Missing: \u00a7e" + missing);
                $this$update_u24lambda_u247.add("");
                if (!Intrinsics.areEqual(cost, "")) {
                    $this$update_u24lambda_u247.add("\u00a77Total cost: \u00a7e" + cost);
                    bl4 = $this$update_u24lambda_u247.add("\u00a77Cost per carry: \u00a7e" + INSTANCE.formatCost(carry.getType().getPricePer()));
                } else {
                    $this$update_u24lambda_u247.add("\u00a7cNo price set for this carry!");
                    bl4 = $this$update_u24lambda_u247.add("\u00a77Set a price with \u00a7e/shcarry <type> <price>");
                }
                $this$update_u24lambda_u247.add("");
                $this$update_u24lambda_u247.add("\u00a7eClick to send current progress in the party chat!");
                $this$update_u24lambda_u247.add("\u00a7eControl-click to remove this carry!");
                Unit unit = Unit.INSTANCE;
                object.add(Renderable.Companion.clickAndHover$default(companion, renderable2, CollectionsKt.build(list2), false, () -> CarryTracker.update$lambda$8(carries, carry, customer, done, requested), null, 20, null));
            }
        }
        display = list;
    }

    /*
     * WARNING - void declaration
     */
    private final void addCustomerName(Customer customer, List<Renderable> list) {
        String customerName = customer.getName();
        Iterable iterable = customer.getCarries();
        double d = 0.0;
        for (Object t : iterable) {
            void it;
            Carry carry = (Carry)t;
            double d2 = d;
            boolean bl = false;
            Double d3 = INSTANCE.getCost((Carry)it);
            double d4 = d3 != null ? d3 : 0.0;
            d = d2 + d4;
        }
        double totalCost = d;
        String totalCostFormat = this.formatCost(totalCost);
        if (!Intrinsics.areEqual(totalCostFormat, "")) {
            String paidFormat = "\u00a76" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, customer.getAlreadyPaid(), false, 1, null);
            String missingFormat = this.formatCost(totalCost - customer.getAlreadyPaid());
            String[] stringArray = new String[]{"\u00a77Carries for \u00a7b" + customerName, "", "\u00a77Total cost: " + totalCostFormat, "\u00a77Already paid: " + paidFormat, "\u00a77Still missing: " + missingFormat, "", "\u00a7eClick to send missing coins in party chat!"};
            list.add(Renderable.Companion.clickAndHover$default(Renderable.Companion, Renderable.Companion.string$default(Renderable.Companion, "\u00a7b" + customerName + ' ' + paidFormat + "\u00a78/" + totalCostFormat, 0.0, null, null, null, 30, null), CollectionsKt.listOf(stringArray), false, () -> CarryTracker.addCustomerName$lambda$10(customerName, paidFormat, missingFormat), null, 20, null));
        } else {
            CollectionUtils.addString$default(CollectionUtils.INSTANCE, list, "\u00a7b" + customerName + totalCostFormat, null, null, 6, null);
        }
    }

    private final Double getCost(Carry $this$getCost) {
        Double d;
        Double d2 = $this$getCost.getType().getPricePer();
        if (d2 != null) {
            double it = ((Number)d2).doubleValue();
            boolean bl = false;
            Double d3 = (double)$this$getCost.getRequested() * it;
            it = ((Number)d3).doubleValue();
            boolean bl2 = false;
            d = !(it == 0.0) ? d3 : null;
        } else {
            d = null;
        }
        return d;
    }

    private final String formatCost(Double totalCost) {
        return Intrinsics.areEqual(totalCost, 0.0) || totalCost == null ? "" : "\u00a76" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, totalCost, false, 1, null);
    }

    private final CarryType createCarryType(String input2) {
        if (input2.length() == 1) {
            return null;
        }
        String string2 = StringsKt.dropLast(input2, 1).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String rawName = string2;
        Integer n = CharsKt.digitToIntOrNull(StringsKt.last(input2));
        if (n == null) {
            return null;
        }
        int tier = n;
        SlayerType slayerType = this.getSlayerType(rawName);
        if (slayerType != null) {
            SlayerType it = slayerType;
            boolean bl = false;
            return new SlayerCarryType(it, tier);
        }
        return null;
    }

    private final SlayerType getSlayerType(String name2) {
        Object v0;
        block1: {
            Iterable iterable = slayerNames.entrySet();
            for (Object t : iterable) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                if (!((List)it.getValue()).contains(name2)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        return entry != null ? (SlayerType)((Object)entry.getKey()) : null;
    }

    private static final Unit update$lambda$8(List $carries, Carry $carry, Customer $customer, int $done, int $requested) {
        Intrinsics.checkNotNullParameter($carries, "$carries");
        Intrinsics.checkNotNullParameter($carry, "$carry");
        Intrinsics.checkNotNullParameter($customer, "$customer");
        if (KeyboardManager.INSTANCE.isModifierKeyDown()) {
            $carries.remove($carry);
            INSTANCE.update();
        } else {
            HypixelCommands.INSTANCE.partyChat($customer.getName() + ' ' + StringUtils.removeColor$default(StringUtils.INSTANCE, $carry.getType().toString(), false, 1, null) + " carry: " + $done + '/' + $requested);
        }
        return Unit.INSTANCE;
    }

    private static final Unit addCustomerName$lambda$10(String $customerName, String $paidFormat, String $missingFormat) {
        Intrinsics.checkNotNullParameter($customerName, "$customerName");
        Intrinsics.checkNotNullParameter($paidFormat, "$paidFormat");
        Intrinsics.checkNotNullParameter($missingFormat, "$missingFormat");
        HypixelCommands.INSTANCE.partyChat($customerName + " Carry: already paid: " + StringUtils.removeColor$default(StringUtils.INSTANCE, $paidFormat, false, 1, null) + ", still missing: " + StringUtils.removeColor$default(StringUtils.INSTANCE, $missingFormat, false, 1, null));
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(CarryTracker.class, "tradeCompletedPattern", "getTradeCompletedPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(CarryTracker.class, "rawNamePattern", "getRawNamePattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new CarryTracker();
        customers = new ArrayList();
        carryTypes = new LinkedHashMap();
        slayerNames = MapsKt.emptyMap();
        display = CollectionsKt.emptyList();
        patternGroup = RepoPattern.Companion.group("carry");
        tradeCompletedPattern$delegate = patternGroup.pattern("trade.completed", "\u00a76Trade completed with (?<name>.*)\u00a7r\u00a76!");
        rawNamePattern$delegate = patternGroup.pattern("trade.coins.gained", " \u00a7r\u00a7a\u00a7l\\+ \u00a7r\u00a76(?<coins>.*) coins");
        lastTradedPlayer = "";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\f\u001a\u0004\b\r\u0010\u000eR\"\u0010\u0006\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010\f\u001a\u0004\b\u000f\u0010\u000e\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lat/hannibal2/skyhanni/features/misc/CarryTracker$Carry;", "", "Lat/hannibal2/skyhanni/features/misc/CarryTracker$CarryType;", "type", "", "requested", "done", "<init>", "(Lat/hannibal2/skyhanni/features/misc/CarryTracker$CarryType;II)V", "Lat/hannibal2/skyhanni/features/misc/CarryTracker$CarryType;", "getType", "()Lat/hannibal2/skyhanni/features/misc/CarryTracker$CarryType;", "I", "getRequested", "()I", "getDone", "setDone", "(I)V", "1.8.9"})
    public static final class Carry {
        @NotNull
        private final CarryType type;
        private final int requested;
        private int done;

        public Carry(@NotNull CarryType type2, int requested, int done) {
            Intrinsics.checkNotNullParameter(type2, "type");
            this.type = type2;
            this.requested = requested;
            this.done = done;
        }

        public /* synthetic */ Carry(CarryType carryType, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 4) != 0) {
                n2 = 0;
            }
            this(carryType, n, n2);
        }

        @NotNull
        public final CarryType getType() {
            return this.type;
        }

        public final int getRequested() {
            return this.requested;
        }

        public final int getDone() {
            return this.done;
        }

        public final void setDone(int n) {
            this.done = n;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0010\b&\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\f\u001a\u0004\b\r\u0010\u000bR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lat/hannibal2/skyhanni/features/misc/CarryTracker$CarryType;", "", "", "name", "", "tier", "", "pricePer", "<init>", "(Ljava/lang/String;ILjava/lang/Double;)V", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "getName", "I", "getTier", "()I", "Ljava/lang/Double;", "getPricePer", "()Ljava/lang/Double;", "setPricePer", "(Ljava/lang/Double;)V", "1.8.9"})
    public static abstract class CarryType {
        @NotNull
        private final String name;
        private final int tier;
        @Nullable
        private Double pricePer;

        public CarryType(@NotNull String name2, int tier, @Nullable Double pricePer) {
            Intrinsics.checkNotNullParameter(name2, "name");
            this.name = name2;
            this.tier = tier;
            this.pricePer = pricePer;
        }

        public /* synthetic */ CarryType(String string2, int n, Double d, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                d = null;
            }
            this(string2, n, d);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final int getTier() {
            return this.tier;
        }

        @Nullable
        public final Double getPricePer() {
            return this.pricePer;
        }

        public final void setPricePer(@Nullable Double d) {
            this.pricePer = d;
        }

        @NotNull
        public String toString() {
            return "\u00a7d" + this.name + ' ' + this.tier;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\rR\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lat/hannibal2/skyhanni/features/misc/CarryTracker$Customer;", "", "", "name", "", "alreadyPaid", "", "Lat/hannibal2/skyhanni/features/misc/CarryTracker$Carry;", "carries", "<init>", "(Ljava/lang/String;DLjava/util/List;)V", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "D", "getAlreadyPaid", "()D", "setAlreadyPaid", "(D)V", "Ljava/util/List;", "getCarries", "()Ljava/util/List;", "1.8.9"})
    public static final class Customer {
        @NotNull
        private final String name;
        private double alreadyPaid;
        @NotNull
        private final List<Carry> carries;

        public Customer(@NotNull String name2, double alreadyPaid, @NotNull List<Carry> carries) {
            Intrinsics.checkNotNullParameter(name2, "name");
            Intrinsics.checkNotNullParameter(carries, "carries");
            this.name = name2;
            this.alreadyPaid = alreadyPaid;
            this.carries = carries;
        }

        public /* synthetic */ Customer(String string2, double d, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                d = 0.0;
            }
            if ((n & 4) != 0) {
                list = new ArrayList();
            }
            this(string2, d, list);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final double getAlreadyPaid() {
            return this.alreadyPaid;
        }

        public final void setAlreadyPaid(double d) {
            this.alreadyPaid = d;
        }

        @NotNull
        public final List<Carry> getCarries() {
            return this.carries;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lat/hannibal2/skyhanni/features/misc/CarryTracker$SlayerCarryType;", "Lat/hannibal2/skyhanni/features/misc/CarryTracker$CarryType;", "Lat/hannibal2/skyhanni/features/slayer/SlayerType;", "slayerType", "", "tier", "<init>", "(Lat/hannibal2/skyhanni/features/slayer/SlayerType;I)V", "Lat/hannibal2/skyhanni/features/slayer/SlayerType;", "getSlayerType", "()Lat/hannibal2/skyhanni/features/slayer/SlayerType;", "1.8.9"})
    public static final class SlayerCarryType
    extends CarryType {
        @NotNull
        private final SlayerType slayerType;

        public SlayerCarryType(@NotNull SlayerType slayerType, int tier) {
            Intrinsics.checkNotNullParameter((Object)slayerType, "slayerType");
            super(slayerType.getDisplayName(), tier, null, 4, null);
            this.slayerType = slayerType;
        }

        @NotNull
        public final SlayerType getSlayerType() {
            return this.slayerType;
        }
    }
}

