/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.minion;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.minion.MinionsConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.events.BlockClickEvent;
import at.hannibal2.skyhanni.events.EntityClickEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.events.InventoryUpdatedEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.MinionCloseEvent;
import at.hannibal2.skyhanni.events.MinionOpenEvent;
import at.hannibal2.skyhanni.events.MinionStorageOpenEvent;
import at.hannibal2.skyhanni.events.SkyHanniRenderEntityEvent;
import at.hannibal2.skyhanni.features.minion.MinionFeatures$removeBuggedMinions$;
import at.hannibal2.skyhanni.utils.BlockUtils;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SpecialColor;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001d\u001a\u00020\u00062\b\b\u0002\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010 \u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001fH\u0007\u00a2\u0006\u0004\b \u0010!J\u0017\u0010#\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\"H\u0007\u00a2\u0006\u0004\b#\u0010$J!\u0010)\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\b\b\u0002\u0010(\u001a\u00020'H\u0002\u00a2\u0006\u0004\b)\u0010*J\u000f\u0010+\u001a\u00020%H\u0002\u00a2\u0006\u0004\b+\u0010,J\u0017\u0010.\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020-H\u0007\u00a2\u0006\u0004\b.\u0010/J\u0017\u00101\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u000200H\u0007\u00a2\u0006\u0004\b1\u00102J\u0017\u00103\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b3\u0010\u0011J\u001d\u00106\u001a\u00020\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020504H\u0007\u00a2\u0006\u0004\b6\u00107J\u000f\u00108\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b8\u00109J\u000f\u0010:\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b:\u00109J\u0017\u0010<\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020;H\u0007\u00a2\u0006\u0004\b<\u0010=J\u0017\u0010?\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020>H\u0007\u00a2\u0006\u0004\b?\u0010@R\u001c\u0010E\u001a\n B*\u0004\u0018\u00010A0A8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u0018\u0010G\u001a\u0004\u0018\u00010F8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bG\u0010HR\u0018\u0010I\u001a\u0004\u0018\u00010F8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bI\u0010HR\u0018\u0010J\u001a\u0004\u0018\u00010%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bJ\u0010KR\u0016\u0010M\u001a\u00020L8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bM\u0010NR\u0016\u0010O\u001a\u00020L8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bO\u0010NR\u0016\u0010P\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bP\u0010KR\u0014\u0010R\u001a\u00020Q8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bR\u0010SR\u001b\u0010Y\u001a\u00020T8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bU\u0010V\u001a\u0004\bW\u0010XR\u001b\u0010\\\u001a\u00020T8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bZ\u0010V\u001a\u0004\b[\u0010XR\u001b\u0010_\u001a\u00020T8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b]\u0010V\u001a\u0004\b^\u0010XR\u001b\u0010b\u001a\u00020T8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b`\u0010V\u001a\u0004\ba\u0010XR$\u0010c\u001a\u0004\u0018\u00010F8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bc\u0010H\u001a\u0004\bd\u0010e\"\u0004\bf\u0010gR\u0018\u0010h\u001a\u0004\u0018\u00010F8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bh\u0010HR\"\u0010i\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bi\u0010j\u001a\u0004\bk\u00109\"\u0004\bl\u0010\u001eR\"\u0010m\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bm\u0010j\u001a\u0004\bn\u00109\"\u0004\bo\u0010\u001eR@\u0010w\u001a\u0010\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020q\u0018\u00010p2\u0014\u0010r\u001a\u0010\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020q\u0018\u00010p8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\bs\u0010t\"\u0004\bu\u0010v\u00a8\u0006x"}, d2={"Lat/hannibal2/skyhanni/features/minion/MinionFeatures;", "", "<init>", "()V", "Lnet/minecraftforge/event/entity/player/PlayerInteractEvent;", "event", "", "onPlayerInteract", "(Lnet/minecraftforge/event/entity/player/PlayerInteractEvent;)V", "Lat/hannibal2/skyhanni/events/EntityClickEvent;", "onEntityClick", "(Lat/hannibal2/skyhanni/events/EntityClickEvent;)V", "Lat/hannibal2/skyhanni/events/BlockClickEvent;", "onBlockClick", "(Lat/hannibal2/skyhanni/events/BlockClickEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "onRenderLastClickedMinion", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "onInventoryOpen", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryUpdatedEvent;", "onInventoryUpdated", "(Lat/hannibal2/skyhanni/events/InventoryUpdatedEvent;)V", "Lat/hannibal2/skyhanni/events/MinionOpenEvent;", "onMinionOpen", "(Lat/hannibal2/skyhanni/events/MinionOpenEvent;)V", "", "isCommand", "removeBuggedMinions", "(Z)V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "", "oldName", "", "newTier", "getMinionName", "(Ljava/lang/String;I)Ljava/lang/String;", "updateCoinsPerDay", "()Ljava/lang/String;", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "onRenderLastEmptied", "Lat/hannibal2/skyhanni/events/SkyHanniRenderEntityEvent$Specials$Pre;", "Lnet/minecraft/entity/EntityLivingBase;", "onRenderLiving", "(Lat/hannibal2/skyhanni/events/SkyHanniRenderEntityEvent$Specials$Pre;)V", "isEnabled", "()Z", "enableWithHub", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;", "onBackgroundDraw", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/minion/MinionsConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/minion/MinionsConfig;", "config", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "lastClickedEntity", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "newMinion", "newMinionName", "Ljava/lang/String;", "", "lastMinionOpened", "J", "lastInventoryClosed", "coinsPerDay", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "minionUpgradePattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getMinionUpgradePattern", "()Ljava/util/regex/Pattern;", "minionUpgradePattern", "minionCoinPattern$delegate", "getMinionCoinPattern", "minionCoinPattern", "minionTitlePattern$delegate", "getMinionTitlePattern", "minionTitlePattern", "minionCollectItemPattern$delegate", "getMinionCollectItemPattern", "minionCollectItemPattern", "lastMinion", "getLastMinion", "()Lat/hannibal2/skyhanni/utils/LorenzVec;", "setLastMinion", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)V", "lastStorage", "minionInventoryOpen", "Z", "getMinionInventoryOpen", "setMinionInventoryOpen", "minionStorageInventoryOpen", "getMinionStorageInventoryOpen", "setMinionStorageInventoryOpen", "", "Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$MinionConfig;", "value", "getMinions", "()Ljava/util/Map;", "setMinions", "(Ljava/util/Map;)V", "minions", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nMinionFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinionFeatures.kt\nat/hannibal2/skyhanni/features/minion/MinionFeatures\n+ 2 EntityUtils.kt\nat/hannibal2/skyhanni/utils/EntityUtils\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,430:1\n172#2:431\n477#3:432\n1251#3,2:433\n1#4:435\n1#4:437\n8#5:436\n188#6,3:438\n*S KotlinDebug\n*F\n+ 1 MinionFeatures.kt\nat/hannibal2/skyhanni/features/minion/MinionFeatures\n*L\n223#1:431\n223#1:432\n224#1:433,2\n347#1:437\n347#1:436\n399#1:438,3\n*E\n"})
public final class MinionFeatures {
    @NotNull
    public static final MinionFeatures INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @Nullable
    private static LorenzVec lastClickedEntity;
    @Nullable
    private static LorenzVec newMinion;
    @Nullable
    private static String newMinionName;
    private static long lastMinionOpened;
    private static long lastInventoryClosed;
    @NotNull
    private static String coinsPerDay;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern minionUpgradePattern$delegate;
    @NotNull
    private static final RepoPattern minionCoinPattern$delegate;
    @NotNull
    private static final RepoPattern minionTitlePattern$delegate;
    @NotNull
    private static final RepoPattern minionCollectItemPattern$delegate;
    @Nullable
    private static LorenzVec lastMinion;
    @Nullable
    private static LorenzVec lastStorage;
    private static boolean minionInventoryOpen;
    private static boolean minionStorageInventoryOpen;

    private MinionFeatures() {
    }

    private final MinionsConfig getConfig() {
        return SkyHanniMod.feature.misc.minions;
    }

    private final Pattern getMinionUpgradePattern() {
        return (Pattern)minionUpgradePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getMinionCoinPattern() {
        return (Pattern)minionCoinPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    private final Pattern getMinionTitlePattern() {
        return (Pattern)minionTitlePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2]);
    }

    private final Pattern getMinionCollectItemPattern() {
        return (Pattern)minionCollectItemPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[3]);
    }

    @Nullable
    public final LorenzVec getLastMinion() {
        return lastMinion;
    }

    public final void setLastMinion(@Nullable LorenzVec lorenzVec) {
        lastMinion = lorenzVec;
    }

    public final boolean getMinionInventoryOpen() {
        return minionInventoryOpen;
    }

    public final void setMinionInventoryOpen(boolean bl) {
        minionInventoryOpen = bl;
    }

    public final boolean getMinionStorageInventoryOpen() {
        return minionStorageInventoryOpen;
    }

    public final void setMinionStorageInventoryOpen(boolean bl) {
        minionStorageInventoryOpen = bl;
    }

    private final Map<LorenzVec, ProfileSpecificStorage.MinionConfig> getMinions() {
        ProfileSpecificStorage profileSpecificStorage = ProfileStorageData.INSTANCE.getProfileSpecific();
        return profileSpecificStorage != null ? profileSpecificStorage.minions : null;
    }

    private final void setMinions(Map<LorenzVec, ? extends ProfileSpecificStorage.MinionConfig> value) {
        block0: {
            if (ProfileStorageData.INSTANCE.getProfileSpecific() == null) break block0;
            ProfileStorageData.INSTANCE.getProfileSpecific().minions = value;
        }
    }

    @SubscribeEvent
    public final void onPlayerInteract(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        BlockPos blockPos = event.pos.func_177972_a(event.face);
        Intrinsics.checkNotNullExpressionValue(blockPos, "offset(...)");
        LorenzVec lookingAt = LorenzVecKt.toLorenzVec(blockPos);
        ItemStack itemStack2 = InventoryUtils.INSTANCE.getItemInHand();
        if (itemStack2 == null) {
            return;
        }
        ItemStack equipped = itemStack2;
        String string2 = equipped.func_82833_r();
        Intrinsics.checkNotNullExpressionValue(string2, "getDisplayName(...)");
        if (StringsKt.contains$default((CharSequence)string2, " Minion ", false, 2, null) && Intrinsics.areEqual(BlockUtils.INSTANCE.getBlockStateAt(lookingAt).func_177230_c(), Blocks.field_150350_a)) {
            newMinion = lookingAt.add(0.5, 0.0, 0.5);
            newMinionName = MinionFeatures.getMinionName$default(this, ItemUtils.INSTANCE.cleanName(equipped), 0, 2, null);
        } else {
            newMinion = null;
            newMinionName = null;
        }
    }

    @SubscribeEvent
    public final void onEntityClick(@NotNull EntityClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.enableWithHub()) {
            return;
        }
        if (event.getClickType() != ClickType.RIGHT_CLICK) {
            return;
        }
        Object object = event.getClickedEntity();
        if (object == null || (object = LorenzVecKt.getLorenzVec(object)) == null) {
            return;
        }
        lastClickedEntity = object;
    }

    @SubscribeEvent
    public final void onBlockClick(@NotNull BlockClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.enableWithHub()) {
            return;
        }
        if (event.getClickType() != ClickType.RIGHT_CLICK) {
            return;
        }
        lastStorage = event.getPosition();
    }

    @SubscribeEvent
    public final void onRenderLastClickedMinion(@NotNull LorenzRenderWorldEvent event) {
        int time;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.enableWithHub()) {
            return;
        }
        if (!this.getConfig().lastClickedMinion.display) {
            return;
        }
        String special = this.getConfig().lastClickedMinion.color;
        Color color = new Color(SpecialColor.specialToChromaRGB(special), true);
        LorenzVec loc = lastMinion;
        if (loc != null && lastMinionOpened + (long)(time = this.getConfig().lastClickedMinion.time * 1000) > System.currentTimeMillis()) {
            RenderUtils.drawWaypointFilled$default(RenderUtils.INSTANCE, event, loc.add(-0.5, 0.0, -0.5), color, true, false, -0.25, 0.2, 0.0, 0.0f, false, 392, null);
        }
    }

    @SubscribeEvent
    public final void onInventoryOpen(@NotNull InventoryFullyOpenedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.enableWithHub()) {
            return;
        }
        if (!RegexUtils.INSTANCE.find(this.getMinionTitlePattern(), event.getInventoryName())) {
            return;
        }
        ItemStack itemStack2 = event.getInventoryItems().get(48);
        if (itemStack2 != null) {
            ItemStack it = itemStack2;
            boolean bl = false;
            if (RegexUtils.INSTANCE.matches(INSTANCE.getMinionCollectItemPattern(), ItemUtils.INSTANCE.getName(it))) {
                new MinionOpenEvent(event.getInventoryName(), event.getInventoryItems()).postAndCatch();
                return;
            }
        }
        new MinionStorageOpenEvent(lastStorage, event.getInventoryItems()).postAndCatch();
        minionStorageInventoryOpen = true;
    }

    @SubscribeEvent
    public final void onInventoryUpdated(@NotNull InventoryUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.enableWithHub()) {
            return;
        }
        if (minionInventoryOpen) {
            new MinionOpenEvent(event.getInventoryName(), event.getInventoryItems()).postAndCatch();
        }
    }

    @SubscribeEvent
    public final void onMinionOpen(@NotNull MinionOpenEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        MinionFeatures.removeBuggedMinions$default(this, false, 1, null);
        Map<LorenzVec, ProfileSpecificStorage.MinionConfig> map2 = this.getMinions();
        if (map2 == null) {
            return;
        }
        Map<LorenzVec, ProfileSpecificStorage.MinionConfig> minions = map2;
        LorenzVec lorenzVec = lastClickedEntity;
        if (lorenzVec == null) {
            return;
        }
        LorenzVec entity = lorenzVec;
        String openInventory = event.getInventoryName();
        String name2 = MinionFeatures.getMinionName$default(this, openInventory, 0, 2, null);
        if (!minions.containsKey(entity) && LorenzUtils.INSTANCE.getSkyBlockIsland() != IslandType.HUB) {
            INSTANCE.setMinions(CollectionUtils.INSTANCE.editCopy(minions, arg_0 -> MinionFeatures.onMinionOpen$lambda$2(entity, name2, arg_0)));
        } else {
            ProfileSpecificStorage.MinionConfig minionConfig = minions.get(entity);
            if (minionConfig != null) {
                ProfileSpecificStorage.MinionConfig it = minionConfig;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.displayName, name2)) {
                    it.displayName = name2;
                }
            }
        }
        lastMinion = entity;
        lastClickedEntity = null;
        minionInventoryOpen = true;
        lastMinionOpened = 0L;
    }

    public final void removeBuggedMinions(boolean isCommand) {
        if (!LorenzUtils.INSTANCE.isInIsland(IslandType.PRIVATE_ISLAND)) {
            return;
        }
        Map<LorenzVec, ProfileSpecificStorage.MinionConfig> map2 = this.getMinions();
        if (map2 == null) {
            return;
        }
        Map<LorenzVec, ProfileSpecificStorage.MinionConfig> minions = map2;
        List removedEntities = new ArrayList();
        for (LorenzVec location : minions.keySet()) {
            boolean bl;
            block6: {
                Sequence<Double> entitiesNearby;
                if (LocationUtils.INSTANCE.distanceToPlayer(location) > 30.0) continue;
                EntityUtils this_$iv = EntityUtils.INSTANCE;
                boolean $i$f$getEntities = false;
                Sequence<Entity> $this$filterIsInstance$iv$iv = this_$iv.getAllEntities();
                boolean $i$f$filterIsInstance = false;
                Sequence<Entity> sequence = SequencesKt.filter($this$filterIsInstance$iv$iv, removeBuggedMinions$$inlined$getEntities$1.INSTANCE);
                Intrinsics.checkNotNull(sequence, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                Sequence<Double> $this$any$iv = entitiesNearby = SequencesKt.map(sequence, arg_0 -> MinionFeatures.removeBuggedMinions$lambda$4(location, arg_0));
                boolean $i$f$any = false;
                Iterator<Double> iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    Double element$iv = iterator2.next();
                    double it = ((Number)element$iv).doubleValue();
                    boolean bl2 = false;
                    if (!(it == 0.0)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
            if (bl) continue;
            removedEntities.add(location);
        }
        int size = removedEntities.size();
        if (size == 0) {
            if (isCommand) {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "No bugged minions found nearby.", false, null, 6, null);
            }
            return;
        }
        this.setMinions(CollectionUtils.INSTANCE.editCopy(minions, arg_0 -> MinionFeatures.removeBuggedMinions$lambda$6(removedEntities, size, arg_0)));
    }

    public static /* synthetic */ void removeBuggedMinions$default(MinionFeatures minionFeatures, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        minionFeatures.removeBuggedMinions(bl);
    }

    @SubscribeEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (event.getReopenSameName()) {
            return;
        }
        minionStorageInventoryOpen = false;
        if (!minionInventoryOpen) {
            return;
        }
        Map<LorenzVec, ProfileSpecificStorage.MinionConfig> map2 = this.getMinions();
        if (map2 == null) {
            return;
        }
        Map<LorenzVec, ProfileSpecificStorage.MinionConfig> minions = map2;
        minionInventoryOpen = false;
        lastMinionOpened = System.currentTimeMillis();
        coinsPerDay = "";
        lastInventoryClosed = System.currentTimeMillis();
        if (LorenzUtils.INSTANCE.isInIsland(IslandType.PRIVATE_ISLAND)) {
            LorenzVec lorenzVec = lastMinion;
            if (lorenzVec == null) {
                return;
            }
            LorenzVec location = lorenzVec;
            if (!minions.containsKey(location) && minions.get(location) != null) {
                minions.get(location).lastClicked = 0L;
            }
        }
        new MinionCloseEvent().postAndCatch();
    }

    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!Intrinsics.areEqual(coinsPerDay, "")) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiChest && this.getConfig().hopperProfitDisplay) {
            coinsPerDay = minionInventoryOpen ? this.updateCoinsPerDay() : "";
        }
    }

    private final String getMinionName(String oldName, int newTier) {
        String[] stringArray = new String[]{" "};
        List list = CollectionsKt.toList(StringsKt.split$default((CharSequence)oldName, stringArray, false, 0, 6, null));
        String last2 = (String)CollectionsKt.last(list);
        int number = newTier != 0 ? newTier : NumberUtil.INSTANCE.romanToDecimal(last2);
        list = CollectionsKt.dropLast(list, 1);
        return CollectionsKt.joinToString$default(list, " ", null, null, 0, null, null, 62, null) + ' ' + number;
    }

    static /* synthetic */ String getMinionName$default(MinionFeatures minionFeatures, String string2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return minionFeatures.getMinionName(string2, n);
    }

    private final String updateCoinsPerDay() {
        long lastClicked;
        Object v3;
        ItemStack stack;
        LorenzVec loc;
        block9: {
            Object v1;
            Object object2;
            block8: {
                LorenzVec lorenzVec = lastMinion;
                if (lorenzVec == null) {
                    return "\u00a7cNo last minion found! Try reopening the minion view.";
                }
                loc = lorenzVec;
                Iterable iterable = InventoryUtils.INSTANCE.getItemsInOpenChest();
                for (Object object2 : iterable) {
                    Slot it = (Slot)object2;
                    boolean bl = false;
                    if (!(it.field_75222_d == 28)) continue;
                    v1 = object2;
                    break block8;
                }
                v1 = null;
            }
            Slot slot = v1;
            if (slot == null) {
                return "";
            }
            Slot slot2 = slot;
            stack = slot2.func_75211_c();
            Intrinsics.checkNotNull(stack);
            object2 = ItemUtils.INSTANCE.getLore(stack);
            Iterator iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                Object bl = iterator2.next();
                String it = (String)bl;
                boolean bl2 = false;
                if (!StringsKt.contains$default((CharSequence)it, "Held Coins", false, 2, null)) continue;
                v3 = bl;
                break block9;
            }
            v3 = null;
        }
        String string2 = v3;
        if (string2 == null) {
            return "";
        }
        String line = string2;
        Map<LorenzVec, ProfileSpecificStorage.MinionConfig> map2 = this.getMinions();
        if (map2 != null && (map2 = map2.get(loc)) != null) {
            Map<LorenzVec, ProfileSpecificStorage.MinionConfig> it = map2;
            boolean bl = false;
            lastClicked = ((ProfileSpecificStorage.MinionConfig)((Object)it)).lastClicked;
            if (lastClicked == 0L) {
                return "\u00a7cCan't calculate coins/day: No time data available!";
            }
        } else {
            return "\u00a7cCan't calculate coins/day: No time data available!";
        }
        long duration = System.currentTimeMillis() - lastClicked;
        String[] bl = new String[]{": \u00a7b"};
        double coins = NumberUtil.INSTANCE.formatDouble((String)StringsKt.split$default((CharSequence)line, bl, false, 0, 6, null).get(1));
        double coinsPerDay = coins / (double)duration * (double)1000 * (double)60 * (double)60 * (double)24;
        String format = NumberUtil.INSTANCE.addSeparators((int)coinsPerDay);
        return "\u00a77Coins/day with " + ItemUtils.INSTANCE.getName(stack) + "\u00a77: \u00a76" + format + " coins";
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        lastClickedEntity = null;
        lastMinion = null;
        lastMinionOpened = 0L;
        minionInventoryOpen = false;
        minionStorageInventoryOpen = false;
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)event, "event");
            if (!this.isEnabled()) {
                return;
            }
            String message = event.getMessage();
            if (RegexUtils.INSTANCE.matches(this.getMinionCoinPattern(), message) && System.currentTimeMillis() - lastInventoryClosed < 2000L) {
                Map<LorenzVec, ProfileSpecificStorage.MinionConfig> map2 = this.getMinions();
                if (map2 != null && (map2 = map2.get(lastMinion)) != null) {
                    Map<LorenzVec, ProfileSpecificStorage.MinionConfig> it = map2;
                    boolean bl = false;
                    ((ProfileSpecificStorage.MinionConfig)((Object)it)).lastClicked = System.currentTimeMillis();
                }
            }
            if (StringsKt.startsWith$default(message, "\u00a7aYou picked up a minion!", false, 2, null) && lastMinion != null) {
                Map<LorenzVec, ProfileSpecificStorage.MinionConfig> map3 = this.getMinions();
                this.setMinions(map3 != null ? CollectionUtils.INSTANCE.editCopy(map3, MinionFeatures::onChat$lambda$11) : null);
                lastClickedEntity = null;
                lastMinion = null;
                lastMinionOpened = 0L;
            }
            if (StringsKt.startsWith$default(message, "\u00a7bYou placed a minion!", false, 2, null) && newMinion != null) {
                Map<LorenzVec, ProfileSpecificStorage.MinionConfig> map4 = this.getMinions();
                this.setMinions(map4 != null ? CollectionUtils.INSTANCE.editCopy(map4, MinionFeatures::onChat$lambda$13) : null);
                newMinion = null;
                newMinionName = null;
            }
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            Pattern $this$matchMatcher$iv = this.getMinionUpgradePattern();
            boolean $i$f$matchMatcher = false;
            Matcher it$iv = $this$matchMatcher$iv.matcher(message);
            boolean bl = false;
            if (!it$iv.matches()) break block7;
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u2415 = it$iv;
            boolean bl2 = false;
            String string2 = $this$onChat_u24lambda_u2415.group("tier");
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            int newTier = NumberUtil.INSTANCE.romanToDecimalIfNecessary(string2);
            Map<LorenzVec, ProfileSpecificStorage.MinionConfig> map5 = INSTANCE.getMinions();
            if (map5 != null) {
                if ((map5 = map5.get(lastMinion)) != null) {
                    String minionName;
                    Map<LorenzVec, ProfileSpecificStorage.MinionConfig> it = map5;
                    boolean bl3 = false;
                    String string3 = ((ProfileSpecificStorage.MinionConfig)((Object)it)).displayName;
                    Intrinsics.checkNotNullExpressionValue(string3, "displayName");
                    ((ProfileSpecificStorage.MinionConfig)((Object)it)).displayName = minionName = INSTANCE.getMinionName(string3, newTier);
                }
            }
        }
    }

    @SubscribeEvent
    public final void onRenderLastEmptied(@NotNull LorenzRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        LorenzVec playerLocation = LocationUtils.INSTANCE.playerLocation();
        Map<LorenzVec, ProfileSpecificStorage.MinionConfig> map2 = this.getMinions();
        if (map2 == null) {
            return;
        }
        Map<LorenzVec, ProfileSpecificStorage.MinionConfig> minions = map2;
        for (Map.Entry<LorenzVec, ProfileSpecificStorage.MinionConfig> minion : minions.entrySet()) {
            LorenzVec location = LorenzVec.add$default(minion.getKey(), 0.0, 1.0, 0.0, 5, null);
            if (LocationUtils.INSTANCE.distanceToPlayer(location) > 50.0) continue;
            long lastEmptied = minion.getValue().lastClicked;
            if (playerLocation.distance(location) >= (double)this.getConfig().emptiedTime.distance) continue;
            if (this.getConfig().nameDisplay) {
                String string2;
                String displayName = minion.getValue().displayName;
                StringBuilder stringBuilder = new StringBuilder().append("\u00a76");
                if (this.getConfig().nameOnlyTier) {
                    Intrinsics.checkNotNull(displayName);
                    String[] stringArray = new String[]{" "};
                    string2 = (String)CollectionsKt.last(StringsKt.split$default((CharSequence)displayName, stringArray, false, 0, 6, null));
                } else {
                    string2 = displayName;
                }
                String name2 = stringBuilder.append(string2).toString();
                RenderUtils.drawString$default(RenderUtils.INSTANCE, event, LorenzVec.add$default(location, 0.0, 0.65, 0.0, 5, null), name2, true, null, 8, null);
            }
            if (!this.getConfig().emptiedTime.display || lastEmptied == 0L) continue;
            long passedSince = SimpleTimeMark.passedSince-UwyO8pc(SimpleTimeMark.constructor-impl(lastEmptied));
            String format = TimeUtils.format-bz6L7rs$default(TimeUtils.INSTANCE, passedSince, null, false, true, 0, false, 27, null) + " ago";
            String text = "\u00a7eHopper Emptied: " + format;
            RenderUtils.drawString$default(RenderUtils.INSTANCE, event, LorenzVec.add$default(location, 0.0, 1.15, 0.0, 5, null), text, true, null, 8, null);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public final void onRenderLiving(@NotNull SkyHanniRenderEntityEvent.Specials.Pre<EntityLivingBase> event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!this.getConfig().hideMobsNametagNearby) {
            return;
        }
        Object entity = event.getEntity();
        if (!(entity instanceof EntityArmorStand)) {
            return;
        }
        if (!entity.func_145818_k_()) {
            return;
        }
        if (((EntityLivingBase)entity).field_70128_L) {
            return;
        }
        Map<LorenzVec, ProfileSpecificStorage.MinionConfig> map2 = this.getMinions();
        if (map2 == null) {
            return;
        }
        Map<LorenzVec, ProfileSpecificStorage.MinionConfig> minions = map2;
        String string2 = ((EntityArmorStand)entity).func_95999_t();
        Intrinsics.checkNotNullExpressionValue(string2, "getCustomNameTag(...)");
        if (StringsKt.contains$default((CharSequence)string2, "\u00a7c\u2764", false, 2, null)) {
            boolean bl;
            block11: {
                LorenzVec loc = LorenzVecKt.getLorenzVec((Entity)entity);
                Map<LorenzVec, ProfileSpecificStorage.MinionConfig> $this$any$iv = minions;
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    Iterator<Map.Entry<LorenzVec, ProfileSpecificStorage.MinionConfig>> iterator2 = $this$any$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<LorenzVec, ProfileSpecificStorage.MinionConfig> element$iv;
                        Map.Entry<LorenzVec, ProfileSpecificStorage.MinionConfig> it = element$iv = iterator2.next();
                        boolean bl2 = false;
                        if (!(it.getKey().distance(loc) < 5.0)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            if (bl) {
                event.cancel();
            }
        }
    }

    private final boolean isEnabled() {
        return LorenzUtils.INSTANCE.isInIsland(IslandType.PRIVATE_ISLAND);
    }

    private final boolean enableWithHub() {
        return this.isEnabled() || LorenzUtils.INSTANCE.isInIsland(IslandType.HUB);
    }

    @SubscribeEvent
    public final void onBackgroundDraw(@NotNull GuiRenderEvent.ChestGuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        if (!minionInventoryOpen) {
            return;
        }
        if (this.getConfig().hopperProfitDisplay) {
            Position position = this.getConfig().hopperProfitPos;
            Intrinsics.checkNotNullExpressionValue(position, "hopperProfitPos");
            RenderUtils.renderString$default(RenderUtils.INSTANCE, position, coinsPerDay, 0, 0, "Minion Coins Per Day", 6, null);
        }
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "minions.lastClickedMinionDisplay", "minions.lastClickedMinion.display", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "minions.lastOpenedMinionColor", "minions.lastClickedMinion.color", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "minions.lastOpenedMinionTime", "minions.lastClickedMinion.time", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "minions.emptiedTimeDisplay", "minions.emptiedTime.display", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "minions.distance", "minions.emptiedTime.distance", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 31, "minions", "misc.minions", null, 8, null);
    }

    private static final Unit onMinionOpen$lambda$2(LorenzVec $entity, String $name, Map $this$editCopy) {
        ProfileSpecificStorage.MinionConfig minionConfig;
        Intrinsics.checkNotNullParameter($entity, "$entity");
        Intrinsics.checkNotNullParameter($name, "$name");
        Intrinsics.checkNotNullParameter($this$editCopy, "$this$editCopy");
        Map map2 = $this$editCopy;
        ProfileSpecificStorage.MinionConfig $this$onMinionOpen_u24lambda_u242_u24lambda_u241 = minionConfig = new ProfileSpecificStorage.MinionConfig();
        boolean bl = false;
        $this$onMinionOpen_u24lambda_u242_u24lambda_u241.displayName = $name;
        $this$onMinionOpen_u24lambda_u242_u24lambda_u241.lastClicked = 0L;
        map2.put($entity, minionConfig);
        return Unit.INSTANCE;
    }

    private static final double removeBuggedMinions$lambda$4(LorenzVec $location, EntityArmorStand it) {
        Intrinsics.checkNotNullParameter($location, "$location");
        Intrinsics.checkNotNullParameter(it, "it");
        return LocationUtils.INSTANCE.distanceTo((Entity)it, $location);
    }

    private static final Unit removeBuggedMinions$lambda$6(List $removedEntities, int $size, Map $this$editCopy) {
        Intrinsics.checkNotNullParameter($removedEntities, "$removedEntities");
        Intrinsics.checkNotNullParameter($this$editCopy, "$this$editCopy");
        for (LorenzVec removedEntity : $removedEntities) {
            $this$editCopy.remove(removedEntity);
        }
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Removed " + $size + " wrong/bugged minion locations from your island.", false, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit onChat$lambda$11(Map $this$editCopy) {
        Intrinsics.checkNotNullParameter($this$editCopy, "$this$editCopy");
        Map map2 = $this$editCopy;
        LorenzVec lorenzVec = lastMinion;
        TypeIntrinsics.asMutableMap(map2).remove(lorenzVec);
        return Unit.INSTANCE;
    }

    private static final Unit onChat$lambda$13(Map $this$editCopy) {
        ProfileSpecificStorage.MinionConfig minionConfig;
        Intrinsics.checkNotNullParameter($this$editCopy, "$this$editCopy");
        Map map2 = $this$editCopy;
        LorenzVec lorenzVec = newMinion;
        Intrinsics.checkNotNull(lorenzVec);
        LorenzVec lorenzVec2 = lorenzVec;
        ProfileSpecificStorage.MinionConfig $this$onChat_u24lambda_u2413_u24lambda_u2412 = minionConfig = new ProfileSpecificStorage.MinionConfig();
        boolean bl = false;
        $this$onChat_u24lambda_u2413_u24lambda_u2412.displayName = newMinionName;
        $this$onChat_u24lambda_u2413_u24lambda_u2412.lastClicked = 0L;
        map2.put(lorenzVec2, minionConfig);
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(MinionFeatures.class, "minionUpgradePattern", "getMinionUpgradePattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MinionFeatures.class, "minionCoinPattern", "getMinionCoinPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MinionFeatures.class, "minionTitlePattern", "getMinionTitlePattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MinionFeatures.class, "minionCollectItemPattern", "getMinionCollectItemPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new MinionFeatures();
        coinsPerDay = "";
        patternGroup = RepoPattern.Companion.group("minion");
        minionUpgradePattern$delegate = patternGroup.pattern("chat.upgrade", "\u00a7aYou have upgraded your Minion to Tier (?<tier>.*)");
        minionCoinPattern$delegate = patternGroup.pattern("chat.coin", "\u00a7aYou received \u00a7r\u00a76(.*) coins\u00a7r\u00a7a!");
        minionTitlePattern$delegate = patternGroup.pattern("title", "Minion [^\u279c]");
        minionCollectItemPattern$delegate = patternGroup.pattern("item.collect", "^\u00a7aCollect All$");
    }
}

