/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.minion;

import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.MinionOpenEvent;
import at.hannibal2.skyhanni.events.entity.ItemAddInInventoryEvent;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NEUItems;
import at.hannibal2.skyhanni.utils.PrimitiveItemStack;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001b\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0003R\"\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lat/hannibal2/skyhanni/features/minion/MinionCollectLogic;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/MinionOpenEvent;", "event", "", "onMinionOpen", "(Lat/hannibal2/skyhanni/events/MinionOpenEvent;)V", "", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "", "count", "()Ljava/util/Map;", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "closeMinion", "", "oldMap", "Ljava/util/Map;", "1.8.9"})
public final class MinionCollectLogic {
    @NotNull
    public static final MinionCollectLogic INSTANCE = new MinionCollectLogic();
    @NotNull
    private static Map<NEUInternalName, Integer> oldMap = MapsKt.emptyMap();

    private MinionCollectLogic() {
    }

    @SubscribeEvent
    public final void onMinionOpen(@NotNull MinionOpenEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!oldMap.isEmpty()) {
            return;
        }
        oldMap = this.count();
    }

    private final Map<NEUInternalName, Integer> count() {
        Map map2 = new LinkedHashMap();
        for (ItemStack stack : InventoryUtils.INSTANCE.getItemsInOwnInventory()) {
            NEUInternalName internalName = ItemUtils.INSTANCE.getInternalName(stack);
            PrimitiveItemStack primitiveItemStack = NEUItems.getPrimitiveMultiplier$default(NEUItems.INSTANCE, internalName, 0, 2, null);
            NEUInternalName newId = primitiveItemStack.component1();
            int amount = primitiveItemStack.component2();
            Integer n = (Integer)map2.get(newId);
            int old = n != null ? n : 0;
            map2.put(newId, old + amount * stack.field_77994_a);
        }
        return map2;
    }

    @SubscribeEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        this.closeMinion();
    }

    private final void closeMinion() {
        if (oldMap.isEmpty()) {
            return;
        }
        for (Map.Entry<NEUInternalName, Integer> entry : this.count().entrySet()) {
            NEUInternalName internalId = entry.getKey();
            int amount = ((Number)entry.getValue()).intValue();
            Integer n = oldMap.get(internalId);
            int old = n != null ? n : 0;
            int diff = amount - old;
            if (diff <= 0) continue;
            new ItemAddInInventoryEvent(internalId, diff).postAndCatch();
        }
        oldMap = MapsKt.emptyMap();
    }
}

