/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.mining.fossilexcavator;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.mining.ExcavatorProfitTrackerConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.ItemAddManager;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.IslandChangeEvent;
import at.hannibal2.skyhanni.events.ItemAddEvent;
import at.hannibal2.skyhanni.events.mining.FossilExcavationEvent;
import at.hannibal2.skyhanni.features.mining.fossilexcavator.FossilExcavatorAPI;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NEUItems;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.renderables.Searchable;
import at.hannibal2.skyhanni.utils.renderables.SearchableKt;
import at.hannibal2.skyhanni.utils.tracker.ItemTrackerData;
import at.hannibal2.skyhanni.utils.tracker.SkyHanniItemTracker;
import com.google.gson.annotations.Expose;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001=B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ)\u0010\u000f\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J!\u0010\u0012\u001a\u00020\u0011*\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J)\u0010\u0015\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0010J\u0017\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0016H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J'\u0010 \u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b \u0010!J\u0017\u0010#\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\"H\u0007\u00a2\u0006\u0004\b#\u0010$J\u001f\u0010'\u001a\u00020\u00112\u0006\u0010&\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010*\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020)H\u0007\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010-\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020,H\u0007\u00a2\u0006\u0004\b-\u0010.J\r\u0010/\u001a\u00020\u001e\u00a2\u0006\u0004\b/\u00100J\r\u00101\u001a\u00020\u0011\u00a2\u0006\u0004\b1\u0010\u0003R\u001c\u00106\u001a\n 3*\u0004\u0018\u000102028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\"\u00108\u001a\u0010\u0012\f\u0012\n 3*\u0004\u0018\u00010\u00040\u0004078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00109R\u0014\u0010<\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;\u00a8\u0006>"}, d2={"Lat/hannibal2/skyhanni/features/mining/fossilexcavator/ExcavatorProfitTracker;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/features/mining/fossilexcavator/ExcavatorProfitTracker$Data;", "data", "", "Lat/hannibal2/skyhanni/utils/renderables/Searchable;", "drawDisplay", "(Lat/hannibal2/skyhanni/features/mining/fossilexcavator/ExcavatorProfitTracker$Data;)Ljava/util/List;", "", "", "fossilDustGained", "", "profit", "addFossilDust", "(Ljava/util/List;JD)D", "", "addGlacitePowder", "(Ljava/util/List;Lat/hannibal2/skyhanni/features/mining/fossilexcavator/ExcavatorProfitTracker$Data;)V", "timesExcavated", "addScrap", "Lat/hannibal2/skyhanni/events/ItemAddEvent;", "event", "onItemAdd", "(Lat/hannibal2/skyhanni/events/ItemAddEvent;)V", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "internalName", "", "amount", "", "command", "tryAddItem", "(Lat/hannibal2/skyhanni/utils/NEUInternalName;IZ)V", "Lat/hannibal2/skyhanni/events/mining/FossilExcavationEvent;", "onFossilExcavation", "(Lat/hannibal2/skyhanni/events/mining/FossilExcavationEvent;)V", "", "name", "addItem", "(Ljava/lang/String;I)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent;)V", "Lat/hannibal2/skyhanni/events/IslandChangeEvent;", "onIslandChange", "(Lat/hannibal2/skyhanni/events/IslandChangeEvent;)V", "isEnabled", "()Z", "resetCommand", "Lat/hannibal2/skyhanni/config/features/mining/ExcavatorProfitTrackerConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/mining/ExcavatorProfitTrackerConfig;", "config", "Lat/hannibal2/skyhanni/utils/tracker/SkyHanniItemTracker;", "tracker", "Lat/hannibal2/skyhanni/utils/tracker/SkyHanniItemTracker;", "getScrapItem", "()Lat/hannibal2/skyhanni/utils/NEUInternalName;", "scrapItem", "Data", "1.8.9"})
public final class ExcavatorProfitTracker {
    @NotNull
    public static final ExcavatorProfitTracker INSTANCE = new ExcavatorProfitTracker();
    @NotNull
    private static final SkyHanniItemTracker<Data> tracker = new SkyHanniItemTracker<Data>("Fossil Excavation Profit Tracker", ExcavatorProfitTracker::tracker$lambda$0, ExcavatorProfitTracker::tracker$lambda$1, new Pair[0], ExcavatorProfitTracker::tracker$lambda$2);

    private ExcavatorProfitTracker() {
    }

    private final ExcavatorProfitTrackerConfig getConfig() {
        return SkyHanniMod.feature.mining.fossilExcavator.profitTracker;
    }

    private final NEUInternalName getScrapItem() {
        return FossilExcavatorAPI.INSTANCE.getScrapItem();
    }

    private final List<Searchable> drawDisplay(Data data2) {
        List<Searchable> list;
        List<Searchable> $this$drawDisplay_u24lambda_u244 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        CollectionUtils.addSearchString$default(CollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u244, "\u00a7e\u00a7lFossil Excavation Profit Tracker", null, null, null, 14, null);
        double profit = tracker.drawItems((Data)((ItemTrackerData)data2), ExcavatorProfitTracker::drawDisplay$lambda$4$lambda$3, $this$drawDisplay_u24lambda_u244);
        long timesExcavated = data2.getTimesExcavated();
        $this$drawDisplay_u24lambda_u244.add(SearchableKt.toSearchable$default(Renderable.Companion.hoverTips$default(Renderable.Companion, "\u00a77Times excavated: \u00a7e" + NumberUtil.INSTANCE.addSeparators(timesExcavated), CollectionsKt.listOf("\u00a77You excavated \u00a7e" + NumberUtil.INSTANCE.addSeparators(timesExcavated) + " \u00a77times."), null, null, null, false, false, false, null, null, 1020, null), null, 1, null));
        profit = INSTANCE.addScrap($this$drawDisplay_u24lambda_u244, timesExcavated, profit);
        if (ExcavatorProfitTracker.INSTANCE.getConfig().showFossilDust) {
            profit = INSTANCE.addFossilDust($this$drawDisplay_u24lambda_u244, data2.getFossilDustGained(), profit);
        }
        if (ExcavatorProfitTracker.INSTANCE.getConfig().trackGlacitePowder) {
            INSTANCE.addGlacitePowder($this$drawDisplay_u24lambda_u244, data2);
        }
        $this$drawDisplay_u24lambda_u244.add(tracker.addTotalProfit(profit, data2.getTimesExcavated(), "excavation"));
        tracker.addPriceFromButton($this$drawDisplay_u24lambda_u244);
        return CollectionsKt.build(list);
    }

    private final double addFossilDust(List<Searchable> $this$addFossilDust, long fossilDustGained, double profit) {
        if (fossilDustGained <= 0L) {
            return profit;
        }
        double pricePer = NEUItems.getPrice$default(NEUItems.INSTANCE, this.getScrapItem(), null, null, 3, null) / (double)500;
        double fossilDustPrice = pricePer * (double)fossilDustGained;
        String[] stringArray = new String[]{"\u00a77You gained \u00a76" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, fossilDustPrice, false, 1, null) + " coins \u00a77in total", "\u00a77for all \u00a7e" + fossilDustGained + " \u00a7fFossil Dust", "\u00a77you have collected.", "", "\u00a77Price Per Fossil Dust: \u00a76" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, pricePer, false, 1, null)};
        $this$addFossilDust.add(SearchableKt.toSearchable(Renderable.Companion.hoverTips$default(Renderable.Companion, "\u00a77" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, fossilDustGained, false, 1, null) + "x \u00a7fFossil Dust\u00a77: \u00a76" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, fossilDustPrice, false, 1, null), CollectionsKt.listOf(stringArray), null, null, null, false, false, false, null, null, 1020, null), "Fossil Dust"));
        return profit + fossilDustPrice;
    }

    private final void addGlacitePowder(List<Searchable> $this$addGlacitePowder, Data data2) {
        long glacitePowderGained = data2.getGlacitePowderGained();
        if (glacitePowderGained <= 0L) {
            return;
        }
        String[] stringArray = new String[]{"\u00a77No real profit,", "\u00a77but still nice to see! Right?"};
        $this$addGlacitePowder.add(SearchableKt.toSearchable(Renderable.Companion.hoverTips$default(Renderable.Companion, "\u00a7bGlacite Powder\u00a77: \u00a7e" + NumberUtil.INSTANCE.addSeparators(glacitePowderGained), CollectionsKt.listOf(stringArray), null, null, null, false, false, false, null, null, 1020, null), "Glacite Powder"));
    }

    private final double addScrap(List<Searchable> $this$addScrap, long timesExcavated, double profit) {
        if (timesExcavated <= 0L) {
            return profit;
        }
        double scrapPrice = (double)timesExcavated * NEUItems.getPrice$default(NEUItems.INSTANCE, this.getScrapItem(), null, null, 3, null);
        String name2 = StringUtils.pluralize$default(StringUtils.INSTANCE, (int)timesExcavated, ItemUtils.INSTANCE.getItemName(this.getScrapItem()), null, false, 12, null);
        String[] stringArray = new String[]{"\u00a77You paid \u00a7c" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, scrapPrice, false, 1, null) + " coins \u00a77in total", "\u00a77for all \u00a7e" + timesExcavated + ' ' + name2, "\u00a77you have used."};
        $this$addScrap.add(SearchableKt.toSearchable(Renderable.Companion.hoverTips$default(Renderable.Companion, name2 + " \u00a77price: \u00a7c-" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, scrapPrice, false, 1, null), CollectionsKt.listOf(stringArray), null, null, null, false, false, false, null, null, 1020, null), "Scrap"));
        return profit - scrapPrice;
    }

    @SubscribeEvent
    public final void onItemAdd(@NotNull ItemAddEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        NEUInternalName internalName = event.getInternalName();
        if (event.getSource() == ItemAddManager.Source.COMMAND) {
            this.tryAddItem(internalName, event.getAmount(), true);
        }
    }

    private final void tryAddItem(NEUInternalName internalName, int amount, boolean command2) {
        tracker.addItem(internalName, amount, command2);
    }

    @SubscribeEvent
    public final void onFossilExcavation(@NotNull FossilExcavationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        for (Pair<String, Integer> pair : event.getLoot()) {
            String name2 = pair.component1();
            int amount = ((Number)pair.component2()).intValue();
            this.addItem(name2, amount);
        }
        tracker.modify(ExcavatorProfitTracker::onFossilExcavation$lambda$5);
    }

    private final void addItem(String name2, int amount) {
        if (Intrinsics.areEqual(name2, "\u00a7bGlacite Powder")) {
            if (this.getConfig().trackGlacitePowder) {
                tracker.modify(arg_0 -> ExcavatorProfitTracker.addItem$lambda$6(amount, arg_0));
            }
            return;
        }
        if (Intrinsics.areEqual(name2, "\u00a7fFossil Dust")) {
            if (this.getConfig().showFossilDust) {
                tracker.modify(arg_0 -> ExcavatorProfitTracker.addItem$lambda$7(amount, arg_0));
            }
            return;
        }
        NEUInternalName internalName = NEUInternalName.Companion.fromItemNameOrNull(name2);
        if (internalName == null) {
            ChatUtils.INSTANCE.debug("no price for excavator profit: '" + name2 + '\'');
            return;
        }
        this.tryAddItem(internalName, amount, false);
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        boolean inChest = Minecraft.func_71410_x().field_71462_r instanceof GuiChest;
        if (inChest && !FossilExcavatorAPI.INSTANCE.getInExcavatorMenu()) {
            return;
        }
        Position position = this.getConfig().position;
        Intrinsics.checkNotNullExpressionValue(position, "position");
        tracker.renderDisplay(position);
    }

    @SubscribeEvent
    public final void onIslandChange(@NotNull IslandChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (event.getNewIsland() == IslandType.DWARVEN_MINES) {
            tracker.firstUpdate();
        }
    }

    public final boolean isEnabled() {
        return LorenzUtils.INSTANCE.isInIsland(IslandType.DWARVEN_MINES) && this.getConfig().enabled && Intrinsics.areEqual(LorenzUtils.INSTANCE.getSkyBlockArea(), "Fossil Research Center");
    }

    public final void resetCommand() {
        tracker.resetCommand();
    }

    private static final Data tracker$lambda$0() {
        return new Data();
    }

    private static final Data tracker$lambda$1(ProfileSpecificStorage it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.mining.fossilExcavatorProfitTracker;
    }

    private static final List tracker$lambda$2(Data it) {
        Intrinsics.checkNotNull(it);
        return INSTANCE.drawDisplay(it);
    }

    private static final boolean drawDisplay$lambda$4$lambda$3(NEUInternalName it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return true;
    }

    private static final Unit onFossilExcavation$lambda$5(Data it) {
        long l = it.getTimesExcavated();
        it.setTimesExcavated(l + 1L);
        return Unit.INSTANCE;
    }

    private static final Unit addItem$lambda$6(int $amount, Data it) {
        it.setGlacitePowderGained(it.getGlacitePowderGained() + (long)$amount);
        return Unit.INSTANCE;
    }

    private static final Unit addItem$lambda$7(int $amount, Data it) {
        it.setFossilDustGained(it.getFossilDustGained() + (long)$amount);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\"\u0010\u0012\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0013\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\"\u0010\u001b\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u0013\u001a\u0004\b\u001c\u0010\u0015\"\u0004\b\u001d\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lat/hannibal2/skyhanni/features/mining/fossilexcavator/ExcavatorProfitTracker$Data;", "Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData;", "<init>", "()V", "", "resetItems", "", "timesGained", "", "", "getDescription", "(J)Ljava/util/List;", "Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;", "item", "getCoinName", "(Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;)Ljava/lang/String;", "getCoinDescription", "(Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;)Ljava/util/List;", "timesExcavated", "J", "getTimesExcavated", "()J", "setTimesExcavated", "(J)V", "glacitePowderGained", "getGlacitePowderGained", "setGlacitePowderGained", "fossilDustGained", "getFossilDustGained", "setFossilDustGained", "1.8.9"})
    public static final class Data
    extends ItemTrackerData {
        @Expose
        private long timesExcavated;
        @Expose
        private long glacitePowderGained;
        @Expose
        private long fossilDustGained;

        @Override
        public void resetItems() {
            this.timesExcavated = 0L;
            this.glacitePowderGained = 0L;
            this.fossilDustGained = 0L;
        }

        @Override
        @NotNull
        public List<String> getDescription(long timesGained) {
            double percentage = (double)timesGained / (double)this.timesExcavated;
            String dropRate = LorenzUtils.INSTANCE.formatPercentage(RangesKt.coerceAtMost(percentage, 1.0));
            String[] stringArray = new String[]{"\u00a77Dropped \u00a7e" + NumberUtil.INSTANCE.addSeparators(timesGained) + " \u00a77times.", "\u00a77Your drop rate: \u00a7c" + dropRate + '.'};
            return CollectionsKt.listOf(stringArray);
        }

        @Override
        @NotNull
        public String getCoinName(@NotNull ItemTrackerData.TrackedItem item) {
            Intrinsics.checkNotNullParameter(item, "item");
            return "<no coins>";
        }

        @Override
        @NotNull
        public List<String> getCoinDescription(@NotNull ItemTrackerData.TrackedItem item) {
            Intrinsics.checkNotNullParameter(item, "item");
            return CollectionsKt.listOf("<no coins>");
        }

        public final long getTimesExcavated() {
            return this.timesExcavated;
        }

        public final void setTimesExcavated(long l) {
            this.timesExcavated = l;
        }

        public final long getGlacitePowderGained() {
            return this.glacitePowderGained;
        }

        public final void setGlacitePowderGained(long l) {
            this.glacitePowderGained = l;
        }

        public final long getFossilDustGained() {
            return this.fossilDustGained;
        }

        public final void setFossilDustGained(long l) {
            this.fossilDustGained = l;
        }
    }
}

