/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.mining;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.mining.DeepCavernsGuideConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.jsonobjects.repo.ParkourJson;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.data.repo.RepoManager;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.events.IslandChangeEvent;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.render.gui.ReplaceItemEvent;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NEUItems;
import at.hannibal2.skyhanni.utils.ParkourHelper;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.player.inventory.ContainerLocalMenu;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0003J\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0003J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001dH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010!\u001a\u00020 \u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020#H\u0007\u00a2\u0006\u0004\b$\u0010%R\u001c\u0010*\u001a\n '*\u0004\u0018\u00010&0&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0018\u0010,\u001a\u0004\u0018\u00010+8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0016\u0010.\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0016\u00100\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u0010/R\u001b\u00106\u001a\u0002018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105\u00a8\u00067"}, d2={"Lat/hannibal2/skyhanni/features/mining/DeepCavernsGuide;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/IslandChangeEvent;", "event", "", "onIslandChange", "(Lat/hannibal2/skyhanni/events/IslandChangeEvent;)V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "Lat/hannibal2/skyhanni/events/ConfigLoadEvent;", "onConfigLoad", "(Lat/hannibal2/skyhanni/events/ConfigLoadEvent;)V", "updateConfig", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "onInventoryOpen", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "start", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/events/render/gui/ReplaceItemEvent;", "replaceItem", "(Lat/hannibal2/skyhanni/events/render/gui/ReplaceItemEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;", "onSlotClick", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/mining/DeepCavernsGuideConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/mining/DeepCavernsGuideConfig;", "config", "Lat/hannibal2/skyhanni/utils/ParkourHelper;", "parkourHelper", "Lat/hannibal2/skyhanni/utils/ParkourHelper;", "show", "Z", "showStartIcon", "Lnet/minecraft/item/ItemStack;", "startIcon$delegate", "Lkotlin/Lazy;", "getStartIcon", "()Lnet/minecraft/item/ItemStack;", "startIcon", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nDeepCavernsGuide.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeepCavernsGuide.kt\nat/hannibal2/skyhanni/features/mining/DeepCavernsGuide\n+ 2 RepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/RepositoryReloadEvent\n*L\n1#1,158:1\n12#2,7:159\n*S KotlinDebug\n*F\n+ 1 DeepCavernsGuide.kt\nat/hannibal2/skyhanni/features/mining/DeepCavernsGuide\n*L\n59#1:159,7\n*E\n"})
public final class DeepCavernsGuide {
    @NotNull
    public static final DeepCavernsGuide INSTANCE = new DeepCavernsGuide();
    @Nullable
    private static ParkourHelper parkourHelper;
    private static boolean show;
    private static boolean showStartIcon;
    @NotNull
    private static final Lazy startIcon$delegate;

    private DeepCavernsGuide() {
    }

    private final DeepCavernsGuideConfig getConfig() {
        return SkyHanniMod.feature.mining.deepCavernsGuide;
    }

    private final ItemStack getStartIcon() {
        Lazy lazy = startIcon$delegate;
        return (ItemStack)lazy.getValue();
    }

    @SubscribeEvent
    public final void onIslandChange(@NotNull IslandChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ParkourHelper parkourHelper = DeepCavernsGuide.parkourHelper;
        if (parkourHelper != null) {
            parkourHelper.reset();
        }
        show = false;
    }

    @SubscribeEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        ParkourJson parkourJson;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String constant$iv = "DeepCavernsParkour";
        Type type$iv = null;
        Gson gson$iv = event.getGson();
        boolean $i$f$getConstant = false;
        try {
            RepoManager.Companion.setLastConstant(constant$iv);
            if (!event.getRepoLocation().exists()) {
                throw new RepoError("Repo folder does not exist!");
            }
            parkourJson = RepoUtils.INSTANCE.getConstant(event.getRepoLocation(), constant$iv, gson$iv, ParkourJson.class, type$iv);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv);
        }
        ParkourJson data2 = parkourJson;
        parkourHelper = new ParkourHelper(data2.getLocations(), data2.getShortCuts(), 1.0, 3.5, false, DeepCavernsGuide::onRepoReload$lambda$1);
        this.updateConfig();
    }

    @SubscribeEvent
    public final void onConfigLoad(@NotNull ConfigLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Property[] propertyArray = new Property[]{this.getConfig().rainbowColor, this.getConfig().monochromeColor, this.getConfig().lookAhead};
        ConditionalUtils.INSTANCE.onToggle(propertyArray, DeepCavernsGuide::onConfigLoad$lambda$2);
    }

    private final void updateConfig() {
        block0: {
            ParkourHelper parkourHelper = DeepCavernsGuide.parkourHelper;
            if (parkourHelper == null) break block0;
            ParkourHelper $this$updateConfig_u24lambda_u243 = parkourHelper;
            boolean bl = false;
            $this$updateConfig_u24lambda_u243.setRainbowColor((Boolean)DeepCavernsGuide.INSTANCE.getConfig().rainbowColor.get());
            Object t = DeepCavernsGuide.INSTANCE.getConfig().monochromeColor.get();
            Intrinsics.checkNotNullExpressionValue(t, "get(...)");
            $this$updateConfig_u24lambda_u243.setMonochromeColor(ColorUtils.INSTANCE.toChromaColor((String)t));
            $this$updateConfig_u24lambda_u243.setLookAhead(((Number)DeepCavernsGuide.INSTANCE.getConfig().lookAhead.get()).intValue() + 1);
        }
    }

    @SubscribeEvent
    public final void onInventoryOpen(@NotNull InventoryFullyOpenedEvent event) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)event, "event");
            showStartIcon = false;
            if (!this.isEnabled()) {
                return;
            }
            if (!Intrinsics.areEqual(event.getInventoryName(), "Lift")) {
                return;
            }
            if (!Intrinsics.areEqual(LorenzUtils.INSTANCE.getSkyBlockArea(), "Gunpowder Mines")) {
                return;
            }
            showStartIcon = true;
            ItemStack itemStack2 = event.getInventoryItems().get(30);
            if (itemStack2 == null) break block4;
            ItemStack it = itemStack2;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.func_82833_r(), "\u00a7aObsidian Sanctuary") && !show) {
                INSTANCE.start();
                ChatUtils.chat$default(ChatUtils.INSTANCE, "Automatically enabling Deep Caverns Guide, helping you find the way to the bottom of the Deep Caverns and the path to Rhys.", false, null, 6, null);
            }
        }
    }

    private final void start() {
        show = true;
        ParkourHelper parkourHelper = DeepCavernsGuide.parkourHelper;
        if (parkourHelper != null) {
            parkourHelper.reset();
        }
        if (DeepCavernsGuide.parkourHelper == null) {
            ChatUtils.clickableChat-gdl2klw$default(ChatUtils.INSTANCE, "DeepCavernsParkour missing in SkyHanni Repo! Try /shupdaterepo to fix it!", DeepCavernsGuide::start$lambda$5, "\u00a7eClick to update the repo!", 0L, false, "\u00a7c", false, 88, null);
        }
    }

    @SubscribeEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        showStartIcon = false;
    }

    @SubscribeEvent
    public final void replaceItem(@NotNull ReplaceItemEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (show) {
            return;
        }
        if (event.getInventory() instanceof ContainerLocalMenu && showStartIcon && event.getSlot() == 49) {
            event.replace(this.getStartIcon());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public final void onSlotClick(@NotNull GuiContainerEvent.SlotClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (showStartIcon && event.getSlotId() == 49) {
            event.cancel();
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Manually enabled Deep Caverns Guide.", false, null, 6, null);
            this.start();
        }
    }

    @SubscribeEvent
    public final void onRenderWorld(@NotNull LorenzRenderWorldEvent event) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)event, "event");
            if (!this.isEnabled()) {
                return;
            }
            if (!show) {
                return;
            }
            ParkourHelper parkourHelper = DeepCavernsGuide.parkourHelper;
            if (parkourHelper == null) break block2;
            parkourHelper.render(event);
        }
    }

    public final boolean isEnabled() {
        return LorenzUtils.INSTANCE.isInIsland(IslandType.DEEP_CAVERNS) && this.getConfig().enabled;
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 38, "mining.deepCavernsParkour", "mining.deepCavernsGuide", null, 8, null);
    }

    private static final ItemStack startIcon_delegate$lambda$0() {
        ItemStack neuItem = NEUItems.INSTANCE.getItemStack(NEUInternalName.Companion.asInternalName("MAP"));
        Item item = neuItem.func_77973_b();
        Intrinsics.checkNotNullExpressionValue(item, "getItem(...)");
        String[] stringArray = new String[]{"\u00a78(From SkyHanni)", "", "\u00a77Manually enable the ", "\u00a77guide to the bottom", "\u00a77of the Deep Caverns."};
        return ItemUtils.INSTANCE.createItemStack(item, "\u00a7bDeep Caverns Guide", stringArray);
    }

    private static final Unit onRepoReload$lambda$1() {
        show = false;
        return Unit.INSTANCE;
    }

    private static final void onConfigLoad$lambda$2() {
        INSTANCE.updateConfig();
    }

    private static final Unit start$lambda$5() {
        SkyHanniMod.Companion.getRepo().updateRepo();
        return Unit.INSTANCE;
    }

    static {
        startIcon$delegate = LazyKt.lazy(DeepCavernsGuide::startIcon_delegate$lambda$0);
    }
}

