/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory.chocolatefactory;

import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.inventory.chocolatefactory.ChocolateFactoryCustomReminderConfig;
import at.hannibal2.skyhanni.config.features.inventory.chocolatefactory.ChocolateUpgradeWarningsConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.hypixel.chat.event.SystemMessageEvent;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.features.fame.ReminderUtils;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.ChocolateAmount;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.ChocolateFactoryAPI;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.ChocolateShopPrice;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternList;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J%\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00142\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u001cH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001f\u0010\u0006J\u001f\u0010\"\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010$\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b$\u0010\u0003J\u0011\u0010%\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010'\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b'\u0010\u0003J\u000f\u0010(\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b(\u0010\u0003J\r\u0010)\u001a\u00020\u0004\u00a2\u0006\u0004\b)\u0010\u0006R\u001c\u0010.\u001a\n +*\u0004\u0018\u00010*0*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u001c\u00102\u001a\n +*\u0004\u0018\u00010/0/8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R(\u00108\u001a\u0004\u0018\u00010\u00152\b\u00103\u001a\u0004\u0018\u00010\u00158B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b4\u00105\"\u0004\b6\u00107R(\u0010<\u001a\u0004\u0018\u00010\u00162\b\u00103\u001a\u0004\u0018\u00010\u00168B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b9\u0010&\"\u0004\b:\u0010;R\u001c\u0010?\u001a\b\u0012\u0004\u0012\u00020>0=8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b?\u0010@R\u0016\u0010B\u001a\u00020A8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u0014\u0010E\u001a\u00020D8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bE\u0010FR\u001b\u0010L\u001a\u00020G8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bH\u0010I\u001a\u0004\bJ\u0010KR!\u0010Q\u001a\b\u0012\u0004\u0012\u00020G0=8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bM\u0010N\u001a\u0004\bO\u0010P\u00a8\u0006R"}, d2={"Lat/hannibal2/skyhanni/features/inventory/chocolatefactory/ChocolateFactoryCustomReminder;", "", "<init>", "()V", "", "isActive", "()Z", "Lat/hannibal2/skyhanni/data/hypixel/chat/event/SystemMessageEvent;", "event", "", "onChat", "(Lat/hannibal2/skyhanni/data/hypixel/chat/event/SystemMessageEvent;)V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;", "onSlotClick", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;)V", "Lnet/minecraft/item/ItemStack;", "item", "Lkotlin/Pair;", "", "", "getCostAndName", "(Lnet/minecraft/item/ItemStack;)Lkotlin/Pair;", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;", "onBackgroundDraw", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "inChocolateMenu", "target", "name", "setReminder", "(JLjava/lang/String;)V", "update", "getTargetDescription", "()Ljava/lang/String;", "warn", "reset", "isEnabled", "Lat/hannibal2/skyhanni/config/features/inventory/chocolatefactory/ChocolateFactoryCustomReminderConfig;", "kotlin.jvm.PlatformType", "getConfigReminder", "()Lat/hannibal2/skyhanni/config/features/inventory/chocolatefactory/ChocolateFactoryCustomReminderConfig;", "configReminder", "Lat/hannibal2/skyhanni/config/features/inventory/chocolatefactory/ChocolateUpgradeWarningsConfig;", "getConfigUpgradeWarnings", "()Lat/hannibal2/skyhanni/config/features/inventory/chocolatefactory/ChocolateUpgradeWarningsConfig;", "configUpgradeWarnings", "value", "getTargetGoal", "()Ljava/lang/Long;", "setTargetGoal", "(Ljava/lang/Long;)V", "targetGoal", "getTargetName", "setTargetName", "(Ljava/lang/String;)V", "targetName", "", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "display", "Ljava/util/List;", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastUpgradeWarning", "J", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "milestoneCostLorePattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getMilestoneCostLorePattern", "()Ljava/util/regex/Pattern;", "milestoneCostLorePattern", "chatMessagePattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternList;", "getChatMessagePattern", "()Ljava/util/List;", "chatMessagePattern", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nChocolateFactoryCustomReminder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChocolateFactoryCustomReminder.kt\nat/hannibal2/skyhanni/features/inventory/chocolatefactory/ChocolateFactoryCustomReminder\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,216:1\n43#2,2:217\n46#2:220\n1#3:219\n*S KotlinDebug\n*F\n+ 1 ChocolateFactoryCustomReminder.kt\nat/hannibal2/skyhanni/features/inventory/chocolatefactory/ChocolateFactoryCustomReminder\n*L\n114#1:217,2\n114#1:220\n114#1:219\n*E\n"})
public final class ChocolateFactoryCustomReminder {
    @NotNull
    public static final ChocolateFactoryCustomReminder INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static List<? extends Renderable> display;
    private static long lastUpgradeWarning;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern milestoneCostLorePattern$delegate;
    @NotNull
    private static final RepoPatternList chatMessagePattern$delegate;

    private ChocolateFactoryCustomReminder() {
    }

    private final ChocolateFactoryCustomReminderConfig getConfigReminder() {
        return ChocolateFactoryAPI.INSTANCE.getConfig().customReminder;
    }

    private final ChocolateUpgradeWarningsConfig getConfigUpgradeWarnings() {
        return ChocolateFactoryAPI.INSTANCE.getConfig().chocolateUpgradeWarnings;
    }

    private final Long getTargetGoal() {
        ProfileSpecificStorage.ChocolateFactoryStorage chocolateFactoryStorage = ChocolateFactoryAPI.INSTANCE.getProfileStorage();
        return chocolateFactoryStorage != null ? chocolateFactoryStorage.targetGoal : null;
    }

    private final void setTargetGoal(Long value) {
        block0: {
            if (ChocolateFactoryAPI.INSTANCE.getProfileStorage() == null) break block0;
            ChocolateFactoryAPI.INSTANCE.getProfileStorage().targetGoal = value;
        }
    }

    private final String getTargetName() {
        ProfileSpecificStorage.ChocolateFactoryStorage chocolateFactoryStorage = ChocolateFactoryAPI.INSTANCE.getProfileStorage();
        return chocolateFactoryStorage != null ? chocolateFactoryStorage.targetName : null;
    }

    private final void setTargetName(String value) {
        block0: {
            if (ChocolateFactoryAPI.INSTANCE.getProfileStorage() == null) break block0;
            ChocolateFactoryAPI.INSTANCE.getProfileStorage().targetName = value;
        }
    }

    public final boolean isActive() {
        return this.getTargetGoal() != null && this.getConfigReminder().enabled;
    }

    private final Pattern getMilestoneCostLorePattern() {
        return (Pattern)milestoneCostLorePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final List<Pattern> getChatMessagePattern() {
        return (List)chatMessagePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    @SubscribeEvent
    public final void onChat(@NotNull SystemMessageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!ChocolateFactoryAPI.INSTANCE.getInChocolateFactory()) {
            return;
        }
        if (this.getConfigReminder().hideChat && RegexUtils.INSTANCE.matches((Iterable<Pattern>)this.getChatMessagePattern(), event.getMessage())) {
            event.setBlockedReason("custom_reminder");
        }
    }

    @SubscribeEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        this.update();
    }

    @SubscribeEvent(receiveCanceled=true)
    public final void onSlotClick(@NotNull GuiContainerEvent.SlotClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        ItemStack itemStack2 = event.getItem();
        if (itemStack2 == null) {
            return;
        }
        ItemStack item = itemStack2;
        if (event.getClickedButton() != 0) {
            return;
        }
        Pair<Long, String> pair = this.getCostAndName(item);
        if (pair == null) {
            return;
        }
        Pair<Long, String> pair2 = pair;
        long cost = ((Number)pair2.component1()).longValue();
        String name2 = pair2.component2();
        long duration = ChocolateAmount.CURRENT.timeUntilGoal-5sfh64U(cost);
        if (Duration.isNegative-impl(duration)) {
            this.reset();
            return;
        }
        this.setReminder(cost, name2);
    }

    private final Pair<Long, String> getCostAndName(ItemStack item) {
        List<String> list = ItemUtils.INSTANCE.getLore(item);
        Long cost = ChocolateFactoryAPI.INSTANCE.getChocolateBuyCost(list);
        if (cost == null) {
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            Pattern $this$matchAll$iv = this.getMilestoneCostLorePattern();
            boolean $i$f$matchAll = false;
            for (String line$iv : list) {
                Matcher it$iv = $this$matchAll$iv.matcher(line$iv);
                boolean bl = false;
                if (!it$iv.find()) continue;
                Intrinsics.checkNotNull(it$iv);
                Matcher $this$getCostAndName_u24lambda_u240 = it$iv;
                boolean bl2 = false;
                String string2 = $this$getCostAndName_u24lambda_u240.group("amount");
                Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
                long amount = NumberUtil.INSTANCE.formatLong(string2);
                long allTime = ((Number)ChocolateAmount.ALL_TIME.getChocolate().invoke()).longValue();
                long missingAllTime = amount - allTime;
                long current = ((Number)ChocolateAmount.CURRENT.getChocolate().invoke()).longValue();
                long missing = missingAllTime + current;
                return TuplesKt.to(missing, "\u00a76" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, amount, false, 1, null) + " Chocolate Milestone");
            }
            return null;
        }
        String string3 = ChocolateFactoryAPI.INSTANCE.getNextLevelName(item);
        if (string3 == null) {
            string3 = ItemUtils.INSTANCE.getName(item);
        }
        String nextLevelName = string3;
        return TuplesKt.to(cost, nextLevelName);
    }

    @SubscribeEvent
    public final void onBackgroundDraw(@NotNull GuiRenderEvent.ChestGuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!this.inChocolateMenu()) {
            return;
        }
        if (ReminderUtils.isBusy$default(ReminderUtils.INSTANCE, false, 1, null)) {
            return;
        }
        Position position = this.getConfigReminder().position;
        Intrinsics.checkNotNullExpressionValue(position, "position");
        RenderUtils.renderRenderables$default(RenderUtils.INSTANCE, position, display, 0, "Chocolate Factory Custom Reminder", false, 10, null);
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!this.getConfigReminder().always) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiChest) {
            return;
        }
        if (ReminderUtils.isBusy$default(ReminderUtils.INSTANCE, false, 1, null)) {
            return;
        }
        Position position = this.getConfigReminder().position;
        Intrinsics.checkNotNullExpressionValue(position, "position");
        RenderUtils.renderRenderables$default(RenderUtils.INSTANCE, position, display, 0, "Chocolate Factory Custom Reminder", false, 10, null);
    }

    private final boolean inChocolateMenu() {
        return ChocolateShopPrice.INSTANCE.getInInventory() || ChocolateFactoryAPI.INSTANCE.getInChocolateFactory() || ChocolateFactoryAPI.INSTANCE.getChocolateFactoryPaused();
    }

    private final void setReminder(long target, String name2) {
        if (Intrinsics.areEqual(this.getTargetName(), name2)) {
            this.reset();
            return;
        }
        this.setTargetGoal(target);
        this.setTargetName(name2);
        this.update();
    }

    private final void update() {
        List list;
        List list2 = list = (List)new ArrayList();
        boolean bl = false;
        String string2 = INSTANCE.getTargetDescription();
        if (string2 != null) {
            String it = string2;
            boolean bl2 = false;
            list2.add(Renderable.Companion.clickAndHover$default(Renderable.Companion, it, CollectionsKt.listOf("\u00a7eClick to remove the goal!"), false, ChocolateFactoryCustomReminder::update$lambda$3$lambda$2$lambda$1, null, 20, null));
        }
        display = list;
    }

    private final String getTargetDescription() {
        Long l = this.getTargetGoal();
        if (l == null) {
            return null;
        }
        long goal = l;
        long duration = ChocolateAmount.CURRENT.timeUntilGoal-5sfh64U(goal);
        if (Duration.isNegative-impl(duration)) {
            this.warn();
            return "\u00a7aGoal Reached! \u00a7eBuy \u00a7f" + this.getTargetName();
        }
        String format = TimeUtils.format-bz6L7rs$default(TimeUtils.INSTANCE, duration, null, false, false, 2, false, 23, null);
        return "\u00a7f" + this.getTargetName() + " \u00a7ein \u00a7b" + format;
    }

    private final void warn() {
        if (ReminderUtils.isBusy$default(ReminderUtils.INSTANCE, false, 1, null)) {
            return;
        }
        if (this.inChocolateMenu()) {
            return;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastUpgradeWarning), TimeUtils.INSTANCE.getMinutes-5sfh64U(this.getConfigUpgradeWarnings().timeBetweenWarnings)) < 0) {
            return;
        }
        lastUpgradeWarning = SimpleTimeMark.Companion.now-uFjCsEo();
        if (this.getConfigUpgradeWarnings().upgradeWarningSound) {
            SoundUtils.INSTANCE.playBeepSound();
        }
        ChatUtils.INSTANCE.clickToActionOrDisable("You can now purchase \u00a7f" + this.getTargetName() + " \u00a7ein Chocolate factory!", new MutablePropertyReference0Impl(this.getConfigReminder()){

            public Object get() {
                return ((ChocolateFactoryCustomReminderConfig)this.receiver).enabled;
            }

            public void set(Object value) {
                ((ChocolateFactoryCustomReminderConfig)this.receiver).enabled = (Boolean)value;
            }
        }, "open Chocolate Factory", ChocolateFactoryCustomReminder::warn$lambda$4);
    }

    private final void reset() {
        this.setTargetGoal(null);
        this.setTargetName("");
        display = CollectionsKt.emptyList();
    }

    public final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && this.getConfigReminder().enabled;
    }

    private static final Unit update$lambda$3$lambda$2$lambda$1() {
        INSTANCE.reset();
        return Unit.INSTANCE;
    }

    private static final Unit warn$lambda$4() {
        HypixelCommands.INSTANCE.chocolateFactory();
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(ChocolateFactoryCustomReminder.class, "milestoneCostLorePattern", "getMilestoneCostLorePattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(ChocolateFactoryCustomReminder.class, "chatMessagePattern", "getChatMessagePattern()Ljava/util/List;", 0))};
        $$delegatedProperties = objectArray;
        INSTANCE = new ChocolateFactoryCustomReminder();
        display = CollectionsKt.emptyList();
        lastUpgradeWarning = SimpleTimeMark.Companion.farPast();
        patternGroup = RepoPattern.Companion.group("inventory.chocolate.factory");
        milestoneCostLorePattern$delegate = patternGroup.pattern("milestone.cost", "\u00a7cRequires (?<amount>.*) all-time Chocolate!");
        objectArray = new String[]{"\u00a7cYou don't have enough Chocolate!", "\u00a7cYou don't have the required items!", "\u00a7cYou must collect (.*) all-time Chocolate!"};
        chatMessagePattern$delegate = patternGroup.list("chat.hide", (String[])objectArray);
    }
}

