/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory.bazaar;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.inventory.BazaarConfig;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.features.inventory.bazaar.BazaarApi;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NEUItems;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.PrimitiveItemStack;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ%\u0010\u000e\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ)\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\n0\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0017\u001a\u00020\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0003J\u0019\u0010\u001b\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u001a0\u0015H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u0018J%\u0010\u001e\u001a\u00020\u001d2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u001c\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020 H\u0007\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020#H\u0007\u00a2\u0006\u0004\b$\u0010%J\r\u0010'\u001a\u00020&\u00a2\u0006\u0004\b'\u0010(R\u001c\u0010-\u001a\n **\u0004\u0018\u00010)0)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00110\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u001b\u00105\u001a\u0002008BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u00102\u001a\u0004\b3\u00104R\u0016\u00106\u001a\u00020&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0016\u00108\u001a\u00020&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00107R\u001c\u00109\u001a\b\u0012\u0004\u0012\u00020\u001a0\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010/R\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010/R\u0016\u0010\u001c\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010:\u00a8\u0006;"}, d2={"Lat/hannibal2/skyhanni/features/inventory/bazaar/CraftMaterialsFromBazaar;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "event", "", "onInventoryOpen", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "", "Lat/hannibal2/skyhanni/utils/PrimitiveItemStack;", "recipeMaterials", "", "recipeName", "showRecipe", "(Ljava/util/List;Ljava/lang/String;)V", "", "", "items", "calculateMaterialsNeeded", "(Ljava/util/Map;)Ljava/util/List;", "", "neededMaterials", "getFromBazaar", "(Ljava/util/List;)V", "updateBazaarDisplay", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "addMultipliers", "multiplier", "", "calculateTotalPrice", "(Ljava/util/List;I)D", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;", "onBackgroundDraw", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/inventory/BazaarConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/BazaarConfig;", "config", "materialSlots", "Ljava/util/List;", "Ljava/util/regex/Pattern;", "inventoryPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getInventoryPattern", "()Ljava/util/regex/Pattern;", "inventoryPattern", "inRecipeInventory", "Z", "purchasing", "display", "I", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nCraftMaterialsFromBazaar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CraftMaterialsFromBazaar.kt\nat/hannibal2/skyhanni/features/inventory/bazaar/CraftMaterialsFromBazaar\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n126#2:175\n153#2,3:176\n774#3:179\n865#3,2:180\n1#4:182\n*S KotlinDebug\n*F\n+ 1 CraftMaterialsFromBazaar.kt\nat/hannibal2/skyhanni/features/inventory/bazaar/CraftMaterialsFromBazaar\n*L\n95#1:175\n95#1:176,3\n155#1:179\n155#1:180,2\n*E\n"})
public final class CraftMaterialsFromBazaar {
    @NotNull
    public static final CraftMaterialsFromBazaar INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final List<Integer> materialSlots;
    @NotNull
    private static final RepoPattern inventoryPattern$delegate;
    private static boolean inRecipeInventory;
    private static boolean purchasing;
    @NotNull
    private static List<? extends Renderable> display;
    @NotNull
    private static List<PrimitiveItemStack> neededMaterials;
    private static int multiplier;

    private CraftMaterialsFromBazaar() {
    }

    private final BazaarConfig getConfig() {
        return SkyHanniMod.feature.inventory.bazaar;
    }

    private final Pattern getInventoryPattern() {
        return (Pattern)inventoryPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    @SubscribeEvent
    public final void onInventoryOpen(@NotNull InventoryFullyOpenedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        boolean correctInventoryName = RegexUtils.INSTANCE.matches(this.getInventoryPattern(), event.getInventoryName());
        Map<Integer, ItemStack> items = event.getInventoryItems();
        ItemStack itemStack2 = items.get(23);
        boolean correctItem = Intrinsics.areEqual(itemStack2 != null ? ItemUtils.INSTANCE.getName(itemStack2) : null, "\u00a7aCrafting Table");
        boolean bl = inRecipeInventory = correctInventoryName && correctItem && !purchasing;
        if (!inRecipeInventory) {
            return;
        }
        Object object = items.get(25);
        if (object == null || (object = ItemUtils.INSTANCE.getItemName((ItemStack)object)) == null) {
            return;
        }
        Object recipeName = object;
        this.showRecipe(this.calculateMaterialsNeeded(event.getInventoryItemsPrimitive()), (String)recipeName);
    }

    private final void showRecipe(List<PrimitiveItemStack> recipeMaterials, String recipeName) {
        List<Renderable> list;
        List neededMaterials = new ArrayList();
        List<Renderable> $this$showRecipe_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        double totalPrice = INSTANCE.calculateTotalPrice(recipeMaterials, 1);
        $this$showRecipe_u24lambda_u241.add(Renderable.Companion.string$default(Renderable.Companion, "\u00a77Craft " + recipeName + " \u00a77(\u00a76" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, totalPrice, false, 1, null) + "\u00a77)", 0.0, null, null, null, 30, null));
        for (PrimitiveItemStack item : recipeMaterials) {
            NEUInternalName material = item.getInternalName();
            int amount = item.getAmount();
            String text = "\u00a78" + NumberUtil.INSTANCE.addSeparators(amount) + "x " + ItemUtils.INSTANCE.getItemName(material);
            if (BazaarApi.INSTANCE.isBazaarItem(material)) {
                neededMaterials.add(item);
                text = text + " \u00a76" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, NEUItems.getPrice$default(NEUItems.INSTANCE, material, null, null, 3, null) * (double)amount, false, 1, null);
            }
            $this$showRecipe_u24lambda_u241.add(Renderable.Companion.string$default(Renderable.Companion, text, 0.0, null, null, null, 30, null));
        }
        if (!((Collection)neededMaterials).isEmpty()) {
            $this$showRecipe_u24lambda_u241.add(Renderable.Companion.clickAndHover$default(Renderable.Companion, "\u00a7eGet from bazaar!", CollectionsKt.listOf("\u00a7eClick here to buy the items from bazaar!"), false, () -> CraftMaterialsFromBazaar.showRecipe$lambda$1$lambda$0(neededMaterials), null, 20, null));
        }
        display = CollectionsKt.build(list);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PrimitiveItemStack> calculateMaterialsNeeded(Map<Integer, PrimitiveItemStack> items) {
        void $this$mapTo$iv$iv;
        Map item;
        Map recipeMaterials = new LinkedHashMap();
        Iterator<Integer> iterator2 = materialSlots.iterator();
        while (iterator2.hasNext()) {
            int slot = ((Number)iterator2.next()).intValue();
            if (items.get(slot) == null) continue;
            NEUInternalName internalName = ((PrimitiveItemStack)((Object)item)).getInternalName();
            CollectionUtils.INSTANCE.addOrPut(recipeMaterials, internalName, ((PrimitiveItemStack)((Object)item)).getAmount());
        }
        Map $this$map$iv = recipeMaterials;
        boolean $i$f$map = false;
        item = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator3 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator3.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PrimitiveItemStack.Companion.makePrimitiveStack((NEUInternalName)it.getKey(), ((Number)it.getValue()).intValue()));
        }
        return (List)destination$iv$iv;
    }

    private final void getFromBazaar(List<PrimitiveItemStack> neededMaterials) {
        CraftMaterialsFromBazaar.neededMaterials = neededMaterials;
        multiplier = 1;
        purchasing = true;
        this.updateBazaarDisplay();
    }

    private final void updateBazaarDisplay() {
        List<Renderable> list;
        List<Renderable> $this$updateBazaarDisplay_u24lambda_u245 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$updateBazaarDisplay_u24lambda_u245.add(Renderable.Companion.string$default(Renderable.Companion, "\u00a77Buy items from Bazaar:", 0.0, null, null, null, 30, null));
        for (PrimitiveItemStack primitiveItemStack : neededMaterials) {
            NEUInternalName material = primitiveItemStack.component1();
            int amount = primitiveItemStack.component2();
            int priceMultiplier = amount * multiplier;
            String text = "\u00a78" + NumberUtil.INSTANCE.addSeparators(priceMultiplier) + "x " + ItemUtils.INSTANCE.getItemName(material) + " \u00a76" + NumberUtil.INSTANCE.shortFormat(NEUItems.getPrice$default(NEUItems.INSTANCE, material, null, null, 3, null) * (double)priceMultiplier, false);
            $this$updateBazaarDisplay_u24lambda_u245.add(Renderable.Companion.optionalLink$default(Renderable.Companion, text, () -> CraftMaterialsFromBazaar.updateBazaarDisplay$lambda$5$lambda$3(material, priceMultiplier), false, null, null, 28, null));
        }
        $this$updateBazaarDisplay_u24lambda_u245.add(Renderable.Companion.clickAndHover$default(Renderable.Companion, "\u00a7eStop!", CollectionsKt.listOf("\u00a7eClick here to stop this view!"), false, CraftMaterialsFromBazaar::updateBazaarDisplay$lambda$5$lambda$4, null, 20, null));
        INSTANCE.addMultipliers($this$updateBazaarDisplay_u24lambda_u245);
        display = CollectionsKt.build(list);
    }

    private final void addMultipliers(List<Renderable> $this$addMultipliers) {
        Integer[] integerArray = new Integer[]{1, 5, 16, 32, 64, 512};
        Iterator<Integer> iterator2 = CollectionsKt.listOf(integerArray).iterator();
        while (iterator2.hasNext()) {
            int m = ((Number)iterator2.next()).intValue();
            boolean isThisMultiply = m == multiplier;
            String nameColor = isThisMultiply ? "\u00a7a" : "\u00a7e";
            String priceColor = isThisMultiply ? "\u00a76" : "\u00a77";
            String price = priceColor + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, this.calculateTotalPrice(neededMaterials, m), false, 1, null);
            String text = nameColor + "Mulitply x" + m + ' ' + price;
            if (!isThisMultiply) {
                $this$addMultipliers.add(Renderable.Companion.clickAndHover$default(Renderable.Companion, text, CollectionsKt.listOf("\u00a7eClick here to multiply the items needed times " + m + '!'), false, () -> CraftMaterialsFromBazaar.addMultipliers$lambda$6(m), null, 20, null));
                continue;
            }
            CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$addMultipliers, text, null, null, 6, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final double calculateTotalPrice(List<PrimitiveItemStack> neededMaterials, int multiplier) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = neededMaterials;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PrimitiveItemStack it = (PrimitiveItemStack)element$iv$iv;
            boolean bl = false;
            if (!BazaarApi.INSTANCE.isBazaarItem(it.getInternalName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        double d = 0.0;
        for (Object t : iterable2) {
            void it;
            PrimitiveItemStack primitiveItemStack = (PrimitiveItemStack)t;
            double d2 = d;
            boolean bl = false;
            double d3 = NEUItems.getPrice$default(NEUItems.INSTANCE, it.getInternalName(), null, null, 3, null) * (double)it.getAmount() * (double)multiplier;
            d = d2 + d3;
        }
        return d;
    }

    @SubscribeEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        inRecipeInventory = false;
    }

    @SubscribeEvent
    public final void onBackgroundDraw(@NotNull GuiRenderEvent.ChestGuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!inRecipeInventory && !purchasing) {
            return;
        }
        Position position = this.getConfig().craftMaterialsFromBazaarPosition;
        Intrinsics.checkNotNullExpressionValue(position, "craftMaterialsFromBazaarPosition");
        RenderUtils.renderRenderables$default(RenderUtils.INSTANCE, position, display, 0, "Craft Materials From Bazaar", false, 10, null);
    }

    public final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && this.getConfig().craftMaterialsFromBazaar;
    }

    private static final Unit showRecipe$lambda$1$lambda$0(List $neededMaterials) {
        Intrinsics.checkNotNullParameter($neededMaterials, "$neededMaterials");
        INSTANCE.getFromBazaar($neededMaterials);
        return Unit.INSTANCE;
    }

    private static final Unit updateBazaarDisplay$lambda$5$lambda$3(NEUInternalName $material, int $priceMultiplier) {
        Intrinsics.checkNotNullParameter($material, "$material");
        BazaarApi.INSTANCE.searchForBazaarItem($material, $priceMultiplier);
        return Unit.INSTANCE;
    }

    private static final Unit updateBazaarDisplay$lambda$5$lambda$4() {
        purchasing = false;
        display = CollectionsKt.emptyList();
        return Unit.INSTANCE;
    }

    private static final Unit addMultipliers$lambda$6(int $m) {
        multiplier = $m;
        INSTANCE.updateBazaarDisplay();
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(CraftMaterialsFromBazaar.class, "inventoryPattern", "getInventoryPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = objectArray;
        INSTANCE = new CraftMaterialsFromBazaar();
        objectArray = new Integer[]{10, 11, 12, 19, 20, 21, 28, 29, 30};
        materialSlots = CollectionsKt.listOf(objectArray);
        inventoryPattern$delegate = RepoPattern.Companion.pattern("inventory.recipe.title", ".* Recipe");
        display = CollectionsKt.emptyList();
        neededMaterials = CollectionsKt.emptyList();
        multiplier = 1;
    }
}

