/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory.bazaar;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.data.OwnInventoryData;
import at.hannibal2.skyhanni.data.bazaar.HypixelBazaarFetcher;
import at.hannibal2.skyhanni.events.BazaarOpenedProductEvent;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.features.dungeon.DungeonAPI;
import at.hannibal2.skyhanni.features.inventory.bazaar.BazaarData;
import at.hannibal2.skyhanni.features.inventory.bazaar.BazaarDataHolder;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NEUItems;
import at.hannibal2.skyhanni.utils.OSUtils;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005*\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\b\u001a\u00020\u0005*\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\u0007J\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0011\u0010\f\u001a\u00020\u000b*\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\u000eJ\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00152\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0017J\u0017\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001cH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ%\u0010!\u001a\u0004\u0018\u00010\u00042\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\t0\u001fH\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020#H\u0007\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010'\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020&H\u0007\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010*\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020)H\u0007\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010,\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b,\u0010-J\u0017\u0010/\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020.H\u0007\u00a2\u0006\u0004\b/\u00100J\u0017\u00102\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u000201H\u0007\u00a2\u0006\u0004\b2\u00103J\u0015\u00105\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u0015\u00a2\u0006\u0004\b5\u00106R\u0016\u00107\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0017\u0010:\u001a\u0002098\u0006\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=R\"\u0010>\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b>\u00108\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u0016\u0010C\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bC\u0010DR$\u0010E\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bE\u0010F\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR$\u0010K\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bK\u0010F\u001a\u0004\bL\u0010H\"\u0004\bM\u0010J\u00a8\u0006N"}, d2={"Lat/hannibal2/skyhanni/features/inventory/bazaar/BazaarApi;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "Lat/hannibal2/skyhanni/features/inventory/bazaar/BazaarData;", "getBazaarData", "(Lat/hannibal2/skyhanni/utils/NEUInternalName;)Lat/hannibal2/skyhanni/features/inventory/bazaar/BazaarData;", "getBazaarDataOrError", "Lnet/minecraft/item/ItemStack;", "stack", "", "isBazaarItem", "(Lnet/minecraft/item/ItemStack;)Z", "(Lat/hannibal2/skyhanni/utils/NEUInternalName;)Z", "internalName", "", "amount", "", "searchForBazaarItem", "(Lat/hannibal2/skyhanni/utils/NEUInternalName;I)V", "", "displayName", "(Ljava/lang/String;I)V", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "event", "onInventoryOpen", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;", "onSlotClick", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;)V", "", "inventoryItems", "getOpenedProduct", "(Ljava/util/Map;)Lat/hannibal2/skyhanni/utils/NEUInternalName;", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;", "onBackgroundDrawn", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "checkIfInBazaar", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)Z", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "inventoryName", "isBazaarOrderInventory", "(Ljava/lang/String;)Z", "loadedNpcPriceData", "Z", "Lat/hannibal2/skyhanni/features/inventory/bazaar/BazaarDataHolder;", "holder", "Lat/hannibal2/skyhanni/features/inventory/bazaar/BazaarDataHolder;", "getHolder", "()Lat/hannibal2/skyhanni/features/inventory/bazaar/BazaarDataHolder;", "inBazaarInventory", "getInBazaarInventory", "()Z", "setInBazaarInventory", "(Z)V", "currentSearchedItem", "Ljava/lang/String;", "currentlyOpenedProduct", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "getCurrentlyOpenedProduct", "()Lat/hannibal2/skyhanni/utils/NEUInternalName;", "setCurrentlyOpenedProduct", "(Lat/hannibal2/skyhanni/utils/NEUInternalName;)V", "orderOptionProduct", "getOrderOptionProduct", "setOrderOptionProduct", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nBazaarApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BazaarApi.kt\nat/hannibal2/skyhanni/features/inventory/bazaar/BazaarApi\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,195:1\n8#2:196\n1#3:197\n1#3:198\n1#3:209\n1611#4,9:199\n1863#4:208\n1864#4:210\n1620#4:211\n1755#4,3:212\n*S KotlinDebug\n*F\n+ 1 BazaarApi.kt\nat/hannibal2/skyhanni/features/inventory/bazaar/BazaarApi\n*L\n155#1:196\n155#1:197\n159#1:209\n159#1:199,9\n159#1:208\n159#1:210\n159#1:211\n160#1:212,3\n*E\n"})
public final class BazaarApi {
    @NotNull
    public static final BazaarApi INSTANCE = new BazaarApi();
    private static boolean loadedNpcPriceData;
    @NotNull
    private static final BazaarDataHolder holder;
    private static boolean inBazaarInventory;
    @NotNull
    private static String currentSearchedItem;
    @Nullable
    private static NEUInternalName currentlyOpenedProduct;
    @Nullable
    private static NEUInternalName orderOptionProduct;

    private BazaarApi() {
    }

    @NotNull
    public final BazaarDataHolder getHolder() {
        return holder;
    }

    public final boolean getInBazaarInventory() {
        return inBazaarInventory;
    }

    public final void setInBazaarInventory(boolean bl) {
        inBazaarInventory = bl;
    }

    @Nullable
    public final NEUInternalName getCurrentlyOpenedProduct() {
        return currentlyOpenedProduct;
    }

    public final void setCurrentlyOpenedProduct(@Nullable NEUInternalName nEUInternalName) {
        currentlyOpenedProduct = nEUInternalName;
    }

    @Nullable
    public final NEUInternalName getOrderOptionProduct() {
        return orderOptionProduct;
    }

    public final void setOrderOptionProduct(@Nullable NEUInternalName nEUInternalName) {
        orderOptionProduct = nEUInternalName;
    }

    @Nullable
    public final BazaarData getBazaarData(@NotNull NEUInternalName $this$getBazaarData) {
        Intrinsics.checkNotNullParameter($this$getBazaarData, "<this>");
        return HypixelBazaarFetcher.INSTANCE.getLatestProductInformation().get($this$getBazaarData);
    }

    @NotNull
    public final BazaarData getBazaarDataOrError(@NotNull NEUInternalName $this$getBazaarDataOrError) {
        Intrinsics.checkNotNullParameter($this$getBazaarDataOrError, "<this>");
        BazaarData bazaarData = this.getBazaarData($this$getBazaarDataOrError);
        if (bazaarData == null) {
            NEUInternalName $this$getBazaarDataOrError_u24lambda_u240 = $this$getBazaarDataOrError;
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to("internal name", $this$getBazaarDataOrError_u24lambda_u240)};
            ErrorManager.INSTANCE.skyHanniError("Can not find bazaar data for " + ItemUtils.INSTANCE.getItemName($this$getBazaarDataOrError_u24lambda_u240), pairArray);
            throw new KotlinNothingValueException();
        }
        return bazaarData;
    }

    public final boolean isBazaarItem(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return this.isBazaarItem(ItemUtils.INSTANCE.getInternalName(stack));
    }

    public final boolean isBazaarItem(@NotNull NEUInternalName $this$isBazaarItem) {
        Intrinsics.checkNotNullParameter($this$isBazaarItem, "<this>");
        return this.getBazaarData($this$isBazaarItem) != null;
    }

    public final void searchForBazaarItem(@NotNull NEUInternalName internalName, int amount) {
        Intrinsics.checkNotNullParameter(internalName, "internalName");
        this.searchForBazaarItem(ItemUtils.INSTANCE.getItemNameWithoutColor(internalName), amount);
    }

    public static /* synthetic */ void searchForBazaarItem$default(BazaarApi bazaarApi, NEUInternalName nEUInternalName, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        bazaarApi.searchForBazaarItem(nEUInternalName, n);
    }

    public final void searchForBazaarItem(@NotNull String displayName, int amount) {
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        if (NEUItems.INSTANCE.neuHasFocus()) {
            return;
        }
        if (LorenzUtils.INSTANCE.getNoTradeMode()) {
            return;
        }
        if (DungeonAPI.INSTANCE.inDungeon() || LorenzUtils.INSTANCE.getInKuudraFight()) {
            return;
        }
        HypixelCommands.INSTANCE.bazaar(StringUtils.removeColor$default(StringUtils.INSTANCE, displayName, false, 1, null));
        if (amount != -1) {
            OSUtils.INSTANCE.copyToClipboard(String.valueOf(amount));
        }
        currentSearchedItem = StringUtils.removeColor$default(StringUtils.INSTANCE, displayName, false, 1, null);
    }

    public static /* synthetic */ void searchForBazaarItem$default(BazaarApi bazaarApi, String string2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        bazaarApi.searchForBazaarItem(string2, n);
    }

    @SubscribeEvent
    public final void onInventoryOpen(@NotNull InventoryFullyOpenedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        inBazaarInventory = this.checkIfInBazaar(event);
        if (inBazaarInventory) {
            NEUInternalName openedProduct;
            NEUInternalName nEUInternalName = this.getOpenedProduct(event.getInventoryItems());
            if (nEUInternalName == null) {
                return;
            }
            currentlyOpenedProduct = openedProduct = nEUInternalName;
            new BazaarOpenedProductEvent(openedProduct, event).postAndCatch();
        }
    }

    @SubscribeEvent
    public final void onSlotClick(@NotNull GuiContainerEvent.SlotClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ItemStack itemStack2 = event.getItem();
        if (itemStack2 == null) {
            return;
        }
        ItemStack item = itemStack2;
        String itemName = ItemUtils.INSTANCE.getName(item);
        if (this.isBazaarOrderInventory(InventoryUtils.INSTANCE.openInventoryName())) {
            NEUInternalName nEUInternalName = ItemUtils.INSTANCE.getInternalNameOrNull(item);
            if (nEUInternalName == null) {
                return;
            }
            NEUInternalName internalName = nEUInternalName;
            if (StringsKt.contains$default((CharSequence)itemName, "SELL", false, 2, null)) {
                orderOptionProduct = internalName;
            } else if (StringsKt.contains$default((CharSequence)itemName, "BUY", false, 2, null)) {
                OwnInventoryData.INSTANCE.ignoreItem-VtjQ1oo(DurationKt.toDuration(1, DurationUnit.SECONDS), arg_0 -> BazaarApi.onSlotClick$lambda$1(internalName, arg_0));
            }
        }
        if (Intrinsics.areEqual(InventoryUtils.INSTANCE.openInventoryName(), "Order options") && Intrinsics.areEqual(itemName, "\u00a7cCancel Order")) {
            OwnInventoryData.INSTANCE.ignoreItem-VtjQ1oo(DurationKt.toDuration(1, DurationUnit.SECONDS), BazaarApi::onSlotClick$lambda$2);
        }
    }

    private final NEUInternalName getOpenedProduct(Map<Integer, ItemStack> inventoryItems) {
        ItemStack itemStack2 = inventoryItems.get(10);
        if (itemStack2 == null) {
            return null;
        }
        ItemStack buyInstantly = itemStack2;
        if (!Intrinsics.areEqual(buyInstantly.func_82833_r(), "\u00a7aBuy Instantly")) {
            return null;
        }
        ItemStack itemStack3 = inventoryItems.get(13);
        if (itemStack3 == null) {
            return null;
        }
        ItemStack bazaarItem = itemStack3;
        String string2 = bazaarItem.func_82833_r();
        Intrinsics.checkNotNullExpressionValue(string2, "getDisplayName(...)");
        return NEUInternalName.Companion.fromItemName(string2);
    }

    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!loadedNpcPriceData) {
            loadedNpcPriceData = true;
            holder.start();
        }
    }

    @SubscribeEvent
    public final void onBackgroundDrawn(@NotNull GuiContainerEvent.BackgroundDrawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        if (!inBazaarInventory) {
            return;
        }
        if (!SkyHanniMod.feature.inventory.bazaar.purchaseHelper) {
            return;
        }
        if (Intrinsics.areEqual(currentSearchedItem, "")) {
            return;
        }
        if (!(event.getGui() instanceof GuiChest)) {
            return;
        }
        GuiContainer guiChest = event.getGui();
        Container container = guiChest.field_147002_h;
        Intrinsics.checkNotNull(container, "null cannot be cast to non-null type net.minecraft.inventory.ContainerChest");
        ContainerChest chest = (ContainerChest)container;
        for (Map.Entry<Slot, ItemStack> entry : InventoryUtils.INSTANCE.getAllItems(chest).entrySet()) {
            Slot slot = entry.getKey();
            ItemStack stack = entry.getValue();
            int n = chest.field_75151_b.indexOf(slot);
            boolean bl = 9 <= n ? n < 45 : false;
            if (!bl) continue;
            String string2 = stack.func_82833_r();
            Intrinsics.checkNotNullExpressionValue(string2, "getDisplayName(...)");
            if (!Intrinsics.areEqual(StringUtils.removeColor$default(StringUtils.INSTANCE, string2, false, 1, null), currentSearchedItem)) continue;
            RenderUtils.INSTANCE.highlight(slot, LorenzColor.GREEN);
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        void $this$matchMatcher$iv;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        if (!inBazaarInventory) {
            return;
        }
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Object object = "\\[Bazaar] (Buy Order Setup!|Bought).*" + currentSearchedItem + ".*";
        int n = 0;
        Pattern pattern = Pattern.compile((String)object, n);
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        object = pattern;
        String text$iv = StringUtils.removeColor$default(StringUtils.INSTANCE, event.getMessage(), false, 1, null);
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u243 = it$iv;
            boolean bl2 = false;
            currentSearchedItem = "";
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkIfInBazaar(InventoryFullyOpenedEvent event) {
        boolean bl;
        boolean bl2;
        block31: {
            void $this$mapNotNullTo$iv$iv;
            int it = event.getInventorySize();
            boolean $i$a$-let-BazaarApi$checkIfInBazaar$items$22 = false;
            Integer[] integerArray = new Integer[]{it - 5, it - 6};
            Iterable $this$mapNotNull$iv = CollectionsKt.listOf(integerArray);
            boolean $i$f$mapNotNull = false;
            Iterable $i$a$-let-BazaarApi$checkIfInBazaar$items$22 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ItemStack it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl3 = false;
                int it2 = ((Number)element$iv$iv).intValue();
                boolean bl4 = false;
                if (event.getInventoryItems().get(it2) == null) continue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List items = (List)destination$iv$iv;
            Iterable $this$any$iv = items;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ItemStack it3 = (ItemStack)element$iv;
                    boolean bl6 = false;
                    if (!(StringUtils.INSTANCE.equalsIgnoreColor(ItemUtils.INSTANCE.getName(it3), "Go Back") && Intrinsics.areEqual(CollectionsKt.firstOrNull(ItemUtils.INSTANCE.getLore(it3)), "\u00a77To Bazaar"))) continue;
                    bl2 = true;
                    break block31;
                }
                bl2 = false;
            }
        }
        if (bl2) {
            return true;
        }
        if (StringsKt.startsWith$default(event.getInventoryName(), "Bazaar \u279c ", false, 2, null)) {
            return true;
        }
        switch (event.getInventoryName()) {
            case "How many do you want?": {
                bl = true;
                break;
            }
            case "How much do you want to pay?": {
                bl = true;
                break;
            }
            case "Confirm Buy Order": {
                bl = true;
                break;
            }
            case "Confirm Instant Buy": {
                bl = true;
                break;
            }
            case "At what price are you selling?": {
                bl = true;
                break;
            }
            case "Confirm Sell Offer": {
                bl = true;
                break;
            }
            case "Order options": {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 25, "bazaar", "inventory.bazaar", null, 8, null);
    }

    @SubscribeEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        inBazaarInventory = false;
        currentlyOpenedProduct = null;
    }

    public final boolean isBazaarOrderInventory(@NotNull String inventoryName) {
        Intrinsics.checkNotNullParameter(inventoryName, "inventoryName");
        String string2 = inventoryName;
        return Intrinsics.areEqual(string2, "Your Bazaar Orders") ? true : Intrinsics.areEqual(string2, "Co-op Bazaar Orders");
    }

    private static final boolean onSlotClick$lambda$1(NEUInternalName $internalName, NEUInternalName it) {
        Intrinsics.checkNotNullParameter($internalName, "$internalName");
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it, $internalName);
    }

    private static final boolean onSlotClick$lambda$2(NEUInternalName it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it, orderOptionProduct);
    }

    static {
        holder = new BazaarDataHolder();
        currentSearchedItem = "";
    }
}

