/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.data.Mayor;
import at.hannibal2.skyhanni.data.MayorAPI;
import at.hannibal2.skyhanni.data.Perk;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryOpenEvent;
import at.hannibal2.skyhanni.events.render.gui.ReplaceItemEvent;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NEUItems;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.client.player.inventory.ContainerLocalMenu;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ)\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\u001a8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010!\u00a8\u0006#"}, d2={"Lat/hannibal2/skyhanni/features/inventory/MinisterInCalendar;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/InventoryOpenEvent;", "event", "", "onInventoryOpen", "(Lat/hannibal2/skyhanni/events/InventoryOpenEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/events/render/gui/ReplaceItemEvent;", "replaceItem", "(Lat/hannibal2/skyhanni/events/render/gui/ReplaceItemEvent;)V", "", "ministerColor", "Lat/hannibal2/skyhanni/data/Mayor;", "minister", "Lnet/minecraft/item/ItemStack;", "item", "changeItem", "(Ljava/lang/String;Lat/hannibal2/skyhanni/data/Mayor;Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;", "", "isEnabled", "()Z", "", "MINISTER_SLOT", "I", "ministerItemStack", "Lnet/minecraft/item/ItemStack;", "", "prefix", "Ljava/util/List;", "suffix", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nMinisterInCalendar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinisterInCalendar.kt\nat/hannibal2/skyhanni/features/inventory/MinisterInCalendar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1557#2:88\n1628#2,3:89\n*S KotlinDebug\n*F\n+ 1 MinisterInCalendar.kt\nat/hannibal2/skyhanni/features/inventory/MinisterInCalendar\n*L\n77#1:88\n77#1:89,3\n*E\n"})
public final class MinisterInCalendar {
    @NotNull
    public static final MinisterInCalendar INSTANCE = new MinisterInCalendar();
    private static final int MINISTER_SLOT = 38;
    @Nullable
    private static ItemStack ministerItemStack;
    @NotNull
    private static final List<String> prefix;
    @NotNull
    private static final List<String> suffix;

    private MinisterInCalendar() {
    }

    @SubscribeEvent
    public final void onInventoryOpen(@NotNull InventoryOpenEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!RegexUtils.INSTANCE.matches(MayorAPI.INSTANCE.getCalendarGuiPattern(), InventoryUtils.INSTANCE.openInventoryName())) {
            return;
        }
        Mayor mayor = MayorAPI.INSTANCE.getCurrentMinister();
        if (mayor == null) {
            return;
        }
        Mayor minister = mayor;
        ItemStack itemStack2 = NEUItems.INSTANCE.getItemStack(NEUInternalName.Companion.asInternalName(minister.name() + "_MAYOR_MONSTER"));
        String ministerColor = MayorAPI.INSTANCE.mayorNameToColorCode(minister.getMayorName());
        ministerItemStack = this.changeItem(ministerColor, minister, itemStack2);
    }

    @SubscribeEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!RegexUtils.INSTANCE.matches(MayorAPI.INSTANCE.getCalendarGuiPattern(), InventoryUtils.INSTANCE.openInventoryName())) {
            return;
        }
        ministerItemStack = null;
    }

    @SubscribeEvent
    public final void replaceItem(@NotNull ReplaceItemEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getInventory() instanceof ContainerLocalMenu) || event.getSlot() != 38) {
            return;
        }
        if (!RegexUtils.INSTANCE.matches(MayorAPI.INSTANCE.getCalendarGuiPattern(), InventoryUtils.INSTANCE.openInventoryName())) {
            return;
        }
        ItemStack itemStack2 = ministerItemStack;
        if (itemStack2 == null) {
            return;
        }
        event.replace(itemStack2);
    }

    /*
     * WARNING - void declaration
     */
    private final ItemStack changeItem(String ministerColor, Mayor minister, ItemStack item) {
        List<String> list;
        String ministerDisplayName = ministerColor + "Minister " + minister.getMayorName();
        List<String> $this$changeItem_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$changeItem_u24lambda_u241.addAll((Collection)prefix);
        for (Perk perk : minister.getActivePerks()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$changeItem_u24lambda_u241.add(ministerColor + perk.getPerkName());
            Object object = new String[]{"\n"};
            object = StringsKt.split$default((CharSequence)StringsKt.removePrefix(StringUtils.INSTANCE.splitLines(perk.getDescription(), 170), (CharSequence)"\u00a7r"), object, false, 0, 6, null);
            List<String> list2 = $this$changeItem_u24lambda_u241;
            boolean $i$f$map = false;
            void var14_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add("\u00a77" + (String)it);
            }
            list2.addAll((List)destination$iv$iv);
        }
        $this$changeItem_u24lambda_u241.addAll((Collection)suffix);
        List<String> ministerLore = CollectionsKt.build(list);
        return ItemUtils.INSTANCE.setLore(item, ministerLore).func_151001_c(ministerDisplayName);
    }

    public final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && SkyHanniMod.feature.inventory.ministerInCalendar;
    }

    static {
        String[] stringArray = new String[]{"\u00a78(from SkyHanni)", "", "\u00a78\u00a7m--------------------------"};
        prefix = CollectionsKt.listOf(stringArray);
        stringArray = new String[]{"\u00a78\u00a7m--------------------------", "", "\u00a77The Minister is who came in 2nd place", "\u00a77during the election. They have one", "\u00a77of their perks active."};
        suffix = CollectionsKt.listOf(stringArray);
    }
}

