/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.visitor;

import at.hannibal2.skyhanni.data.jsonobjects.repo.GardenJson;
import at.hannibal2.skyhanni.data.jsonobjects.repo.GardenVisitor;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.data.repo.RepoManager;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.utils.StringUtils;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fR\"\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR4\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00100\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lat/hannibal2/skyhanni/features/garden/visitor/GardenVisitorColorNames;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "event", "", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "", "name", "getColoredName", "(Ljava/lang/String;)Ljava/lang/String;", "", "visitorColors", "Ljava/util/Map;", "", "visitorItems", "getVisitorItems", "()Ljava/util/Map;", "setVisitorItems", "(Ljava/util/Map;)V", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nGardenVisitorColorNames.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GardenVisitorColorNames.kt\nat/hannibal2/skyhanni/features/garden/visitor/GardenVisitorColorNames\n+ 2 RepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/RepositoryReloadEvent\n*L\n1#1,32:1\n12#2,7:33\n*S KotlinDebug\n*F\n+ 1 GardenVisitorColorNames.kt\nat/hannibal2/skyhanni/features/garden/visitor/GardenVisitorColorNames\n*L\n17#1:33,7\n*E\n"})
public final class GardenVisitorColorNames {
    @NotNull
    public static final GardenVisitorColorNames INSTANCE = new GardenVisitorColorNames();
    @NotNull
    private static Map<String, String> visitorColors = new LinkedHashMap();
    @NotNull
    private static Map<String, List<String>> visitorItems = new LinkedHashMap();

    private GardenVisitorColorNames() {
    }

    @NotNull
    public final Map<String, List<String>> getVisitorItems() {
        return visitorItems;
    }

    public final void setVisitorItems(@NotNull Map<String, List<String>> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        visitorItems = map2;
    }

    @SubscribeEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        GardenJson gardenJson;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String constant$iv = "Garden";
        Type type$iv = null;
        Gson gson$iv = event.getGson();
        boolean $i$f$getConstant = false;
        try {
            RepoManager.Companion.setLastConstant(constant$iv);
            if (!event.getRepoLocation().exists()) {
                throw new RepoError("Repo folder does not exist!");
            }
            gardenJson = RepoUtils.INSTANCE.getConstant(event.getRepoLocation(), constant$iv, gson$iv, GardenJson.class, type$iv);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv);
        }
        GardenJson data2 = gardenJson;
        visitorColors.clear();
        visitorItems.clear();
        for (Map.Entry<String, GardenVisitor> entry : data2.getVisitors().entrySet()) {
            String visitor2 = entry.getKey();
            GardenVisitor visitorData = entry.getValue();
            visitorColors.put(visitor2, visitorData.getRarity().getColor().getChatColor());
            visitorItems.put(visitor2, visitorData.getNeedItems());
        }
    }

    @NotNull
    public final String getColoredName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        String cleanName = StringUtils.removeColor$default(StringUtils.INSTANCE, name2, false, 1, null);
        String string2 = visitorColors.get(cleanName);
        if (string2 == null) {
            return name2;
        }
        String color = string2;
        return color + cleanName;
    }
}

