/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.pests;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.garden.pests.PestWaypointConfig;
import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.events.ItemClickEvent;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.ReceiveParticleEvent;
import at.hannibal2.skyhanni.events.garden.pests.PestUpdateEvent;
import at.hannibal2.skyhanni.events.minecraft.packet.PacketReceivedEvent;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.features.garden.pests.PestAPI;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.network.play.server.S0EPacketSpawnObject;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0011\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001cH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0011\u0010\u001f\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0004\b\u001f\u0010\u0018J\r\u0010!\u001a\u00020 \u00a2\u0006\u0004\b!\u0010\"R\u001c\u0010'\u001a\n $*\u0004\u0018\u00010#0#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0016\u0010)\u001a\u00020(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0018\u0010+\u001a\u0004\u0018\u00010\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0018\u0010-\u001a\u0004\u0018\u00010\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010,R\u0018\u0010.\u001a\u0004\u0018\u00010\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010,R\u0018\u0010/\u001a\u0004\u0018\u00010\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u0010,R\u001c\u00101\u001a\b\u0012\u0004\u0012\u00020\u0016008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0016\u00104\u001a\u0002038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0016\u00106\u001a\u0002038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00105R\u0016\u00107\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0018\u0010:\u001a\u0004\u0018\u0001098\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b:\u0010;\u00a8\u0006<"}, d2={"Lat/hannibal2/skyhanni/features/garden/pests/PestParticleWaypoint;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/ItemClickEvent;", "event", "", "onItemClick", "(Lat/hannibal2/skyhanni/events/ItemClickEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "reset", "Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;", "onReceiveParticle", "(Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/packet/PacketReceivedEvent;", "onFireWorkSpawn", "(Lat/hannibal2/skyhanni/events/minecraft/packet/PacketReceivedEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "getWaypoint", "()Lat/hannibal2/skyhanni/utils/LorenzVec;", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "Lat/hannibal2/skyhanni/events/garden/pests/PestUpdateEvent;", "onPestUpdate", "(Lat/hannibal2/skyhanni/events/garden/pests/PestUpdateEvent;)V", "calculateWaypoint", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/garden/pests/PestWaypointConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/pests/PestWaypointConfig;", "config", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastPestTrackerUse", "J", "firstParticlePoint", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "secondParticlePoint", "lastParticlePoint", "guessPoint", "", "locations", "Ljava/util/List;", "", "particles", "I", "lastParticles", "isPointingToPest", "Z", "Ljava/awt/Color;", "color", "Ljava/awt/Color;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nPestParticleWaypoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PestParticleWaypoint.kt\nat/hannibal2/skyhanni/features/garden/pests/PestParticleWaypoint\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,192:1\n11102#2:193\n11437#2,3:194\n1#3:197\n*S KotlinDebug\n*F\n+ 1 PestParticleWaypoint.kt\nat/hannibal2/skyhanni/features/garden/pests/PestParticleWaypoint\n*L\n104#1:193\n104#1:194,3\n*E\n"})
public final class PestParticleWaypoint {
    @NotNull
    public static final PestParticleWaypoint INSTANCE = new PestParticleWaypoint();
    private static long lastPestTrackerUse = SimpleTimeMark.Companion.farPast();
    @Nullable
    private static LorenzVec firstParticlePoint;
    @Nullable
    private static LorenzVec secondParticlePoint;
    @Nullable
    private static LorenzVec lastParticlePoint;
    @Nullable
    private static LorenzVec guessPoint;
    @NotNull
    private static List<LorenzVec> locations;
    private static int particles;
    private static int lastParticles;
    private static boolean isPointingToPest;
    @Nullable
    private static Color color;

    private PestParticleWaypoint() {
    }

    private final PestWaypointConfig getConfig() {
        return SkyHanniMod.feature.garden.pests.pestWaypoint;
    }

    @SubscribeEvent
    public final void onItemClick(@NotNull ItemClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (PestAPI.INSTANCE.hasVacuumInHand() && event.getClickType() == ClickType.LEFT_CLICK && !Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
            this.reset();
            lastPestTrackerUse = SimpleTimeMark.Companion.now-uFjCsEo();
        }
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        this.reset();
    }

    private final void reset() {
        lastPestTrackerUse = SimpleTimeMark.Companion.farPast();
        locations = CollectionsKt.emptyList();
        guessPoint = null;
        lastParticlePoint = null;
        firstParticlePoint = null;
        secondParticlePoint = null;
        particles = 0;
        lastParticles = 0;
        isPointingToPest = false;
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=true)
    public final void onReceiveParticle(@NotNull ReceiveParticleEvent event) {
        block17: {
            Object object;
            LorenzVec location;
            block20: {
                block19: {
                    block18: {
                        block16: {
                            void $this$mapTo$iv$iv;
                            boolean bl;
                            Intrinsics.checkNotNullParameter((Object)event, "event");
                            if (!this.isEnabled()) {
                                return;
                            }
                            if (event.getType() != EnumParticleTypes.REDSTONE || !(event.getSpeed() == 1.0f)) {
                                return;
                            }
                            LorenzVec darkYellow = new LorenzVec(0.0, 0.8, 0.0);
                            LorenzVec yellow = new LorenzVec(0.8, 0.8, 0.0);
                            LorenzVec redPest = new LorenzVec(0.8, 0.4, 0.0);
                            LorenzVec redPlot = new LorenzVec(0.8, 0.0, 0.0);
                            LorenzVec lorenzVec = event.getOffset().roundTo(5);
                            if (Intrinsics.areEqual(lorenzVec, redPlot)) {
                                bl = false;
                            } else if (Intrinsics.areEqual(lorenzVec, redPest) || Intrinsics.areEqual(lorenzVec, yellow) || Intrinsics.areEqual(lorenzVec, darkYellow)) {
                                bl = true;
                            } else {
                                return;
                            }
                            isPointingToPest = bl;
                            location = event.getLocation();
                            if (this.getConfig().hideParticles) {
                                event.cancel();
                            }
                            if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastPestTrackerUse), DurationKt.toDuration(3, DurationUnit.SECONDS)) > 0) {
                                return;
                            }
                            if (particles > 5) {
                                return;
                            }
                            if (firstParticlePoint != null) break block16;
                            if (LocationUtils.INSTANCE.playerLocation().distance(location) > 5.0) {
                                return;
                            }
                            firstParticlePoint = location;
                            Double[] $this$map$iv = event.getOffset().toDoubleArray();
                            boolean $i$f$map = false;
                            Double[] doubleArray = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                            boolean $i$f$mapTo = false;
                            for (void item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                double d = ((Number)item$iv$iv).doubleValue();
                                Collection collection = destination$iv$iv;
                                boolean bl2 = false;
                                collection.add(Float.valueOf((float)it));
                            }
                            List list = (List)destination$iv$iv;
                            float r = ((Number)list.get(0)).floatValue();
                            float g = ((Number)list.get(1)).floatValue();
                            float b = ((Number)list.get(2)).floatValue();
                            color = new Color(r, g, b);
                            break block17;
                        }
                        if (secondParticlePoint != null) break block18;
                        secondParticlePoint = location;
                        lastParticlePoint = location;
                        locations = CollectionUtils.INSTANCE.editCopy(locations, arg_0 -> PestParticleWaypoint.onReceiveParticle$lambda$1(location, arg_0));
                        break block17;
                    }
                    object = secondParticlePoint;
                    if (object == null) break block19;
                    LorenzVec it = object;
                    boolean bl = false;
                    LorenzVec lorenzVec = firstParticlePoint;
                    Double d = lorenzVec != null ? Double.valueOf(lorenzVec.distance(it)) : null;
                    object = d;
                    if (d != null) break block20;
                }
                return;
            }
            double firstDistance = (Double)object;
            LorenzVec lorenzVec = lastParticlePoint;
            if (lorenzVec == null) {
                return;
            }
            double distance = lorenzVec.distance(location);
            if (Math.abs(distance - firstDistance) > 0.1) {
                return;
            }
            lastParticlePoint = location;
            locations = CollectionUtils.INSTANCE.editCopy(locations, arg_0 -> PestParticleWaypoint.onReceiveParticle$lambda$3(location, arg_0));
        }
        ++particles;
    }

    @HandleEvent(onlyOnIsland=IslandType.GARDEN)
    public final void onFireWorkSpawn(@NotNull PacketReceivedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!(event.getPacket() instanceof S0EPacketSpawnObject)) {
            return;
        }
        if (!this.getConfig().hideParticles) {
            return;
        }
        int fireworkId = 76;
        if (((S0EPacketSpawnObject)event.getPacket()).func_148993_l() == fireworkId) {
            event.cancel();
        }
    }

    @SubscribeEvent
    public final void onRenderWorld(@NotNull LorenzRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (locations.isEmpty()) {
            return;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastPestTrackerUse), DurationKt.toDuration(this.getConfig().showForSeconds, DurationUnit.SECONDS)) > 0) {
            this.reset();
            return;
        }
        LorenzVec lorenzVec = this.getWaypoint();
        if (lorenzVec == null) {
            return;
        }
        LorenzVec waypoint = lorenzVec;
        String text = isPointingToPest ? "\u00a7aPest Guess" : "\u00a7cInfested Plot Guess";
        Color color = PestParticleWaypoint.color;
        if (color == null) {
            throw new IllegalStateException("color is null".toString());
        }
        Color color2 = color;
        RenderUtils.drawWaypointFilled$default(RenderUtils.INSTANCE, event, waypoint, color2, false, true, 0.0, 0.0, 0.0, 0.0f, false, 500, null);
        RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, waypoint, text, 1.3, 0.0f, 0.0, 0.0, false, false, null, 504, null);
        if (this.getConfig().drawLine) {
            RenderUtils.INSTANCE.draw3DLine(event, RenderUtils.INSTANCE.exactPlayerEyeLocation(event), waypoint, color2, 3, false);
        }
    }

    private final LorenzVec getWaypoint() {
        LorenzVec lorenzVec;
        if (lastParticles != particles || guessPoint == null) {
            LorenzVec lorenzVec2 = this.calculateWaypoint();
            if (lorenzVec2 != null) {
                LorenzVec lorenzVec3;
                LorenzVec it = lorenzVec3 = lorenzVec2;
                boolean bl = false;
                guessPoint = it;
                lastParticles = particles;
                lorenzVec = lorenzVec3;
            } else {
                lorenzVec = null;
            }
        } else {
            lorenzVec = guessPoint;
        }
        return lorenzVec;
    }

    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        LorenzVec lorenzVec = guessPoint;
        if (lorenzVec == null) {
            return;
        }
        LorenzVec guessPoint = lorenzVec;
        if (LocationUtils.INSTANCE.distanceToPlayerIgnoreY(guessPoint) > 8.0) {
            return;
        }
        if (isPointingToPest) {
            long l = DurationKt.toDuration(1, DurationUnit.SECONDS);
            long l2 = DurationKt.toDuration(this.getConfig().showForSeconds, DurationUnit.SECONDS);
            long l3 = SimpleTimeMark.passedSince-UwyO8pc(lastPestTrackerUse);
            if (!(0 <= ((Comparable)Duration.box-impl(l3)).compareTo(Duration.box-impl(l)) ? ((Comparable)Duration.box-impl(l3)).compareTo(Duration.box-impl(l2)) <= 0 : false)) {
                return;
            }
        }
        this.reset();
    }

    @HandleEvent
    public final void onPestUpdate(@NotNull PestUpdateEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (PestAPI.INSTANCE.getScoreboardPests() == 0) {
            this.reset();
        }
    }

    private final LorenzVec calculateWaypoint() {
        LorenzVec lorenzVec = firstParticlePoint;
        if (lorenzVec == null) {
            return null;
        }
        LorenzVec firstParticle = lorenzVec;
        List list = CollectionsKt.toList((Iterable)locations);
        LorenzVec pos = new LorenzVec(0.0, 0.0, 0.0);
        Iterator iterator2 = ((Iterable)list).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i2 = n++;
            LorenzVec particle = (LorenzVec)iterator2.next();
            pos = pos.plus(particle.minus(firstParticle).div((double)i2 + 1.0));
        }
        return firstParticle.plus(pos.times(120.0 / (double)list.size()));
    }

    public final boolean isEnabled() {
        return GardenAPI.INSTANCE.inGarden() && this.getConfig().enabled;
    }

    private static final Unit onReceiveParticle$lambda$1(LorenzVec $location, List $this$editCopy) {
        Intrinsics.checkNotNullParameter($location, "$location");
        Intrinsics.checkNotNullParameter($this$editCopy, "$this$editCopy");
        $this$editCopy.add($location);
        return Unit.INSTANCE;
    }

    private static final Unit onReceiveParticle$lambda$3(LorenzVec $location, List $this$editCopy) {
        Intrinsics.checkNotNullParameter($location, "$location");
        Intrinsics.checkNotNullParameter($this$editCopy, "$this$editCopy");
        $this$editCopy.add($location);
        return Unit.INSTANCE;
    }

    static {
        locations = CollectionsKt.emptyList();
    }
}

