/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.pests;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.features.garden.pests.PestWaypointConfig;
import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.events.ItemClickEvent;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.events.ReceiveParticleEvent;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.features.garden.GardenPlotAPI;
import at.hannibal2.skyhanni.features.garden.pests.PestAPI;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001'B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014J%\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u001c\u0010!\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0016\u0010#\u001a\u00020\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R \u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006("}, d2={"Lat/hannibal2/skyhanni/features/garden/pests/PestParticleLine;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/ItemClickEvent;", "event", "", "onItemClick", "(Lat/hannibal2/skyhanni/events/ItemClickEvent;)V", "Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;", "onReceiveParticle", "(Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;)V", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "location", "", "Lat/hannibal2/skyhanni/features/garden/pests/PestParticleLine$ParticleLocation;", "getCurrentList", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Ljava/util/List;", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "showMiddle", "", "list", "draw", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;Ljava/util/List;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/garden/pests/PestWaypointConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/pests/PestWaypointConfig;", "config", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastPestTrackerUse", "J", "locations", "Ljava/util/List;", "ParticleLocation", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nPestParticleLine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PestParticleLine.kt\nat/hannibal2/skyhanni/features/garden/pests/PestParticleLine\n+ 2 LorenzUtils.kt\nat/hannibal2/skyhanni/utils/LorenzUtils\n*L\n1#1,131:1\n337#2:132\n*S KotlinDebug\n*F\n+ 1 PestParticleLine.kt\nat/hannibal2/skyhanni/features/garden/pests/PestParticleLine\n*L\n52#1:132\n*E\n"})
public final class PestParticleLine {
    @NotNull
    public static final PestParticleLine INSTANCE = new PestParticleLine();
    private static long lastPestTrackerUse = SimpleTimeMark.Companion.farPast();
    @NotNull
    private static final List<List<ParticleLocation>> locations = new ArrayList();

    private PestParticleLine() {
    }

    private final PestWaypointConfig getConfig() {
        return SkyHanniMod.feature.garden.pests.pestWaypoint;
    }

    @SubscribeEvent
    public final void onItemClick(@NotNull ItemClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (PestAPI.INSTANCE.hasVacuumInHand() && event.getClickType() == ClickType.LEFT_CLICK) {
            lastPestTrackerUse = SimpleTimeMark.Companion.now-uFjCsEo();
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onReceiveParticle(@NotNull ReceiveParticleEvent event) {
        void $this$isAnyOf$iv;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastPestTrackerUse), DurationKt.toDuration(5, DurationUnit.SECONDS)) > 0) {
            return;
        }
        LorenzUtils lorenzUtils = LorenzUtils.INSTANCE;
        Enum enum_ = (Enum)event.getType();
        EnumParticleTypes[] enumParticleTypesArray = new EnumParticleTypes[]{EnumParticleTypes.ENCHANTMENT_TABLE, EnumParticleTypes.VILLAGER_ANGRY};
        Enum[] array$iv = (Enum[])enumParticleTypesArray;
        boolean $i$f$isAnyOf = false;
        if (ArraysKt.contains(array$iv, $this$isAnyOf$iv) && this.getConfig().hideParticles) {
            event.cancel();
        }
        if (event.getType() != EnumParticleTypes.VILLAGER_ANGRY) {
            return;
        }
        LorenzVec location = event.getLocation();
        DelayedRun.INSTANCE.runNextTick(() -> PestParticleLine.onReceiveParticle$lambda$0(location));
    }

    private final List<ParticleLocation> getCurrentList(LorenzVec location) {
        List<ParticleLocation> list = CollectionsKt.lastOrNull(locations);
        if (list != null) {
            List<ParticleLocation> it = list;
            boolean bl = false;
            double distance = CollectionsKt.last(it).getLocation().distance(location);
            if (distance < 4.0) {
                return it;
            }
        }
        List newList = new ArrayList();
        locations.add(newList);
        if (locations.size() == 5) {
            locations.remove(0);
        }
        return newList;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public final void onRenderWorld(@NotNull LorenzRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastPestTrackerUse), DurationKt.toDuration(10, DurationUnit.SECONDS)) > 0) {
            locations.clear();
            return;
        }
        for (List<ParticleLocation> list : locations) {
            this.draw(event, list);
        }
        this.showMiddle(event);
    }

    private final void showMiddle(LorenzRenderWorldEvent event) {
        if (!this.getConfig().showMiddle) {
            return;
        }
        if (locations.size() <= 0) {
            return;
        }
        GardenPlotAPI.Plot plot = GardenPlotAPI.INSTANCE.getCurrentPlot();
        if (plot == null) {
            return;
        }
        GardenPlotAPI.Plot plot2 = plot;
        LorenzVec middle = LorenzVec.copy$default(plot2.getMiddle(), 0.0, LocationUtils.INSTANCE.playerLocation().getY(), 0.0, 5, null);
        if (LocationUtils.INSTANCE.distanceToPlayer(middle) > 15.0) {
            return;
        }
        RenderUtils.drawWaypointFilled$default(RenderUtils.INSTANCE, event, middle, LorenzColor.GRAY.toColor(), false, false, 0.0, 0.0, 0.0, 0.0f, false, 508, null);
        RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, middle, "Middle", 1.0, 0.0f, 0.0, 0.0, false, false, null, 504, null);
    }

    private final void draw(LorenzRenderWorldEvent event, List<ParticleLocation> list) {
        Color color = LorenzColor.YELLOW.toColor();
        Iterator iterator2 = SequencesKt.zipWithNext(CollectionsKt.asSequence((Iterable)list)).iterator();
        while (iterator2.hasNext()) {
            Pair pair = iterator2.next();
            ParticleLocation prev = (ParticleLocation)pair.component1();
            ParticleLocation next = (ParticleLocation)pair.component2();
            if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(next.getSpawnTime-uFjCsEo()), DurationKt.toDuration(5, DurationUnit.SECONDS)) > 0) continue;
            LorenzVec location = next.getLocation();
            RenderUtils.INSTANCE.draw3DLine_nea(event, prev.getLocation(), location, color, 3, false);
            boolean isVeryLast = Intrinsics.areEqual(list, CollectionsKt.lastOrNull(locations)) && Intrinsics.areEqual(next, CollectionsKt.lastOrNull(list));
            if (!isVeryLast) continue;
            LorenzVec lastLocation = location.add(-0.5, -0.5, -0.5);
            RenderUtils.drawWaypointFilled$default(RenderUtils.INSTANCE, event, lastLocation, color, false, true, 0.0, 0.0, 0.0, 0.0f, false, 500, null);
            RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, lastLocation, "\u00a7ePest Guess", 1.3, 0.0f, 0.0, 0.0, false, false, null, 504, null);
        }
    }

    public final boolean isEnabled() {
        return GardenAPI.INSTANCE.inGarden() && this.getConfig().enabled;
    }

    private static final Unit onReceiveParticle$lambda$0(LorenzVec $location) {
        Intrinsics.checkNotNullParameter($location, "$location");
        INSTANCE.getCurrentList($location).add(new ParticleLocation($location, SimpleTimeMark.Companion.now-uFjCsEo(), null));
        return Unit.INSTANCE;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lat/hannibal2/skyhanni/features/garden/pests/PestParticleLine$ParticleLocation;", "", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "location", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "spawnTime", "<init>", "(Lat/hannibal2/skyhanni/utils/LorenzVec;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "getLocation", "()Lat/hannibal2/skyhanni/utils/LorenzVec;", "J", "getSpawnTime-uFjCsEo", "()J", "1.8.9"})
    public static final class ParticleLocation {
        @NotNull
        private final LorenzVec location;
        private final long spawnTime;

        private ParticleLocation(LorenzVec location, long spawnTime) {
            Intrinsics.checkNotNullParameter(location, "location");
            this.location = location;
            this.spawnTime = spawnTime;
        }

        @NotNull
        public final LorenzVec getLocation() {
            return this.location;
        }

        public final long getSpawnTime-uFjCsEo() {
            return this.spawnTime;
        }

        public /* synthetic */ ParticleLocation(LorenzVec location, long spawnTime, DefaultConstructorMarker $constructor_marker) {
            this(location, spawnTime);
        }
    }
}

