/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.inventory;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.features.garden.cropmilestones.CropMilestonesOverflowConfig;
import at.hannibal2.skyhanni.data.GardenCropMilestones;
import at.hannibal2.skyhanni.events.LorenzToolTipEvent;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.StringUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ1\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J3\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u000e2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\u00112\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u001c\u0010 \u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Lat/hannibal2/skyhanni/features/garden/inventory/GardenInventoryTooltipOverflow;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzToolTipEvent;", "event", "", "onTooltip", "(Lat/hannibal2/skyhanni/events/LorenzToolTipEvent;)V", "", "", "split", "", "currentTier", "Lkotlin/Pair;", "getLevels", "(Ljava/util/List;I)Lkotlin/Pair;", "Lat/hannibal2/skyhanni/features/garden/CropType;", "crop", "", "counter", "getHaveNeed", "(ILat/hannibal2/skyhanni/features/garden/CropType;J)Lkotlin/Pair;", "getCrop", "(Ljava/util/List;)Lat/hannibal2/skyhanni/features/garden/CropType;", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/garden/cropmilestones/CropMilestonesOverflowConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/cropmilestones/CropMilestonesOverflowConfig;", "config", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nGardenInventoryTooltipOverflow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GardenInventoryTooltipOverflow.kt\nat/hannibal2/skyhanni/features/garden/inventory/GardenInventoryTooltipOverflow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1755#2,3:97\n*S KotlinDebug\n*F\n+ 1 GardenInventoryTooltipOverflow.kt\nat/hannibal2/skyhanni/features/garden/inventory/GardenInventoryTooltipOverflow\n*L\n34#1:97,3\n*E\n"})
public final class GardenInventoryTooltipOverflow {
    @NotNull
    public static final GardenInventoryTooltipOverflow INSTANCE = new GardenInventoryTooltipOverflow();

    private GardenInventoryTooltipOverflow() {
    }

    private final CropMilestonesOverflowConfig getConfig() {
        return SkyHanniMod.feature.garden.cropMilestones.overflow;
    }

    @SubscribeEvent
    public final void onTooltip(@NotNull LorenzToolTipEvent event) {
        boolean bl;
        ItemStack stack;
        block8: {
            Intrinsics.checkNotNullParameter((Object)event, "event");
            if (!this.isEnabled()) {
                return;
            }
            String inventoryName = InventoryUtils.INSTANCE.openInventoryName();
            if (!Intrinsics.areEqual(inventoryName, "Crop Milestones")) {
                return;
            }
            stack = event.getItemStack();
            Iterable $this$any$iv = ItemUtils.INSTANCE.getLore(stack);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)it, "Max tier reached!", false, 2, null)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (!bl) {
            return;
        }
        String[] $i$f$any = new String[]{" "};
        List split = StringsKt.split$default((CharSequence)ItemUtils.INSTANCE.cleanName(stack), $i$f$any, false, 0, 6, null);
        CropType crop = this.getCrop(split);
        long counter = GardenCropMilestones.INSTANCE.getCounter(crop);
        int currentTier = GardenCropMilestones.INSTANCE.getTierForCropCount(counter, crop, true);
        Pair<Long, Long> pair = this.getHaveNeed(currentTier, crop, counter);
        long have = ((Number)pair.component1()).longValue();
        long need = ((Number)pair.component2()).longValue();
        Pair<String, String> pair2 = this.getLevels(split, currentTier);
        String level = pair2.component1();
        String nextLevel = pair2.component2();
        boolean next = false;
        ListIterator<String> iterator2 = event.getToolTip().listIterator();
        double percentage = (double)have / (double)need;
        ListIterator<String> listIterator2 = iterator2;
        while (((Iterator)listIterator2).hasNext()) {
            String bar;
            String maxTierReached;
            String line = listIterator2.next();
            if (StringsKt.contains$default((CharSequence)line, maxTierReached = "\u00a77\u00a78Max tier reached!", false, 2, null)) {
                iterator2.set("\u00a77Progress to tier " + nextLevel + ": \u00a7e" + LorenzUtils.INSTANCE.formatPercentage(percentage));
                ItemUtils.INSTANCE.setName(event.getItemStack(), "\u00a7a" + crop.getCropName() + ' ' + level);
                next = true;
                continue;
            }
            if (!next || !StringsKt.contains$default((CharSequence)line, bar = "                    ", false, 2, null)) continue;
            Object progressBar2 = StringUtils.progressBar$default(StringUtils.INSTANCE, percentage, 0, 2, null);
            iterator2.set(progressBar2 + " \u00a7e" + NumberUtil.INSTANCE.addSeparators(have) + "\u00a76/\u00a7e" + NumberUtil.INSTANCE.addSeparators(need));
        }
    }

    private final Pair<String, String> getLevels(List<String> split, int currentTier) {
        int nextTier = currentTier + 1;
        boolean useRoman = StringsKt.toIntOrNull(CollectionsKt.last(split)) == null;
        String level = useRoman ? NumberUtil.INSTANCE.toRoman(currentTier) : "" + currentTier;
        String nextLevel = useRoman ? NumberUtil.INSTANCE.toRoman(nextTier) : "" + nextTier;
        return new Pair<String, String>(level, nextLevel);
    }

    private final Pair<Long, Long> getHaveNeed(int currentTier, CropType crop, long counter) {
        int nextTier = currentTier + 1;
        long cropsForCurrentTier = GardenCropMilestones.INSTANCE.getCropsForTier(currentTier, crop, true);
        long cropsForNextTier = GardenCropMilestones.INSTANCE.getCropsForTier(nextTier, crop, true);
        long have = counter - cropsForCurrentTier;
        long need = cropsForNextTier - cropsForCurrentTier;
        return new Pair<Long, Long>(have, need);
    }

    private final CropType getCrop(List<String> split) {
        String cropName = CollectionsKt.joinToString$default(CollectionsKt.dropLast(split, 1), " ", null, null, 0, null, null, 62, null);
        return CropType.Companion.getByName(StringUtils.removeColor$default(StringUtils.INSTANCE, cropName, false, 1, null));
    }

    public final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && this.getConfig().inventoryTooltip;
    }
}

