/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.inventory;

import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.garden.AnitaShopConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.jsonobjects.repo.AnitaUpgradeCostsJson;
import at.hannibal2.skyhanni.data.jsonobjects.repo.AnitaUpgradePrice;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.data.repo.RepoManager;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.events.LorenzToolTipEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemPriceUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eR\u001c\u0010\u0013\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0019\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\"\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lat/hannibal2/skyhanni/features/garden/inventory/AnitaExtraFarmingFortune;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzToolTipEvent;", "event", "", "onTooltip", "(Lat/hannibal2/skyhanni/events/LorenzToolTipEvent;)V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/garden/AnitaShopConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/AnitaShopConfig;", "config", "Ljava/util/regex/Pattern;", "realAmountPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getRealAmountPattern", "()Ljava/util/regex/Pattern;", "realAmountPattern", "", "", "Lat/hannibal2/skyhanni/data/jsonobjects/repo/AnitaUpgradePrice;", "levelPrice", "Ljava/util/Map;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nAnitaExtraFarmingFortune.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnitaExtraFarmingFortune.kt\nat/hannibal2/skyhanni/features/garden/inventory/AnitaExtraFarmingFortune\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 RepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/RepositoryReloadEvent\n*L\n1#1,91:1\n8#2:92\n1#3:93\n1#3:94\n360#4,7:95\n12#5,7:102\n*S KotlinDebug\n*F\n+ 1 AnitaExtraFarmingFortune.kt\nat/hannibal2/skyhanni/features/garden/inventory/AnitaExtraFarmingFortune\n*L\n46#1:92\n46#1:93\n74#1:95,7\n82#1:102,7\n*E\n"})
public final class AnitaExtraFarmingFortune {
    @NotNull
    public static final AnitaExtraFarmingFortune INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPattern realAmountPattern$delegate;
    @NotNull
    private static Map<Integer, AnitaUpgradePrice> levelPrice;

    private AnitaExtraFarmingFortune() {
    }

    private final AnitaShopConfig getConfig() {
        return GardenAPI.INSTANCE.getConfig().anitaShop;
    }

    private final Pattern getRealAmountPattern() {
        return (Pattern)realAmountPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    @SubscribeEvent
    public final void onTooltip(@NotNull LorenzToolTipEvent event) {
        int upgradeIndex;
        int anitaUpgrade;
        block11: {
            int n;
            Intrinsics.checkNotNullParameter((Object)event, "event");
            if (!this.getConfig().extraFarmingFortune) {
                return;
            }
            if (!Intrinsics.areEqual(InventoryUtils.INSTANCE.openInventoryName(), "Anita")) {
                return;
            }
            String string2 = event.getItemStack().func_82833_r();
            Intrinsics.checkNotNullExpressionValue(string2, "getDisplayName(...)");
            if (!StringsKt.contains$default((CharSequence)string2, "Extra Farming Fortune", false, 2, null)) {
                return;
            }
            Object object = GardenAPI.INSTANCE.getStorage();
            if (object == null || (object = ((ProfileSpecificStorage.GardenStorage)object).fortune) == null) {
                return;
            }
            anitaUpgrade = ((ProfileSpecificStorage.GardenStorage.Fortune)object).anitaUpgrade;
            double contributionFactor = 0.0;
            contributionFactor = 1.0;
            AnitaUpgradePrice anitaUpgradePrice = levelPrice.get(anitaUpgrade + 1);
            if (anitaUpgradePrice == null) {
                return;
            }
            int baseAmount = anitaUpgradePrice.getJacobTickets();
            for (String line : event.getToolTip()) {
                RegexUtils regexUtils = RegexUtils.INSTANCE;
                Pattern pattern = this.getRealAmountPattern();
                boolean $i$f$matchMatcher = false;
                Matcher it$iv = pattern.matcher(line);
                boolean bl = false;
                if (!it$iv.matches()) continue;
                Intrinsics.checkNotNull(it$iv);
                Matcher $this$onTooltip_u24lambda_u240 = it$iv;
                boolean bl2 = false;
                String string3 = $this$onTooltip_u24lambda_u240.group("realAmount");
                Intrinsics.checkNotNullExpressionValue(string3, "group(...)");
                double realAmount = NumberUtil.INSTANCE.formatDouble(string3);
                contributionFactor = realAmount / (double)baseAmount;
            }
            int goldMedals = 0;
            int jacobTickets = 0;
            for (Map.Entry<Integer, AnitaUpgradePrice> entry : levelPrice.entrySet()) {
                int level = ((Number)entry.getKey()).intValue();
                AnitaUpgradePrice price = entry.getValue();
                if (level <= anitaUpgrade) continue;
                goldMedals += price.getGoldMedals();
                jacobTickets += price.getJacobTickets();
            }
            jacobTickets = (int)(contributionFactor * (double)jacobTickets);
            String[] stringArray = new String[]{"\u00a75\u00a7o\u00a7eClick to trade!"};
            Integer n2 = CollectionUtils.INSTANCE.indexOfFirst(event.getToolTip(), stringArray);
            if (n2 == null) {
                return;
            }
            int it = ((Number)n2).intValue();
            boolean bl = false;
            int index = it - 1;
            double d = (double)jacobTickets * ItemPriceUtils.getPrice$default(ItemPriceUtils.INSTANCE, NEUInternalName.Companion.asInternalName("JACOBS_TICKET"), null, null, 3, null);
            event.getToolTip().add(index, "  \u00a77Price: \u00a76" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, d, false, 1, null) + " coins");
            event.getToolTip().add(index, "\u00a7aJacob Tickets \u00a78x" + NumberUtil.INSTANCE.addSeparators(jacobTickets));
            event.getToolTip().add(index, "\u00a76Gold medals: \u00a78x" + goldMedals);
            event.getToolTip().add(index, "\u00a77Cost to max out");
            event.getToolTip().add(index, "");
            List<String> $this$indexOfFirst$iv = event.getToolTip();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<String> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                String item$iv;
                String it2 = item$iv = iterator2.next();
                boolean bl3 = false;
                if (StringsKt.contains$default((CharSequence)it2, "You have", false, 2, null)) {
                    n = index$iv;
                    break block11;
                }
                ++index$iv;
            }
            n = upgradeIndex = -1;
        }
        if (upgradeIndex != -1) {
            event.getToolTip().add(upgradeIndex + 1, "\u00a77Current Tier: \u00a7e" + anitaUpgrade + '/' + levelPrice.size());
        }
    }

    @SubscribeEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        AnitaUpgradeCostsJson anitaUpgradeCostsJson;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String constant$iv = "AnitaUpgradeCosts";
        Type type$iv = null;
        Gson gson$iv = event.getGson();
        boolean $i$f$getConstant = false;
        try {
            RepoManager.Companion.setLastConstant(constant$iv);
            if (!event.getRepoLocation().exists()) {
                throw new RepoError("Repo folder does not exist!");
            }
            anitaUpgradeCostsJson = RepoUtils.INSTANCE.getConstant(event.getRepoLocation(), constant$iv, gson$iv, AnitaUpgradeCostsJson.class, type$iv);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv);
        }
        AnitaUpgradeCostsJson data2 = anitaUpgradeCostsJson;
        levelPrice = data2.getLevelPrice();
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.extraFarmingFortune", "garden.anitaShop.extraFarmingFortune", null, 8, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(AnitaExtraFarmingFortune.class, "realAmountPattern", "getRealAmountPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new AnitaExtraFarmingFortune();
        realAmountPattern$delegate = RepoPattern.Companion.pattern("garden.inventory.anita.extrafortune.realamount", "\u00a75\u00a7o\u00a7aJacob's Ticket \u00a78x(?<realAmount>.*)");
        levelPrice = MapsKt.emptyMap();
    }
}

