/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.farming;

import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.garden.GardenConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.data.GardenCropMilestones;
import at.hannibal2.skyhanni.data.jsonobjects.repo.DicerDropsJson;
import at.hannibal2.skyhanni.data.jsonobjects.repo.DicerType;
import at.hannibal2.skyhanni.data.jsonobjects.repo.DropInfo;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.data.repo.RepoManager;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.events.CropClickEvent;
import at.hannibal2.skyhanni.events.GardenToolChangeEvent;
import at.hannibal2.skyhanni.events.ProfileJoinEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.features.garden.farming.GardenCropMilestoneDisplay;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.TimersKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0003J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u0019\u001a\u00020\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001b\u001a\u00020\u0015\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u0003J\r\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b\u001f\u0010 J\u0013\u0010#\u001a\u0004\u0018\u00010\"*\u00020!\u00a2\u0006\u0004\b#\u0010$J\u0019\u0010&\u001a\u00020\u0006*\u00020!2\u0006\u0010%\u001a\u00020\"\u00a2\u0006\u0004\b&\u0010'J\u0013\u0010(\u001a\u0004\u0018\u00010\u0015*\u00020!\u00a2\u0006\u0004\b(\u0010)J\r\u0010*\u001a\u00020\u001e\u00a2\u0006\u0004\b*\u0010 J\u0017\u0010,\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020+H\u0007\u00a2\u0006\u0004\b,\u0010-R\u001c\u00102\u001a\n /*\u0004\u0018\u00010.0.8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\"\u00106\u001a\u0010\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"\u0018\u0001038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\"\u00107\u001a\u0010\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u0015\u0018\u0001038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u00105R$\u00108\u001a\u0004\u0018\u00010!8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b8\u00109\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\"\u0010?\u001a\u00020>8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b?\u0010@\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\"\u0010E\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bE\u0010F\u001a\u0004\bG\u0010\u001c\"\u0004\bH\u0010IR\u001c\u0010K\u001a\b\u0012\u0004\u0012\u00020\"0J8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bK\u0010LR\u0016\u0010M\u001a\u00020\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bM\u0010NR\u0016\u0010O\u001a\u00020\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bO\u0010NR\u001a\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bP\u0010LR\u001a\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bQ\u0010LR\"\u0010R\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bR\u0010F\u001a\u0004\bS\u0010\u001c\"\u0004\bT\u0010IR\"\u0010U\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bU\u0010F\u001a\u0004\bV\u0010\u001c\"\u0004\bW\u0010I\u00a8\u0006X"}, d2={"Lat/hannibal2/skyhanni/features/garden/farming/GardenCropSpeed;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/ProfileJoinEvent;", "event", "", "onProfileJoin", "(Lat/hannibal2/skyhanni/events/ProfileJoinEvent;)V", "Lat/hannibal2/skyhanni/events/GardenToolChangeEvent;", "onGardenToolChange", "(Lat/hannibal2/skyhanni/events/GardenToolChangeEvent;)V", "update", "Lat/hannibal2/skyhanni/events/CropClickEvent;", "onCropClick", "(Lat/hannibal2/skyhanni/events/CropClickEvent;)V", "checkSpeed", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "", "", "dicerList", "Lat/hannibal2/skyhanni/data/jsonobjects/repo/DicerType;", "data", "calculateAverageDicer", "(Ljava/util/List;Lat/hannibal2/skyhanni/data/jsonobjects/repo/DicerType;)V", "getRecentBPS", "()D", "resetSpeed", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/features/garden/CropType;", "", "getSpeed", "(Lat/hannibal2/skyhanni/features/garden/CropType;)Ljava/lang/Integer;", "speed", "setSpeed", "(Lat/hannibal2/skyhanni/features/garden/CropType;I)V", "getLatestBlocksPerSecond", "(Lat/hannibal2/skyhanni/features/garden/CropType;)Ljava/lang/Double;", "isSpeedDataEmpty", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/garden/GardenConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/GardenConfig;", "config", "", "getCropsPerSecond", "()Ljava/util/Map;", "cropsPerSecond", "latestBlocksPerSecond", "lastBrokenCrop", "Lat/hannibal2/skyhanni/features/garden/CropType;", "getLastBrokenCrop", "()Lat/hannibal2/skyhanni/features/garden/CropType;", "setLastBrokenCrop", "(Lat/hannibal2/skyhanni/features/garden/CropType;)V", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastBrokenTime", "J", "getLastBrokenTime-uFjCsEo", "()J", "setLastBrokenTime-gJLAdNM", "(J)V", "averageBlocksPerSecond", "D", "getAverageBlocksPerSecond", "setAverageBlocksPerSecond", "(D)V", "", "blocksSpeedList", "Ljava/util/List;", "blocksBroken", "I", "secondsStopped", "melonDicer", "pumpkinDicer", "latestMelonDicer", "getLatestMelonDicer", "setLatestMelonDicer", "latestPumpkinDicer", "getLatestPumpkinDicer", "setLatestPumpkinDicer", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nGardenCropSpeed.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GardenCropSpeed.kt\nat/hannibal2/skyhanni/features/garden/farming/GardenCropSpeed\n+ 2 RepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/RepositoryReloadEvent\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,197:1\n12#2,7:198\n1#3:205\n*S KotlinDebug\n*F\n+ 1 GardenCropSpeed.kt\nat/hannibal2/skyhanni/features/garden/farming/GardenCropSpeed\n*L\n143#1:198,7\n*E\n"})
public final class GardenCropSpeed {
    @NotNull
    public static final GardenCropSpeed INSTANCE;
    @Nullable
    private static CropType lastBrokenCrop;
    private static long lastBrokenTime;
    private static double averageBlocksPerSecond;
    @NotNull
    private static List<Integer> blocksSpeedList;
    private static int blocksBroken;
    private static int secondsStopped;
    @NotNull
    private static final List<Double> melonDicer;
    @NotNull
    private static final List<Double> pumpkinDicer;
    private static double latestMelonDicer;
    private static double latestPumpkinDicer;

    private GardenCropSpeed() {
    }

    private final GardenConfig getConfig() {
        return GardenAPI.INSTANCE.getConfig();
    }

    private final Map<CropType, Integer> getCropsPerSecond() {
        ProfileSpecificStorage.GardenStorage gardenStorage = GardenAPI.INSTANCE.getStorage();
        return gardenStorage != null ? gardenStorage.cropsPerSecond : null;
    }

    private final Map<CropType, Double> getLatestBlocksPerSecond() {
        ProfileSpecificStorage.GardenStorage gardenStorage = GardenAPI.INSTANCE.getStorage();
        return gardenStorage != null ? gardenStorage.latestBlocksPerSecond : null;
    }

    @Nullable
    public final CropType getLastBrokenCrop() {
        return lastBrokenCrop;
    }

    public final void setLastBrokenCrop(@Nullable CropType cropType) {
        lastBrokenCrop = cropType;
    }

    public final long getLastBrokenTime-uFjCsEo() {
        return lastBrokenTime;
    }

    public final void setLastBrokenTime-gJLAdNM(long l) {
        lastBrokenTime = l;
    }

    public final double getAverageBlocksPerSecond() {
        return averageBlocksPerSecond;
    }

    public final void setAverageBlocksPerSecond(double d) {
        averageBlocksPerSecond = d;
    }

    public final double getLatestMelonDicer() {
        return latestMelonDicer;
    }

    public final void setLatestMelonDicer(double d) {
        latestMelonDicer = d;
    }

    public final double getLatestPumpkinDicer() {
        return latestPumpkinDicer;
    }

    public final void setLatestPumpkinDicer(double d) {
        latestPumpkinDicer = d;
    }

    @SubscribeEvent
    public final void onProfileJoin(@NotNull ProfileJoinEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        lastBrokenCrop = null;
    }

    @SubscribeEvent
    public final void onGardenToolChange(@NotNull GardenToolChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (this.isEnabled()) {
            this.resetSpeed();
            this.update();
        }
    }

    private final void update() {
        GardenCropMilestoneDisplay.INSTANCE.update();
    }

    @SubscribeEvent
    public final void onCropClick(@NotNull CropClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (event.getClickType() != ClickType.LEFT_CLICK) {
            return;
        }
        lastBrokenCrop = event.getCrop();
        lastBrokenTime = SimpleTimeMark.Companion.now-uFjCsEo();
        int n = blocksBroken;
        blocksBroken = n + 1;
    }

    private final void checkSpeed() {
        block13: {
            CropType it;
            block14: {
                Object object;
                String toolName;
                block16: {
                    block15: {
                        int blocksBroken;
                        block12: {
                            blocksBroken = RangesKt.coerceAtMost(GardenCropSpeed.blocksBroken, 20);
                            GardenCropSpeed.blocksBroken = 0;
                            if (blocksBroken != 0) break block12;
                            if (blocksSpeedList.isEmpty()) {
                                return;
                            }
                            int n = secondsStopped;
                            secondsStopped = n + 1;
                            break block13;
                        }
                        if (secondsStopped >= this.getConfig().cropMilestones.blocksBrokenResetTime) {
                            this.resetSpeed();
                        }
                        averageBlocksPerSecond = (blocksSpeedList = CollectionUtils.INSTANCE.editCopy(blocksSpeedList, arg_0 -> GardenCropSpeed.checkSpeed$lambda$1(blocksBroken, arg_0))).size() > 5 ? CollectionsKt.averageOfInt(CollectionsKt.drop((Iterable)blocksSpeedList, 3)) : (blocksSpeedList.size() > 1 ? CollectionsKt.averageOfInt(CollectionsKt.drop((Iterable)blocksSpeedList, 1)) : 0.0);
                        CropType cropType = GardenAPI.INSTANCE.getCurrentlyFarmedCrop();
                        if (cropType == null) break block13;
                        it = cropType;
                        boolean bl = false;
                        ItemStack heldTool = InventoryUtils.INSTANCE.getItemInHand();
                        Object object2 = heldTool;
                        String string2 = toolName = object2 != null && (object2 = ItemUtils.INSTANCE.getInternalName((ItemStack)object2)) != null ? ((NEUInternalName)object2).asString() : null;
                        boolean bl2 = string2 != null ? StringsKt.contains$default((CharSequence)string2, "DICER", false, 2, null) : false;
                        if (!bl2) break block14;
                        object = lastBrokenCrop;
                        if (object == null || (object = object.getCropName()) == null) break block15;
                        String string3 = ((String)object).toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
                        object = string3;
                        if (string3 != null) break block16;
                    }
                    object = "NONE";
                }
                CropType lastCrop = object;
                String string4 = toolName.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
                if (StringsKt.contains$default((CharSequence)string4, (CharSequence)((Object)lastCrop), false, 2, null)) {
                    int tier;
                    int n = StringsKt.endsWith$default(toolName, "DICER", false, 2, null) ? 0 : (StringsKt.endsWith$default(toolName, "DICER_2", false, 2, null) ? 1 : (tier = StringsKt.endsWith$default(toolName, "DICER_3", false, 2, null) ? 2 : -1));
                    if (tier != -1 && !((Collection)melonDicer).isEmpty() && !((Collection)pumpkinDicer).isEmpty()) {
                        if (it == CropType.MELON) {
                            latestMelonDicer = ((Number)melonDicer.get(tier)).doubleValue();
                        } else if (it == CropType.PUMPKIN) {
                            latestPumpkinDicer = ((Number)pumpkinDicer.get(tier)).doubleValue();
                        }
                    }
                }
            }
            if (!(averageBlocksPerSecond > 1.0)) break block13;
            Map<CropType, Double> map2 = INSTANCE.getLatestBlocksPerSecond();
            if (map2 != null) {
                map2.put(it, averageBlocksPerSecond);
            }
        }
    }

    @SubscribeEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        DicerDropsJson dicerDropsJson;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String constant$iv = "DicerDrops";
        Type type$iv = null;
        Gson gson$iv = event.getGson();
        boolean $i$f$getConstant = false;
        try {
            RepoManager.Companion.setLastConstant(constant$iv);
            if (!event.getRepoLocation().exists()) {
                throw new RepoError("Repo folder does not exist!");
            }
            dicerDropsJson = RepoUtils.INSTANCE.getConstant(event.getRepoLocation(), constant$iv, gson$iv, DicerDropsJson.class, type$iv);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv);
        }
        DicerDropsJson data2 = dicerDropsJson;
        this.calculateAverageDicer(melonDicer, data2.getMELON());
        this.calculateAverageDicer(pumpkinDicer, data2.getPUMPKIN());
    }

    private final void calculateAverageDicer(List<Double> dicerList, DicerType data2) {
        dicerList.clear();
        for (DropInfo dropType : data2.getDrops()) {
            double chance = (double)dropType.getChance() / (double)data2.getTotalChance();
            Iterator iterator2 = ((Iterable)dropType.getAmount()).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int index = n++;
                int amount = ((Number)iterator2.next()).intValue();
                double dropAmount = (double)amount * chance;
                if (index < dicerList.size()) {
                    dicerList.set(index, ((Number)dicerList.get(index)).doubleValue() + dropAmount);
                    continue;
                }
                dicerList.add(dropAmount);
            }
        }
    }

    public final double getRecentBPS() {
        double d;
        int size = blocksSpeedList.size();
        if (size <= 1) {
            d = 0.0;
        } else {
            int startIndex = size >= 6 ? size - 6 : 0;
            List<Integer> validValues = blocksSpeedList.subList(startIndex, size);
            d = CollectionsKt.averageOfInt((Iterable<Integer>)CollectionsKt.dropLast(validValues, 1));
        }
        return d;
    }

    private final void resetSpeed() {
        averageBlocksPerSecond = 0.0;
        blocksSpeedList = CollectionsKt.emptyList();
        secondsStopped = 0;
    }

    public final boolean isEnabled() {
        return GardenAPI.INSTANCE.inGarden();
    }

    @Nullable
    public final Integer getSpeed(@NotNull CropType $this$getSpeed) {
        Intrinsics.checkNotNullParameter((Object)$this$getSpeed, "<this>");
        Map<CropType, Integer> map2 = this.getCropsPerSecond();
        return map2 != null ? map2.get((Object)$this$getSpeed) : null;
    }

    public final void setSpeed(@NotNull CropType $this$setSpeed, int speed) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$setSpeed, "<this>");
            Map<CropType, Integer> map2 = this.getCropsPerSecond();
            if (map2 == null) break block0;
            map2.put($this$setSpeed, speed);
        }
    }

    @Nullable
    public final Double getLatestBlocksPerSecond(@NotNull CropType $this$getLatestBlocksPerSecond) {
        Intrinsics.checkNotNullParameter((Object)$this$getLatestBlocksPerSecond, "<this>");
        Map<CropType, Double> map2 = this.getLatestBlocksPerSecond();
        return map2 != null ? map2.get((Object)$this$getLatestBlocksPerSecond) : null;
    }

    public final boolean isSpeedDataEmpty() {
        boolean bl;
        Map<CropType, Integer> map2 = this.getCropsPerSecond();
        if (map2 != null && (map2 = map2.values()) != null) {
            int it = CollectionsKt.sumOfInt((Iterable)((Object)map2));
            boolean bl2 = false;
            bl = it == 0;
        } else {
            bl = true;
        }
        return bl;
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.blocksBrokenResetTime", "garden.cropMilestones.blocksBrokenResetTime", null, 8, null);
    }

    private static final Unit checkSpeed$lambda$1(int $blocksBroken, List $this$editCopy) {
        Intrinsics.checkNotNullParameter($this$editCopy, "$this$editCopy");
        while (secondsStopped > 0) {
            $this$editCopy.add(0);
            --secondsStopped;
        }
        $this$editCopy.add($blocksBroken);
        if ($this$editCopy.size() == 2) {
            CollectionsKt.removeFirst($this$editCopy);
            $this$editCopy.add($blocksBroken);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ int access$getBlocksBroken$p() {
        return blocksBroken;
    }

    public static final /* synthetic */ void access$checkSpeed(GardenCropSpeed $this) {
        $this.checkSpeed();
    }

    public static final /* synthetic */ void access$update(GardenCropSpeed $this) {
        $this.update();
    }

    static {
        Timer timer;
        INSTANCE = new GardenCropSpeed();
        lastBrokenTime = SimpleTimeMark.Companion.now-uFjCsEo();
        blocksSpeedList = CollectionsKt.emptyList();
        melonDicer = new ArrayList();
        pumpkinDicer = new ArrayList();
        String string2 = "skyhanni-crop-milestone-speed";
        long l = 1000L;
        boolean bl = false;
        long l2 = 0L;
        Timer timer2 = timer = TimersKt.timer(string2, bl);
        timer2.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                TimerTask $this$_init__u24lambda_u240 = this;
                boolean bl = false;
                if (GardenCropSpeed.INSTANCE.isEnabled()) {
                    if (GardenAPI.INSTANCE.getMushroomCowPet()) {
                        CropType cropType = GardenCropSpeed.INSTANCE.getLastBrokenCrop();
                        GardenCropMilestones.INSTANCE.setCounter(CropType.MUSHROOM, GardenCropMilestones.INSTANCE.getCounter(CropType.MUSHROOM) + (long)(GardenCropSpeed.access$getBlocksBroken$p() * (cropType != null ? cropType.getMultiplier() : 1)));
                    }
                    GardenCropSpeed.access$checkSpeed(GardenCropSpeed.INSTANCE);
                    GardenCropSpeed.access$update(GardenCropSpeed.INSTANCE);
                }
            }
        }, l2, l);
    }
}

