/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.composter;

import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.garden.composter.ComposterConfig;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.LorenzToolTipEvent;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NEUItems;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eR\u001c\u0010\u0013\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lat/hannibal2/skyhanni/features/garden/composter/GardenComposterInventoryFeatures;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzToolTipEvent;", "event", "", "onTooltip", "(Lat/hannibal2/skyhanni/events/LorenzToolTipEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;", "onBackgroundDrawn", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/garden/composter/ComposterConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/composter/ComposterConfig;", "config", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nGardenComposterInventoryFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GardenComposterInventoryFeatures.kt\nat/hannibal2/skyhanni/features/garden/composter/GardenComposterInventoryFeatures\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1755#2,3:101\n*S KotlinDebug\n*F\n+ 1 GardenComposterInventoryFeatures.kt\nat/hannibal2/skyhanni/features/garden/composter/GardenComposterInventoryFeatures\n*L\n87#1:101,3\n*E\n"})
public final class GardenComposterInventoryFeatures {
    @NotNull
    public static final GardenComposterInventoryFeatures INSTANCE = new GardenComposterInventoryFeatures();

    private GardenComposterInventoryFeatures() {
    }

    private final ComposterConfig getConfig() {
        return GardenAPI.INSTANCE.getConfig().composters;
    }

    @SubscribeEvent
    public final void onTooltip(@NotNull LorenzToolTipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!GardenAPI.INSTANCE.inGarden()) {
            return;
        }
        if (!this.getConfig().upgradePrice) {
            return;
        }
        if (!Intrinsics.areEqual(InventoryUtils.INSTANCE.openInventoryName(), "Composter Upgrades")) {
            return;
        }
        boolean next = false;
        List<String> list = event.getToolTip();
        int i2 = -1;
        int indexFullCost = 0;
        double fullPrice = 0.0;
        int amountItems = 0;
        for (String line : event.toolTipRemovedPrefix()) {
            Pair<String, Integer> pair;
            ++i2;
            if (Intrinsics.areEqual(line, "\u00a77Upgrade Cost:")) {
                next = true;
                indexFullCost = i2;
                continue;
            }
            if (!next || StringsKt.endsWith$default(line, " Copper", false, 2, null)) continue;
            if (Intrinsics.areEqual(line, "")) break;
            if (ItemUtils.INSTANCE.readItemAmount(line) == null) {
                GardenComposterInventoryFeatures $this$onTooltip_u24lambda_u240 = this;
                boolean bl = false;
                Pair[] pairArray = new Pair[]{TuplesKt.to("line", line)};
                ErrorManager.logErrorStateWithData$default(ErrorManager.INSTANCE, "Error reading item line", "could not read item line", pairArray, false, false, false, null, 120, null);
                continue;
            }
            String itemName = pair.component1();
            int amount = ((Number)pair.component2()).intValue();
            NEUInternalName internalName = NEUInternalName.Companion.fromItemName(itemName);
            double lowestBin = NEUItems.getPrice$default(NEUItems.INSTANCE, internalName, null, null, 3, null);
            double price = lowestBin * (double)amount;
            fullPrice += price;
            String format = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, price, false, 1, null);
            list.set(i2, list.get(i2) + " \u00a77(\u00a76" + format + "\u00a77)");
            ++amountItems;
        }
        if (amountItems > 1) {
            String format = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, fullPrice, false, 1, null);
            list.set(indexFullCost, list.get(indexFullCost) + " \u00a77(\u00a76" + format + "\u00a77)");
        }
    }

    @SubscribeEvent
    public final void onBackgroundDrawn(@NotNull GuiContainerEvent.BackgroundDrawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        if (!this.getConfig().highlightUpgrade) {
            return;
        }
        if (Intrinsics.areEqual(InventoryUtils.INSTANCE.openInventoryName(), "Composter Upgrades")) {
            if (!(event.getGui() instanceof GuiChest)) {
                return;
            }
            GuiContainer guiChest = event.getGui();
            Container container = guiChest.field_147002_h;
            Intrinsics.checkNotNull(container, "null cannot be cast to non-null type net.minecraft.inventory.ContainerChest");
            ContainerChest chest = (ContainerChest)container;
            for (Map.Entry<Slot, ItemStack> entry : InventoryUtils.INSTANCE.getUpperItems(chest).entrySet()) {
                boolean bl;
                Slot slot;
                block8: {
                    slot = entry.getKey();
                    ItemStack stack = entry.getValue();
                    Iterable $this$any$iv = ItemUtils.INSTANCE.getLore(stack);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(it, "\u00a7eClick to upgrade!")) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                RenderUtils.INSTANCE.highlight(slot, LorenzColor.GOLD);
            }
        }
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.composterUpgradePrice", "garden.composters.upgradePrice", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.composterHighLightUpgrade", "garden.composters.highlightUpgrade", null, 8, null);
    }
}

