/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden;

import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.enums.OutsideSbFeature;
import at.hannibal2.skyhanni.config.features.garden.YawPitchDisplayConfig;
import at.hannibal2.skyhanni.events.GardenToolChangeEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import java.math.BigDecimal;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0016\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0018\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001b\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lat/hannibal2/skyhanni/features/garden/GardenYawAndPitch;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "event", "", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/events/GardenToolChangeEvent;", "onGardenToolChange", "(Lat/hannibal2/skyhanni/events/GardenToolChangeEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/garden/YawPitchDisplayConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/YawPitchDisplayConfig;", "config", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastChange", "J", "", "lastYaw", "F", "lastPitch", "1.8.9"})
public final class GardenYawAndPitch {
    @NotNull
    public static final GardenYawAndPitch INSTANCE = new GardenYawAndPitch();
    private static long lastChange = SimpleTimeMark.Companion.farPast();
    private static float lastYaw;
    private static float lastPitch;

    private GardenYawAndPitch() {
    }

    private final YawPitchDisplayConfig getConfig() {
        return GardenAPI.INSTANCE.getConfig().yawPitchDisplay;
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getOnHypixel()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (GardenAPI.INSTANCE.hideExtraGuis()) {
            return;
        }
        if (GardenAPI.INSTANCE.getToolInHand() == null && !this.getConfig().showWithoutTool) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        float yaw = LocationUtils.INSTANCE.calculatePlayerYaw();
        float pitch = player.field_70125_A;
        if (!(yaw == lastYaw) || !(pitch == lastPitch)) {
            lastChange = SimpleTimeMark.Companion.now-uFjCsEo();
        }
        lastYaw = yaw;
        lastPitch = pitch;
        if (!this.getConfig().showAlways) {
            if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastChange), DurationKt.toDuration(this.getConfig().timeout, DurationUnit.SECONDS)) > 0) {
                return;
            }
        }
        String yawText = new BigDecimal(String.valueOf(NumberUtil.INSTANCE.roundTo(yaw, this.getConfig().yawPrecision))).toPlainString();
        String pitchText = new BigDecimal(String.valueOf(NumberUtil.INSTANCE.roundTo(pitch, this.getConfig().pitchPrecision))).toPlainString();
        String[] stringArray = new String[]{"\u00a7aYaw: \u00a7f" + yawText, "\u00a7aPitch: \u00a7f" + pitchText};
        List<String> displayList = CollectionsKt.listOf(stringArray);
        if (GardenAPI.INSTANCE.inGarden()) {
            Position position = this.getConfig().pos;
            Intrinsics.checkNotNullExpressionValue(position, "pos");
            RenderUtils.renderStrings$default(RenderUtils.INSTANCE, position, displayList, 0, "Yaw and Pitch", 2, null);
        } else {
            Position position = this.getConfig().posOutside;
            Intrinsics.checkNotNullExpressionValue(position, "posOutside");
            RenderUtils.renderStrings$default(RenderUtils.INSTANCE, position, displayList, 0, "Yaw and Pitch", 2, null);
        }
    }

    @SubscribeEvent
    public final void onGardenToolChange(@NotNull GardenToolChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        lastChange = SimpleTimeMark.Companion.farPast();
    }

    private final boolean isEnabled() {
        return this.getConfig().enabled && (OutsideSbFeature.YAW_AND_PITCH.isSelected() && !LorenzUtils.INSTANCE.getInSkyBlock() || LorenzUtils.INSTANCE.getInSkyBlock() && (GardenAPI.INSTANCE.inGarden() || this.getConfig().showOutsideGarden));
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 18, "garden.yawPitchDisplay.showEverywhere", "garden.yawPitchDisplay.showOutsideGarden", null, 8, null);
    }
}

