/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden;

import at.hannibal2.skyhanni.config.features.garden.MoneyPerHourConfig;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.features.garden.farming.CropMoneyDisplay;
import at.hannibal2.skyhanni.features.garden.farming.GardenCropSpeed;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NEUItems;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.PrimitiveItemStack;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tR\u001c\u0010\u000e\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lat/hannibal2/skyhanni/features/garden/GardenCropTimeCommand;", "", "<init>", "()V", "", "", "args", "", "onCommand", "([Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/config/features/garden/MoneyPerHourConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/MoneyPerHourConfig;", "config", "1.8.9"})
public final class GardenCropTimeCommand {
    @NotNull
    public static final GardenCropTimeCommand INSTANCE = new GardenCropTimeCommand();

    private GardenCropTimeCommand() {
    }

    private final MoneyPerHourConfig getConfig() {
        return GardenAPI.INSTANCE.getConfig().moneyPerHours;
    }

    public final void onCommand(@NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        if (!this.getConfig().display) {
            ChatUtils.INSTANCE.userError("shcroptime requires 'Show money per Hour' feature to be enabled to work!");
            return;
        }
        if (args2.length < 2) {
            ChatUtils.INSTANCE.userError("Usage: /shcroptime <amount> <item>");
            return;
        }
        Long l = NumberUtil.INSTANCE.formatLongOrUserError(args2[0]);
        if (l == null) {
            return;
        }
        long amount = l;
        Map<NEUInternalName, Integer> multipliers = CropMoneyDisplay.INSTANCE.getMultipliers();
        if (multipliers.isEmpty()) {
            ChatUtils.INSTANCE.userError("Data not loaded yet. Join the garden and display the money per hour display.");
            return;
        }
        String rawSearchName = CollectionsKt.joinToString$default(CollectionsKt.drop((Iterable)ArraysKt.toMutableList(args2), 1), " ", null, null, 0, null, null, 62, null);
        String string2 = rawSearchName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String searchName = string2;
        Map map2 = new LinkedHashMap();
        for (Map.Entry<NEUInternalName, Integer> entry : multipliers.entrySet()) {
            NEUInternalName internalName = entry.getKey();
            String itemName = ItemUtils.INSTANCE.getItemName(internalName);
            String string3 = StringUtils.removeColor$default(StringUtils.INSTANCE, itemName, false, 1, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
            if (!StringsKt.contains$default((CharSequence)string3, searchName, false, 2, null)) continue;
            PrimitiveItemStack primitiveItemStack = NEUItems.getPrimitiveMultiplier$default(NEUItems.INSTANCE, internalName, 0, 2, null);
            NEUInternalName baseId = primitiveItemStack.component1();
            int baseAmount = primitiveItemStack.component2();
            String baseName = ItemUtils.INSTANCE.getItemName(baseId);
            CropType crop = CropType.Companion.getByName(StringUtils.removeColor$default(StringUtils.INSTANCE, baseName, false, 1, null));
            long fullAmount = (long)baseAmount * amount;
            String text = baseAmount == 1 ? "\u00a7e" + NumberUtil.INSTANCE.addSeparators(amount) + "x " + itemName : "\u00a7e" + NumberUtil.INSTANCE.addSeparators(amount) + "x " + itemName + " \u00a77(\u00a7e" + NumberUtil.INSTANCE.addSeparators(fullAmount) + "x " + baseName + "\u00a77)";
            Integer speed = GardenCropSpeed.INSTANCE.getSpeed(crop);
            if (speed == null) {
                map2.put(text + " \u00a7cNo speed data!", -1L);
                continue;
            }
            long missingTime = DurationKt.toDuration(fullAmount / (long)speed.intValue(), DurationUnit.SECONDS);
            String duration = TimeUtils.format-bz6L7rs$default(TimeUtils.INSTANCE, missingTime, null, false, false, 0, false, 31, null);
            map2.put(text + " \u00a7b" + duration, Duration.getInWholeSeconds-impl(missingTime));
        }
        if (map2.isEmpty()) {
            ChatUtils.INSTANCE.userError("No crop item found for '" + rawSearchName + "'.");
            return;
        }
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Crop Speed for " + map2.size() + " items:\n" + CollectionsKt.joinToString$default(CollectionUtils.INSTANCE.sorted(map2).keySet(), "\n", null, null, 0, null, null, 62, null), false, null, 6, null);
    }
}

