/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.fishing.trophy;

import at.hannibal2.skyhanni.data.jsonobjects.repo.TrophyFishInfo;
import at.hannibal2.skyhanni.features.fishing.trophy.TrophyFishManager;
import at.hannibal2.skyhanni.features.fishing.trophy.TrophyRarity;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.StringUtils;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J+\u0010\r\u001a\u00020\u00042\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\f\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lat/hannibal2/skyhanni/features/fishing/trophy/TrophyFishAPI;", "", "<init>", "()V", "", "internalName", "hoverInfo", "(Ljava/lang/String;)Ljava/lang/String;", "", "Lat/hannibal2/skyhanni/features/fishing/trophy/TrophyRarity;", "", "counts", "rarity", "formatCount", "(Ljava/util/Map;Lat/hannibal2/skyhanni/features/fishing/trophy/TrophyRarity;)Ljava/lang/String;", "1.8.9"})
public final class TrophyFishAPI {
    @NotNull
    public static final TrophyFishAPI INSTANCE = new TrophyFishAPI();

    private TrophyFishAPI() {
    }

    @Nullable
    public final String hoverInfo(@NotNull String internalName) {
        Map<TrophyRarity, Integer> counts;
        TrophyRarity trophyRarity;
        Intrinsics.checkNotNullParameter(internalName, "internalName");
        Map<String, Map<TrophyRarity, Integer>> map2 = TrophyFishManager.INSTANCE.getFish();
        if (map2 == null) {
            return null;
        }
        Map<String, Map<TrophyRarity, Integer>> trophyFishes = map2;
        TrophyFishInfo trophyFishInfo = TrophyFishManager.INSTANCE.getInfo(internalName);
        if (trophyFishInfo == null) {
            return null;
        }
        TrophyFishInfo info = trophyFishInfo;
        Map<TrophyRarity, Integer> map3 = trophyFishes.get(internalName);
        if (map3 == null) {
            map3 = MapsKt.emptyMap();
        }
        if ((trophyRarity = (TrophyRarity)((Object)CollectionsKt.maxOrNull((Iterable)(counts = map3).keySet()))) == null) {
            trophyRarity = TrophyRarity.BRONZE;
        }
        TrophyRarity bestFishObtained = trophyRarity;
        String rateString = info.getRate() != null ? "\u00a78[\u00a77" + info.getRate() + "%\u00a78]" : "";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n                |").append(info.getDisplayName()).append(' ').append(rateString).append("\n                |").append(StringUtils.INSTANCE.splitLines(info.getDescription(), 150)).append("\n                |\n                |").append(TrophyRarity.DIAMOND.getFormattedString()).append(": ").append(this.formatCount(counts, TrophyRarity.DIAMOND)).append("\n                |").append(TrophyRarity.GOLD.getFormattedString()).append(": ").append(this.formatCount(counts, TrophyRarity.GOLD)).append("\n                |").append(TrophyRarity.SILVER.getFormattedString()).append(": ").append(this.formatCount(counts, TrophyRarity.SILVER)).append("\n                |").append(TrophyRarity.BRONZE.getFormattedString()).append(": ").append(this.formatCount(counts, TrophyRarity.BRONZE)).append("\n                |\n                |\u00a77Total: ");
        stringBuilder.append(bestFishObtained.getFormatCode()).append(NumberUtil.INSTANCE.addSeparators(CollectionsKt.sumOfInt((Iterable<Integer>)counts.values()))).append("\n            ");
        return StringsKt.trimMargin$default(stringBuilder.toString(), null, 1, null);
    }

    private final String formatCount(Map<TrophyRarity, Integer> counts, TrophyRarity rarity) {
        int count2 = ((Number)counts.getOrDefault((Object)rarity, 0)).intValue();
        return count2 > 0 ? "\u00a76" + NumberUtil.INSTANCE.addSeparators(count2) : "\u00a7c\u2716";
    }
}

