/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.fishing.trophy;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.features.fishing.trophyfishing.GeyserFishingConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.ReceiveParticleEvent;
import at.hannibal2.skyhanni.features.fishing.FishingAPI;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SpecialColor;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000f\u0010\bJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0017\u001a\n \u0014*\u0004\u0018\u00010\u00130\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001aR\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lat/hannibal2/skyhanni/features/fishing/trophy/GeyserFishing;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;", "event", "", "onReceiveParticle", "(Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "hideGeyserParticles", "", "shouldProcessParticles", "()Z", "Lat/hannibal2/skyhanni/config/features/fishing/trophyfishing/GeyserFishingConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/fishing/trophyfishing/GeyserFishingConfig;", "config", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "geyserOffset", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "geyser", "Lnet/minecraft/util/AxisAlignedBB;", "geyserBox", "Lnet/minecraft/util/AxisAlignedBB;", "1.8.9"})
public final class GeyserFishing {
    @NotNull
    public static final GeyserFishing INSTANCE = new GeyserFishing();
    @NotNull
    private static final LorenzVec geyserOffset = new LorenzVec(0.1f, 0.6f, 0.1f);
    @Nullable
    private static LorenzVec geyser;
    @Nullable
    private static AxisAlignedBB geyserBox;

    private GeyserFishing() {
    }

    private final GeyserFishingConfig getConfig() {
        return SkyHanniMod.feature.fishing.trophyFishing.geyserOptions;
    }

    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=true)
    public final void onReceiveParticle(@NotNull ReceiveParticleEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.shouldProcessParticles()) {
            return;
        }
        ReceiveParticleEvent $this$onReceiveParticle_u24lambda_u240 = event;
        boolean bl = false;
        if ($this$onReceiveParticle_u24lambda_u240.getType() != EnumParticleTypes.CLOUD || $this$onReceiveParticle_u24lambda_u240.getCount() != 15 || !($this$onReceiveParticle_u24lambda_u240.getSpeed() == 0.05f) || !Intrinsics.areEqual($this$onReceiveParticle_u24lambda_u240.getOffset(), geyserOffset)) {
            return;
        }
        LorenzVec lorenzVec = geyser = event.getLocation();
        if (lorenzVec == null) {
            return;
        }
        LorenzVec potentialGeyser = lorenzVec;
        geyserBox = new AxisAlignedBB(potentialGeyser.getX() - (double)2, 117.9, potentialGeyser.getZ() - (double)2, potentialGeyser.getX() + (double)2, 117.91, potentialGeyser.getZ() + (double)2);
        if (this.getConfig().hideParticles && FishingAPI.INSTANCE.getBobber() != null) {
            this.hideGeyserParticles(event);
        }
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        geyser = null;
        geyserBox = null;
    }

    @SubscribeEvent
    public final void onRenderWorld(@NotNull LorenzRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.getConfig().drawBox) {
            return;
        }
        AxisAlignedBB axisAlignedBB = geyserBox;
        if (axisAlignedBB == null) {
            return;
        }
        AxisAlignedBB geyserBox = axisAlignedBB;
        LorenzVec lorenzVec = geyser;
        if (lorenzVec == null) {
            return;
        }
        LorenzVec geyser = lorenzVec;
        if (LocationUtils.INSTANCE.distanceToPlayerIgnoreY(geyser) > 96.0) {
            return;
        }
        if (!LorenzUtils.INSTANCE.isInIsland(IslandType.CRIMSON_ISLE)) {
            return;
        }
        if (this.getConfig().onlyWithRod && !FishingAPI.INSTANCE.getHoldingLavaRod()) {
            return;
        }
        Color color = new Color(SpecialColor.specialToChromaRGB(this.getConfig().boxColor), true);
        RenderUtils.drawFilledBoundingBox_nea$default(RenderUtils.INSTANCE, event, geyserBox, color, 0.0f, false, false, 28, null);
    }

    private final void hideGeyserParticles(ReceiveParticleEvent event) {
        EntityFishHook entityFishHook = FishingAPI.INSTANCE.getBobber();
        if (entityFishHook == null) {
            return;
        }
        EntityFishHook bobber = entityFishHook;
        LorenzVec lorenzVec = geyser;
        if (lorenzVec == null) {
            return;
        }
        LorenzVec geyser = lorenzVec;
        if (LocationUtils.INSTANCE.distanceTo((Entity)bobber, event.getLocation()) < 3.0 && LocationUtils.INSTANCE.distanceTo((Entity)bobber, geyser) < 3.0) {
            event.cancel();
        }
    }

    private final boolean shouldProcessParticles() {
        return LorenzUtils.INSTANCE.isInIsland(IslandType.CRIMSON_ISLE) && Intrinsics.areEqual(LorenzUtils.INSTANCE.getSkyBlockArea(), "Blazing Volcano") && (this.getConfig().hideParticles || this.getConfig().drawBox);
    }
}

