/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.fishing.tracker;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.fishing.SeaCreatureTrackerConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.FishingBobberCastEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.SeaCreatureFishEvent;
import at.hannibal2.skyhanni.features.fishing.FishingAPI;
import at.hannibal2.skyhanni.features.fishing.SeaCreature;
import at.hannibal2.skyhanni.features.fishing.SeaCreatureManager;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.renderables.RenderableUtils;
import at.hannibal2.skyhanni.utils.renderables.Searchable;
import at.hannibal2.skyhanni.utils.renderables.SearchableKt;
import at.hannibal2.skyhanni.utils.tracker.SkyHanniTracker;
import at.hannibal2.skyhanni.utils.tracker.TrackerData;
import com.google.gson.annotations.Expose;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000f\u001a\u0012\u0012\b\u0012\u00060\fj\u0002`\r\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J-\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00170\u0016*\b\u0012\u0004\u0012\u00020\u00120\u00152\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001b\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00170\u0016H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001cH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010 \u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001fH\u0007\u00a2\u0006\u0004\b \u0010!J\u0017\u0010#\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\"H\u0007\u00a2\u0006\u0004\b#\u0010$J\r\u0010%\u001a\u00020\u0006\u00a2\u0006\u0004\b%\u0010\u0003J\u000f\u0010&\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b&\u0010'R\u001c\u0010,\u001a\n )*\u0004\u0018\u00010(0(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\"\u0010.\u001a\u0010\u0012\f\u0012\n )*\u0004\u0018\u00010\t0\t0-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0018\u00100\u001a\u00060\fj\u0002`\r8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b0\u00101R\u001a\u00102\u001a\u00060\fj\u0002`\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u00101\u00a8\u00064"}, d2={"Lat/hannibal2/skyhanni/features/fishing/tracker/SeaCreatureTracker;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/SeaCreatureFishEvent;", "event", "", "onSeaCreatureFish", "(Lat/hannibal2/skyhanni/events/SeaCreatureFishEvent;)V", "Lat/hannibal2/skyhanni/features/fishing/tracker/SeaCreatureTracker$Data;", "data", "", "", "Lat/hannibal2/skyhanni/features/fishing/tracker/CategoryName;", "", "getCurrentCategories", "(Lat/hannibal2/skyhanni/features/fishing/tracker/SeaCreatureTracker$Data;)Ljava/util/Map;", "", "Lat/hannibal2/skyhanni/utils/renderables/Searchable;", "drawDisplay", "(Lat/hannibal2/skyhanni/features/fishing/tracker/SeaCreatureTracker$Data;)Ljava/util/List;", "", "Lkotlin/Function1;", "", "addCategories", "(Ljava/util/List;Lat/hannibal2/skyhanni/features/fishing/tracker/SeaCreatureTracker$Data;)Lkotlin/jvm/functions/Function1;", "filterCurrentCategory", "()Lkotlin/jvm/functions/Function1;", "Lat/hannibal2/skyhanni/events/ConfigLoadEvent;", "onConfigLoad", "(Lat/hannibal2/skyhanni/events/ConfigLoadEvent;)V", "Lat/hannibal2/skyhanni/events/FishingBobberCastEvent;", "onBobberThrow", "(Lat/hannibal2/skyhanni/events/FishingBobberCastEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent;)V", "resetCommand", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/fishing/SeaCreatureTrackerConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/fishing/SeaCreatureTrackerConfig;", "config", "Lat/hannibal2/skyhanni/utils/tracker/SkyHanniTracker;", "tracker", "Lat/hannibal2/skyhanni/utils/tracker/SkyHanniTracker;", "nameAll", "Ljava/lang/String;", "currentCategory", "Data", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nSeaCreatureTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeaCreatureTracker.kt\nat/hannibal2/skyhanni/features/fishing/tracker/SeaCreatureTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 RenderableUtils.kt\nat/hannibal2/skyhanni/utils/renderables/RenderableUtils\n*L\n1#1,166:1\n1782#2,4:167\n1062#2:178\n535#3:171\n520#3,6:172\n98#4,28:179\n*S KotlinDebug\n*F\n+ 1 SeaCreatureTracker.kt\nat/hannibal2/skyhanni/features/fishing/tracker/SeaCreatureTracker\n*L\n65#1:167,4\n81#1:178\n78#1:171\n78#1:172,6\n110#1:179,28\n*E\n"})
public final class SeaCreatureTracker {
    @NotNull
    public static final SeaCreatureTracker INSTANCE = new SeaCreatureTracker();
    @NotNull
    private static final SkyHanniTracker<Data> tracker = new SkyHanniTracker<Data>("Sea Creature Tracker", SeaCreatureTracker::tracker$lambda$0, SeaCreatureTracker::tracker$lambda$1, new Pair[0], SeaCreatureTracker::tracker$lambda$2);
    @NotNull
    private static final String nameAll;
    @NotNull
    private static String currentCategory;

    private SeaCreatureTracker() {
    }

    private final SeaCreatureTrackerConfig getConfig() {
        return SkyHanniMod.feature.fishing.seaCreatureTracker;
    }

    @SubscribeEvent
    public final void onSeaCreatureFish(@NotNull SeaCreatureFishEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        tracker.modify(arg_0 -> SeaCreatureTracker.onSeaCreatureFish$lambda$3(event, arg_0));
        if (this.getConfig().hideChat) {
            event.getChatEvent().setBlockedReason("sea_creature_tracker");
        }
    }

    private final Map<String, Integer> getCurrentCategories(Data data2) {
        Map map2 = new LinkedHashMap();
        map2.put(nameAll, data2.getAmount().size());
        for (Map.Entry<String, List<String>> entry : SeaCreatureManager.INSTANCE.getAllVariants().entrySet()) {
            int amount;
            int n;
            String category = entry.getKey();
            List<String> names = entry.getValue();
            Iterable $this$count$iv = names;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!data2.getAmount().containsKey(it) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            if ((amount = n) <= 0) continue;
            Integer n2 = amount;
            map2.put(category, n2);
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Searchable> drawDisplay(Data data2) {
        void $this$filterTo$iv$iv;
        List<Searchable> list;
        List<Searchable> $this$drawDisplay_u24lambda_u248 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        CollectionUtils.addSearchString$default(CollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u248, "\u00a77Sea Creature Tracker:", null, null, null, 14, null);
        Function1<String, Boolean> filter2 = INSTANCE.addCategories($this$drawDisplay_u24lambda_u248, data2);
        Map<String, Integer> $this$filter$iv = data2.getAmount();
        boolean $i$f$filter = false;
        Map<String, Integer> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            if (!filter2.invoke((String)it.getKey()).booleanValue()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map realAmount = destination$iv$iv;
        double total = CollectionUtils.INSTANCE.sumAllValues(realAmount);
        Iterable $this$sortedByDescending$iv = realAmount.entrySet();
        boolean $i$f$sortedByDescending = false;
        for (Map.Entry entry : CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Integer)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getValue()));
            }
        })) {
            String string2;
            String name2 = (String)entry.getKey();
            int amount = ((Number)entry.getValue()).intValue();
            Object object = SeaCreatureManager.INSTANCE.getAllFishingMobs().get(name2);
            if (object == null || (object = ((SeaCreature)object).getDisplayName()) == null) {
                List<Searchable> $this$drawDisplay_u24lambda_u248_u24lambda_u247 = $this$drawDisplay_u24lambda_u248;
                boolean bl3 = false;
                Pair[] pairArray = new Pair[]{TuplesKt.to("SeaCreatureManager.allFishingMobs.keys", SeaCreatureManager.INSTANCE.getAllFishingMobs().keySet()), TuplesKt.to("name", name2)};
                ErrorManager.logErrorStateWithData$default(ErrorManager.INSTANCE, "Sea Creature Tracker can not display a name correctly", "Could not find sea creature by name", pairArray, false, false, false, null, 120, null);
                object = name2;
            }
            Object displayName = object;
            if (((Boolean)SeaCreatureTracker.INSTANCE.getConfig().showPercentage.get()).booleanValue()) {
                String percentage = LorenzUtils.INSTANCE.formatPercentage((double)amount / total);
                string2 = " \u00a77" + percentage;
            } else {
                string2 = "";
            }
            String percentageSuffix = string2;
            CollectionUtils.addSearchString$default(CollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u248, " \u00a77- \u00a7e" + NumberUtil.INSTANCE.addSeparators(amount) + ' ' + (String)displayName + percentageSuffix, (String)displayName, null, null, 12, null);
        }
        CollectionUtils.addSearchString$default(CollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u248, " \u00a77- \u00a7e" + NumberUtil.INSTANCE.addSeparators(total) + " \u00a77Total Sea Creatures", null, null, null, 14, null);
        return CollectionsKt.build(list);
    }

    /*
     * WARNING - void declaration
     */
    private final Function1<String, Boolean> addCategories(List<Searchable> $this$addCategories, Data data2) {
        Map<String, Integer> amounts = this.getCurrentCategories(data2);
        List list = CollectionsKt.toList((Iterable)amounts.keySet());
        if (!list.contains(currentCategory)) {
            currentCategory = nameAll;
        }
        if (tracker.isInventoryOpen()) {
            void getName$iv;
            void prefix$iv;
            void $this$addButton_u24lambda_u2411$iv;
            List list2;
            RenderableUtils renderableUtils = RenderableUtils.INSTANCE;
            String string2 = "\u00a77Category: ";
            String string3 = StringUtils.INSTANCE.allLettersFirstUppercase(currentCategory) + " \u00a77(" + amounts.get(currentCategory) + ')';
            List tips$iv = CollectionsKt.emptyList();
            boolean $i$f$addButton = false;
            Function0 onClick$iv = new Function0<Unit>(list){
                final /* synthetic */ List $list$inlined;
                {
                    this.$list$inlined = list;
                }

                public final void invoke() {
                    if (System.currentTimeMillis() - ChatUtils.INSTANCE.getLastButtonClicked() > 150L) {
                        boolean bl = false;
                        int id = this.$list$inlined.indexOf(SeaCreatureTracker.access$getCurrentCategory$p());
                        SeaCreatureTracker.access$setCurrentCategory$p((String)this.$list$inlined.get((id + 1) % this.$list$inlined.size()));
                        SeaCreatureTracker.access$getTracker$p().update();
                        SoundUtils.INSTANCE.playClickSound();
                        ChatUtils.INSTANCE.setLastButtonClicked(System.currentTimeMillis());
                    }
                }
            };
            List list3 = list2 = CollectionsKt.createListBuilder();
            Renderable.Companion companion = Renderable.Companion;
            List<Searchable> list4 = $this$addCategories;
            boolean bl = false;
            CollectionUtils.addString$default(CollectionUtils.INSTANCE, (List)$this$addButton_u24lambda_u2411$iv, (String)prefix$iv, null, null, 6, null);
            CollectionUtils.addString$default(CollectionUtils.INSTANCE, (List)$this$addButton_u24lambda_u2411$iv, "\u00a7a[", null, null, 6, null);
            boolean bl2 = tips$iv.isEmpty() ? $this$addButton_u24lambda_u2411$iv.add(Renderable.Companion.link("\u00a7e" + (String)getName$iv, false, onClick$iv)) : $this$addButton_u24lambda_u2411$iv.add(Renderable.Companion.clickAndHover$default(Renderable.Companion, "\u00a7e" + (String)getName$iv, tips$iv, false, onClick$iv, null, 16, null));
            CollectionUtils.addString$default(CollectionUtils.INSTANCE, (List)$this$addButton_u24lambda_u2411$iv, "\u00a7a]", null, null, 6, null);
            Unit unit = Unit.INSTANCE;
            list4.add(SearchableKt.toSearchable$default(Renderable.Companion.horizontalContainer$default(companion, CollectionsKt.build(list2), 0, null, null, 14, null), null, 1, null));
        }
        return Intrinsics.areEqual(currentCategory, nameAll) ? SeaCreatureTracker::addCategories$lambda$10 : this.filterCurrentCategory();
    }

    private final Function1<String, Boolean> filterCurrentCategory() {
        List<String> list = SeaCreatureManager.INSTANCE.getAllVariants().get(currentCategory);
        if (list == null) {
            SeaCreatureTracker $this$filterCurrentCategory_u24lambda_u2412 = this;
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to("SeaCreatureManager.allVariants.keys", SeaCreatureManager.INSTANCE.getAllVariants().keySet()), TuplesKt.to("currentCategory", currentCategory)};
            ErrorManager.logErrorStateWithData$default(ErrorManager.INSTANCE, "Sea Creature Tracker can not find all sea creature variants", "Sea creature variant is not found", pairArray, false, false, false, null, 120, null);
            return SeaCreatureTracker::filterCurrentCategory$lambda$12$lambda$11;
        }
        List<String> items = list;
        return arg_0 -> SeaCreatureTracker.filterCurrentCategory$lambda$13(items, arg_0);
    }

    @SubscribeEvent
    public final void onConfigLoad(@NotNull ConfigLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Property[] propertyArray = new Property[]{this.getConfig().showPercentage};
        ConditionalUtils.INSTANCE.onToggle(propertyArray, SeaCreatureTracker::onConfigLoad$lambda$14);
    }

    @SubscribeEvent
    public final void onBobberThrow(@NotNull FishingBobberCastEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        tracker.firstUpdate();
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!FishingAPI.INSTANCE.isFishing(false)) {
            return;
        }
        Position position = this.getConfig().position;
        Intrinsics.checkNotNullExpressionValue(position, "position");
        tracker.renderDisplay(position);
    }

    public final void resetCommand() {
        tracker.resetCommand();
    }

    private final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && this.getConfig().enabled && !FishingAPI.INSTANCE.getWearingTrophyArmor() && !LorenzUtils.INSTANCE.getInKuudraFight();
    }

    private static final Data tracker$lambda$0() {
        return new Data();
    }

    private static final Data tracker$lambda$1(ProfileSpecificStorage it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.fishing.seaCreatureTracker;
    }

    private static final List tracker$lambda$2(Data it) {
        Intrinsics.checkNotNull(it);
        return INSTANCE.drawDisplay(it);
    }

    private static final Unit onSeaCreatureFish$lambda$3(SeaCreatureFishEvent $event, Data it) {
        Intrinsics.checkNotNullParameter((Object)$event, "$event");
        int amount = $event.getDoubleHook() && SeaCreatureTracker.INSTANCE.getConfig().countDouble ? 2 : 1;
        CollectionUtils.INSTANCE.addOrPut(it.getAmount(), $event.getSeaCreature().getName(), amount);
        return Unit.INSTANCE;
    }

    private static final boolean addCategories$lambda$10(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return true;
    }

    private static final boolean filterCurrentCategory$lambda$12$lambda$11(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return true;
    }

    private static final boolean filterCurrentCategory$lambda$13(List $items, String it) {
        Intrinsics.checkNotNullParameter($items, "$items");
        Intrinsics.checkNotNullParameter(it, "it");
        return $items.contains(it);
    }

    private static final void onConfigLoad$lambda$14() {
        tracker.update();
    }

    public static final /* synthetic */ String access$getCurrentCategory$p() {
        return currentCategory;
    }

    public static final /* synthetic */ void access$setCurrentCategory$p(String string2) {
        currentCategory = string2;
    }

    public static final /* synthetic */ SkyHanniTracker access$getTracker$p() {
        return tracker;
    }

    static {
        currentCategory = nameAll = "All";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003R.\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lat/hannibal2/skyhanni/features/fishing/tracker/SeaCreatureTracker$Data;", "Lat/hannibal2/skyhanni/utils/tracker/TrackerData;", "<init>", "()V", "", "reset", "", "", "", "amount", "Ljava/util/Map;", "getAmount", "()Ljava/util/Map;", "setAmount", "(Ljava/util/Map;)V", "1.8.9"})
    public static final class Data
    extends TrackerData {
        @Expose
        @NotNull
        private Map<String, Integer> amount = new LinkedHashMap();

        @Override
        public void reset() {
            this.amount.clear();
        }

        @NotNull
        public final Map<String, Integer> getAmount() {
            return this.amount;
        }

        public final void setAmount(@NotNull Map<String, Integer> map2) {
            Intrinsics.checkNotNullParameter(map2, "<set-?>");
            this.amount = map2;
        }
    }
}

