/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.fishing;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.data.jsonobjects.repo.SeaCreatureInfo;
import at.hannibal2.skyhanni.data.jsonobjects.repo.SeaCreatureJson;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.data.repo.RepoManager;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.SeaCreatureFishEvent;
import at.hannibal2.skyhanni.features.fishing.SeaCreature;
import at.hannibal2.skyhanni.utils.LorenzRarity;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0012\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R \u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e0\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R.\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e0\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0016\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR4\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001d0\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u0016\u001a\u0004\b\u001f\u0010\u001a\"\u0004\b \u0010\u001cR\u0014\u0010\"\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u001b\u0010)\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u001b\u0010,\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010&\u001a\u0004\b+\u0010(\u00a8\u0006-"}, d2={"Lat/hannibal2/skyhanni/features/fishing/SeaCreatureManager;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "event", "", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "", "message", "Lat/hannibal2/skyhanni/features/fishing/SeaCreature;", "getSeaCreatureFromMessage", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/features/fishing/SeaCreature;", "", "doubleHook", "Z", "", "seaCreatureMap", "Ljava/util/Map;", "", "allFishingMobs", "getAllFishingMobs", "()Ljava/util/Map;", "setAllFishingMobs", "(Ljava/util/Map;)V", "", "allVariants", "getAllVariants", "setAllVariants", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "doubleHookPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getDoubleHookPattern", "()Ljava/util/regex/Pattern;", "doubleHookPattern", "thunderBottleChargedPattern$delegate", "getThunderBottleChargedPattern", "thunderBottleChargedPattern", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nSeaCreatureManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeaCreatureManager.kt\nat/hannibal2/skyhanni/features/fishing/SeaCreatureManager\n+ 2 RepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/RepositoryReloadEvent\n*L\n1#1,95:1\n12#2,7:96\n*S KotlinDebug\n*F\n+ 1 SeaCreatureManager.kt\nat/hannibal2/skyhanni/features/fishing/SeaCreatureManager\n*L\n65#1:96,7\n*E\n"})
public final class SeaCreatureManager {
    @NotNull
    public static final SeaCreatureManager INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    private static boolean doubleHook;
    @NotNull
    private static final Map<String, SeaCreature> seaCreatureMap;
    @NotNull
    private static Map<String, SeaCreature> allFishingMobs;
    @NotNull
    private static Map<String, ? extends List<String>> allVariants;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern doubleHookPattern$delegate;
    @NotNull
    private static final RepoPattern thunderBottleChargedPattern$delegate;

    private SeaCreatureManager() {
    }

    @NotNull
    public final Map<String, SeaCreature> getAllFishingMobs() {
        return allFishingMobs;
    }

    public final void setAllFishingMobs(@NotNull Map<String, SeaCreature> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        allFishingMobs = map2;
    }

    @NotNull
    public final Map<String, List<String>> getAllVariants() {
        return allVariants;
    }

    public final void setAllVariants(@NotNull Map<String, ? extends List<String>> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        allVariants = map2;
    }

    private final Pattern getDoubleHookPattern() {
        return (Pattern)doubleHookPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getThunderBottleChargedPattern() {
        return (Pattern)thunderBottleChargedPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        if (RegexUtils.INSTANCE.matches(this.getDoubleHookPattern(), event.getMessage())) {
            if (SkyHanniMod.feature.fishing.compactDoubleHook) {
                event.setBlockedReason("double_hook");
            }
            doubleHook = true;
        } else if (!doubleHook || !RegexUtils.INSTANCE.matches(this.getThunderBottleChargedPattern(), event.getMessage())) {
            SeaCreature seaCreature = this.getSeaCreatureFromMessage(event.getMessage());
            if (seaCreature != null) {
                new SeaCreatureFishEvent(seaCreature, event, doubleHook).postAndCatch();
            }
            doubleHook = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        Map map2;
        void constant$iv;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        seaCreatureMap.clear();
        allFishingMobs = MapsKt.emptyMap();
        int counter = 0;
        String string2 = "SeaCreatures";
        Type type$iv = SeaCreatureJson.Companion.getTYPE();
        Gson gson$iv = event.getGson();
        boolean $i$f$getConstant = false;
        try {
            RepoManager.Companion.setLastConstant((String)constant$iv);
            if (!event.getRepoLocation().exists()) {
                throw new RepoError("Repo folder does not exist!");
            }
            map2 = RepoUtils.INSTANCE.getConstant(event.getRepoLocation(), (String)constant$iv, gson$iv, Map.class, type$iv);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + (String)constant$iv + '\'', e$iv);
        }
        Map data2 = map2;
        Map allFishingMobs = new LinkedHashMap();
        Map variants = new LinkedHashMap();
        for (Map.Entry entry : data2.entrySet()) {
            String variantName = (String)entry.getKey();
            SeaCreatureJson variant = (SeaCreatureJson)entry.getValue();
            String chatColor = variant.getChatColor();
            List variantFishes = new ArrayList();
            variants.put(variantName, variantFishes);
            for (Map.Entry<String, SeaCreatureInfo> entry2 : variant.getSeaCreatures().entrySet()) {
                String name2 = entry2.getKey();
                SeaCreatureInfo seaCreature = entry2.getValue();
                String chatMessage = seaCreature.getChatMessage();
                int fishingExperience = seaCreature.getFishingExperience();
                LorenzRarity rarity = seaCreature.getRarity();
                boolean rare = seaCreature.getRare();
                SeaCreature creature = new SeaCreature(name2, fishingExperience, chatColor, rare, rarity);
                seaCreatureMap.put(chatMessage, creature);
                allFishingMobs.put(name2, creature);
                variantFishes.add(name2);
                ++counter;
            }
        }
        SeaCreatureManager.allFishingMobs = allFishingMobs;
        allVariants = variants;
    }

    private final SeaCreature getSeaCreatureFromMessage(String message) {
        return seaCreatureMap.getOrDefault(message, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(SeaCreatureManager.class, "doubleHookPattern", "getDoubleHookPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(SeaCreatureManager.class, "thunderBottleChargedPattern", "getThunderBottleChargedPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new SeaCreatureManager();
        seaCreatureMap = new LinkedHashMap();
        allFishingMobs = MapsKt.emptyMap();
        allVariants = MapsKt.emptyMap();
        patternGroup = RepoPattern.Companion.group("fishing.seacreature");
        doubleHookPattern$delegate = patternGroup.pattern("doublehook", "\u00a7eIt's a \u00a7r\u00a7aDouble Hook\u00a7r\u00a7e!(?: Woot woot!)?");
        thunderBottleChargedPattern$delegate = patternGroup.pattern("thundercharged", "\u00a7e> Your bottle of thunder has fully charged!");
    }
}

