/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.fishing;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.combat.damageindicator.DamageIndicatorConfig;
import at.hannibal2.skyhanni.config.features.fishing.RareCatchesConfig;
import at.hannibal2.skyhanni.data.mob.Mob;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.MobEvent;
import at.hannibal2.skyhanni.events.RenderEntityOutlineEvent;
import at.hannibal2.skyhanni.events.SeaCreatureFishEvent;
import at.hannibal2.skyhanni.features.combat.damageindicator.BossType;
import at.hannibal2.skyhanni.features.dungeon.DungeonAPI;
import at.hannibal2.skyhanni.features.fishing.SeaCreature;
import at.hannibal2.skyhanni.features.fishing.SeaCreatureManager;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.MobUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.TimeLimitedSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001f\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001c\u0010#\u001a\n \u001c*\u0004\u0018\u00010 0 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0016\u0010%\u001a\u00020$8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020(0'8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020+0'8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010*R1\u00102\u001a\u001f\u0012\u0013\u0012\u00110.\u00a2\u0006\f\b/\u0012\b\b0\u0012\u0004\b\b(1\u0012\u0006\u0012\u0004\u0018\u00010+0-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103\u00a8\u00064"}, d2={"Lat/hannibal2/skyhanni/features/fishing/SeaCreatureFeatures;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/MobEvent$Spawn$SkyblockMob;", "event", "", "onMobSpawn", "(Lat/hannibal2/skyhanni/events/MobEvent$Spawn$SkyblockMob;)V", "Lat/hannibal2/skyhanni/events/MobEvent$DeSpawn$SkyblockMob;", "onMobDeSpawn", "(Lat/hannibal2/skyhanni/events/MobEvent$DeSpawn$SkyblockMob;)V", "Lat/hannibal2/skyhanni/events/SeaCreatureFishEvent;", "onSeaCreatureFish", "(Lat/hannibal2/skyhanni/events/SeaCreatureFishEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/RenderEntityOutlineEvent;", "onRenderEntityOutlines", "(Lat/hannibal2/skyhanni/events/RenderEntityOutlineEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/fishing/RareCatchesConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/fishing/RareCatchesConfig;", "config", "Lat/hannibal2/skyhanni/config/features/combat/damageindicator/DamageIndicatorConfig;", "getDamageIndicatorConfig", "()Lat/hannibal2/skyhanni/config/features/combat/damageindicator/DamageIndicatorConfig;", "damageIndicatorConfig", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastRareCatch", "J", "Lat/hannibal2/skyhanni/utils/TimeLimitedSet;", "Lat/hannibal2/skyhanni/data/mob/Mob;", "rareSeaCreatures", "Lat/hannibal2/skyhanni/utils/TimeLimitedSet;", "", "entityIds", "Lkotlin/Function1;", "Lnet/minecraft/entity/Entity;", "Lkotlin/ParameterName;", "name", "entity", "getEntityOutlineColor", "Lkotlin/jvm/functions/Function1;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nSeaCreatureFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeaCreatureFeatures.kt\nat/hannibal2/skyhanni/features/fishing/SeaCreatureFeatures\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n774#2:119\n865#2,2:120\n1755#2,3:122\n*S KotlinDebug\n*F\n+ 1 SeaCreatureFeatures.kt\nat/hannibal2/skyhanni/features/fishing/SeaCreatureFeatures\n*L\n54#1:119\n54#1:120,2\n55#1:122,3\n*E\n"})
public final class SeaCreatureFeatures {
    @NotNull
    public static final SeaCreatureFeatures INSTANCE = new SeaCreatureFeatures();
    private static long lastRareCatch = SimpleTimeMark.Companion.farPast();
    @NotNull
    private static TimeLimitedSet<Mob> rareSeaCreatures = new TimeLimitedSet(DurationKt.toDuration(6, DurationUnit.MINUTES), null, 2, null);
    @NotNull
    private static TimeLimitedSet<Integer> entityIds = new TimeLimitedSet(DurationKt.toDuration(6, DurationUnit.MINUTES), null, 2, null);
    @NotNull
    private static final Function1<Entity, Integer> getEntityOutlineColor = SeaCreatureFeatures::getEntityOutlineColor$lambda$3;

    private SeaCreatureFeatures() {
    }

    private final RareCatchesConfig getConfig() {
        return SkyHanniMod.feature.fishing.rareCatches;
    }

    private final DamageIndicatorConfig getDamageIndicatorConfig() {
        return SkyHanniMod.feature.combat.damageIndicator;
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onMobSpawn(@NotNull MobEvent.Spawn.SkyblockMob event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        Mob mob = event.getMob();
        SeaCreature seaCreature = SeaCreatureManager.INSTANCE.getAllFishingMobs().get(mob.getName());
        if (seaCreature == null) {
            return;
        }
        SeaCreature creature = seaCreature;
        if (!creature.getRare()) {
            return;
        }
        EntityLivingBase entity = mob.getBaseEntity();
        boolean shouldNotify = !entityIds.contains(entity.func_145782_y());
        entityIds.addIfAbsent(entity.func_145782_y());
        rareSeaCreatures.add(mob);
        boolean shouldHighlight = this.getConfig().highlight;
        if (this.getDamageIndicatorConfig().enabled && this.getDamageIndicatorConfig().bossesToShow.contains(DamageIndicatorConfig.BossCategory.SEA_CREATURES)) {
            boolean bl;
            block14: {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = BossType.getEntries();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    BossType it = (BossType)((Object)element$iv$iv);
                    boolean bl2 = false;
                    if (!(it.getBossTypeToggle() == DamageIndicatorConfig.BossCategory.SEA_CREATURES)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List seaCreaturesBosses = (List)destination$iv$iv;
                Iterable $this$any$iv = seaCreaturesBosses;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        BossType it = (BossType)((Object)element$iv);
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(StringUtils.removeColor$default(StringUtils.INSTANCE, it.getFullName(), false, 1, null), mob.getName())) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (bl) {
                shouldHighlight = false;
            }
        }
        if (shouldHighlight) {
            mob.highlight(LorenzColor.GREEN.toColor());
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastRareCatch), DurationKt.toDuration(1, DurationUnit.SECONDS)) < 0) {
            return;
        }
        if (Intrinsics.areEqual(mob.getName(), "Water Hydra") && entity.func_110143_aJ() == (float)LorenzUtils.INSTANCE.getBaseMaxHealth(entity) / (float)2) {
            return;
        }
        if (this.getConfig().alertOtherCatches && shouldNotify) {
            String text = this.getConfig().creatureName ? creature.getDisplayName() + " NEARBY!" : creature.getRarity().getChatColorCode() + "RARE SEA CREATURE!";
            LorenzUtils.INSTANCE.sendTitle-dWUq8MI(text, DurationKt.toDuration(1.5, DurationUnit.SECONDS), 3.6, 7.0f);
            if (this.getConfig().playSound) {
                SoundUtils.INSTANCE.playBeepSound();
            }
        }
    }

    @SubscribeEvent
    public final void onMobDeSpawn(@NotNull MobEvent.DeSpawn.SkyblockMob event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        rareSeaCreatures.remove(event.getMob());
    }

    @SubscribeEvent
    public final void onSeaCreatureFish(@NotNull SeaCreatureFishEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        if (!this.getConfig().alertOwnCatches) {
            return;
        }
        if (event.getSeaCreature().getRare()) {
            String text = this.getConfig().creatureName ? event.getSeaCreature().getDisplayName() + '!' : event.getSeaCreature().getRarity().getChatColorCode() + "RARE CATCH!";
            LorenzUtils.INSTANCE.sendTitle-dWUq8MI(text, DurationKt.toDuration(3, DurationUnit.SECONDS), 2.8, 7.0f);
            if (this.getConfig().playSound) {
                SoundUtils.INSTANCE.playBeepSound();
            }
            lastRareCatch = SimpleTimeMark.Companion.now-uFjCsEo();
        }
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        rareSeaCreatures.clear();
        entityIds.clear();
    }

    @SubscribeEvent
    public final void onRenderEntityOutlines(@NotNull RenderEntityOutlineEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (this.isEnabled() && this.getConfig().highlight && event.getType() == RenderEntityOutlineEvent.Type.XRAY) {
            event.queueEntitiesToOutline(getEntityOutlineColor);
        }
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 2, "fishing.rareSeaCreatureHighlight", "fishing.rareCatches.highlight", null, 8, null);
    }

    private final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && !DungeonAPI.INSTANCE.inDungeon() && !LorenzUtils.INSTANCE.getInKuudraFight();
    }

    private static final Integer getEntityOutlineColor$lambda$3(Entity entity) {
        Integer n;
        Intrinsics.checkNotNullParameter(entity, "entity");
        Object object = entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
        if (object != null && (object = MobUtils.INSTANCE.getMob((EntityLivingBase)object)) != null) {
            Object mob = object;
            boolean bl = false;
            n = rareSeaCreatures.contains((Mob)mob) && LocationUtils.INSTANCE.distanceToPlayer(entity) < 30.0 ? Integer.valueOf(LorenzColor.GREEN.toColor().getRGB()) : null;
        } else {
            n = null;
        }
        return n;
    }
}

