/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.event.hoppity;

import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.jsonobjects.other.HypixelApiEasterEvent;
import at.hannibal2.skyhanni.data.jsonobjects.other.HypixelApiEvents;
import at.hannibal2.skyhanni.data.jsonobjects.other.HypixelApiPlayer;
import at.hannibal2.skyhanni.data.jsonobjects.other.HypixelApiRabbits;
import at.hannibal2.skyhanni.data.jsonobjects.repo.HoppityEggLocationsJson;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.data.repo.RepoManager;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.events.NeuProfileDataLoadedEvent;
import at.hannibal2.skyhanni.events.ProfileJoinEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityEggsManager;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.ChocolateFactoryAPI;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0003J\u001f\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ)\u0010\u001f\u001a\u00020\u00102\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u001dH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\r\u0010!\u001a\u00020\u0010\u00a2\u0006\u0004\b!\u0010\u0003J\u0017\u0010#\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\"H\u0007\u00a2\u0006\u0004\b#\u0010$RH\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070&0%2\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070&0%8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010)\"\u0004\b*\u0010 R:\u0010-\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u00070\u001d0\u001d8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010.\u001a\u0004\b/\u0010)\"\u0004\b0\u0010 R\u0017\u00103\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0017\u00105\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b4\u00102R\u0016\u00106\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0016\u00108\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00107R(\u00109\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010.\u00a8\u0006:"}, d2={"Lat/hannibal2/skyhanni/features/event/hoppity/HoppityEggLocations;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/data/IslandType;", "islandType", "", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "getEggsIn", "(Lat/hannibal2/skyhanni/data/IslandType;)Ljava/util/Set;", "location", "", "hasCollectedEgg", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Z", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "event", "", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "saveNearestEgg", "island", "saveEggLocation", "(Lat/hannibal2/skyhanni/data/IslandType;Lat/hannibal2/skyhanni/utils/LorenzVec;)V", "Lat/hannibal2/skyhanni/events/ProfileJoinEvent;", "onProfileJoin", "(Lat/hannibal2/skyhanni/events/ProfileJoinEvent;)V", "Lat/hannibal2/skyhanni/events/NeuProfileDataLoadedEvent;", "onNeuProfileDataLoaded", "(Lat/hannibal2/skyhanni/events/NeuProfileDataLoadedEvent;)V", "", "locations", "loadApiCollectedEggs", "(Ljava/util/Map;)V", "toggleDebug", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "", "", "value", "getCollectedEggStorage", "()Ljava/util/Map;", "setCollectedEggStorage", "collectedEggStorage", "", "apiEggLocations", "Ljava/util/Map;", "getApiEggLocations", "setApiEggLocations", "getIslandLocations", "()Ljava/util/Set;", "islandLocations", "getIslandCollectedLocations", "islandCollectedLocations", "loadedNeuThisProfile", "Z", "showEggLocationsDebug", "legacyEggLocations", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nHoppityEggLocations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HoppityEggLocations.kt\nat/hannibal2/skyhanni/features/event/hoppity/HoppityEggLocations\n+ 2 RepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/RepositoryReloadEvent\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n12#2,7:153\n462#3:160\n412#3:161\n381#3,7:180\n1246#4,4:162\n2341#4,14:166\n1611#4,9:187\n1863#4:196\n1864#4:198\n1620#4:199\n1863#4,2:201\n1#5:197\n1#5:200\n*S KotlinDebug\n*F\n+ 1 HoppityEggLocations.kt\nat/hannibal2/skyhanni/features/event/hoppity/HoppityEggLocations\n*L\n50#1:153,7\n52#1:160\n52#1:161\n71#1:180,7\n52#1:162,4\n56#1:166,14\n94#1:187,9\n94#1:196\n94#1:198\n94#1:199\n116#1:201,2\n94#1:197\n*E\n"})
public final class HoppityEggLocations {
    @NotNull
    public static final HoppityEggLocations INSTANCE = new HoppityEggLocations();
    @NotNull
    private static Map<IslandType, ? extends Map<String, LorenzVec>> apiEggLocations = MapsKt.emptyMap();
    private static boolean loadedNeuThisProfile;
    private static boolean showEggLocationsDebug;
    @NotNull
    private static Map<IslandType, ? extends Set<LorenzVec>> legacyEggLocations;

    private HoppityEggLocations() {
    }

    private final Map<IslandType, Set<LorenzVec>> getCollectedEggStorage() {
        Object object = ChocolateFactoryAPI.INSTANCE.getProfileStorage();
        if (object == null || (object = ((ProfileSpecificStorage.ChocolateFactoryStorage)object).collectedEggLocations) == null) {
            object = new LinkedHashMap();
        }
        return object;
    }

    private final void setCollectedEggStorage(Map<IslandType, Set<LorenzVec>> value) {
        block0: {
            if (ChocolateFactoryAPI.INSTANCE.getProfileStorage() == null) break block0;
            ChocolateFactoryAPI.INSTANCE.getProfileStorage().collectedEggLocations = value;
        }
    }

    @NotNull
    public final Map<IslandType, Map<String, LorenzVec>> getApiEggLocations() {
        return apiEggLocations;
    }

    public final void setApiEggLocations(@NotNull Map<IslandType, ? extends Map<String, LorenzVec>> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        apiEggLocations = map2;
    }

    @NotNull
    public final Set<LorenzVec> getIslandLocations() {
        Object object = apiEggLocations.get((Object)LorenzUtils.INSTANCE.getSkyBlockIsland());
        if (object == null || (object = object.values()) == null || (object = CollectionsKt.toSet((Iterable)object)) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    @NotNull
    public final Set<LorenzVec> getIslandCollectedLocations() {
        Set<LorenzVec> set = this.getCollectedEggStorage().get((Object)LorenzUtils.INSTANCE.getSkyBlockIsland());
        if (set == null || (set = CollectionsKt.toSet((Iterable)set)) == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @NotNull
    public final Set<LorenzVec> getEggsIn(@NotNull IslandType islandType) {
        Intrinsics.checkNotNullParameter((Object)islandType, "islandType");
        Set<LorenzVec> set = this.getCollectedEggStorage().get((Object)islandType);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    public final boolean hasCollectedEgg(@NotNull LorenzVec location) {
        Intrinsics.checkNotNullParameter(location, "location");
        return this.getIslandCollectedLocations().contains(location);
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        void $this$mapValuesTo$iv$iv;
        HoppityEggLocationsJson hoppityEggLocationsJson;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String constant$iv = "HoppityEggLocations";
        Type type$iv = null;
        Object gson$iv = event.getGson();
        boolean $i$f$getConstant = false;
        try {
            RepoManager.Companion.setLastConstant(constant$iv);
            if (!event.getRepoLocation().exists()) {
                throw new RepoError("Repo folder does not exist!");
            }
            hoppityEggLocationsJson = RepoUtils.INSTANCE.getConstant(event.getRepoLocation(), constant$iv, (Gson)gson$iv, HoppityEggLocationsJson.class, type$iv);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv);
        }
        HoppityEggLocationsJson data2 = hoppityEggLocationsJson;
        apiEggLocations = data2.getApiEggLocations();
        Map<IslandType, List<LorenzVec>> $this$mapValues$iv = data2.getEggLocations();
        boolean $i$f$mapValues = false;
        gson$iv = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Set set = CollectionsKt.toSet((Iterable)it.getValue());
            map3.put(k, set);
        }
        legacyEggLocations = destination$iv$iv;
    }

    public final void saveNearestEgg() {
        Object v0;
        Iterable $this$minByOrNull$iv = this.getIslandLocations();
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                LorenzVec it = (LorenzVec)minElem$iv;
                boolean bl = false;
                double minValue$iv = LocationUtils.INSTANCE.distanceSqToPlayer(it);
                do {
                    Object e$iv = iterator$iv.next();
                    LorenzVec it2 = (LorenzVec)e$iv;
                    $i$a$-minByOrNull-HoppityEggLocations$saveNearestEgg$location$1 = false;
                    double v$iv = LocationUtils.INSTANCE.distanceSqToPlayer(it2);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        LorenzVec lorenzVec = v0;
        if (lorenzVec == null) {
            return;
        }
        LorenzVec location = lorenzVec;
        if (LocationUtils.INSTANCE.distanceSqToPlayer(location) > 100.0) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("island", LorenzUtils.INSTANCE.getSkyBlockIsland()), TuplesKt.to("distanceSqToPlayer", LocationUtils.INSTANCE.distanceSqToPlayer(location)), TuplesKt.to("playerLocation", LocationUtils.INSTANCE.playerLocation()), TuplesKt.to("closestKnownEgg", location)};
            ErrorManager.INSTANCE.skyHanniError("Player far from any known egg location!", pairArray);
            throw new KotlinNothingValueException();
        }
        this.saveEggLocation(LorenzUtils.INSTANCE.getSkyBlockIsland(), location);
    }

    private final void saveEggLocation(IslandType island, LorenzVec location) {
        Set set;
        Map<IslandType, Set<LorenzVec>> $this$getOrPut$iv = this.getCollectedEggStorage();
        boolean $i$f$getOrPut = false;
        Set value$iv = $this$getOrPut$iv.get((Object)island);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(island, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        Set locations = set;
        ((Collection)locations).add(location);
    }

    @SubscribeEvent
    public final void onProfileJoin(@NotNull ProfileJoinEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        loadedNeuThisProfile = false;
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onNeuProfileDataLoaded(@NotNull NeuProfileDataLoadedEvent event) {
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (loadedNeuThisProfile || !HoppityEggsManager.INSTANCE.getConfig().loadFromNeuPv) {
            return;
        }
        Object object = event.getCurrentPlayerData();
        if (object == null || (object = ((HypixelApiPlayer)object).getEvents()) == null || (object = ((HypixelApiEvents)object).getEaster()) == null || (object = ((HypixelApiEasterEvent)object).getRabbits()) == null || (object = ((HypixelApiRabbits)object).getCollectedLocations()) == null) {
            return;
        }
        Map<String, List<String>> rawLocations = object;
        loadedNeuThisProfile = true;
        List apiCollectedLocations = CollectionsKt.flatten((Iterable)rawLocations.values());
        Map collectedEggsApiData = new LinkedHashMap();
        for (Map.Entry<IslandType, ? extends Map<String, LorenzVec>> object3 : apiEggLocations.entrySet()) {
            void $this$mapNotNullTo$iv$iv;
            IslandType island = object3.getKey();
            Map<String, LorenzVec> locationNameToCoords = object3.getValue();
            $this$mapNotNull$iv = apiCollectedLocations;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                LorenzVec it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (locationNameToCoords.get(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List coords = (List)destination$iv$iv;
            collectedEggsApiData.put(island, CollectionsKt.toMutableSet(coords));
        }
        Iterable iterable = this.getCollectedEggStorage().values();
        int island = 0;
        for (Object t : iterable) {
            void it;
            $this$mapNotNull$iv = (Set)t;
            int n = island;
            boolean bl = false;
            int n2 = it.size();
            island = n + n2;
        }
        int storedEggLocationCount = island;
        int n = apiCollectedLocations.size() - storedEggLocationCount;
        if (n <= 0) {
            return;
        }
        String locationStr = StringUtils.pluralize$default(StringUtils.INSTANCE, n, "location", "locations", false, 8, null);
        ChatUtils.clickableChat-gdl2klw$default(ChatUtils.INSTANCE, "Click here to load " + n + " more collected egg " + locationStr + " from NEU PV!", () -> HoppityEggLocations.onNeuProfileDataLoaded$lambda$5(collectedEggsApiData), null, 0L, false, null, true, 60, null);
    }

    private final void loadApiCollectedEggs(Map<IslandType, ? extends Set<LorenzVec>> locations) {
        for (Map.Entry<IslandType, ? extends Set<LorenzVec>> entry : locations.entrySet()) {
            IslandType island = entry.getKey();
            Set<LorenzVec> coordinates = entry.getValue();
            Iterable $this$forEach$iv = coordinates;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LorenzVec it = (LorenzVec)element$iv;
                boolean bl = false;
                INSTANCE.saveEggLocation(island, it);
            }
        }
    }

    public final void toggleDebug() {
        showEggLocationsDebug = !showEggLocationsDebug;
        String enabledDisabled = showEggLocationsDebug ? "\u00a7aEnabled" : "\u00a7cDisabled";
        ChatUtils.chat$default(ChatUtils.INSTANCE, enabledDisabled + " hoppity egg location debug viewer.", false, null, 6, null);
    }

    @SubscribeEvent
    public final void onRenderWorld(@NotNull LorenzRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock() || !showEggLocationsDebug) {
            return;
        }
        Set<LorenzVec> set = legacyEggLocations.get((Object)LorenzUtils.INSTANCE.getSkyBlockIsland());
        if (set == null) {
            return;
        }
        Set<LorenzVec> legacyLocations = set;
        Map<String, LorenzVec> map2 = apiEggLocations.get((Object)LorenzUtils.INSTANCE.getSkyBlockIsland());
        if (map2 == null) {
            return;
        }
        Map<String, LorenzVec> apiLocations = map2;
        Set<LorenzVec> collectedLocations = this.getIslandCollectedLocations();
        for (LorenzVec location : legacyLocations) {
            Object v2;
            block5: {
                Iterable iterable = apiLocations.entrySet();
                for (Object t : iterable) {
                    Map.Entry it = (Map.Entry)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getValue(), location)) continue;
                    v2 = t;
                    break block5;
                }
                v2 = null;
            }
            Map.Entry entry = v2;
            String name2 = entry != null ? (String)entry.getKey() : null;
            boolean isCollected = collectedLocations.contains(location);
            LorenzColor color = isCollected ? LorenzColor.GREEN : LorenzColor.RED;
            String nameColorCode = (name2 != null ? LorenzColor.GREEN : LorenzColor.RED).getChatColor();
            RenderUtils.INSTANCE.drawColor(event, location, color, false, 0.5f);
            RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, LorenzVec.add$default(location, 0.0, 0.5, 0.0, 5, null), nameColorCode + name2, 1.2, 0.0f, 0.0, 0.0, false, false, null, 504, null);
            if (!(LocationUtils.INSTANCE.distanceSqToPlayer(location) < 100.0)) continue;
            RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, LorenzVec.add$default(location, 0.0, 0.5, 0.0, 5, null), LorenzVec.toCleanString$default(location, null, 1, null), 1.0, 12.0f, 0.0, 0.0, false, false, null, 496, null);
        }
    }

    private static final Unit onNeuProfileDataLoaded$lambda$5(Map $collectedEggsApiData) {
        Intrinsics.checkNotNullParameter($collectedEggsApiData, "$collectedEggsApiData");
        INSTANCE.loadApiCollectedEggs($collectedEggsApiData);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Updated Hoppity egg location data!", false, null, 6, null);
        return Unit.INSTANCE;
    }

    static {
        legacyEggLocations = MapsKt.emptyMap();
    }
}

