/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.event.diana;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.event.diana.DianaConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.events.BlockClickEvent;
import at.hannibal2.skyhanni.events.BurrowDetectEvent;
import at.hannibal2.skyhanni.events.BurrowDugEvent;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.minecraft.packet.PacketReceivedEvent;
import at.hannibal2.skyhanni.features.event.diana.BurrowAPI;
import at.hannibal2.skyhanni.features.event.diana.BurrowType;
import at.hannibal2.skyhanni.features.event.diana.DianaAPI;
import at.hannibal2.skyhanni.utils.BlockUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.TimeLimitedSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2APacketParticles;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002-.B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000f\u0010\u0003J\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J!\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00132\b\b\u0002\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u001c\u0010\"\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00130#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R \u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020'0&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0018\u0010*\u001a\u0004\u0018\u00010\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0018\u0010,\u001a\u0004\u0018\u00010\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010+\u00a8\u0006/"}, d2={"Lat/hannibal2/skyhanni/features/event/diana/GriffinBurrowParticleFinder;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "event", "", "onDebugDataCollect", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/packet/PacketReceivedEvent;", "onPacketReceive", "(Lat/hannibal2/skyhanni/events/minecraft/packet/PacketReceivedEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "reset", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "location", "", "ignoreFound", "tryDig", "(Lat/hannibal2/skyhanni/utils/LorenzVec;Z)Z", "Lat/hannibal2/skyhanni/events/BlockClickEvent;", "onBlockClick", "(Lat/hannibal2/skyhanni/events/BlockClickEvent;)V", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/event/diana/DianaConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/event/diana/DianaConfig;", "config", "Lat/hannibal2/skyhanni/utils/TimeLimitedSet;", "recentlyDugParticleBurrows", "Lat/hannibal2/skyhanni/utils/TimeLimitedSet;", "", "Lat/hannibal2/skyhanni/features/event/diana/GriffinBurrowParticleFinder$Burrow;", "burrows", "Ljava/util/Map;", "lastDugParticleBurrow", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "fakeBurrow", "ParticleType", "Burrow", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nGriffinBurrowParticleFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GriffinBurrowParticleFinder.kt\nat/hannibal2/skyhanni/features/event/diana/GriffinBurrowParticleFinder\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,214:1\n381#2,7:215\n*S KotlinDebug\n*F\n+ 1 GriffinBurrowParticleFinder.kt\nat/hannibal2/skyhanni/features/event/diana/GriffinBurrowParticleFinder\n*L\n74#1:215,7\n*E\n"})
public final class GriffinBurrowParticleFinder {
    @NotNull
    public static final GriffinBurrowParticleFinder INSTANCE = new GriffinBurrowParticleFinder();
    @NotNull
    private static final TimeLimitedSet<LorenzVec> recentlyDugParticleBurrows = new TimeLimitedSet(DurationKt.toDuration(1, DurationUnit.MINUTES), null, 2, null);
    @NotNull
    private static final Map<LorenzVec, Burrow> burrows = new LinkedHashMap();
    @Nullable
    private static LorenzVec lastDugParticleBurrow;
    @Nullable
    private static LorenzVec fakeBurrow;

    private GriffinBurrowParticleFinder() {
    }

    private final DianaConfig getConfig() {
        return SkyHanniMod.feature.event.diana;
    }

    @SubscribeEvent
    public final void onDebugDataCollect(@NotNull DebugDataCollectEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        event.title("Griffin Burrow Particle Finder");
        if (!DianaAPI.INSTANCE.isDoingDiana()) {
            event.addIrrelevant("not doing diana");
            return;
        }
        event.addData(GriffinBurrowParticleFinder::onDebugDataCollect$lambda$0);
    }

    @HandleEvent(onlyOnIsland=IslandType.HUB, priority=1, receiveCancelled=true)
    public final void onPacketReceive(@NotNull PacketReceivedEvent event) {
        ParticleType particleType;
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!this.getConfig().burrowsSoopyGuess) {
            return;
        }
        Packet<?> packet = event.getPacket();
        if (packet instanceof S2APacketParticles && (particleType = ParticleType.Companion.getParticleType((S2APacketParticles)packet)) != null) {
            Burrow burrow;
            BlockPos blockPos = LorenzVecKt.toLorenzVec((S2APacketParticles)packet).toBlockPos().func_177977_b();
            Intrinsics.checkNotNullExpressionValue(blockPos, "down(...)");
            LorenzVec location = LorenzVecKt.toLorenzVec(blockPos);
            if (recentlyDugParticleBurrows.contains(location)) {
                return;
            }
            Map<LorenzVec, Burrow> $this$getOrPut$iv = burrows;
            boolean $i$f$getOrPut = false;
            Burrow value$iv = $this$getOrPut$iv.get(location);
            if (value$iv == null) {
                boolean bl = false;
                Burrow answer$iv = new Burrow(location, false, false, 0, false, 30, null);
                $this$getOrPut$iv.put(location, answer$iv);
                burrow = answer$iv;
            } else {
                burrow = value$iv;
            }
            Burrow burrow2 = burrow;
            ParticleType particleType2 = particleType;
            switch (WhenMappings.$EnumSwitchMapping$0[particleType2.ordinal()]) {
                case 1: {
                    burrow2.setHasFootstep(true);
                    break;
                }
                case 2: {
                    burrow2.setHasEnchant(true);
                    break;
                }
                case 3: {
                    burrow2.setType(0);
                    break;
                }
                case 4: {
                    burrow2.setType(1);
                    break;
                }
                case 5: {
                    burrow2.setType(2);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if (burrow2.getHasEnchant() && burrow2.getHasFootstep() && burrow2.getType() != -1 && !burrow2.getFound()) {
                new BurrowDetectEvent(burrow2.getLocation(), burrow2.getType()).postAndCatch();
                burrow2.setFound(true);
            }
        }
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        this.reset();
    }

    public final void reset() {
        burrows.clear();
        recentlyDugParticleBurrows.clear();
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!this.getConfig().burrowsSoopyGuess) {
            return;
        }
        String message = event.getMessage();
        if (StringsKt.startsWith$default(message, "\u00a7eYou dug out a Griffin Burrow!", false, 2, null) || Intrinsics.areEqual(message, "\u00a7eYou finished the Griffin burrow chain! \u00a7r\u00a77(4/4)")) {
            BurrowAPI.INSTANCE.setLastBurrowRelatedChatMessage-gJLAdNM(SimpleTimeMark.Companion.now-uFjCsEo());
            LorenzVec burrow = lastDugParticleBurrow;
            if (burrow != null && !GriffinBurrowParticleFinder.tryDig$default(this, burrow, false, 2, null)) {
                fakeBurrow = burrow;
            }
        }
        if (Intrinsics.areEqual(message, "\u00a7cDefeat all the burrow defenders in order to dig it!")) {
            BurrowAPI.INSTANCE.setLastBurrowRelatedChatMessage-gJLAdNM(SimpleTimeMark.Companion.now-uFjCsEo());
        }
    }

    private final boolean tryDig(LorenzVec location, boolean ignoreFound) {
        Burrow burrow = burrows.get(location);
        if (burrow == null) {
            return false;
        }
        Burrow burrow2 = burrow;
        if (!burrow2.getFound() && !ignoreFound) {
            return false;
        }
        burrows.remove(location);
        recentlyDugParticleBurrows.add(location);
        lastDugParticleBurrow = null;
        new BurrowDugEvent(burrow2.getLocation()).postAndCatch();
        return true;
    }

    static /* synthetic */ boolean tryDig$default(GriffinBurrowParticleFinder griffinBurrowParticleFinder, LorenzVec lorenzVec, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return griffinBurrowParticleFinder.tryDig(lorenzVec, bl);
    }

    @SubscribeEvent
    public final void onBlockClick(@NotNull BlockClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!this.getConfig().burrowsSoopyGuess) {
            return;
        }
        LorenzVec location = event.getPosition();
        ItemStack itemStack2 = event.getItemInHand();
        if (!(itemStack2 != null ? DianaAPI.INSTANCE.isDianaSpade(itemStack2) : false) || BlockUtils.INSTANCE.getBlockAt(location) != Blocks.field_150349_c) {
            return;
        }
        if (Intrinsics.areEqual(location, fakeBurrow)) {
            fakeBurrow = null;
            this.tryDig(location, true);
            return;
        }
        if (burrows.containsKey(location)) {
            lastDugParticleBurrow = location;
            DelayedRun.INSTANCE.runDelayed-bouF650(DurationKt.toDuration(1, DurationUnit.SECONDS), () -> GriffinBurrowParticleFinder.onBlockClick$lambda$2(location));
        }
    }

    private final boolean isEnabled() {
        return DianaAPI.INSTANCE.isDoingDiana();
    }

    private static final Unit onDebugDataCollect$lambda$0(List $this$addData) {
        Intrinsics.checkNotNullParameter($this$addData, "$this$addData");
        $this$addData.add("burrows: " + burrows.size());
        for (Burrow burrow : burrows.values()) {
            LorenzVec location = burrow.getLocation();
            boolean found = burrow.getFound();
            $this$addData.add(LorenzVec.printWithAccuracy$default(location, 1, null, 2, null));
            $this$addData.add(" type: " + (Object)((Object)burrow.getType()));
            $this$addData.add(" found: " + found);
            $this$addData.add(" ");
        }
        return Unit.INSTANCE;
    }

    private static final Unit onBlockClick$lambda$2(LorenzVec $location) {
        Intrinsics.checkNotNullParameter($location, "$location");
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(BurrowAPI.INSTANCE.getLastBurrowRelatedChatMessage-uFjCsEo()), DurationKt.toDuration(2, DurationUnit.SECONDS)) > 0) {
            burrows.remove($location);
        }
        return Unit.INSTANCE;
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eR\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\"\u0010\u0006\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010\u0014\u001a\u0004\b\u0019\u0010\u0016\"\u0004\b\u001a\u0010\u0018R\"\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010\u001b\u001a\u0004\b\r\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\"\u0010\t\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010\u0014\u001a\u0004\b\u001f\u0010\u0016\"\u0004\b \u0010\u0018\u00a8\u0006!"}, d2={"Lat/hannibal2/skyhanni/features/event/diana/GriffinBurrowParticleFinder$Burrow;", "", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "location", "", "hasFootstep", "hasEnchant", "", "type", "found", "<init>", "(Lat/hannibal2/skyhanni/utils/LorenzVec;ZZIZ)V", "Lat/hannibal2/skyhanni/features/event/diana/BurrowType;", "getType", "()Lat/hannibal2/skyhanni/features/event/diana/BurrowType;", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "getLocation", "()Lat/hannibal2/skyhanni/utils/LorenzVec;", "setLocation", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)V", "Z", "getHasFootstep", "()Z", "setHasFootstep", "(Z)V", "getHasEnchant", "setHasEnchant", "I", "()I", "setType", "(I)V", "getFound", "setFound", "1.8.9"})
    public static final class Burrow {
        @NotNull
        private LorenzVec location;
        private boolean hasFootstep;
        private boolean hasEnchant;
        private int type;
        private boolean found;

        public Burrow(@NotNull LorenzVec location, boolean hasFootstep, boolean hasEnchant, int type2, boolean found) {
            Intrinsics.checkNotNullParameter(location, "location");
            this.location = location;
            this.hasFootstep = hasFootstep;
            this.hasEnchant = hasEnchant;
            this.type = type2;
            this.found = found;
        }

        public /* synthetic */ Burrow(LorenzVec lorenzVec, boolean bl, boolean bl2, int n, boolean bl3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                bl = false;
            }
            if ((n2 & 4) != 0) {
                bl2 = false;
            }
            if ((n2 & 8) != 0) {
                n = -1;
            }
            if ((n2 & 0x10) != 0) {
                bl3 = false;
            }
            this(lorenzVec, bl, bl2, n, bl3);
        }

        @NotNull
        public final LorenzVec getLocation() {
            return this.location;
        }

        public final void setLocation(@NotNull LorenzVec lorenzVec) {
            Intrinsics.checkNotNullParameter(lorenzVec, "<set-?>");
            this.location = lorenzVec;
        }

        public final boolean getHasFootstep() {
            return this.hasFootstep;
        }

        public final void setHasFootstep(boolean bl) {
            this.hasFootstep = bl;
        }

        public final boolean getHasEnchant() {
            return this.hasEnchant;
        }

        public final void setHasEnchant(boolean bl) {
            this.hasEnchant = bl;
        }

        public final int getType() {
            return this.type;
        }

        public final void setType(int n) {
            this.type = n;
        }

        public final boolean getFound() {
            return this.found;
        }

        public final void setFound(boolean bl) {
            this.found = bl;
        }

        @NotNull
        public final BurrowType getType() {
            BurrowType burrowType;
            switch (this.type) {
                case 0: {
                    burrowType = BurrowType.START;
                    break;
                }
                case 1: {
                    burrowType = BurrowType.MOB;
                    break;
                }
                case 2: {
                    burrowType = BurrowType.TREASURE;
                    break;
                }
                default: {
                    burrowType = BurrowType.UNKNOWN;
                }
            }
            return burrowType;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\r\b\u0082\u0081\u0002\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\fB\"\b\u0002\u0012\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR(\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u00a2\u0006\u0002\b\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\t\u001a\u0004\b\n\u0010\u000bj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lat/hannibal2/skyhanni/features/event/diana/GriffinBurrowParticleFinder$ParticleType;", "", "Lkotlin/Function1;", "Lnet/minecraft/network/play/server/S2APacketParticles;", "", "Lkotlin/ExtensionFunctionType;", "check", "<init>", "(Ljava/lang/String;ILkotlin/jvm/functions/Function1;)V", "Lkotlin/jvm/functions/Function1;", "getCheck", "()Lkotlin/jvm/functions/Function1;", "Companion", "EMPTY", "MOB", "TREASURE", "FOOTSTEP", "ENCHANT", "1.8.9"})
    private static final class ParticleType
    extends Enum<ParticleType> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final Function1<S2APacketParticles, Boolean> check;
        public static final /* enum */ ParticleType EMPTY;
        public static final /* enum */ ParticleType MOB;
        public static final /* enum */ ParticleType TREASURE;
        public static final /* enum */ ParticleType FOOTSTEP;
        public static final /* enum */ ParticleType ENCHANT;
        private static final /* synthetic */ ParticleType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ParticleType(Function1<? super S2APacketParticles, Boolean> check2) {
            this.check = check2;
        }

        @NotNull
        public final Function1<S2APacketParticles, Boolean> getCheck() {
            return this.check;
        }

        public static ParticleType[] values() {
            return (ParticleType[])$VALUES.clone();
        }

        public static ParticleType valueOf(String value) {
            return Enum.valueOf(ParticleType.class, value);
        }

        @NotNull
        public static EnumEntries<ParticleType> getEntries() {
            return $ENTRIES;
        }

        private static final boolean _init_$lambda$0(S2APacketParticles s2APacketParticles) {
            Intrinsics.checkNotNullParameter(s2APacketParticles, "<this>");
            return s2APacketParticles.func_179749_a() == EnumParticleTypes.CRIT_MAGIC && s2APacketParticles.func_149222_k() == 4 && s2APacketParticles.func_149227_j() == 0.01f && s2APacketParticles.func_149221_g() == 0.5f && s2APacketParticles.func_149224_h() == 0.1f && s2APacketParticles.func_149223_i() == 0.5f;
        }

        private static final boolean _init_$lambda$1(S2APacketParticles s2APacketParticles) {
            Intrinsics.checkNotNullParameter(s2APacketParticles, "<this>");
            return s2APacketParticles.func_179749_a() == EnumParticleTypes.CRIT && s2APacketParticles.func_149222_k() == 3 && s2APacketParticles.func_149227_j() == 0.01f && s2APacketParticles.func_149221_g() == 0.5f && s2APacketParticles.func_149224_h() == 0.1f && s2APacketParticles.func_149223_i() == 0.5f;
        }

        private static final boolean _init_$lambda$2(S2APacketParticles s2APacketParticles) {
            Intrinsics.checkNotNullParameter(s2APacketParticles, "<this>");
            return s2APacketParticles.func_179749_a() == EnumParticleTypes.DRIP_LAVA && s2APacketParticles.func_149222_k() == 2 && s2APacketParticles.func_149227_j() == 0.01f && s2APacketParticles.func_149221_g() == 0.35f && s2APacketParticles.func_149224_h() == 0.1f && s2APacketParticles.func_149223_i() == 0.35f;
        }

        private static final boolean _init_$lambda$3(S2APacketParticles s2APacketParticles) {
            Intrinsics.checkNotNullParameter(s2APacketParticles, "<this>");
            return s2APacketParticles.func_179749_a() == EnumParticleTypes.FOOTSTEP && s2APacketParticles.func_149222_k() == 1 && s2APacketParticles.func_149227_j() == 0.0f && s2APacketParticles.func_149221_g() == 0.05f && s2APacketParticles.func_149224_h() == 0.0f && s2APacketParticles.func_149223_i() == 0.05f;
        }

        private static final boolean _init_$lambda$4(S2APacketParticles s2APacketParticles) {
            Intrinsics.checkNotNullParameter(s2APacketParticles, "<this>");
            return s2APacketParticles.func_179749_a() == EnumParticleTypes.ENCHANTMENT_TABLE && s2APacketParticles.func_149222_k() == 5 && s2APacketParticles.func_149227_j() == 0.05f && s2APacketParticles.func_149221_g() == 0.5f && s2APacketParticles.func_149224_h() == 0.4f && s2APacketParticles.func_149223_i() == 0.5f;
        }

        static {
            EMPTY = new ParticleType(ParticleType::_init_$lambda$0);
            MOB = new ParticleType(ParticleType::_init_$lambda$1);
            TREASURE = new ParticleType(ParticleType::_init_$lambda$2);
            FOOTSTEP = new ParticleType(ParticleType::_init_$lambda$3);
            ENCHANT = new ParticleType(ParticleType::_init_$lambda$4);
            $VALUES = particleTypeArray = new ParticleType[]{ParticleType.EMPTY, ParticleType.MOB, ParticleType.TREASURE, ParticleType.FOOTSTEP, ParticleType.ENCHANT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lat/hannibal2/skyhanni/features/event/diana/GriffinBurrowParticleFinder$ParticleType$Companion;", "", "<init>", "()V", "Lnet/minecraft/network/play/server/S2APacketParticles;", "packet", "Lat/hannibal2/skyhanni/features/event/diana/GriffinBurrowParticleFinder$ParticleType;", "getParticleType", "(Lnet/minecraft/network/play/server/S2APacketParticles;)Lat/hannibal2/skyhanni/features/event/diana/GriffinBurrowParticleFinder$ParticleType;", "1.8.9"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final ParticleType getParticleType(@NotNull S2APacketParticles packet) {
                Intrinsics.checkNotNullParameter(packet, "packet");
                if (!packet.func_179750_b()) {
                    return null;
                }
                for (ParticleType type2 : ParticleType.getEntries()) {
                    if (!type2.getCheck().invoke(packet).booleanValue()) continue;
                    return type2;
                }
                return null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ParticleType.values().length];
            try {
                nArray[ParticleType.FOOTSTEP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParticleType.ENCHANT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParticleType.EMPTY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParticleType.MOB.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParticleType.TREASURE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

