/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.dungeon;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.features.dungeon.ObjectHighlighterConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.mob.Mob;
import at.hannibal2.skyhanni.data.mob.MobData;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.events.MobEvent;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0003J\u000f\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ!\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u001aH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010 \u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b \u0010\u0018J\u0017\u0010!\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b!\u0010\u0018R\u001c\u0010&\u001a\n #*\u0004\u0018\u00010\"0\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001c\u0010*\u001a\n #*\u0004\u0018\u00010'0'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u001c\u0010.\u001a\n #*\u0004\u0018\u00010+0+8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020\u00150/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u001a\u00102\u001a\b\u0012\u0004\u0012\u00020\u00150/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00101\u00a8\u00063"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonMobManager;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/ConfigLoadEvent;", "event", "", "onConfigLoad", "(Lat/hannibal2/skyhanni/events/ConfigLoadEvent;)V", "Lat/hannibal2/skyhanni/events/MobEvent$Spawn$SkyblockMob;", "onMobSpawn", "(Lat/hannibal2/skyhanni/events/MobEvent$Spawn$SkyblockMob;)V", "Lat/hannibal2/skyhanni/events/MobEvent$DeSpawn$SkyblockMob;", "onMobDeSpawn", "(Lat/hannibal2/skyhanni/events/MobEvent$DeSpawn$SkyblockMob;)V", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "onLorenzTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/data/mob/Mob;", "mob", "handleStar", "(Lat/hannibal2/skyhanni/data/mob/Mob;)V", "handleInvisibleStar", "Ljava/awt/Color;", "getStarColor", "()Ljava/awt/Color;", "colour", "handleStar0", "(Lat/hannibal2/skyhanni/data/mob/Mob;Ljava/awt/Color;)V", "handleFel", "handleFelDespawn", "Lat/hannibal2/skyhanni/config/features/dungeon/ObjectHighlighterConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/dungeon/ObjectHighlighterConfig;", "config", "Lat/hannibal2/skyhanni/config/features/dungeon/ObjectHighlighterConfig$StarredConfig;", "getStarredConfig", "()Lat/hannibal2/skyhanni/config/features/dungeon/ObjectHighlighterConfig$StarredConfig;", "starredConfig", "Lat/hannibal2/skyhanni/config/features/dungeon/ObjectHighlighterConfig$FelConfig;", "getFel", "()Lat/hannibal2/skyhanni/config/features/dungeon/ObjectHighlighterConfig$FelConfig;", "fel", "", "staredInvisible", "Ljava/util/Set;", "felOnTheGround", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nDungeonMobManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DungeonMobManager.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonMobManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n774#2:151\n865#2,2:152\n1863#2,2:154\n774#2:156\n865#2,2:157\n1863#2,2:159\n1863#2,2:161\n*S KotlinDebug\n*F\n+ 1 DungeonMobManager.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonMobManager\n*L\n86#1:151\n86#1:152,2\n86#1:154,2\n39#1:156\n39#1:157,2\n39#1:159,2\n52#1:161,2\n*E\n"})
public final class DungeonMobManager {
    @NotNull
    public static final DungeonMobManager INSTANCE = new DungeonMobManager();
    @NotNull
    private static final Set<Mob> staredInvisible = new LinkedHashSet();
    @NotNull
    private static final Set<Mob> felOnTheGround = new LinkedHashSet();

    private DungeonMobManager() {
    }

    private final ObjectHighlighterConfig getConfig() {
        return SkyHanniMod.feature.dungeon.objectHighlighter;
    }

    private final ObjectHighlighterConfig.StarredConfig getStarredConfig() {
        return this.getConfig().starred;
    }

    private final ObjectHighlighterConfig.FelConfig getFel() {
        return this.getConfig().fel;
    }

    @SubscribeEvent
    public final void onConfigLoad(@NotNull ConfigLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Property[] propertyArray = new Property[]{this.getStarredConfig().highlight, this.getStarredConfig().colour};
        ConditionalUtils.INSTANCE.onToggle(propertyArray, DungeonMobManager::onConfigLoad$lambda$2);
        propertyArray = new Property[]{this.getFel().highlight, this.getFel().colour};
        ConditionalUtils.INSTANCE.onToggle(propertyArray, DungeonMobManager::onConfigLoad$lambda$3);
    }

    @SubscribeEvent
    public final void onMobSpawn(@NotNull MobEvent.Spawn.SkyblockMob event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (event.getMob().getMobType() != Mob.Type.DUNGEON) {
            return;
        }
        this.handleStar(event.getMob());
        this.handleFel(event.getMob());
    }

    @SubscribeEvent
    public final void onMobDeSpawn(@NotNull MobEvent.DeSpawn.SkyblockMob event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (event.getMob().getMobType() != Mob.Type.DUNGEON) {
            return;
        }
        if (((Boolean)this.getStarredConfig().highlight.get()).booleanValue()) {
            staredInvisible.remove(event.getMob());
        }
        this.handleFelDespawn(event.getMob());
    }

    @SubscribeEvent
    public final void onLorenzTick(@NotNull LorenzTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.isInIsland(IslandType.CATACOMBS)) {
            return;
        }
        this.handleInvisibleStar();
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onRenderWorld(@NotNull LorenzRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!((Boolean)this.getFel().highlight.get()).booleanValue()) {
            return;
        }
        if (this.getFel().line.booleanValue()) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = felOnTheGround;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Mob it = (Mob)element$iv$iv;
                boolean bl = false;
                if (!it.canBeSeen()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Mob it = (Mob)element$iv;
                boolean bl = false;
                LorenzVec lorenzVec = LorenzVec.add$default(LorenzVecKt.getLorenzVec((Entity)it.getBaseEntity()), 0.0, 0.15, 0.0, 5, null);
                LorenzVec lorenzVec2 = RenderUtils.INSTANCE.exactPlayerEyeLocation(event);
                Object t = DungeonMobManager.INSTANCE.getFel().colour.get();
                Intrinsics.checkNotNullExpressionValue(t, "get(...)");
                RenderUtils.INSTANCE.draw3DLine(event, lorenzVec, lorenzVec2, ColorUtils.INSTANCE.toChromaColor((String)t), 3, true);
            }
        }
        felOnTheGround.removeIf(arg_0 -> DungeonMobManager.onRenderWorld$lambda$7(arg_0 -> DungeonMobManager.onRenderWorld$lambda$6(event, arg_0), arg_0));
    }

    private final void handleStar(Mob mob) {
        if (!((Boolean)this.getStarredConfig().highlight.get()).booleanValue()) {
            return;
        }
        if (!mob.getHasStar()) {
            return;
        }
        this.handleStar0(mob, this.getStarColor());
    }

    private final void handleInvisibleStar() {
        if (!((Boolean)this.getStarredConfig().highlight.get()).booleanValue()) {
            return;
        }
        staredInvisible.removeIf(arg_0 -> DungeonMobManager.handleInvisibleStar$lambda$9(DungeonMobManager::handleInvisibleStar$lambda$8, arg_0));
    }

    private final Color getStarColor() {
        Object t = this.getStarredConfig().colour.get();
        Intrinsics.checkNotNullExpressionValue(t, "get(...)");
        return ColorUtils.INSTANCE.toChromaColor((String)t);
    }

    private final void handleStar0(Mob mob, Color colour) {
        if (mob.isInvisible()) {
            staredInvisible.add(mob);
            return;
        }
        mob.highlight(colour);
    }

    private final void handleFel(Mob mob) {
        if (!((Boolean)this.getFel().highlight.get()).booleanValue()) {
            return;
        }
        if (!Intrinsics.areEqual(mob.getName(), "Fels")) {
            return;
        }
        if (!mob.isInvisible()) {
            return;
        }
        felOnTheGround.add(mob);
    }

    private final void handleFelDespawn(Mob mob) {
        if (!((Boolean)this.getFel().highlight.get()).booleanValue()) {
            return;
        }
        felOnTheGround.remove(mob);
    }

    /*
     * WARNING - void declaration
     */
    private static final void onConfigLoad$lambda$2() {
        void $this$filterTo$iv$iv;
        Color color = (Boolean)DungeonMobManager.INSTANCE.getStarredConfig().highlight.get() != false ? INSTANCE.getStarColor() : null;
        Iterable $this$filter$iv = MobData.INSTANCE.getSkyblockMobs();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Mob it = (Mob)element$iv$iv;
            boolean bl = false;
            if (!it.getHasStar()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Mob it = (Mob)element$iv;
            boolean bl = false;
            INSTANCE.handleStar0(it, color);
        }
        if (!((Boolean)DungeonMobManager.INSTANCE.getStarredConfig().highlight.get()).booleanValue()) {
            staredInvisible.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void onConfigLoad$lambda$3() {
        if (((Boolean)DungeonMobManager.INSTANCE.getFel().highlight.get()).booleanValue()) {
            if (felOnTheGround.isEmpty()) {
                void $this$forEach$iv;
                Iterable iterable = MobData.INSTANCE.getSkyblockMobs();
                DungeonMobManager dungeonMobManager = INSTANCE;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Mob p0 = (Mob)element$iv;
                    boolean bl = false;
                    dungeonMobManager.handleFel(p0);
                }
            }
        } else {
            felOnTheGround.clear();
        }
    }

    private static final boolean onRenderWorld$lambda$6(LorenzRenderWorldEvent $event, Mob mob) {
        Intrinsics.checkNotNullParameter((Object)$event, "$event");
        Intrinsics.checkNotNullParameter(mob, "mob");
        LorenzVec lorenzVec = LorenzVecKt.getLorenzVec((Entity)mob.getBaseEntity()).add(-0.5, -0.23, -0.5);
        Object t = DungeonMobManager.INSTANCE.getFel().colour.get();
        Intrinsics.checkNotNullExpressionValue(t, "get(...)");
        RenderUtils.drawWaypointFilled$default(RenderUtils.INSTANCE, $event, lorenzVec, ColorUtils.INSTANCE.toChromaColor((String)t), false, false, -0.2, 0.0, 0.0, 0.8f, true, 96, null);
        return !mob.isInvisible();
    }

    private static final boolean onRenderWorld$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean handleInvisibleStar$lambda$8(Mob it) {
        boolean visible;
        Intrinsics.checkNotNullParameter(it, "it");
        boolean bl = visible = !it.isInvisible();
        if (visible) {
            it.highlight(INSTANCE.getStarColor());
        }
        return visible;
    }

    private static final boolean handleInvisibleStar$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

