/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.combat.mobs;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.features.combat.MobsConfig;
import at.hannibal2.skyhanni.events.EntityHealthUpdateEvent;
import at.hannibal2.skyhanni.events.EntityMaxHealthUpdateEvent;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.mixins.hooks.RenderLivingEntityHelper;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.RenderUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.init.Blocks;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u0007\u0010\nJ\u0017\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0017R\u001c\u0010\u001d\u001a\n \u001a*\u0004\u0018\u00010\u00190\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lat/hannibal2/skyhanni/features/combat/mobs/MobHighlight;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/EntityHealthUpdateEvent;", "event", "", "onEntityHealthUpdate", "(Lat/hannibal2/skyhanni/events/EntityHealthUpdateEvent;)V", "Lat/hannibal2/skyhanni/events/EntityMaxHealthUpdateEvent;", "(Lat/hannibal2/skyhanni/events/EntityMaxHealthUpdateEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "onWorldRender", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lnet/minecraft/entity/monster/EntitySpider;", "entity", "checkArachne", "(Lnet/minecraft/entity/monster/EntitySpider;)V", "Lnet/minecraft/entity/EntityLivingBase;", "markArachneMinis", "(Lnet/minecraft/entity/EntityLivingBase;)V", "markArachne", "Lat/hannibal2/skyhanni/config/features/combat/MobsConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/combat/MobsConfig;", "config", "arachne", "Lnet/minecraft/entity/EntityLivingBase;", "1.8.9"})
public final class MobHighlight {
    @NotNull
    public static final MobHighlight INSTANCE = new MobHighlight();
    @Nullable
    private static EntityLivingBase arachne;

    private MobHighlight() {
    }

    private final MobsConfig getConfig() {
        return SkyHanniMod.feature.combat.mobs;
    }

    @SubscribeEvent
    public final void onEntityHealthUpdate(@NotNull EntityHealthUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        EntityLivingBase entity = event.getEntity();
        int baseMaxHealth = LorenzUtils.INSTANCE.getBaseMaxHealth(entity);
        if (this.getConfig().corruptedMobHighlight && event.getHealth() == baseMaxHealth * 3) {
            RenderLivingEntityHelper.INSTANCE.setEntityColorWithNoHurtTime(entity, ColorUtils.INSTANCE.withAlpha(LorenzColor.DARK_PURPLE.toColor(), 127), MobHighlight::onEntityHealthUpdate$lambda$0);
        }
    }

    @SubscribeEvent
    public final void onEntityHealthUpdate(@NotNull EntityMaxHealthUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        EntityLivingBase entity = event.getEntity();
        int maxHealth = event.getMaxHealth();
        if (this.getConfig().arachneKeeperHighlight && (maxHealth == 3000 || maxHealth == 12000) && entity instanceof EntityCaveSpider) {
            RenderLivingEntityHelper.INSTANCE.setEntityColorWithNoHurtTime(entity, ColorUtils.INSTANCE.withAlpha(LorenzColor.DARK_BLUE.toColor(), 127), MobHighlight::onEntityHealthUpdate$lambda$1);
        }
        if (this.getConfig().corleoneHighlighter && maxHealth == 1000000 && entity instanceof EntityOtherPlayerMP && Intrinsics.areEqual(((EntityOtherPlayerMP)entity).func_70005_c_(), "Team Treasurite")) {
            RenderLivingEntityHelper.INSTANCE.setEntityColorWithNoHurtTime(entity, ColorUtils.INSTANCE.withAlpha(LorenzColor.DARK_PURPLE.toColor(), 127), MobHighlight::onEntityHealthUpdate$lambda$2);
        }
        if (entity instanceof EntityEnderman) {
            boolean isBruiser;
            boolean isZealot = maxHealth == 13000 || maxHealth == 52000;
            boolean bl = isBruiser = maxHealth == 65000 || maxHealth == 260000;
            if (this.getConfig().zealotBruiserHighlighter && (isZealot || isBruiser)) {
                RenderLivingEntityHelper.INSTANCE.setEntityColorWithNoHurtTime(entity, ColorUtils.INSTANCE.withAlpha(LorenzColor.DARK_AQUA.toColor(), 127), MobHighlight::onEntityHealthUpdate$lambda$3);
            }
            if (this.getConfig().chestZealotHighlighter) {
                EntityLivingBase entityLivingBase = entity;
                EntityEnderman entityEnderman = entityLivingBase instanceof EntityEnderman ? (EntityEnderman)entityLivingBase : null;
                boolean isHoldingChest = Intrinsics.areEqual(entityEnderman != null && (entityEnderman = EntityUtils.INSTANCE.getBlockInHand(entityEnderman)) != null ? entityEnderman.func_177230_c() : null, Blocks.field_150477_bB);
                if ((isZealot || isBruiser) && isHoldingChest) {
                    RenderLivingEntityHelper.INSTANCE.setEntityColorWithNoHurtTime(entity, ColorUtils.INSTANCE.withAlpha(LorenzColor.GREEN.toColor(), 127), MobHighlight::onEntityHealthUpdate$lambda$4);
                }
            }
            if (this.getConfig().specialZealotHighlighter && LorenzUtils.INSTANCE.ignoreDerpy(maxHealth) == 2000) {
                RenderLivingEntityHelper.INSTANCE.setEntityColorWithNoHurtTime(entity, ColorUtils.INSTANCE.withAlpha(LorenzColor.DARK_RED.toColor(), 50), MobHighlight::onEntityHealthUpdate$lambda$5);
            }
        }
        if (entity instanceof EntitySpider) {
            this.checkArachne((EntitySpider)entity);
        }
    }

    @SubscribeEvent
    public final void onWorldRender(@NotNull LorenzRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock() || !this.getConfig().lineToArachne) {
            return;
        }
        EntityLivingBase entityLivingBase = arachne;
        if (entityLivingBase == null) {
            return;
        }
        EntityLivingBase arachne = entityLivingBase;
        if (arachne.field_70128_L || arachne.func_110143_aJ() <= 0.0f) {
            MobHighlight.arachne = null;
            return;
        }
        if (LocationUtils.INSTANCE.distanceToPlayer((Entity)arachne) > 10.0) {
            return;
        }
        RenderUtils.INSTANCE.draw3DLine(event, RenderUtils.INSTANCE.exactPlayerEyeLocation(event), LorenzVec.add$default(LorenzVecKt.getLorenzVec((Entity)arachne), 0, 1, 0, 5, null), LorenzColor.RED.toColor(), this.getConfig().lineToArachneWidth, true);
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        arachne = null;
    }

    private final void checkArachne(EntitySpider entity) {
        if (!this.getConfig().arachneBossHighlighter && !this.getConfig().lineToArachne) {
            return;
        }
        if (!(EntityUtils.hasNameTagWith$default(EntityUtils.INSTANCE, (EntityLivingBase)entity, 1, "[\u00a77Lv300\u00a78] \u00a7cArachne", false, 0.0, false, 28, null) || EntityUtils.hasNameTagWith$default(EntityUtils.INSTANCE, (EntityLivingBase)entity, 1, "[\u00a77Lv300\u00a78] \u00a7lArachne", false, 0.0, false, 28, null) || EntityUtils.hasNameTagWith$default(EntityUtils.INSTANCE, (EntityLivingBase)entity, 1, "[\u00a77Lv500\u00a78] \u00a7cArachne", false, 0.0, false, 28, null) || EntityUtils.hasNameTagWith$default(EntityUtils.INSTANCE, (EntityLivingBase)entity, 1, "[\u00a77Lv500\u00a78] \u00a7lArachne", false, 0.0, false, 28, null))) {
            return;
        }
        if (entity instanceof EntityCaveSpider) {
            this.markArachneMinis((EntityLivingBase)entity);
        } else if (LorenzUtils.INSTANCE.getBaseMaxHealth((EntityLivingBase)entity) == 20000 || LorenzUtils.INSTANCE.getBaseMaxHealth((EntityLivingBase)entity) == 100000) {
            arachne = (EntityLivingBase)entity;
            this.markArachne((EntityLivingBase)entity);
        }
    }

    private final void markArachneMinis(EntityLivingBase entity) {
        RenderLivingEntityHelper.INSTANCE.setEntityColorWithNoHurtTime(entity, ColorUtils.INSTANCE.withAlpha(LorenzColor.GOLD.toColor(), 50), MobHighlight::markArachneMinis$lambda$6);
    }

    private final void markArachne(EntityLivingBase entity) {
        RenderLivingEntityHelper.INSTANCE.setEntityColorWithNoHurtTime(entity, ColorUtils.INSTANCE.withAlpha(LorenzColor.RED.toColor(), 50), MobHighlight::markArachne$lambda$7);
    }

    private static final boolean onEntityHealthUpdate$lambda$0() {
        return MobHighlight.INSTANCE.getConfig().corruptedMobHighlight;
    }

    private static final boolean onEntityHealthUpdate$lambda$1() {
        return MobHighlight.INSTANCE.getConfig().arachneKeeperHighlight;
    }

    private static final boolean onEntityHealthUpdate$lambda$2() {
        return MobHighlight.INSTANCE.getConfig().corleoneHighlighter;
    }

    private static final boolean onEntityHealthUpdate$lambda$3() {
        return MobHighlight.INSTANCE.getConfig().zealotBruiserHighlighter;
    }

    private static final boolean onEntityHealthUpdate$lambda$4() {
        return MobHighlight.INSTANCE.getConfig().chestZealotHighlighter;
    }

    private static final boolean onEntityHealthUpdate$lambda$5() {
        return MobHighlight.INSTANCE.getConfig().specialZealotHighlighter;
    }

    private static final boolean markArachneMinis$lambda$6() {
        return MobHighlight.INSTANCE.getConfig().arachneBossHighlighter;
    }

    private static final boolean markArachne$lambda$7() {
        return MobHighlight.INSTANCE.getConfig().arachneBossHighlighter;
    }
}

