/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.processor;

import at.hannibal2.skyhanni.deps.moulconfig.Config;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiOptionEditor;
import at.hannibal2.skyhanni.deps.moulconfig.observer.GetSetter;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.deps.moulconfig.processor.ProcessedCategory;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class ProcessedOption {
    public final String name;
    public final String desc;
    public final Field field;
    public final String path;
    public final ProcessedCategory category;
    private final Object container;
    public GuiOptionEditor editor;
    public int accordionId = -1;
    public boolean isProperty;
    public Config config;

    public ProcessedOption(String name2, String desc, String path, Field field, ProcessedCategory category, Object container, Config config) {
        this.name = name2;
        this.path = path;
        this.desc = desc;
        this.category = category;
        this.config = config;
        this.field = field;
        this.container = container;
        this.isProperty = field.getType() == Property.class;
    }

    public Object get() {
        try {
            Object obj = this.field.get(this.container);
            if (this.isProperty) {
                return ((Property)obj).get();
            }
            return obj;
        }
        catch (Exception e) {
            return null;
        }
    }

    public GetSetter<?> intoProperty() {
        return new GetSetter<Object>(){

            @Override
            public Object get() {
                return ProcessedOption.this.get();
            }

            @Override
            public void set(Object newValue) {
                ProcessedOption.this.set(newValue);
            }
        };
    }

    public Type getType() {
        if (this.isProperty) {
            return ((ParameterizedType)this.field.getGenericType()).getActualTypeArguments()[0];
        }
        return this.field.getGenericType();
    }

    public boolean set(Object value) {
        try {
            Object toSet = this.getType() == Integer.TYPE && value instanceof Number ? Integer.valueOf(((Number)value).intValue()) : value;
            if (this.isProperty) {
                ((Property)this.field.get(this.container)).set(toSet);
            } else {
                this.field.set(this.container, toSet);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void explicitNotifyChange() {
        if (this.isProperty) {
            try {
                ((Property)this.field.get(this.container)).notifyObservers();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

