/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.processor;

import at.hannibal2.skyhanni.deps.moulconfig.Config;
import at.hannibal2.skyhanni.deps.moulconfig.Overlay;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiOptionEditor;
import at.hannibal2.skyhanni.deps.moulconfig.gui.editors.GuiOptionEditorAccordion;
import at.hannibal2.skyhanni.deps.moulconfig.internal.Warnings;
import at.hannibal2.skyhanni.deps.moulconfig.processor.BuiltinMoulConfigGuis;
import at.hannibal2.skyhanni.deps.moulconfig.processor.ConfigProcessorDriver;
import at.hannibal2.skyhanni.deps.moulconfig.processor.ConfigStructureReader;
import at.hannibal2.skyhanni.deps.moulconfig.processor.ProcessedCategory;
import at.hannibal2.skyhanni.deps.moulconfig.processor.ProcessedOption;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoulConfigProcessor<T extends Config>
implements ConfigStructureReader {
    private final T configBaseObject;
    private final LinkedHashMap<String, ProcessedCategory> categories = new LinkedHashMap();
    private final List<Overlay> overlays = new ArrayList<Overlay>();
    private ProcessedCategory currentCategory;
    private Map<Overlay, List<ProcessedOption>> processedOverlays = new IdentityHashMap<Overlay, List<ProcessedOption>>();
    private Stack<Integer> accordion = new Stack();
    private Stack<String> categoryPath = new Stack();
    private boolean isFinalized;
    private Map<Field, ProcessedOption> optionLookup = new HashMap<Field, ProcessedOption>();
    private Map<Class<? extends Annotation>, BiFunction<ProcessedOption, Annotation, GuiOptionEditor>> editors = new HashMap<Class<? extends Annotation>, BiFunction<ProcessedOption, Annotation, GuiOptionEditor>>();
    private ConfigProcessorDriver driver;

    public MoulConfigProcessor(T configBaseObject) {
        this.configBaseObject = configBaseObject;
    }

    public static <T extends Config> MoulConfigProcessor<T> withDefaults(T configBaseObject) {
        MoulConfigProcessor<T> moulConfigProcessor = new MoulConfigProcessor<T>(configBaseObject);
        BuiltinMoulConfigGuis.addProcessors(moulConfigProcessor);
        return moulConfigProcessor;
    }

    public <A extends Annotation> void registerConfigEditor(Class<A> annotation, BiFunction<ProcessedOption, ? extends A, GuiOptionEditor> editorGenerator) {
        this.editors.put(annotation, editorGenerator);
    }

    public void requireFinalized() {
        if (!this.isFinalized) {
            Warnings.warn("Finalization requirement on MoulConfigProcessor broken. Please first process a config", 4);
        }
    }

    public List<Overlay> getAllOverlays() {
        return this.overlays;
    }

    @Override
    public void beginCategory(Object baseObject, Field field, String name2, String description2) {
        this.currentCategory = new ProcessedCategory(field, name2, description2);
        this.categories.put(this.currentCategory.getIdentifier(), this.currentCategory);
    }

    public T getConfigObject() {
        return this.configBaseObject;
    }

    @Override
    public void pushPath(String fieldPath) {
        this.categoryPath.push(fieldPath);
    }

    @Override
    public void beginConfig(Class<? extends Config> configClass, ConfigProcessorDriver driver, Config configObject) {
        this.driver = driver;
        if (this.editors.isEmpty()) {
            Warnings.warn("Calling a config processor with no editors registered. Consider registering editors using BuiltinMoulConfigGuis.addProcessors or MoulConfigProcessor.withDefaults");
        }
        if (this.isFinalized) {
            Warnings.warn("Processing a finalized config");
        }
    }

    @Override
    public void endConfig() {
        this.isFinalized = true;
    }

    @Override
    public void popPath() {
        this.categoryPath.pop();
    }

    @Override
    public void endCategory() {
        for (ProcessedOption option : this.currentCategory.options) {
            GuiOptionEditor editor = option.editor;
            if (!(editor instanceof GuiOptionEditorAccordion)) continue;
            this.currentCategory.accordionAnchors.put(((GuiOptionEditorAccordion)editor).getAccordionId(), option);
        }
        this.accordion.clear();
    }

    @Override
    public void beginAccordion(Object baseObject, Field field, ConfigOption option, int id) {
        ProcessedOption processedOption = this.createProcessedOption(baseObject, field, option);
        processedOption.editor = new GuiOptionEditorAccordion(processedOption, id);
        this.currentCategory.options.add(processedOption);
        this.accordion.push(id);
    }

    @Override
    public void endAccordion() {
        this.accordion.pop();
    }

    @Override
    public void emitOption(Object baseObject, Field field, ConfigOption option) {
        ProcessedOption processedOption = this.createProcessedOption(baseObject, field, option);
        GuiOptionEditor optionGui = this.createOptionGui(processedOption, field, option);
        if (optionGui == null) {
            Warnings.warn("Could not create GUI Option Editor for " + field + " in " + baseObject.getClass());
            return;
        }
        processedOption.editor = optionGui;
        this.currentCategory.options.add(processedOption);
    }

    protected ProcessedOption createProcessedOption(Object baseObject, Field field, ConfigOption option) {
        ProcessedOption processedOption = new ProcessedOption(option.name(), option.desc(), String.join((CharSequence)".", this.categoryPath) + "." + field.getName(), field, this.currentCategory, baseObject, (Config)this.configBaseObject);
        this.optionLookup.put(field, processedOption);
        if (!this.accordion.isEmpty()) {
            processedOption.accordionId = this.accordion.peek();
        }
        return processedOption;
    }

    @Override
    public void setCategoryParent(Field field) {
        this.currentCategory.parent = field.toString();
    }

    @Override
    public void emitGuiOverlay(Object baseObject, Field field, ConfigOption option) {
        Overlay overlay;
        try {
            overlay = (Overlay)field.get(baseObject);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        this.overlays.add(overlay);
        if (this.processedOverlays.containsKey(overlay)) {
            return;
        }
        MoulConfigProcessor<T> subProcessor = new MoulConfigProcessor<T>(this.configBaseObject);
        subProcessor.processedOverlays = this.processedOverlays;
        subProcessor.editors = this.editors;
        subProcessor.currentCategory = new ProcessedCategory(field, option.name(), option.desc());
        this.pushPath(field.getName());
        new ConfigProcessorDriver(subProcessor).processCategory(overlay, null);
        this.popPath();
        this.processedOverlays.put(overlay, subProcessor.currentCategory.options);
    }

    protected GuiOptionEditor createOptionGui(ProcessedOption processedOption, Field field, ConfigOption option) {
        for (Map.Entry<Class<? extends Annotation>, BiFunction<ProcessedOption, Annotation, GuiOptionEditor>> entry : this.editors.entrySet()) {
            GuiOptionEditor editor;
            Annotation annotation = field.getAnnotation(entry.getKey());
            if (annotation == null || (editor = entry.getValue().apply(processedOption, annotation)) == null) continue;
            return editor;
        }
        return null;
    }

    public LinkedHashMap<String, ProcessedCategory> getAllCategories() {
        this.requireFinalized();
        return this.categories;
    }

    public Map<Overlay, List<ProcessedOption>> getOverlayOptions() {
        this.requireFinalized();
        return this.processedOverlays;
    }

    @Nullable
    public ProcessedOption getOptionFromField(@NotNull Field field) {
        this.requireFinalized();
        return this.optionLookup.get(field);
    }

    public boolean isFinalized() {
        return this.isFinalized;
    }
}

