/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.gui.component;

import at.hannibal2.skyhanni.deps.moulconfig.common.IFontRenderer;
import at.hannibal2.skyhanni.deps.moulconfig.common.IMinecraft;
import at.hannibal2.skyhanni.deps.moulconfig.common.KeyboardConstants;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiComponent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiImmediateContext;
import at.hannibal2.skyhanni.deps.moulconfig.gui.KeyboardEvent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.MouseEvent;
import at.hannibal2.skyhanni.deps.moulconfig.internal.ClipboardUtils;
import at.hannibal2.skyhanni.deps.moulconfig.observer.GetSetter;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b,\b\u0016\u0018\u0000 H2\u00020\u0001:\u0001HBA\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0013J\u001f\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001f\u0010!\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010#\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010%\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b%\u0010$J\u0017\u0010&\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b&\u0010$J\u0017\u0010'\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b'\u0010$J\u001f\u0010)\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b)\u0010*J\u001f\u0010-\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b-\u0010.J'\u0010-\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b-\u00100J\u000f\u00101\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b1\u0010\u0011J\u001f\u00103\u001a\u00020\u00052\u0006\u00102\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b3\u00104J\u000f\u00105\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b5\u0010\u0011J\u0015\u00107\u001a\u00020\u000f2\u0006\u00106\u001a\u00020\u0003\u00a2\u0006\u0004\b7\u00108R\u0016\u00109\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u001d\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006\u00a2\u0006\f\n\u0004\b\t\u0010;\u001a\u0004\b<\u0010=R\u0017\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010>\u001a\u0004\b?\u0010@R\u0016\u0010A\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bA\u0010:R\u0016\u0010B\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010:R\u0017\u0010\n\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\n\u0010C\u001a\u0004\bD\u0010\u0015R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010E\u001a\u0004\bF\u0010GR\u0018\u0010(\u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010CR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010:\u00a8\u0006I"}, d2={"Lat/hannibal2/skyhanni/deps/moulconfig/gui/component/TextFieldComponent;", "Lat/hannibal2/skyhanni/deps/moulconfig/gui/GuiComponent;", "Lat/hannibal2/skyhanni/deps/moulconfig/observer/GetSetter;", "", "text", "", "width", "Ljava/util/function/Supplier;", "", "editable", "suggestion", "Lat/hannibal2/skyhanni/deps/moulconfig/common/IFontRenderer;", "font", "<init>", "(Lio/github/notenoughupdates/moulconfig/observer/GetSetter;ILjava/util/function/Supplier;Ljava/lang/String;Lio/github/notenoughupdates/moulconfig/common/IFontRenderer;)V", "", "checkScrollOffset", "()V", "getHeight", "()I", "getSelection", "()Ljava/lang/String;", "getWidth", "Lat/hannibal2/skyhanni/deps/moulconfig/gui/KeyboardEvent;", "event", "Lat/hannibal2/skyhanni/deps/moulconfig/gui/GuiImmediateContext;", "context", "keyboardEvent", "(Lio/github/notenoughupdates/moulconfig/gui/KeyboardEvent;Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;)Z", "Lat/hannibal2/skyhanni/deps/moulconfig/gui/MouseEvent;", "mouseEvent", "(Lio/github/notenoughupdates/moulconfig/gui/MouseEvent;Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;)Z", "i", "onDirectionalKey", "(Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;I)V", "render", "(Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;)V", "renderBox", "renderCursor", "renderSelection", "visibleText", "renderText", "(Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;Ljava/lang/String;)V", "str", "startIndex", "safeSubString", "(Ljava/lang/String;I)Ljava/lang/String;", "endIndex", "(Ljava/lang/String;II)Ljava/lang/String;", "scrollCursorIntoView", "skipWords", "skipCharacters", "(ZI)I", "validateCursor", "s", "writeText", "(Ljava/lang/String;)V", "cursor", "I", "Ljava/util/function/Supplier;", "getEditable", "()Ljava/util/function/Supplier;", "Lat/hannibal2/skyhanni/deps/moulconfig/common/IFontRenderer;", "getFont", "()Lio/github/notenoughupdates/moulconfig/common/IFontRenderer;", "scrollOffset", "selection", "Ljava/lang/String;", "getSuggestion", "Lat/hannibal2/skyhanni/deps/moulconfig/observer/GetSetter;", "getText", "()Lio/github/notenoughupdates/moulconfig/observer/GetSetter;", "Companion", "common"})
public class TextFieldComponent
extends GuiComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GetSetter<String> text;
    private final int width;
    @NotNull
    private final Supplier<Boolean> editable;
    @NotNull
    private final String suggestion;
    @NotNull
    private final IFontRenderer font;
    private int cursor;
    private int selection;
    private int scrollOffset;
    @Nullable
    private String visibleText;
    private static final int TEXT_PADDING_X = 2;
    private static final int BACKGROUND_COLOR = -16777216;
    private static final int BORDER_COLOR_SELECTED = -96;
    private static final int BORDER_COLOR_UNSELECTED = -6250336;
    private static final int ENABLED_COLOR = -2039584;
    private static final int SUGGESTION_COLOR = -8355712;
    private static final int DISABLED_COLOR = -9408400;
    private static final int CURSOR_COLOR = -3092272;
    private static final int TEXT_PADDING_Y = 2;

    public TextFieldComponent(@NotNull GetSetter<String> text, int width, @NotNull Supplier<Boolean> editable, @NotNull String suggestion, @NotNull IFontRenderer font) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(editable, "editable");
        Intrinsics.checkNotNullParameter(suggestion, "suggestion");
        Intrinsics.checkNotNullParameter(font, "font");
        this.text = text;
        this.width = width;
        this.editable = editable;
        this.suggestion = suggestion;
        this.font = font;
        this.selection = -1;
    }

    public /* synthetic */ TextFieldComponent(GetSetter getSetter, int n, Supplier supplier, String string2, IFontRenderer iFontRenderer, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            GetSetter<Boolean> getSetter2 = GetSetter.constant(true);
            Intrinsics.checkNotNullExpressionValue(getSetter2, "constant(true)");
            supplier = getSetter2;
        }
        if ((n2 & 8) != 0) {
            string2 = "";
        }
        if ((n2 & 0x10) != 0) {
            iFontRenderer = IMinecraft.instance.getDefaultFontRenderer();
        }
        this(getSetter, n, supplier, string2, iFontRenderer);
    }

    @NotNull
    public final GetSetter<String> getText() {
        return this.text;
    }

    @NotNull
    public final Supplier<Boolean> getEditable() {
        return this.editable;
    }

    @NotNull
    public final String getSuggestion() {
        return this.suggestion;
    }

    @NotNull
    public final IFontRenderer getFont() {
        return this.font;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return 14;
    }

    public void scrollCursorIntoView() {
        this.validateCursor();
        if (this.scrollOffset > this.cursor) {
            this.scrollOffset = this.cursor;
        }
        if (this.scrollOffset < this.cursor) {
            String string2 = this.text.get();
            Intrinsics.checkNotNullExpressionValue(string2, "text.get()");
            if (this.font.trimStringToWidth(this.safeSubString(string2, this.scrollOffset), this.width - 4).length() + this.scrollOffset < this.cursor) {
                this.scrollOffset = this.cursor;
            }
        }
        this.checkScrollOffset();
    }

    public void checkScrollOffset() {
        String text = this.text.get();
        int n = text.length();
        Intrinsics.checkNotNullExpressionValue(text, "text");
        int rightMostScrollOffset = n - this.font.trimStringToWidth(text, this.width - 4, true).length();
        this.scrollOffset = Math.max(0, Math.min(rightMostScrollOffset, this.scrollOffset));
    }

    @Override
    public void render(@NotNull GuiImmediateContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.validateCursor();
        this.checkScrollOffset();
        String string2 = this.text.get();
        Intrinsics.checkNotNullExpressionValue(string2, "text.get()");
        this.visibleText = this.font.trimStringToWidth(this.safeSubString(string2, this.scrollOffset), this.width - 4);
        this.renderBox(context2);
        String string3 = this.visibleText;
        Intrinsics.checkNotNull(string3);
        this.renderText(context2, string3);
        String string4 = this.text.get();
        Intrinsics.checkNotNullExpressionValue(string4, "text.get()");
        if (((CharSequence)string4).length() == 0 && !this.isFocused()) {
            context2.getRenderContext().drawString(this.font, this.suggestion, 2, 2, -8355712, false);
        }
        if (this.isFocused()) {
            this.renderCursor(context2);
        }
        this.renderSelection(context2);
    }

    public void validateCursor() {
        this.cursor = Math.max(0, Math.min(this.text.get().length(), this.cursor));
    }

    private final void renderSelection(GuiImmediateContext context2) {
        int right;
        int left;
        block5: {
            block4: {
                if (this.selection == this.cursor || this.selection == -1) {
                    return;
                }
                left = Math.min(this.cursor, this.selection);
                right = Math.max(this.cursor, this.selection);
                if (right < this.scrollOffset) break block4;
                String string2 = this.visibleText;
                Intrinsics.checkNotNull(string2);
                if (left <= this.scrollOffset + string2.length()) break block5;
            }
            return;
        }
        int normalizedLeft = Math.max(this.scrollOffset, left) - this.scrollOffset;
        String string3 = this.visibleText;
        Intrinsics.checkNotNull(string3);
        int normalizedRight = Math.min(this.scrollOffset + string3.length(), right) - this.scrollOffset;
        String string4 = this.visibleText;
        Intrinsics.checkNotNull(string4);
        int leftPos = this.font.getStringWidth(this.safeSubString(string4, 0, normalizedLeft));
        String string5 = this.visibleText;
        Intrinsics.checkNotNull(string5);
        int rightPos = leftPos + this.font.getStringWidth(this.safeSubString(string5, normalizedLeft, normalizedRight));
        context2.getRenderContext().invertedRect(2 + leftPos, 2.0f, 2 + rightPos, this.getHeight() - 2);
    }

    private final void renderCursor(GuiImmediateContext context2) {
        if (System.currentTimeMillis() / (long)1000 % (long)2 == 0L) {
            return;
        }
        if (this.cursor < this.scrollOffset) {
            return;
        }
        String string2 = this.visibleText;
        Intrinsics.checkNotNull(string2);
        if (this.cursor > this.scrollOffset + string2.length()) {
            return;
        }
        String string3 = this.visibleText;
        Intrinsics.checkNotNull(string3);
        int cursorOffset = this.font.getStringWidth(this.safeSubString(string3, 0, this.cursor - this.scrollOffset));
        context2.getRenderContext().drawColoredRect(2 + cursorOffset, 2.0f, 2 + cursorOffset + 1, this.getHeight() - 2, -3092272);
    }

    private final void renderText(GuiImmediateContext context2, String visibleText) {
        Boolean bl = this.editable.get();
        Intrinsics.checkNotNullExpressionValue(bl, "editable.get()");
        int textColor = bl != false ? -2039584 : -9408400;
        context2.getRenderContext().drawString(this.font, visibleText, 2, 2, textColor, true);
    }

    private final void renderBox(GuiImmediateContext context2) {
        int borderColor = this.isFocused() ? -96 : -6250336;
        context2.getRenderContext().drawColoredRect(0.0f, 0.0f, this.width, this.getHeight(), borderColor);
        context2.getRenderContext().drawColoredRect(1.0f, 1.0f, this.width - 1, this.getHeight() - 1, -16777216);
    }

    @Override
    public boolean keyboardEvent(@NotNull KeyboardEvent event, @NotNull GuiImmediateContext context2) {
        Intrinsics.checkNotNullParameter(event, "event");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!this.editable.get().booleanValue()) {
            return false;
        }
        if (!this.isFocused()) {
            return false;
        }
        if (event instanceof KeyboardEvent.KeyPressed && ((KeyboardEvent.KeyPressed)event).getPressed()) {
            int n = ((KeyboardEvent.KeyPressed)event).getKeycode();
            if (n == KeyboardConstants.INSTANCE.getLeft()) {
                this.onDirectionalKey(context2, -1);
                return true;
            }
            if (n == KeyboardConstants.INSTANCE.getRight()) {
                this.onDirectionalKey(context2, 1);
                return true;
            }
            if (n == KeyboardConstants.INSTANCE.getHome() ? true : n == KeyboardConstants.INSTANCE.getUp()) {
                if (context2.getRenderContext().isShiftDown()) {
                    if (this.selection == -1) {
                        this.selection = this.cursor;
                    }
                } else {
                    this.selection = -1;
                }
                this.cursor = 0;
                this.scrollCursorIntoView();
                return true;
            }
            if (n == KeyboardConstants.INSTANCE.getDown() ? true : n == KeyboardConstants.INSTANCE.getEnd()) {
                if (context2.getRenderContext().isShiftDown()) {
                    if (this.selection == -1) {
                        this.selection = this.cursor;
                    }
                } else {
                    this.selection = -1;
                }
                this.cursor = this.text.get().length();
                this.scrollCursorIntoView();
                return true;
            }
            if (n == KeyboardConstants.INSTANCE.getBackSpace()) {
                if (this.selection == -1) {
                    this.selection = this.skipCharacters(context2.getRenderContext().isCtrlDown(), -1);
                }
                this.writeText("");
                return true;
            }
            if (n == KeyboardConstants.INSTANCE.getDelete()) {
                if (this.selection == -1) {
                    this.selection = this.skipCharacters(context2.getRenderContext().isCtrlDown(), 1);
                }
                this.writeText("");
                return true;
            }
            if (n == KeyboardConstants.INSTANCE.getKeyC()) {
                if (context2.getRenderContext().isCtrlDown()) {
                    ClipboardUtils.copyToClipboard(this.getSelection());
                    return true;
                }
                return false;
            }
            if (n == KeyboardConstants.INSTANCE.getKeyX()) {
                if (context2.getRenderContext().isCtrlDown()) {
                    ClipboardUtils.copyToClipboard(this.getSelection());
                    this.writeText("");
                    return true;
                }
                return false;
            }
            if (n == KeyboardConstants.INSTANCE.getKeyV()) {
                if (context2.getRenderContext().isCtrlDown()) {
                    String string2 = ClipboardUtils.getClipboardContent();
                    Intrinsics.checkNotNullExpressionValue(string2, "getClipboardContent()");
                    this.writeText(string2);
                    return true;
                }
                return false;
            }
            if (n == KeyboardConstants.INSTANCE.getKeyA()) {
                if (context2.getRenderContext().isCtrlDown()) {
                    this.cursor = this.text.get().length();
                    this.selection = 0;
                    this.scrollCursorIntoView();
                    return true;
                }
                return false;
            }
            return false;
        }
        if (event instanceof KeyboardEvent.CharTyped) {
            char it = ((KeyboardEvent.CharTyped)event).getChar();
            boolean anyWritten = false;
            if (Intrinsics.compare(it, 32) >= 0 && it != '\u00a7' && it != '\u007f') {
                char c = it;
                String string3 = "";
                this.writeText(c + string3);
                anyWritten = true;
            }
            return anyWritten;
        }
        return false;
    }

    private final String getSelection() {
        if (this.selection == -1) {
            return "";
        }
        int l = Math.min(this.cursor, this.selection);
        int r = Math.max(this.cursor, this.selection);
        String string2 = this.text.get();
        Intrinsics.checkNotNullExpressionValue(string2, "text.get()");
        return this.safeSubString(string2, l, r);
    }

    @Override
    public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context2) {
        Intrinsics.checkNotNullParameter(mouseEvent, "mouseEvent");
        Intrinsics.checkNotNullParameter(context2, "context");
        super.mouseEvent(mouseEvent, context2);
        if (context2.isHovered() && mouseEvent instanceof MouseEvent.Click && ((MouseEvent.Click)mouseEvent).getMouseState() && ((MouseEvent.Click)mouseEvent).getMouseButton() == 0) {
            this.requestFocus();
            return true;
        }
        return false;
    }

    private final String safeSubString(String str, int startIndex) {
        String string2 = str.substring(Math.min(startIndex, str.length()));
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
        return string2;
    }

    private final String safeSubString(String str, int startIndex, int endIndex) {
        String string2 = str.substring(Math.min(startIndex, str.length()), Math.min(Math.max(startIndex, endIndex), str.length()));
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string2;
    }

    public final void writeText(@NotNull String s) {
        Intrinsics.checkNotNullParameter(s, "s");
        String t = this.text.get();
        if (this.selection == -1) {
            StringBuilder stringBuilder = new StringBuilder();
            Intrinsics.checkNotNullExpressionValue(t, "t");
            this.text.set(stringBuilder.append(this.safeSubString(t, 0, this.cursor)).append(s).append(this.safeSubString(t, this.cursor)).toString());
            this.cursor += s.length();
        } else {
            int l = Math.min(this.cursor, this.selection);
            int r = Math.max(this.cursor, this.selection);
            StringBuilder stringBuilder = new StringBuilder();
            Intrinsics.checkNotNullExpressionValue(t, "t");
            this.text.set(stringBuilder.append(this.safeSubString(t, 0, l)).append(s).append(this.safeSubString(t, r)).toString());
            this.cursor = l + s.length();
            this.selection = -1;
        }
        this.scrollCursorIntoView();
    }

    public void onDirectionalKey(@NotNull GuiImmediateContext context2, int i2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        if (context2.getRenderContext().isShiftDown()) {
            if (this.selection == -1) {
                this.selection = this.cursor;
            }
            this.cursor = this.skipCharacters(context2.getRenderContext().isCtrlDown(), i2);
        } else if (this.selection != -1) {
            this.cursor = i2 < 0 ? Math.min(this.cursor, this.selection) : Math.max(this.cursor, this.selection);
            this.selection = -1;
        } else {
            this.cursor = this.skipCharacters(context2.getRenderContext().isCtrlDown(), i2);
        }
        this.scrollCursorIntoView();
    }

    private final int skipCharacters(boolean skipWords, int i2) {
        if (i2 != -1 && i2 != 1) {
            return this.cursor;
        }
        int position = this.cursor;
        do {
            if ((position += i2) < 0) {
                return 0;
            }
            if (position > this.text.get().length()) {
                return this.text.get().length();
            }
            if (skipWords) continue;
            return position;
        } while (position >= this.text.get().length() || !Character.isWhitespace(this.text.get().charAt(position)));
        return position;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006R\u0014\u0010\n\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0006R\u0014\u0010\f\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0006R\u0014\u0010\u000e\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lat/hannibal2/skyhanni/deps/moulconfig/gui/component/TextFieldComponent$Companion;", "", "<init>", "()V", "", "BACKGROUND_COLOR", "I", "BORDER_COLOR_SELECTED", "BORDER_COLOR_UNSELECTED", "CURSOR_COLOR", "DISABLED_COLOR", "ENABLED_COLOR", "SUGGESTION_COLOR", "TEXT_PADDING_X", "TEXT_PADDING_Y", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

