/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.gui.component;

import at.hannibal2.skyhanni.deps.moulconfig.common.NinePatches;
import at.hannibal2.skyhanni.deps.moulconfig.common.RenderContext;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiComponent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiImmediateContext;
import at.hannibal2.skyhanni.deps.moulconfig.gui.KeyboardEvent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.MouseEvent;
import java.util.function.BiFunction;

public class PanelComponent
extends GuiComponent {
    private final GuiComponent element;
    private final int insets;
    private final BackgroundRenderer backgroundRenderer;

    public PanelComponent(GuiComponent element, int insets, BackgroundRenderer backgroundRenderer) {
        this.element = element;
        this.insets = insets;
        this.backgroundRenderer = backgroundRenderer;
    }

    public PanelComponent(GuiComponent element) {
        this(element, 2, DefaultBackgroundRenderer.DARK_RECT);
    }

    @Override
    public <T> T foldChildren(T initial, BiFunction<GuiComponent, T, T> visitor2) {
        return visitor2.apply(this.element, (GuiComponent)initial);
    }

    @Override
    public int getWidth() {
        return this.element.getWidth() + this.insets * 2;
    }

    @Override
    public int getHeight() {
        return this.element.getHeight() + this.insets * 2 + 2;
    }

    protected GuiImmediateContext getChildContext(GuiImmediateContext context2) {
        return context2.translated(this.insets, this.insets, context2.getWidth() - this.insets * 2, context2.getHeight() - this.insets * 2 - 2);
    }

    @Override
    public void render(GuiImmediateContext context2) {
        context2.getRenderContext().pushMatrix();
        this.backgroundRenderer.render(context2.getRenderContext(), 0, 0, context2.getWidth(), context2.getHeight() - 2);
        context2.getRenderContext().translate(this.insets, this.insets, 0.0f);
        this.element.render(this.getChildContext(context2));
        context2.getRenderContext().popMatrix();
    }

    @Override
    public boolean keyboardEvent(KeyboardEvent event, GuiImmediateContext context2) {
        return this.element.keyboardEvent(event, this.getChildContext(context2));
    }

    @Override
    public boolean mouseEvent(MouseEvent mouseEvent, GuiImmediateContext context2) {
        return this.element.mouseEvent(mouseEvent, this.getChildContext(context2));
    }

    public GuiComponent getElement() {
        return this.element;
    }

    public int getInsets() {
        return this.insets;
    }

    public BackgroundRenderer getBackgroundRenderer() {
        return this.backgroundRenderer;
    }

    public static enum DefaultBackgroundRenderer implements BackgroundRenderer
    {
        DARK_RECT{

            @Override
            public void render(RenderContext renderContext, int x, int y, int width, int height) {
                renderContext.drawDarkRect(x, y, width, height);
            }
        }
        ,
        BUTTON{

            @Override
            public void render(RenderContext renderContext, int x, int y, int width, int height) {
                renderContext.drawNinePatch(NinePatches.INSTANCE.createButton(), x, y, width, height);
            }
        }
        ,
        VANILLA{

            @Override
            public void render(RenderContext renderContext, int x, int y, int width, int height) {
                renderContext.drawNinePatch(NinePatches.INSTANCE.createVanillaPanel(), x, y, width, height);
            }
        };

    }

    public static interface BackgroundRenderer {
        public void render(RenderContext var1, int var2, int var3, int var4, int var5);
    }
}

