/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.gui;

import at.hannibal2.skyhanni.deps.moulconfig.Overlay;
import at.hannibal2.skyhanni.deps.moulconfig.internal.TextRenderUtils;
import at.hannibal2.skyhanni.deps.moulconfig.processor.MoulConfigProcessor;
import at.hannibal2.skyhanni.deps.moulconfig.processor.ProcessedOption;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;

public class MoulGuiOverlayEditor
extends GuiScreen {
    final List<Overlay> overlays;
    final Map<Overlay, List<ProcessedOption>> processedOptions;
    Overlay grabbedOverlay;
    float grabbedOverlayAnchorX;
    float grabbedOverlayAnchorY;

    public MoulGuiOverlayEditor(List<Overlay> overlays, Map<Overlay, List<ProcessedOption>> processedOptions) {
        this.overlays = overlays;
        this.processedOptions = processedOptions;
    }

    public MoulGuiOverlayEditor(MoulConfigProcessor<?> testConfigMoulConfigProcessor) {
        this(testConfigMoulConfigProcessor.getAllOverlays(), testConfigMoulConfigProcessor.getOverlayOptions());
    }

    private boolean isOverlayHovered(Overlay overlay, int mouseX, int mouseY) {
        return overlay.getX() < (float)mouseX && (float)mouseX < overlay.getX() + overlay.getScaledWidth() && overlay.getY() < (float)mouseY && (float)mouseY < overlay.getY() + overlay.getScaledHeight();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_146276_q_();
        boolean hasHoveredAny = this.grabbedOverlay != null;
        for (Overlay overlay : this.overlays) {
            boolean hovered;
            if (!overlay.shouldShowInEditor()) continue;
            GlStateManager.func_179094_E();
            overlay.transform();
            boolean bl = hovered = overlay == this.grabbedOverlay;
            if (!hasHoveredAny && this.isOverlayHovered(overlay, mouseX, mouseY)) {
                hovered = true;
                hasHoveredAny = true;
            }
            MoulGuiOverlayEditor.func_73734_a((int)0, (int)0, (int)overlay.getWidth(), (int)overlay.getHeight(), (int)(hovered ? -1333755776 : -2146430960));
            TextRenderUtils.drawStringCenteredScaledMaxWidth(overlay.getName(), this.field_146297_k.field_71466_p, (float)overlay.getWidth() / 2.0f, (float)overlay.getHeight() / 2.0f, true, overlay.getWidth(), -1);
            GlStateManager.func_179121_F();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.tryGrabOverlay(mouseX, mouseY);
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (clickedMouseButton == 0) {
            this.tryMoveGrabbedOverlay(mouseX, mouseY);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        if (state == 0) {
            this.tryReleaseOverlay();
        }
    }

    public void tryGrabOverlay(int mouseX, int mouseY) {
        for (Overlay overlay : this.overlays) {
            if (!overlay.shouldShowInEditor() || !this.isOverlayHovered(overlay, mouseX, mouseY)) continue;
            this.grabbedOverlay = overlay;
            this.grabbedOverlayAnchorX = (float)mouseX - overlay.getX();
            this.grabbedOverlayAnchorY = (float)mouseY - overlay.getY();
            break;
        }
    }

    public void tryMoveGrabbedOverlay(int mouseX, int mouseY) {
        Overlay overlay = this.grabbedOverlay;
        if (overlay == null) {
            return;
        }
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        overlay.xPosition = ((float)mouseX - this.grabbedOverlayAnchorX) / (float)scaledResolution.func_78327_c();
        overlay.yPosition = ((float)mouseY - this.grabbedOverlayAnchorY) / (float)scaledResolution.func_78324_d();
    }

    public void tryReleaseOverlay() {
        this.grabbedOverlay = null;
    }
}

