/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.libautoupdate;

import at.hannibal2.skyhanni.deps.libautoupdate.GithubReleaseUpdateData;
import at.hannibal2.skyhanni.deps.libautoupdate.JsonUpdateSource;
import at.hannibal2.skyhanni.deps.libautoupdate.UpdateData;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.NonNull;

public class GithubReleaseUpdateSource
extends JsonUpdateSource {
    @NonNull
    final String owner;
    @NonNull
    final String repository;

    protected UpdateData selectUpdate(String updateStream, List<GithubRelease> releases) {
        if (Objects.equals("pre", updateStream)) {
            return this.findLatestRelease(releases.stream().filter(it -> !it.isDraft()).collect(Collectors.toList()));
        }
        if (Objects.equals("full", updateStream)) {
            return this.findLatestRelease(releases.stream().filter(it -> !it.isDraft() && !it.isPrerelease()).collect(Collectors.toList()));
        }
        return null;
    }

    protected UpdateData findAsset(GithubRelease release) {
        if (release.getAssets() == null) {
            return null;
        }
        return release.getAssets().stream().filter(it -> (Objects.equals(it.getContentType(), "application/x-java-archive") || it.getName() != null && it.getName().endsWith(".jar")) && it.getBrowserDownloadUrl() != null).map(it -> new GithubReleaseUpdateData(release.getName() == null ? release.getTagName() : release.getName(), (JsonElement)new JsonPrimitive(release.getTagName()), null, it.getBrowserDownloadUrl(), release.getBody(), release.getTargetCommitish(), release.getCreated_at(), release.getPublishedAt(), release.getHtmlUrl())).findFirst().orElse(null);
    }

    protected UpdateData findLatestRelease(Iterable<GithubRelease> validReleases) {
        return StreamSupport.stream(validReleases.spliterator(), false).max(Comparator.comparing(GithubRelease::getPublishedAt)).map(this::findAsset).orElse(null);
    }

    protected String getReleaseApiUrl() {
        return String.format("https://api.github.com/repos/%s/%s/releases", this.owner, this.repository);
    }

    @Override
    public CompletableFuture<UpdateData> checkUpdate(String updateStream) {
        CompletableFuture releases = this.getJsonFromURL(this.getReleaseApiUrl(), new TypeToken<List<GithubRelease>>(){}.getType());
        return releases.thenApply(it -> it == null ? null : this.selectUpdate(updateStream, (List<GithubRelease>)it));
    }

    public GithubReleaseUpdateSource(@NonNull String owner, @NonNull String repository) {
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        if (repository == null) {
            throw new NullPointerException("repository is marked non-null but is null");
        }
        this.owner = owner;
        this.repository = repository;
    }

    @NonNull
    public String getOwner() {
        return this.owner;
    }

    @NonNull
    public String getRepository() {
        return this.repository;
    }

    public String toString() {
        return "GithubReleaseUpdateSource(owner=" + this.getOwner() + ", repository=" + this.getRepository() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GithubReleaseUpdateSource)) {
            return false;
        }
        GithubReleaseUpdateSource other = (GithubReleaseUpdateSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$repository = this.getRepository();
        String other$repository = other.getRepository();
        return !(this$repository == null ? other$repository != null : !this$repository.equals(other$repository));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GithubReleaseUpdateSource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        String $owner = this.getOwner();
        result2 = result2 * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $repository = this.getRepository();
        result2 = result2 * 59 + ($repository == null ? 43 : $repository.hashCode());
        return result2;
    }

    public static class GithubRelease {
        @SerializedName(value="tag_name")
        String tagName;
        @SerializedName(value="target_commitish")
        String targetCommitish;
        String name;
        boolean draft = false;
        boolean prerelease = false;
        @SerializedName(value="created_at")
        Date created_at;
        @SerializedName(value="published_at")
        Date publishedAt;
        int id = 0;
        List<Download> assets;
        String body;
        @SerializedName(value="html_url")
        String htmlUrl;

        public String getTagName() {
            return this.tagName;
        }

        public String getTargetCommitish() {
            return this.targetCommitish;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDraft() {
            return this.draft;
        }

        public boolean isPrerelease() {
            return this.prerelease;
        }

        public Date getCreated_at() {
            return this.created_at;
        }

        public Date getPublishedAt() {
            return this.publishedAt;
        }

        public int getId() {
            return this.id;
        }

        public List<Download> getAssets() {
            return this.assets;
        }

        public String getBody() {
            return this.body;
        }

        public String getHtmlUrl() {
            return this.htmlUrl;
        }

        public void setTagName(String tagName) {
            this.tagName = tagName;
        }

        public void setTargetCommitish(String targetCommitish) {
            this.targetCommitish = targetCommitish;
        }

        public void setName(String name2) {
            this.name = name2;
        }

        public void setDraft(boolean draft) {
            this.draft = draft;
        }

        public void setPrerelease(boolean prerelease) {
            this.prerelease = prerelease;
        }

        public void setCreated_at(Date created_at) {
            this.created_at = created_at;
        }

        public void setPublishedAt(Date publishedAt) {
            this.publishedAt = publishedAt;
        }

        public void setId(int id) {
            this.id = id;
        }

        public void setAssets(List<Download> assets) {
            this.assets = assets;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public void setHtmlUrl(String htmlUrl) {
            this.htmlUrl = htmlUrl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GithubRelease)) {
                return false;
            }
            GithubRelease other = (GithubRelease)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isDraft() != other.isDraft()) {
                return false;
            }
            if (this.isPrerelease() != other.isPrerelease()) {
                return false;
            }
            if (this.getId() != other.getId()) {
                return false;
            }
            String this$tagName = this.getTagName();
            String other$tagName = other.getTagName();
            if (this$tagName == null ? other$tagName != null : !this$tagName.equals(other$tagName)) {
                return false;
            }
            String this$targetCommitish = this.getTargetCommitish();
            String other$targetCommitish = other.getTargetCommitish();
            if (this$targetCommitish == null ? other$targetCommitish != null : !this$targetCommitish.equals(other$targetCommitish)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Date this$created_at = this.getCreated_at();
            Date other$created_at = other.getCreated_at();
            if (this$created_at == null ? other$created_at != null : !((Object)this$created_at).equals(other$created_at)) {
                return false;
            }
            Date this$publishedAt = this.getPublishedAt();
            Date other$publishedAt = other.getPublishedAt();
            if (this$publishedAt == null ? other$publishedAt != null : !((Object)this$publishedAt).equals(other$publishedAt)) {
                return false;
            }
            List<Download> this$assets = this.getAssets();
            List<Download> other$assets = other.getAssets();
            if (this$assets == null ? other$assets != null : !((Object)this$assets).equals(other$assets)) {
                return false;
            }
            String this$body = this.getBody();
            String other$body = other.getBody();
            if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
                return false;
            }
            String this$htmlUrl = this.getHtmlUrl();
            String other$htmlUrl = other.getHtmlUrl();
            return !(this$htmlUrl == null ? other$htmlUrl != null : !this$htmlUrl.equals(other$htmlUrl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GithubRelease;
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            result2 = result2 * 59 + (this.isDraft() ? 79 : 97);
            result2 = result2 * 59 + (this.isPrerelease() ? 79 : 97);
            result2 = result2 * 59 + this.getId();
            String $tagName = this.getTagName();
            result2 = result2 * 59 + ($tagName == null ? 43 : $tagName.hashCode());
            String $targetCommitish = this.getTargetCommitish();
            result2 = result2 * 59 + ($targetCommitish == null ? 43 : $targetCommitish.hashCode());
            String $name = this.getName();
            result2 = result2 * 59 + ($name == null ? 43 : $name.hashCode());
            Date $created_at = this.getCreated_at();
            result2 = result2 * 59 + ($created_at == null ? 43 : ((Object)$created_at).hashCode());
            Date $publishedAt = this.getPublishedAt();
            result2 = result2 * 59 + ($publishedAt == null ? 43 : ((Object)$publishedAt).hashCode());
            List<Download> $assets = this.getAssets();
            result2 = result2 * 59 + ($assets == null ? 43 : ((Object)$assets).hashCode());
            String $body = this.getBody();
            result2 = result2 * 59 + ($body == null ? 43 : $body.hashCode());
            String $htmlUrl = this.getHtmlUrl();
            result2 = result2 * 59 + ($htmlUrl == null ? 43 : $htmlUrl.hashCode());
            return result2;
        }

        public String toString() {
            return "GithubReleaseUpdateSource.GithubRelease(tagName=" + this.getTagName() + ", targetCommitish=" + this.getTargetCommitish() + ", name=" + this.getName() + ", draft=" + this.isDraft() + ", prerelease=" + this.isPrerelease() + ", created_at=" + this.getCreated_at() + ", publishedAt=" + this.getPublishedAt() + ", id=" + this.getId() + ", assets=" + this.getAssets() + ", body=" + this.getBody() + ", htmlUrl=" + this.getHtmlUrl() + ")";
        }

        public static class Download {
            int id = 0;
            String name;
            @SerializedName(value="content_type")
            String contentType;
            String label;
            @SerializedName(value="browser_download_url")
            String browserDownloadUrl;

            public int getId() {
                return this.id;
            }

            public String getName() {
                return this.name;
            }

            public String getContentType() {
                return this.contentType;
            }

            public String getLabel() {
                return this.label;
            }

            public String getBrowserDownloadUrl() {
                return this.browserDownloadUrl;
            }

            public void setId(int id) {
                this.id = id;
            }

            public void setName(String name2) {
                this.name = name2;
            }

            public void setContentType(String contentType) {
                this.contentType = contentType;
            }

            public void setLabel(String label) {
                this.label = label;
            }

            public void setBrowserDownloadUrl(String browserDownloadUrl) {
                this.browserDownloadUrl = browserDownloadUrl;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Download)) {
                    return false;
                }
                Download other = (Download)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getId() != other.getId()) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$contentType = this.getContentType();
                String other$contentType = other.getContentType();
                if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
                    return false;
                }
                String this$label = this.getLabel();
                String other$label = other.getLabel();
                if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                    return false;
                }
                String this$browserDownloadUrl = this.getBrowserDownloadUrl();
                String other$browserDownloadUrl = other.getBrowserDownloadUrl();
                return !(this$browserDownloadUrl == null ? other$browserDownloadUrl != null : !this$browserDownloadUrl.equals(other$browserDownloadUrl));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Download;
            }

            public int hashCode() {
                int PRIME = 59;
                int result2 = 1;
                result2 = result2 * 59 + this.getId();
                String $name = this.getName();
                result2 = result2 * 59 + ($name == null ? 43 : $name.hashCode());
                String $contentType = this.getContentType();
                result2 = result2 * 59 + ($contentType == null ? 43 : $contentType.hashCode());
                String $label = this.getLabel();
                result2 = result2 * 59 + ($label == null ? 43 : $label.hashCode());
                String $browserDownloadUrl = this.getBrowserDownloadUrl();
                result2 = result2 * 59 + ($browserDownloadUrl == null ? 43 : $browserDownloadUrl.hashCode());
                return result2;
            }

            public String toString() {
                return "GithubReleaseUpdateSource.GithubRelease.Download(id=" + this.getId() + ", name=" + this.getName() + ", contentType=" + this.getContentType() + ", label=" + this.getLabel() + ", browserDownloadUrl=" + this.getBrowserDownloadUrl() + ")";
            }
        }
    }
}

