/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.discordipc.entities.pipe;

import at.hannibal2.skyhanni.deps.discordipc.IPCClient;
import at.hannibal2.skyhanni.deps.discordipc.entities.Callback;
import at.hannibal2.skyhanni.deps.discordipc.entities.Packet;
import at.hannibal2.skyhanni.deps.discordipc.entities.pipe.Pipe;
import at.hannibal2.skyhanni.deps.discordipc.entities.pipe.PipeStatus;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;

public class WindowsPipe
extends Pipe {
    public RandomAccessFile file;

    WindowsPipe(IPCClient ipcClient, HashMap<String, Callback> callbacks, String location) {
        super(ipcClient, callbacks);
        try {
            this.file = new RandomAccessFile(location, "rw");
        }
        catch (FileNotFoundException e) {
            this.file = null;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.file.write(b);
    }

    @Override
    public Packet read() throws IOException, JsonParseException {
        while ((this.status == PipeStatus.CONNECTED || this.status == PipeStatus.CLOSING) && this.file.length() == 0L) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.status == PipeStatus.DISCONNECTED) {
            throw new IOException("Disconnected!");
        }
        if (this.status == PipeStatus.CLOSED) {
            return new Packet(Packet.OpCode.CLOSE, null, this.ipcClient.getEncoding());
        }
        Packet.OpCode op = Packet.OpCode.values()[Integer.reverseBytes(this.file.readInt())];
        int len = Integer.reverseBytes(this.file.readInt());
        byte[] d = new byte[len];
        this.file.readFully(d);
        JsonObject packetData = new JsonObject();
        packetData.addProperty("", new String(d));
        Packet p = new Packet(op, packetData, this.ipcClient.getEncoding());
        if (this.ipcClient.isDebugMode()) {
            System.out.println(String.format("Received packet: %s", p.toString()));
        }
        if (this.listener != null) {
            this.listener.onPacketReceived(this.ipcClient, p);
        }
        return p;
    }

    @Override
    public void close() throws IOException {
        if (this.ipcClient.isDebugMode()) {
            System.out.println("Closing IPC pipe...");
        }
        this.status = PipeStatus.CLOSING;
        this.send(Packet.OpCode.CLOSE, new JsonObject(), null);
        this.status = PipeStatus.CLOSED;
        this.file.close();
    }
}

