/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.discordipc.entities.pipe;

import at.hannibal2.skyhanni.deps.discordipc.IPCClient;
import at.hannibal2.skyhanni.deps.discordipc.entities.Callback;
import at.hannibal2.skyhanni.deps.discordipc.entities.Packet;
import at.hannibal2.skyhanni.deps.discordipc.entities.pipe.Pipe;
import at.hannibal2.skyhanni.deps.discordipc.entities.pipe.PipeStatus;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.newsclub.net.unix.AFInputStream;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;

public class UnixPipe
extends Pipe {
    private final AFUNIXSocket socket = AFUNIXSocket.newInstance();

    UnixPipe(IPCClient ipcClient, HashMap<String, Callback> callbacks, String location) throws IOException {
        super(ipcClient, callbacks);
        this.socket.connect(AFUNIXSocketAddress.of(new File(location)));
    }

    @Override
    public Packet read() throws IOException, JsonParseException {
        AFInputStream is = this.socket.getInputStream();
        while ((this.status == PipeStatus.CONNECTED || this.status == PipeStatus.CLOSING) && is.available() == 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.status == PipeStatus.DISCONNECTED) {
            throw new IOException("Disconnected!");
        }
        if (this.status == PipeStatus.CLOSED) {
            return new Packet(Packet.OpCode.CLOSE, null, this.ipcClient.getEncoding());
        }
        byte[] d = new byte[8];
        int readResult = is.read(d);
        ByteBuffer bb = ByteBuffer.wrap(d);
        if (this.ipcClient.isDebugMode()) {
            System.out.println(String.format("Read Byte Data: %s with result %s", new String(d), readResult));
        }
        Packet.OpCode op = Packet.OpCode.values()[Integer.reverseBytes(bb.getInt())];
        d = new byte[Integer.reverseBytes(bb.getInt())];
        int reversedResult = is.read(d);
        if (this.ipcClient.isDebugMode()) {
            System.out.println(String.format("Read Reversed Byte Data: %s with result %s", new String(d), reversedResult));
        }
        JsonObject packetData = new JsonObject();
        packetData.addProperty("", new String(d));
        Packet p = new Packet(op, packetData, this.ipcClient.getEncoding());
        if (this.ipcClient.isDebugMode()) {
            System.out.println(String.format("Received packet: %s", p.toString()));
        }
        if (this.listener != null) {
            this.listener.onPacketReceived(this.ipcClient, p);
        }
        return p;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.socket.getOutputStream().write(b);
    }

    @Override
    public void close() throws IOException {
        if (this.ipcClient.isDebugMode()) {
            System.out.println("Closing IPC pipe...");
        }
        this.status = PipeStatus.CLOSING;
        this.send(Packet.OpCode.CLOSE, new JsonObject(), null);
        this.status = PipeStatus.CLOSED;
        this.socket.close();
    }
}

