/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.discordipc.entities.pipe;

import at.hannibal2.skyhanni.deps.discordipc.IPCClient;
import at.hannibal2.skyhanni.deps.discordipc.IPCListener;
import at.hannibal2.skyhanni.deps.discordipc.entities.Callback;
import at.hannibal2.skyhanni.deps.discordipc.entities.DiscordBuild;
import at.hannibal2.skyhanni.deps.discordipc.entities.Packet;
import at.hannibal2.skyhanni.deps.discordipc.entities.User;
import at.hannibal2.skyhanni.deps.discordipc.entities.pipe.PipeStatus;
import at.hannibal2.skyhanni.deps.discordipc.entities.pipe.UnixPipe;
import at.hannibal2.skyhanni.deps.discordipc.entities.pipe.WindowsPipe;
import at.hannibal2.skyhanni.deps.discordipc.exceptions.NoDiscordClientException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;

public abstract class Pipe {
    private static final int VERSION = 1;
    private static final String[] unixPaths = new String[]{"XDG_RUNTIME_DIR", "TMPDIR", "TMP", "TEMP"};
    final IPCClient ipcClient;
    private final HashMap<String, Callback> callbacks;
    PipeStatus status = PipeStatus.CONNECTING;
    IPCListener listener;
    private DiscordBuild build;
    private User currentUser;

    Pipe(IPCClient ipcClient, HashMap<String, Callback> callbacks) {
        this.ipcClient = ipcClient;
        this.callbacks = callbacks;
    }

    public static Pipe openPipe(IPCClient ipcClient, long clientId, HashMap<String, Callback> callbacks, DiscordBuild ... preferredOrder) throws NoDiscordClientException {
        int i2;
        if (preferredOrder == null || preferredOrder.length == 0) {
            preferredOrder = new DiscordBuild[]{DiscordBuild.ANY};
        }
        Pipe pipe = null;
        Pipe[] open = new Pipe[DiscordBuild.values().length];
        for (i2 = 0; i2 < 10; ++i2) {
            try {
                String location = Pipe.getPipeLocation(i2);
                if (ipcClient.isDebugMode()) {
                    System.out.println(String.format("Searching for IPC: %s", location));
                }
                if ((pipe = Pipe.createPipe(ipcClient, callbacks, location)) == null) continue;
                JsonObject finalObject = new JsonObject();
                finalObject.addProperty("v", (Number)1);
                finalObject.addProperty("client_id", Long.toString(clientId));
                pipe.send(Packet.OpCode.HANDSHAKE, finalObject, null);
                Packet p = pipe.read();
                JsonObject parsedData = new JsonParser().parse(p.getJson().getAsJsonPrimitive("").getAsString()).getAsJsonObject();
                JsonObject data2 = parsedData.getAsJsonObject("data");
                JsonObject userData = data2.getAsJsonObject("user");
                pipe.build = DiscordBuild.from(data2.getAsJsonObject("config").get("api_endpoint").getAsString());
                pipe.currentUser = new User(userData.getAsJsonPrimitive("username").getAsString(), userData.getAsJsonPrimitive("discriminator").getAsString(), Long.parseLong(userData.getAsJsonPrimitive("id").getAsString()), userData.has("avatar") ? userData.getAsJsonPrimitive("avatar").getAsString() : null);
                if (ipcClient.isDebugMode()) {
                    System.out.println(String.format("Found a valid client (%s) with packet: %s", pipe.build.name(), p.toString()));
                    System.out.println(String.format("Found a valid user (%s) with id: %s", pipe.currentUser.getName(), pipe.currentUser.getId()));
                }
                if (pipe.build == preferredOrder[0] || DiscordBuild.ANY == preferredOrder[0]) {
                    if (!ipcClient.isDebugMode()) break;
                    System.out.println(String.format("Found preferred client: %s", pipe.build.name()));
                    break;
                }
                open[pipe.build.ordinal()] = pipe;
                open[DiscordBuild.ANY.ordinal()] = pipe;
                pipe.build = null;
                pipe = null;
                continue;
            }
            catch (JsonParseException | IOException ex) {
                pipe = null;
            }
        }
        if (pipe == null) {
            for (i2 = 1; i2 < preferredOrder.length; ++i2) {
                DiscordBuild cb = preferredOrder[i2];
                if (ipcClient.isDebugMode()) {
                    System.out.println(String.format("Looking for client build: %s", cb.name()));
                }
                if (open[cb.ordinal()] == null) continue;
                pipe = open[cb.ordinal()];
                open[cb.ordinal()] = null;
                if (cb == DiscordBuild.ANY) {
                    for (int k = 0; k < open.length; ++k) {
                        if (open[k] != pipe) continue;
                        pipe.build = DiscordBuild.values()[k];
                        open[k] = null;
                    }
                } else {
                    pipe.build = cb;
                }
                if (!ipcClient.isDebugMode()) break;
                System.out.println(String.format("Found preferred client: %s", pipe.build.name()));
                break;
            }
            if (pipe == null) {
                throw new NoDiscordClientException();
            }
        }
        for (i2 = 0; i2 < open.length; ++i2) {
            if (i2 == DiscordBuild.ANY.ordinal() || open[i2] == null) continue;
            try {
                open[i2].close();
                continue;
            }
            catch (IOException ex) {
                if (!ipcClient.isDebugMode()) continue;
                System.out.println(String.format("Failed to close an open IPC pipe: %s", ex));
            }
        }
        pipe.status = PipeStatus.CONNECTED;
        return pipe;
    }

    private static Pipe createPipe(IPCClient ipcClient, HashMap<String, Callback> callbacks, String location) {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            WindowsPipe attemptedPipe = new WindowsPipe(ipcClient, callbacks, location);
            return attemptedPipe.file != null ? attemptedPipe : null;
        }
        if (osName.contains("linux") || osName.contains("mac")) {
            try {
                return new UnixPipe(ipcClient, callbacks, location);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Unsupported OS: " + osName);
    }

    private static String generateNonce() {
        return UUID.randomUUID().toString();
    }

    private static String getPipeLocation(int i2) {
        String str;
        if (System.getProperty("os.name").contains("Win")) {
            return "\\\\?\\pipe\\discord-ipc-" + i2;
        }
        String tmppath = null;
        String[] stringArray = unixPaths;
        int n = stringArray.length;
        for (int j = 0; j < n && (tmppath = System.getenv(str = stringArray[j])) == null; ++j) {
        }
        if (tmppath == null) {
            tmppath = "/tmp";
        }
        return tmppath + "/discord-ipc-" + i2;
    }

    public void send(Packet.OpCode op, JsonObject data2, Callback callback) {
        try {
            String nonce = Pipe.generateNonce();
            data2.addProperty("nonce", nonce);
            Packet p = new Packet(op, data2, this.ipcClient.getEncoding());
            if (callback != null && !callback.isEmpty()) {
                this.callbacks.put(nonce, callback);
            }
            this.write(p.toBytes());
            if (this.ipcClient.isDebugMode()) {
                System.out.println(String.format("Sent packet: %s", p.toString()));
            }
            if (this.listener != null) {
                this.listener.onPacketSent(this.ipcClient, p);
            }
        }
        catch (IOException ex) {
            System.out.println("Encountered an IOException while sending a packet and disconnected!");
            this.status = PipeStatus.DISCONNECTED;
        }
    }

    public abstract Packet read() throws IOException, JsonParseException;

    public abstract void write(byte[] var1) throws IOException;

    public PipeStatus getStatus() {
        return this.status;
    }

    public void setStatus(PipeStatus status) {
        this.status = status;
    }

    public void setListener(IPCListener listener) {
        this.listener = listener;
    }

    public abstract void close() throws IOException;

    public DiscordBuild getDiscordBuild() {
        return this.build;
    }

    public User getCurrentUser() {
        return this.currentUser;
    }
}

