/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data.repo;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011JG\u0010\u001b\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00152\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00172\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u001d\u0010\u0003J\u000f\u0010\u001e\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u001e\u0010\u0003\u00a8\u0006\u001f"}, d2={"Lat/hannibal2/skyhanni/data/repo/RepoUtils;", "", "<init>", "()V", "Ljava/io/File;", "file", "", "recursiveDelete", "(Ljava/io/File;)V", "", "zipFilePath", "destinationDirectory", "unzipIgnoreFirstFolder", "(Ljava/lang/String;Ljava/lang/String;)V", "rootDirectory", "", "isInTree", "(Ljava/io/File;Ljava/io/File;)Z", "T", "repoLocation", "constant", "Lcom/google/gson/Gson;", "gson", "Ljava/lang/Class;", "clazz", "Ljava/lang/reflect/Type;", "type", "getConstant", "(Ljava/io/File;Ljava/lang/String;Lcom/google/gson/Gson;Ljava/lang/Class;Ljava/lang/reflect/Type;)Ljava/lang/Object;", "updateRepo", "resetRepoLocation", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nRepoUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepoUtils.kt\nat/hannibal2/skyhanni/data/repo/RepoUtils\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n37#2,2:119\n1#3:121\n*S KotlinDebug\n*F\n+ 1 RepoUtils.kt\nat/hannibal2/skyhanni/data/repo/RepoUtils\n*L\n45#1:119,2\n*E\n"})
public final class RepoUtils {
    @NotNull
    public static final RepoUtils INSTANCE = new RepoUtils();

    private RepoUtils() {
    }

    public final void recursiveDelete(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        if (file.isDirectory() && !Files.isSymbolicLink(file.toPath())) {
            Iterator<File> iterator2 = ArrayIteratorKt.iterator(file.listFiles());
            while (iterator2.hasNext()) {
                File child = iterator2.next();
                Intrinsics.checkNotNull(child);
                this.recursiveDelete(child);
            }
        }
        file.delete();
    }

    public final void unzipIgnoreFirstFolder(@NotNull String zipFilePath, @NotNull String destinationDirectory) {
        Intrinsics.checkNotNullParameter(zipFilePath, "zipFilePath");
        Intrinsics.checkNotNullParameter(destinationDirectory, "destinationDirectory");
        File dir = new File(destinationDirectory);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        FileInputStream fis = null;
        byte[] buffer = new byte[1024];
        try {
            fis = new FileInputStream(zipFilePath);
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                if (!ze.isDirectory()) {
                    Object fileName;
                    String[] stringArray = fileName = ze.getName();
                    Intrinsics.checkNotNull(stringArray);
                    String[] stringArray2 = fileName;
                    Intrinsics.checkNotNull(stringArray2);
                    CharSequence charSequence = (CharSequence)stringArray2;
                    stringArray2 = new String[]{"/"};
                    Collection $this$toTypedArray$iv22 = StringsKt.split$default(charSequence, stringArray2, false, 0, 6, null);
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv22;
                    int $this$toTypedArray$iv22 = thisCollection$iv.toArray(new String[0])[0].length() + 1;
                    String string2 = stringArray.substring($this$toTypedArray$iv22);
                    Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                    fileName = string2;
                    File newFile = new File(destinationDirectory + File.separator + (String)fileName);
                    new File(newFile.getParent()).mkdirs();
                    if (!this.isInTree(dir, newFile)) {
                        throw new RuntimeException("SkyHanni detected an invalid zip file. This is a potential security risk, please report this on the SkyHanni discord.");
                    }
                    FileOutputStream fos = new FileOutputStream(newFile);
                    int len = 0;
                    while (true) {
                        int n;
                        int it = n = zis.read(buffer);
                        boolean bl = false;
                        len = it;
                        if (n <= 0) break;
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                zis.closeEntry();
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
            fis.close();
        }
        catch (IOException e) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("zipFilePath", zipFilePath), TuplesKt.to("destinationDirectory", destinationDirectory)};
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "unzipIgnoreFirstFolder failed", pairArray, false, false, false, 56, null);
        }
    }

    private final boolean isInTree(File rootDirectory, File file) throws IOException {
        File rootDirectory2 = rootDirectory;
        File file2 = file;
        Intrinsics.checkNotNull(file2);
        rootDirectory2 = rootDirectory2.getCanonicalFile();
        for (file2 = (v103710).getCanonicalFile(); file2 != null; file2 = file2.getParentFile()) {
            if (!Intrinsics.areEqual(file2, rootDirectory2)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T getConstant(@NotNull File repoLocation, @NotNull String constant, @NotNull Gson gson2, @Nullable Class<T> clazz, @Nullable Type type2) {
        Intrinsics.checkNotNullParameter(repoLocation, "repoLocation");
        Intrinsics.checkNotNullParameter(constant, "constant");
        Intrinsics.checkNotNullParameter(gson2, "gson");
        String name2 = "constants/" + constant + ".json";
        File jsonFile = new File(repoLocation, name2);
        if (!jsonFile.isFile()) {
            throw new RepoError("Repo file '" + name2 + "' not found.");
        }
        Closeable closeable = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(jsonFile), StandardCharsets.UTF_8));
        Throwable throwable = null;
        try {
            BufferedReader reader = (BufferedReader)closeable;
            boolean bl = false;
            if (type2 == null) {
                Object object = gson2.fromJson((Reader)reader, clazz);
                return (T)object;
            }
            Object object = gson2.fromJson((Reader)reader, type2);
            return (T)object;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    public static /* synthetic */ Object getConstant$default(RepoUtils repoUtils, File file, String string2, Gson gson2, Class clazz, Type type2, int n, Object object) {
        if ((n & 0x10) != 0) {
            type2 = null;
        }
        return repoUtils.getConstant(file, string2, gson2, clazz, type2);
    }

    @JvmStatic
    public static final void updateRepo() {
        SkyHanniMod.Companion.getRepo().updateRepo();
    }

    @JvmStatic
    public static final void resetRepoLocation() {
        SkyHanniMod.Companion.getRepo().resetRepositoryLocation(true);
    }
}

