/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.events.InventoryUpdatedEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.events.minecraft.packet.PacketReceivedEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2DPacketOpenWindow;
import net.minecraft.network.play.server.S2EPacketCloseWindow;
import net.minecraft.network.play.server.S2FPacketSetSlot;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lat/hannibal2/skyhanni/data/OtherInventoryData;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$CloseWindowEvent;", "event", "", "onCloseWindow", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$CloseWindowEvent;)V", "", "reopenSameName", "close", "(Z)V", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/packet/PacketReceivedEvent;", "onInventoryDataReceiveEvent", "(Lat/hannibal2/skyhanni/events/minecraft/packet/PacketReceivedEvent;)V", "Lat/hannibal2/skyhanni/data/OtherInventoryData$Inventory;", "inventory", "done", "(Lat/hannibal2/skyhanni/data/OtherInventoryData$Inventory;)V", "currentInventory", "Lat/hannibal2/skyhanni/data/OtherInventoryData$Inventory;", "acceptItems", "Z", "Lat/hannibal2/skyhanni/events/InventoryUpdatedEvent;", "lateEvent", "Lat/hannibal2/skyhanni/events/InventoryUpdatedEvent;", "Inventory", "1.8.9"})
public final class OtherInventoryData {
    @NotNull
    public static final OtherInventoryData INSTANCE = new OtherInventoryData();
    @Nullable
    private static Inventory currentInventory;
    private static boolean acceptItems;
    @Nullable
    private static InventoryUpdatedEvent lateEvent;

    private OtherInventoryData() {
    }

    @SubscribeEvent
    public final void onCloseWindow(@NotNull GuiContainerEvent.CloseWindowEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        OtherInventoryData.close$default(this, false, 1, null);
    }

    public final void close(boolean reopenSameName) {
        new InventoryCloseEvent(reopenSameName).postAndCatch();
        currentInventory = null;
    }

    public static /* synthetic */ void close$default(OtherInventoryData otherInventoryData, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        otherInventoryData.close(bl);
    }

    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, "event");
            InventoryUpdatedEvent inventoryUpdatedEvent = lateEvent;
            if (inventoryUpdatedEvent == null) break block0;
            InventoryUpdatedEvent it = inventoryUpdatedEvent;
            boolean bl = false;
            it.postAndCatch();
            lateEvent = null;
        }
    }

    @HandleEvent
    public final void onInventoryDataReceiveEvent(@NotNull PacketReceivedEvent event) {
        block12: {
            Intrinsics.checkNotNullParameter(event, "event");
            Packet<?> packet = event.getPacket();
            if (packet instanceof S2EPacketCloseWindow) {
                OtherInventoryData.close$default(this, false, 1, null);
            }
            if (packet instanceof S2DPacketOpenWindow) {
                int windowId = ((S2DPacketOpenWindow)packet).func_148901_c();
                String title = ((S2DPacketOpenWindow)packet).func_179840_c().func_150260_c();
                int slotCount = ((S2DPacketOpenWindow)packet).func_148898_f();
                Inventory inventory = currentInventory;
                this.close(Intrinsics.areEqual(title, inventory != null ? inventory.getTitle() : null));
                Intrinsics.checkNotNull(title);
                currentInventory = new Inventory(windowId, title, slotCount, null, false, 24, null);
                acceptItems = true;
            }
            if (!(packet instanceof S2FPacketSetSlot)) break block12;
            if (!acceptItems) {
                Inventory inventory = currentInventory;
                if (inventory != null) {
                    ItemStack itemStack2;
                    Inventory it = inventory;
                    boolean bl = false;
                    if (it.getWindowId() != ((S2FPacketSetSlot)packet).func_149175_c()) {
                        return;
                    }
                    int slot = ((S2FPacketSetSlot)packet).func_149173_d();
                    if (slot < it.getSlotCount() && (itemStack2 = ((S2FPacketSetSlot)packet).func_149174_e()) != null) {
                        Integer n = slot;
                        it.getItems().put(n, itemStack2);
                        lateEvent = new InventoryUpdatedEvent(it);
                    }
                }
                return;
            }
            Inventory inventory = currentInventory;
            if (inventory != null) {
                Inventory it = inventory;
                boolean bl = false;
                if (it.getWindowId() != ((S2FPacketSetSlot)packet).func_149175_c()) {
                    return;
                }
                int slot = ((S2FPacketSetSlot)packet).func_149173_d();
                if (slot < it.getSlotCount()) {
                    ItemStack itemStack3 = ((S2FPacketSetSlot)packet).func_149174_e();
                    if (itemStack3 != null) {
                        Integer n = slot;
                        it.getItems().put(n, itemStack3);
                    }
                } else {
                    INSTANCE.done(it);
                    return;
                }
                if (it.getItems().size() == it.getSlotCount()) {
                    INSTANCE.done(it);
                }
            }
        }
    }

    private final void done(Inventory inventory) {
        new InventoryFullyOpenedEvent(inventory).postAndCatch();
        inventory.setFullyOpenedOnce(true);
        new InventoryUpdatedEvent(inventory).postAndCatch();
        acceptItems = false;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u000e\u001a\u0004\b\u0014\u0010\u0010R#\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u00078\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\"\u0010\u000b\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lat/hannibal2/skyhanni/data/OtherInventoryData$Inventory;", "", "", "windowId", "", "title", "slotCount", "", "Lnet/minecraft/item/ItemStack;", "items", "", "fullyOpenedOnce", "<init>", "(ILjava/lang/String;ILjava/util/Map;Z)V", "I", "getWindowId", "()I", "Ljava/lang/String;", "getTitle", "()Ljava/lang/String;", "getSlotCount", "Ljava/util/Map;", "getItems", "()Ljava/util/Map;", "Z", "getFullyOpenedOnce", "()Z", "setFullyOpenedOnce", "(Z)V", "1.8.9"})
    public static final class Inventory {
        private final int windowId;
        @NotNull
        private final String title;
        private final int slotCount;
        @NotNull
        private final Map<Integer, ItemStack> items;
        private boolean fullyOpenedOnce;

        public Inventory(int windowId, @NotNull String title, int slotCount, @NotNull Map<Integer, ItemStack> items, boolean fullyOpenedOnce) {
            Intrinsics.checkNotNullParameter(title, "title");
            Intrinsics.checkNotNullParameter(items, "items");
            this.windowId = windowId;
            this.title = title;
            this.slotCount = slotCount;
            this.items = items;
            this.fullyOpenedOnce = fullyOpenedOnce;
        }

        public /* synthetic */ Inventory(int n, String string2, int n2, Map map2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 8) != 0) {
                map2 = new LinkedHashMap();
            }
            if ((n3 & 0x10) != 0) {
                bl = false;
            }
            this(n, string2, n2, map2, bl);
        }

        public final int getWindowId() {
            return this.windowId;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        public final int getSlotCount() {
            return this.slotCount;
        }

        @NotNull
        public final Map<Integer, ItemStack> getItems() {
            return this.items;
        }

        public final boolean getFullyOpenedOnce() {
            return this.fullyOpenedOnce;
        }

        public final void setFullyOpenedOnce(boolean bl) {
            this.fullyOpenedOnce = bl;
        }
    }
}

