/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.events.ItemInHandChangeEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.PlaySoundEvent;
import at.hannibal2.skyhanni.events.ReceiveParticleEvent;
import at.hannibal2.skyhanni.events.minecraft.packet.PacketReceivedEvent;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S29PacketSoundEffect;
import net.minecraft.network.play.server.S2APacketParticles;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\f\u0010\bJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u000e\u0010\u0011J\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\n\u0010\u0013R\"\u0010\u0015\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lat/hannibal2/skyhanni/data/MinecraftData;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/minecraft/packet/PacketReceivedEvent;", "event", "", "onSoundPacket", "(Lat/hannibal2/skyhanni/events/minecraft/packet/PacketReceivedEvent;)V", "Lnet/minecraftforge/event/world/WorldEvent$Load;", "onWorldChange", "(Lnet/minecraftforge/event/world/WorldEvent$Load;)V", "onParticlePacketReceive", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$ClientTickEvent;", "onTick", "(Lnet/minecraftforge/fml/common/gameevent/TickEvent$ClientTickEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "", "totalTicks", "I", "getTotalTicks", "()I", "setTotalTicks", "(I)V", "1.8.9"})
public final class MinecraftData {
    @NotNull
    public static final MinecraftData INSTANCE = new MinecraftData();
    private static int totalTicks;

    private MinecraftData() {
    }

    @HandleEvent(onlyOnSkyblock=true, receiveCancelled=true)
    public final void onSoundPacket(@NotNull PacketReceivedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Packet<?> packet = event.getPacket();
        if (!(packet instanceof S29PacketSoundEffect)) {
            return;
        }
        String string2 = ((S29PacketSoundEffect)packet).func_149212_c();
        Intrinsics.checkNotNullExpressionValue(string2, "getSoundName(...)");
        if (new PlaySoundEvent(string2, new LorenzVec(((S29PacketSoundEffect)packet).func_149207_d(), ((S29PacketSoundEffect)packet).func_149211_e(), ((S29PacketSoundEffect)packet).func_149210_f()), ((S29PacketSoundEffect)packet).func_149209_h(), ((S29PacketSoundEffect)packet).func_149208_g()).postAndCatch()) {
            event.cancel();
        }
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull WorldEvent.Load event) {
        Intrinsics.checkNotNullParameter(event, "event");
        new LorenzWorldChangeEvent().postAndCatch();
    }

    @HandleEvent(onlyOnSkyblock=true, receiveCancelled=true)
    public final void onParticlePacketReceive(@NotNull PacketReceivedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Packet<?> packet = event.getPacket();
        if (!(packet instanceof S2APacketParticles)) {
            return;
        }
        EnumParticleTypes enumParticleTypes = ((S2APacketParticles)packet).func_179749_a();
        Intrinsics.checkNotNull(enumParticleTypes);
        LorenzVec lorenzVec = new LorenzVec(((S2APacketParticles)packet).func_149220_d(), ((S2APacketParticles)packet).func_149226_e(), ((S2APacketParticles)packet).func_149225_f());
        int n = ((S2APacketParticles)packet).func_149222_k();
        float f = ((S2APacketParticles)packet).func_149227_j();
        LorenzVec lorenzVec2 = new LorenzVec(((S2APacketParticles)packet).func_149221_g(), ((S2APacketParticles)packet).func_149224_h(), ((S2APacketParticles)packet).func_149223_i());
        boolean bl = ((S2APacketParticles)packet).func_179750_b();
        int[] nArray = ((S2APacketParticles)packet).func_179748_k();
        Intrinsics.checkNotNullExpressionValue(nArray, "getParticleArgs(...)");
        if (new ReceiveParticleEvent(enumParticleTypes, lorenzVec, n, f, lorenzVec2, bl, nArray).postAndCatch()) {
            event.cancel();
        }
    }

    public final int getTotalTicks() {
        return totalTicks;
    }

    public final void setTotalTicks(int n) {
        totalTicks = n;
    }

    @SubscribeEvent
    public final void onTick(@NotNull TickEvent.ClientTickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        DelayedRun.INSTANCE.checkRuns();
        int n = totalTicks;
        totalTicks = n + 1;
        new LorenzTickEvent(totalTicks).postAndCatch();
    }

    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        NEUInternalName oldItem;
        Object newItem;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        ItemStack hand = InventoryUtils.INSTANCE.getItemInHand();
        Object object = hand;
        if (object == null || (object = ItemUtils.INSTANCE.getInternalName((ItemStack)object)) == null) {
            object = NEUInternalName.Companion.getNONE();
        }
        if (!Intrinsics.areEqual(newItem = object, oldItem = InventoryUtils.INSTANCE.getItemInHandId())) {
            InventoryUtils.INSTANCE.getRecentItemsInHand().keySet().removeIf(arg_0 -> MinecraftData.onTick$lambda$1(MinecraftData::onTick$lambda$0, arg_0));
            if (!Intrinsics.areEqual(newItem, NEUInternalName.Companion.getNONE())) {
                InventoryUtils.INSTANCE.getRecentItemsInHand().put(System.currentTimeMillis(), (NEUInternalName)newItem);
            }
            InventoryUtils.INSTANCE.setItemInHandId((NEUInternalName)newItem);
            InventoryUtils.INSTANCE.setLatestItemInHand(hand);
            new ItemInHandChangeEvent((NEUInternalName)newItem, oldItem).postAndCatch();
        }
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        InventoryUtils.INSTANCE.setItemInHandId(NEUInternalName.Companion.getNONE());
        InventoryUtils.INSTANCE.getRecentItemsInHand().clear();
    }

    private static final boolean onTick$lambda$0(Long it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it + (long)30000 > System.currentTimeMillis();
    }

    private static final boolean onTick$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

