/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.model.Graph;
import at.hannibal2.skyhanni.data.model.GraphKt;
import at.hannibal2.skyhanni.data.model.GraphNode;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.events.IslandChangeEvent;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.skyblock.ScoreboardAreaChangeEvent;
import at.hannibal2.skyhanni.features.misc.IslandAreas;
import at.hannibal2.skyhanni.test.SkyHanniDebugsAndTests;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import com.google.gson.Gson;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0003J\u0017\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010#\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010$\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b$\u0010\u0003J\u0017\u0010&\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020%H\u0007\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010(\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b(\u0010\u0003J#\u0010,\u001a\u00020\u00062\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020*0)H\u0002\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010.\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b.\u0010\u0003J\r\u0010/\u001a\u00020\u0006\u00a2\u0006\u0004\b/\u0010\u0003JI\u00108\u001a\u00020\u00062\u0006\u00101\u001a\u0002002\b\b\u0002\u00103\u001a\u0002022\u000e\b\u0002\u00105\u001a\b\u0012\u0004\u0012\u00020\u0006042\b\b\u0002\u00106\u001a\u00020\u00112\u000e\b\u0002\u00107\u001a\b\u0012\u0004\u0012\u00020\u001104\u00a2\u0006\u0004\b8\u00109J\u0017\u0010;\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020:H\u0007\u00a2\u0006\u0004\b;\u0010<J+\u0010A\u001a\b\u0012\u0004\u0012\u00020>0=2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020>0=2\u0006\u0010@\u001a\u00020*H\u0002\u00a2\u0006\u0004\bA\u0010BJ\u0019\u0010E\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\bC\u0010DR$\u0010F\u001a\u0004\u0018\u00010\u001f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bF\u0010G\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010\"R\u0011\u0010M\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\bK\u0010LR$\u0010N\u001a\u0004\u0018\u00010>8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bN\u0010O\u001a\u0004\bP\u0010Q\"\u0004\bR\u0010SR\u0018\u0010T\u001a\u0004\u0018\u0001008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bT\u0010UR\u001e\u00103\u001a\n V*\u0004\u0018\u000102028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u0010WR\u0016\u00106\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u0010XR\u001c\u00105\u001a\b\u0012\u0004\u0012\u00020\u0006048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u0010YR(\u0010[\u001a\u0004\u0018\u00010>2\b\u0010Z\u001a\u0004\u0018\u00010>8\u0002@BX\u0082\u000e\u00a2\u0006\f\n\u0004\b[\u0010O\"\u0004\b\\\u0010SR\u0018\u0010]\u001a\u0004\u0018\u00010>8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b]\u0010OR\u0018\u0010^\u001a\u0004\u0018\u00010\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b^\u0010GR\u001c\u00107\u001a\b\u0012\u0004\u0012\u00020\u0011048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u0010YR\u0018\u0010_\u001a\u0004\u0018\u00010\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b_\u0010`R\u0014\u0010b\u001a\u00020a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bb\u0010cR\u001b\u0010i\u001a\u00020d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\be\u0010f\u001a\u0004\bg\u0010h\u00a8\u0006j"}, d2={"Lat/hannibal2/skyhanni/data/IslandGraphs;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "event", "", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "Lat/hannibal2/skyhanni/events/IslandChangeEvent;", "onIslandChange", "(Lat/hannibal2/skyhanni/events/IslandChangeEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "", "area", "", "isGlaciteTunnelsArea", "(Ljava/lang/String;)Z", "Lat/hannibal2/skyhanni/events/skyblock/ScoreboardAreaChangeEvent;", "onAreaChange", "(Lat/hannibal2/skyhanni/events/skyblock/ScoreboardAreaChangeEvent;)V", "loadDwarvenMines", "Lat/hannibal2/skyhanni/data/IslandType;", "newIsland", "loadIsland", "(Lat/hannibal2/skyhanni/data/IslandType;)V", "islandName", "reloadFromJson", "(Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/data/model/Graph;", "graph", "setNewGraph-0y7Y464", "(Ljava/util/List;)V", "setNewGraph", "reset", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "handleTick", "Lkotlin/Pair;", "", "path", "setFastestPath", "(Lkotlin/Pair;)V", "onNewNote", "stop", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "location", "Ljava/awt/Color;", "color", "Lkotlin/Function0;", "onFound", "showGoalExact", "condition", "pathFind", "(Lat/hannibal2/skyhanni/utils/LorenzVec;Ljava/awt/Color;Lkotlin/jvm/functions/Function0;ZLkotlin/jvm/functions/Function0;)V", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "", "Lat/hannibal2/skyhanni/data/model/GraphNode;", "nodes", "maxDistance", "cutByMaxDistance", "(Ljava/util/List;D)Ljava/util/List;", "skipNodes-8Gl89O8", "(Ljava/util/List;)Ljava/util/List;", "skipNodes", "currentIslandGraph", "Ljava/util/List;", "getCurrentIslandGraph-ZhRhRFc", "()Ljava/util/List;", "setCurrentIslandGraph-1yoMeZ4", "getExistsForThisIsland", "()Z", "existsForThisIsland", "closedNote", "Lat/hannibal2/skyhanni/data/model/GraphNode;", "getClosedNote", "()Lat/hannibal2/skyhanni/data/model/GraphNode;", "setClosedNote", "(Lat/hannibal2/skyhanni/data/model/GraphNode;)V", "currentTarget", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "kotlin.jvm.PlatformType", "Ljava/awt/Color;", "Z", "Lkotlin/jvm/functions/Function0;", "value", "goal", "setGoal", "prevGoal", "fastestPath", "inGlaciteTunnels", "Ljava/lang/Boolean;", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "glaciteTunnelsPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getGlaciteTunnelsPattern", "()Ljava/util/regex/Pattern;", "glaciteTunnelsPattern", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nIslandGraphs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IslandGraphs.kt\nat/hannibal2/skyhanni/data/IslandGraphs\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,397:1\n2318#2,14:398\n2318#2,14:413\n1557#2:427\n1628#2,3:428\n543#2,6:431\n1#3:412\n*S KotlinDebug\n*F\n+ 1 IslandGraphs.kt\nat/hannibal2/skyhanni/data/IslandGraphs\n*L\n236#1:398,14\n296#1:413,14\n351#1:427\n351#1:428,3\n367#1:431,6\n*E\n"})
public final class IslandGraphs {
    @NotNull
    public static final IslandGraphs INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @Nullable
    private static List<? extends GraphNode> currentIslandGraph;
    @Nullable
    private static GraphNode closedNote;
    @Nullable
    private static LorenzVec currentTarget;
    private static Color color;
    private static boolean showGoalExact;
    @NotNull
    private static Function0<Unit> onFound;
    @Nullable
    private static GraphNode goal;
    @Nullable
    private static GraphNode prevGoal;
    @Nullable
    private static List<? extends GraphNode> fastestPath;
    @NotNull
    private static Function0<Boolean> condition;
    @Nullable
    private static Boolean inGlaciteTunnels;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern glaciteTunnelsPattern$delegate;

    private IslandGraphs() {
    }

    @Nullable
    public final List<? extends GraphNode> getCurrentIslandGraph-ZhRhRFc() {
        return currentIslandGraph;
    }

    public final void setCurrentIslandGraph-1yoMeZ4(@Nullable List<? extends GraphNode> list) {
        currentIslandGraph = list;
    }

    public final boolean getExistsForThisIsland() {
        return currentIslandGraph != null;
    }

    @Nullable
    public final GraphNode getClosedNote() {
        return closedNote;
    }

    public final void setClosedNote(@Nullable GraphNode graphNode) {
        closedNote = graphNode;
    }

    private final void setGoal(GraphNode value) {
        prevGoal = goal;
        goal = value;
    }

    private final Pattern getGlaciteTunnelsPattern() {
        return (Pattern)glaciteTunnelsPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    @SubscribeEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        this.loadIsland(LorenzUtils.INSTANCE.getSkyBlockIsland());
    }

    @SubscribeEvent
    public final void onIslandChange(@NotNull IslandChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (currentIslandGraph != null) {
            return;
        }
        if (event.getNewIsland() == IslandType.NONE) {
            return;
        }
        this.loadIsland(event.getNewIsland());
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        currentIslandGraph = null;
        this.reset();
    }

    public final boolean isGlaciteTunnelsArea(@Nullable String area) {
        return RegexUtils.INSTANCE.matches(this.getGlaciteTunnelsPattern(), area);
    }

    @HandleEvent
    public final void onAreaChange(@NotNull ScoreboardAreaChangeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!LorenzUtils.INSTANCE.isInIsland(IslandType.DWARVEN_MINES)) {
            inGlaciteTunnels = null;
            return;
        }
        boolean now = this.isGlaciteTunnelsArea(LorenzUtils.INSTANCE.getSkyBlockArea());
        if (!Intrinsics.areEqual(inGlaciteTunnels, now)) {
            inGlaciteTunnels = now;
            this.loadDwarvenMines();
        }
    }

    private final void loadDwarvenMines() {
        if (this.isGlaciteTunnelsArea(LorenzUtils.INSTANCE.getSkyBlockArea())) {
            this.reloadFromJson("GLACITE_TUNNELS");
        } else {
            this.reloadFromJson("DWARVEN_MINES");
        }
    }

    private final void loadIsland(IslandType newIsland) {
        if (newIsland == IslandType.DWARVEN_MINES) {
            this.loadDwarvenMines();
        } else {
            this.reloadFromJson(newIsland.name());
        }
    }

    private final void reloadFromJson(String islandName) {
        String constant = "island_graphs/" + islandName;
        String name2 = "constants/" + constant + ".json";
        File jsonFile = new File(SkyHanniMod.Companion.getRepo().getRepoLocation(), name2);
        if (!jsonFile.isFile()) {
            currentIslandGraph = null;
            return;
        }
        File file = SkyHanniMod.Companion.getRepo().getRepoLocation();
        Gson gson2 = Graph.Companion.getGson();
        Intrinsics.checkNotNullExpressionValue(gson2, "<get-gson>(...)");
        List graph = ((Graph)RepoUtils.getConstant$default(RepoUtils.INSTANCE, file, constant, gson2, Graph.class, null, 16, null)).unbox-impl();
        this.setNewGraph-0y7Y464(graph);
    }

    public final void setNewGraph-0y7Y464(@NotNull List<? extends GraphNode> graph) {
        Intrinsics.checkNotNullParameter(graph, "graph");
        IslandAreas.INSTANCE.setDisplay(null);
        this.reset();
        currentIslandGraph = graph;
        this.handleTick();
        IslandAreas.INSTANCE.noteMoved();
        DelayedRun.INSTANCE.runDelayed-bouF650(DurationKt.toDuration(150, DurationUnit.MILLISECONDS), IslandGraphs::setNewGraph_0y7Y464$lambda$2);
    }

    private final void reset() {
        closedNote = null;
        currentTarget = null;
        this.setGoal(null);
        fastestPath = null;
    }

    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        this.handleTick();
    }

    private final void handleTick() {
        double nodeDistance;
        double d;
        GraphNode newClosest;
        GraphNode graphNode;
        GraphNode prevClosed = closedNote;
        List<? extends GraphNode> list = currentIslandGraph;
        if (list == null) {
            return;
        }
        List<? extends GraphNode> graph = list;
        LorenzVec lorenzVec = currentTarget;
        if (lorenzVec != null) {
            LorenzVec it = lorenzVec;
            boolean bl = false;
            if (LocationUtils.INSTANCE.distanceToPlayer(it) < 3.0) {
                onFound.invoke();
                INSTANCE.reset();
            }
            if (!condition.invoke().booleanValue()) {
                INSTANCE.reset();
            }
        }
        if (SkyHanniDebugsAndTests.INSTANCE.getC() == 0.0) {
            Object t;
            Iterable $this$minBy$iv = Graph.box-impl(graph);
            boolean $i$f$minByOrThrow = false;
            Iterator iterator$iv = $this$minBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t = minElem$iv;
            } else {
                GraphNode it = (GraphNode)minElem$iv;
                boolean bl = false;
                double minValue$iv = LocationUtils.INSTANCE.distanceSqToPlayer(it.getPosition());
                do {
                    Object e$iv = iterator$iv.next();
                    GraphNode it2 = (GraphNode)e$iv;
                    $i$a$-minByOrThrow-IslandGraphs$handleTick$newClosest$1 = false;
                    double v$iv = LocationUtils.INSTANCE.distanceSqToPlayer(it2.getPosition());
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t = minElem$iv;
            }
            graphNode = (GraphNode)t;
        } else {
            graphNode = newClosest = null;
        }
        if (Intrinsics.areEqual(closedNote, newClosest)) {
            return;
        }
        closedNote = newClosest;
        this.onNewNote();
        GraphNode graphNode2 = closedNote;
        if (graphNode2 == null) {
            return;
        }
        GraphNode closest = graphNode2;
        GraphNode graphNode3 = goal;
        if (graphNode3 == null) {
            return;
        }
        GraphNode goal = graphNode3;
        if (Intrinsics.areEqual(closest, prevClosed)) {
            return;
        }
        Pair<Graph, Double> pair = GraphKt.findShortestPathAsGraphWithDistance-LidtmbA(graph, closest, goal);
        List path = pair.component1().unbox-impl();
        double distance = ((Number)pair.component2()).doubleValue();
        GraphNode first2 = (GraphNode)CollectionsKt.firstOrNull(Graph.box-impl(path));
        GraphNode second2 = (GraphNode)CollectionsKt.getOrNull(Graph.box-impl(path), 1);
        LorenzVec playerPosition = LocationUtils.INSTANCE.playerLocation();
        GraphNode graphNode4 = first2;
        if (graphNode4 != null) {
            GraphNode it = graphNode4;
            boolean bl = false;
            d = playerPosition.distance(it.getPosition());
        } else {
            d = nodeDistance = 0.0;
        }
        if (first2 != null && second2 != null) {
            double direct = playerPosition.distance(second2.getPosition());
            Double d2 = first2.getNeighbours().get(second2);
            double firstPath = d2 != null ? d2 : 0.0;
            double around = nodeDistance + firstPath;
            if (direct < around) {
                this.setFastestPath(TuplesKt.to(Graph.box-impl(Graph.constructor-impl(CollectionsKt.drop(Graph.box-impl(path), 1))), distance - firstPath + direct));
                return;
            }
        }
        this.setFastestPath(TuplesKt.to(Graph.box-impl(path), distance + nodeDistance));
    }

    private final void setFastestPath(Pair<Graph, Double> path) {
        block2: {
            List list;
            Pair<Graph, Double> pair = path;
            Object it = pair;
            boolean bl = false;
            Pair<Graph, Double> pair2 = !((Collection)((Pair)it).getFirst()).isEmpty() ? pair : null;
            if (pair2 != null) {
                Graph graph = pair2.getFirst();
                list = graph != null ? graph.unbox-impl() : null;
            } else {
                list = null;
            }
            List<? extends GraphNode> list2 = fastestPath = list;
            if (list2 == null) break block2;
            it = list2;
            boolean bl2 = false;
            fastestPath = Graph.constructor-impl(INSTANCE.cutByMaxDistance((List<GraphNode>)it, 3.0));
        }
    }

    private final void onNewNote() {
        IslandAreas.INSTANCE.noteMoved();
    }

    public final void stop() {
        currentTarget = null;
        this.setGoal(null);
        fastestPath = null;
    }

    /*
     * WARNING - void declaration
     */
    public final void pathFind(@NotNull LorenzVec location, @NotNull Color color, @NotNull Function0<Unit> onFound, boolean showGoalExact, @NotNull Function0<Boolean> condition) {
        Object t;
        void $this$minBy$iv;
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(color, "color");
        Intrinsics.checkNotNullParameter(onFound, "onFound");
        Intrinsics.checkNotNullParameter(condition, "condition");
        this.reset();
        currentTarget = location;
        IslandGraphs.color = color;
        IslandGraphs.onFound = onFound;
        IslandGraphs.showGoalExact = showGoalExact;
        IslandGraphs.condition = condition;
        List<? extends GraphNode> list = currentIslandGraph;
        if (list == null) {
            return;
        }
        List<? extends GraphNode> graph = list;
        Iterable iterable = Graph.box-impl(graph);
        IslandGraphs islandGraphs = this;
        boolean $i$f$minByOrThrow = false;
        Iterator iterator$iv = $this$minBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object minElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            t = minElem$iv;
        } else {
            GraphNode it = (GraphNode)minElem$iv;
            boolean bl = false;
            LorenzVec lorenzVec = it.getPosition();
            LorenzVec lorenzVec2 = currentTarget;
            Intrinsics.checkNotNull(lorenzVec2);
            double minValue$iv = lorenzVec.distance(lorenzVec2);
            do {
                Object e$iv = iterator$iv.next();
                GraphNode it2 = (GraphNode)e$iv;
                $i$a$-minByOrThrow-IslandGraphs$pathFind$3 = false;
                LorenzVec lorenzVec3 = it2.getPosition();
                LorenzVec lorenzVec4 = currentTarget;
                Intrinsics.checkNotNull(lorenzVec4);
                double v$iv = lorenzVec3.distance(lorenzVec4);
                if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                minElem$iv = e$iv;
                minValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            t = minElem$iv;
        }
        islandGraphs.setGoal((GraphNode)t);
    }

    public static /* synthetic */ void pathFind$default(IslandGraphs islandGraphs, LorenzVec lorenzVec, Color color, Function0 function0, boolean bl, Function0 function02, int n, Object object) {
        if ((n & 2) != 0) {
            color = LorenzColor.WHITE.toColor();
        }
        if ((n & 4) != 0) {
            function0 = IslandGraphs::pathFind$lambda$8;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            function02 = IslandGraphs::pathFind$lambda$9;
        }
        islandGraphs.pathFind(lorenzVec, color, function0, bl, function02);
    }

    @SubscribeEvent
    public final void onRenderWorld(@NotNull LorenzRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        List<? extends GraphNode> list = fastestPath;
        if (list == null) {
            return;
        }
        List<? extends GraphNode> path = list;
        List<? extends GraphNode> graph = path;
        List<? extends GraphNode> list2 = this.skipNodes-8Gl89O8(graph);
        if (list2 == null) {
            list2 = graph;
        }
        graph = list2;
        RenderUtils renderUtils = RenderUtils.INSTANCE;
        List<? extends GraphNode> list3 = graph;
        Color color = IslandGraphs.color;
        Intrinsics.checkNotNullExpressionValue(color, "color");
        Color color2 = color;
        RenderUtils.draw3DPathWithWaypoint-rnC6y4o$default(renderUtils, event, list3, color2, 6, true, false, 1.0, null, 2.0, false, 336, null);
        LorenzVec lastNode = CollectionsKt.last(graph).getPosition();
        LorenzVec lorenzVec = currentTarget;
        if (lorenzVec == null) {
            return;
        }
        LorenzVec targetLocation = lorenzVec;
        LorenzVec lorenzVec2 = lastNode.add(0.5, 0.5, 0.5);
        LorenzVec lorenzVec3 = targetLocation.add(0.5, 0.5, 0.5);
        Color color3 = IslandGraphs.color;
        Intrinsics.checkNotNullExpressionValue(color3, "color");
        RenderUtils.INSTANCE.draw3DLine(event, lorenzVec2, lorenzVec3, color3, 4, true);
        if (showGoalExact) {
            Color color4 = IslandGraphs.color;
            Intrinsics.checkNotNullExpressionValue(color4, "color");
            RenderUtils.drawWaypointFilled$default(RenderUtils.INSTANCE, event, targetLocation, color4, false, false, 0.0, 0.0, 0.0, 0.0f, false, 508, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<GraphNode> cutByMaxDistance(List<GraphNode> nodes, double maxDistance) {
        void $this$mapTo$iv$iv;
        Object lastPosition;
        int index = 0;
        index = nodes.size() * 10;
        List locations = new ArrayList();
        boolean first2 = true;
        for (GraphNode node : nodes) {
            if (first2) {
                first2 = false;
            } else {
                lastPosition = (LorenzVec)CollectionsKt.last(locations);
                LorenzVec currentPosition = node.getPosition();
                LorenzVec vector = currentPosition.minus((LorenzVec)lastPosition).normalize();
                double distance = ((LorenzVec)lastPosition).distance(currentPosition);
                while (distance > maxDistance) {
                    if ((distance -= maxDistance) < maxDistance / (double)2) {
                        double cfr_ignored_0 = (maxDistance + distance) / (double)2;
                        break;
                    }
                    double nextStepDistance = maxDistance;
                    LorenzVec newPosition = ((LorenzVec)lastPosition).plus(vector.times(nextStepDistance));
                    locations.add(newPosition);
                    lastPosition = newPosition;
                }
            }
            locations.add(node.getPosition());
        }
        Iterable $this$map$iv = locations;
        boolean $i$f$map = false;
        lastPosition = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LorenzVec nextStepDistance = (LorenzVec)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int n = index;
            index = n + 1;
            collection.add(new GraphNode(n, (LorenzVec)it, null, null, 12, null));
        }
        return (List)destination$iv$iv;
    }

    private final List<? extends GraphNode> skipNodes-8Gl89O8(List<? extends GraphNode> graph) {
        LorenzVec v2;
        LorenzVec v1;
        double v;
        boolean angleSkip;
        GraphNode graphNode;
        List<? extends GraphNode> nodes;
        boolean skipNodeDistance;
        LorenzVec playerEyeLocation;
        block6: {
            GraphNode graphNode2 = closedNote;
            if (graphNode2 == null) {
                return null;
            }
            GraphNode closedNode = graphNode2;
            playerEyeLocation = LocationUtils.INSTANCE.playerEyeLocation();
            double playerY = playerEyeLocation.getY() - 1.0;
            double distanceToPlayer = LocationUtils.INSTANCE.distanceToPlayer(closedNode.getPosition());
            skipNodeDistance = distanceToPlayer > 8.0;
            double maxSkipDistance = skipNodeDistance ? 50.0 : 20.0;
            List<? extends GraphNode> $this$lastOrNull$iv = nodes = graph;
            boolean $i$f$lastOrNull = false;
            ListIterator<? extends GraphNode> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                GraphNode graphNode3;
                GraphNode it = graphNode3 = iterator$iv.previous();
                boolean bl = false;
                if (!(LocationUtils.INSTANCE.canBeSeen(it.getPosition(), maxSkipDistance, (Double)-1.0) && Math.abs(it.getPosition().getY() - playerY) <= 2.0)) continue;
                graphNode = graphNode3;
                break block6;
            }
            graphNode = null;
        }
        GraphNode graphNode4 = graphNode;
        if (graphNode4 == null) {
            return null;
        }
        GraphNode potentialSkip = graphNode4;
        boolean bl = Intrinsics.areEqual(potentialSkip, CollectionsKt.first(nodes)) ? false : (angleSkip = (v = (v1 = potentialSkip.getPosition().minus(playerEyeLocation)).angleInRad(v2 = CollectionsKt.first(nodes).getPosition().minus(playerEyeLocation))) > 1.0);
        if (!skipNodeDistance && !angleSkip) {
            return null;
        }
        List list = new ArrayList();
        list.add(potentialSkip);
        boolean passed = false;
        for (GraphNode graphNode5 : nodes) {
            if (passed) {
                list.add(graphNode5);
                continue;
            }
            if (!Intrinsics.areEqual(graphNode5, potentialSkip)) continue;
            passed = true;
        }
        return Graph.constructor-impl(list);
    }

    private static final Unit onFound$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final boolean condition$lambda$1() {
        return true;
    }

    private static final Unit setNewGraph_0y7Y464$lambda$2() {
        IslandAreas.INSTANCE.updatePosition();
        return Unit.INSTANCE;
    }

    private static final Unit pathFind$lambda$8() {
        return Unit.INSTANCE;
    }

    private static final boolean pathFind$lambda$9() {
        return true;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(IslandGraphs.class, "glaciteTunnelsPattern", "getGlaciteTunnelsPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new IslandGraphs();
        color = Color.WHITE;
        onFound = IslandGraphs::onFound$lambda$0;
        condition = IslandGraphs::condition$lambda$1;
        patternGroup = RepoPattern.Companion.group("data.island.navigation");
        glaciteTunnelsPattern$delegate = patternGroup.pattern("glacitetunnels", "(Glacite Tunnels|Dwarven Base Camp|Great Glacite Lake|Fossil Research Center)");
    }
}

