/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.features.skillprogress;

import at.hannibal2.skyhanni.config.FeatureToggle;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.Accordion;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorBoolean;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorColour;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorDropdown;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorSlider;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import com.google.gson.annotations.Expose;

public class SkillProgressBarConfig {
    @Expose
    @ConfigOption(name="Enabled", desc="Enable or disable the progress bar.")
    @ConfigEditorBoolean
    @FeatureToggle
    public Property<Boolean> enabled = Property.of(false);
    @Expose
    @ConfigOption(name="Textured Bar", desc="Use a textured progress bar.\n\u00a7eCan be changed with a resource pack.")
    @ConfigEditorBoolean
    public Property<Boolean> useTexturedBar = Property.of(false);
    @Expose
    @ConfigOption(name="Chroma", desc="Use the SBA like chroma effect on the bar.\n\u00a7eIf enabled, ignore the Bar Color setting.")
    @ConfigEditorBoolean
    public Property<Boolean> useChroma = Property.of(false);
    @Expose
    @ConfigOption(name="Bar Color", desc="Color of the progress bar.\n\u00a7eIgnored if Chroma is enabled.")
    @ConfigEditorColour
    public String barStartColor = "0:255:255:0:0";
    @Expose
    @ConfigOption(name="Textured Bar", desc="")
    @Accordion
    public TexturedBar texturedBar = new TexturedBar();
    @Expose
    @ConfigOption(name="Regular Bar", desc="")
    @Accordion
    public RegularBar regularBar = new RegularBar();

    public static class RegularBar {
        @Expose
        @ConfigOption(name="Width", desc="Modify the width of the bar.")
        @ConfigEditorSlider(minStep=1.0f, minValue=100.0f, maxValue=1000.0f)
        public int width = 182;
        @Expose
        @ConfigOption(name="Height", desc="Modify the height of the bar.")
        @ConfigEditorSlider(minStep=1.0f, minValue=3.0f, maxValue=15.0f)
        public int height = 6;
    }

    public static class TexturedBar {
        @Expose
        @ConfigOption(name="Used Texture", desc="Choose what texture to use.")
        @ConfigEditorDropdown
        public Property<UsedTexture> usedTexture = Property.of(UsedTexture.MATCH_PACK);
        @Expose
        @ConfigOption(name="Width", desc="Modify the width of the bar.\n\u00a7eDefault: 182\n\u00a7c!!Do not work for now!!")
        @ConfigEditorSlider(minStep=1.0f, minValue=16.0f, maxValue=1024.0f)
        public int width = 182;
        @Expose
        @ConfigOption(name="Height", desc="Modify the height of the bar.\n\u00a7eDefault: 5\n\u00a7c!!Do not work for now!!")
        @ConfigEditorSlider(minStep=1.0f, minValue=3.0f, maxValue=16.0f)
        public int height = 5;

        public static enum UsedTexture {
            MATCH_PACK("Match Resource Pack", "minecraft:textures/gui/icons.png"),
            CUSTOM_1("Texture 1", "skyhanni:bars/1.png"),
            CUSTOM_2("Texture 2", "skyhanni:bars/2.png"),
            CUSTOM_3("Texture 3", "skyhanni:bars/3.png"),
            CUSTOM_4("Texture 4", "skyhanni:bars/4.png"),
            CUSTOM_5("Texture 5", "skyhanni:bars/5.png");

            private final String str;
            private final String path;

            private UsedTexture(String str, String path) {
                this.str = str;
                this.path = path;
            }

            public String getPath() {
                return this.path;
            }

            public String toString() {
                return this.str;
            }
        }
    }
}

