/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.features.misc;

import at.hannibal2.skyhanni.config.FeatureToggle;
import at.hannibal2.skyhanni.config.HasLegacyId;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorBoolean;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorDraggableList;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorDropdown;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorText;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DiscordRPCConfig {
    @Expose
    @ConfigOption(name="Enable Discord RPC", desc="Details about your SkyBlock session displayed through Discord.")
    @ConfigEditorBoolean
    @FeatureToggle
    public Property<Boolean> enabled = Property.of(false);
    @Expose
    @ConfigOption(name="First Line", desc="Decide what to show in the first line.")
    @ConfigEditorDropdown
    public Property<LineEntry> firstLine = Property.of(LineEntry.NOTHING);
    @Expose
    @ConfigOption(name="Second Line", desc="Decide what to show in the second line.")
    @ConfigEditorDropdown
    public Property<LineEntry> secondLine = Property.of(LineEntry.NOTHING);
    @Expose
    @ConfigOption(name="Custom", desc="What should be displayed if you select \"Custom\" above.")
    @ConfigEditorText
    public Property<String> customText = Property.of("");
    @Expose
    @ConfigOption(name="Dynamic Priority", desc="Disable certain dynamic statuses, or change the priority in case two are triggered at the same time (higher up means higher priority).")
    @ConfigEditorDraggableList
    public List<PriorityEntry> autoPriority = new ArrayList<PriorityEntry>(Arrays.asList(PriorityEntry.CROP_MILESTONES, PriorityEntry.SLAYER, PriorityEntry.STACKING_ENCHANT, PriorityEntry.DUNGEONS, PriorityEntry.AFK));
    @Expose
    @ConfigOption(name="Dynamic Fallback", desc="What to show when none of your \"Dynamic Priority\" statuses are active.")
    @ConfigEditorDropdown
    public Property<LineEntry> auto = Property.of(LineEntry.NOTHING);
    @Expose
    @ConfigOption(name="Show Button for SkyCrypt", desc="Add a button to the RPC that opens your SkyCrypt profile.")
    @ConfigEditorBoolean
    public Property<Boolean> showSkyCryptButton = Property.of(true);

    public static enum LineEntry implements HasLegacyId
    {
        NOTHING("Nothing", 0),
        LOCATION("Location", 1),
        PURSE("Purse", 2),
        BITS("Bits", 3),
        STATS("Stats", 4),
        HELD_ITEM("Held Item", 5),
        SKYBLOCK_DATE("SkyBlock Date", 6),
        PROFILE("Profile", 7),
        SLAYER("Slayer", 8),
        CUSTOM("Custom", 9),
        DYNAMIC("Dynamic", 10),
        CROP_MILESTONE("Crop Milestone", 11),
        CURRENT_PET("Current Pet", 12);

        private final String str;
        private final int legacyId;

        private LineEntry(String str, int legacyId) {
            this.str = str;
            this.legacyId = legacyId;
        }

        private LineEntry(String str) {
            this(str, -1);
        }

        @Override
        public int getLegacyId() {
            return this.legacyId;
        }

        @Override
        public String toString() {
            return this.str;
        }
    }

    public static enum PriorityEntry implements HasLegacyId
    {
        CROP_MILESTONES("Crop Milestones", 0),
        SLAYER("Slayer", 1),
        STACKING_ENCHANT("Stacking Enchantment", 2),
        DUNGEONS("Dungeon", 3),
        AFK("AFK Indicator", 4);

        private final String str;
        private final int legacyId;

        private PriorityEntry(String str, int legacyId) {
            this.str = str;
            this.legacyId = legacyId;
        }

        private PriorityEntry(String str) {
            this(str, -1);
        }

        @Override
        public int getLegacyId() {
            return this.legacyId;
        }

        @Override
        public String toString() {
            return this.str;
        }
    }
}

