/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.features.inventory;

import at.hannibal2.skyhanni.config.FeatureToggle;
import at.hannibal2.skyhanni.config.HasLegacyId;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorBoolean;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorDropdown;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorSlider;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigLink;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import com.google.gson.annotations.Expose;

public class ChestValueConfig {
    @Expose
    @ConfigOption(name="Enabled", desc="Enable estimated value of chest.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean enabled = false;
    @Expose
    @ConfigOption(name="Enabled in own Inventory", desc="Enable the feature for your own inventory.")
    @ConfigEditorBoolean
    public boolean enableInOwnInventory = false;
    @Expose
    @ConfigOption(name="Enabled in dungeons", desc="Enable the feature in dungeons.")
    @ConfigEditorBoolean
    public boolean enableInDungeons = false;
    @Expose
    @ConfigOption(name="Enable during Item Value", desc="Show this display even if the Estimated Item Value is visible.")
    @ConfigEditorBoolean
    public boolean showDuringEstimatedItemValue = false;
    @Expose
    @ConfigOption(name="Show Stacks", desc="Show the item icon before name.")
    @ConfigEditorBoolean
    public boolean showStacks = true;
    @Expose
    @ConfigOption(name="Display Type", desc="Try to align everything to look nicer.")
    @ConfigEditorBoolean
    public boolean alignedDisplay = true;
    @Expose
    @ConfigOption(name="Name Length", desc="Reduce item name length to gain extra space on screen.\n\u00a7cCalculated in pixels!")
    @ConfigEditorSlider(minStep=1.0f, minValue=100.0f, maxValue=150.0f)
    public int nameLength = 100;
    @Expose
    @ConfigOption(name="Highlight Slot", desc="Highlight slot where the item is when you hover over it in the display.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean enableHighlight = true;
    @Expose
    @ConfigOption(name="Sorting Type", desc="Price sorting type.")
    @ConfigEditorDropdown
    public SortingTypeEntry sortingType = SortingTypeEntry.DESCENDING;
    @Expose
    @ConfigOption(name="Value formatting Type", desc="Format of the price.")
    @ConfigEditorDropdown
    public NumberFormatEntry formatType = NumberFormatEntry.SHORT;
    @Expose
    @ConfigOption(name="Item To Show", desc="Choose how many items are displayed.\nAll items in the chest are still counted for the total value.")
    @ConfigEditorSlider(minValue=0.0f, maxValue=54.0f, minStep=1.0f)
    public int itemToShow = 15;
    @Expose
    @ConfigOption(name="Hide below", desc="Item item value below configured amount.\nItems are still counted for the total value.")
    @ConfigEditorSlider(minValue=50000.0f, maxValue=1.0E7f, minStep=50000.0f)
    public int hideBelow = 100000;
    @Expose
    @ConfigLink(owner=ChestValueConfig.class, field="enabled")
    public Position position = new Position(107, 141, false, true);

    public static enum NumberFormatEntry implements HasLegacyId
    {
        SHORT("Short", 0),
        LONG("Long", 1);

        private final String str;
        private final int legacyId;

        private NumberFormatEntry(String str, int legacyId) {
            this.str = str;
            this.legacyId = legacyId;
        }

        private NumberFormatEntry(String str) {
            this(str, -1);
        }

        @Override
        public int getLegacyId() {
            return this.legacyId;
        }

        @Override
        public String toString() {
            return this.str;
        }
    }

    public static enum SortingTypeEntry implements HasLegacyId
    {
        DESCENDING("Descending", 0),
        ASCENDING("Ascending", 1);

        private final String str;
        private final int legacyId;

        private SortingTypeEntry(String str, int legacyId) {
            this.str = str;
            this.legacyId = legacyId;
        }

        private SortingTypeEntry(String str) {
            this(str, -1);
        }

        @Override
        public int getLegacyId() {
            return this.legacyId;
        }

        @Override
        public String toString() {
            return this.str;
        }
    }
}

