/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.features.garden;

import at.hannibal2.skyhanni.config.FeatureToggle;
import at.hannibal2.skyhanni.config.HasLegacyId;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorBoolean;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorDraggableList;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorSlider;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigLink;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MoneyPerHourConfig {
    @Expose
    @ConfigOption(name="Show Money per Hour", desc="Display the money per hour YOU get with YOUR crop/minute value when selling the item to bazaar.\nSupports Bountiful, Mushroom Cow Perk, Armor Crops and Dicer Drops. Their toggles are below.")
    @ConfigEditorBoolean
    @FeatureToggle
    public boolean display = false;
    @Expose
    @ConfigOption(name="Only Show Top", desc="Only show the best # items.")
    @ConfigEditorSlider(minValue=1.0f, maxValue=25.0f, minStep=1.0f)
    public int showOnlyBest = 5;
    @Expose
    @ConfigOption(name="Extend Top List", desc="Add current crop to the list if its lower ranked than the set limit by extending the list.")
    @ConfigEditorBoolean
    public boolean showCurrent = true;
    @Expose
    @ConfigOption(name="Always On", desc="Always show the money/hour Display while in the garden.")
    @ConfigEditorBoolean
    public boolean alwaysOn = false;
    @Expose
    @ConfigOption(name="Compact Mode", desc="Hide the item name and the position number.")
    @ConfigEditorBoolean
    public boolean compact = false;
    @Expose
    @ConfigOption(name="Compact Price", desc="Show the price more compact.")
    @ConfigEditorBoolean
    public boolean compactPrice = false;
    @Expose
    @ConfigOption(name="Use Custom", desc="Use the custom format below instead of classic \u279c \u00a7eSell Offer \u00a77and other profiles \u279c \u00a7eNPC Price.")
    @ConfigEditorBoolean
    public boolean useCustomFormat = false;
    @Expose
    @ConfigOption(name="Custom Format", desc="Set what prices to show")
    @ConfigEditorDraggableList(requireNonEmpty=true)
    public List<CustomFormatEntry> customFormat = new ArrayList<CustomFormatEntry>(Arrays.asList(CustomFormatEntry.SELL_OFFER, CustomFormatEntry.INSTANT_SELL, CustomFormatEntry.NPC_PRICE));
    @Expose
    @ConfigOption(name="Merge Seeds", desc="Merge the seeds price with the wheat price.")
    @ConfigEditorBoolean
    public boolean mergeSeeds = true;
    @Expose
    @ConfigOption(name="Include Bountiful", desc="Include the coins from Bountiful in the calculation.")
    @ConfigEditorBoolean
    public boolean bountiful = true;
    @Expose
    @ConfigOption(name="Include Mooshroom Cow", desc="Include the coins you get from selling the mushrooms from your Mooshroom Cow pet.")
    @ConfigEditorBoolean
    public boolean mooshroom = true;
    @Expose
    @ConfigOption(name="Include Armor Drops", desc="Include the average coins/hr from your armor.")
    @ConfigEditorBoolean
    public boolean armor = true;
    @Expose
    @ConfigOption(name="Include Dicer Drops", desc="Include the average coins/hr from your melon or pumpkin dicer.")
    @ConfigEditorBoolean
    public boolean dicer = true;
    @Expose
    @ConfigOption(name="Hide Title", desc="Hide the first line of 'Money Per Hour' entirely.")
    @ConfigEditorBoolean
    public boolean hideTitle = false;
    @Expose
    @ConfigLink(owner=MoneyPerHourConfig.class, field="display")
    public Position pos = new Position(-330, 170, false, true);

    public static enum CustomFormatEntry implements HasLegacyId
    {
        SELL_OFFER("\u00a7eSell Offer", 0),
        INSTANT_SELL("\u00a7eInstant Sell", 1),
        NPC_PRICE("\u00a7eNPC Price", 2);

        private final String str;
        private final int legacyId;

        private CustomFormatEntry(String str, int legacyId) {
            this.str = str;
            this.legacyId = legacyId;
        }

        private CustomFormatEntry(String str) {
            this(str, -1);
        }

        @Override
        public int getLegacyId() {
            return this.legacyId;
        }

        @Override
        public String toString() {
            return this.str;
        }
    }
}

