/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.features.crimsonisle;

import at.hannibal2.skyhanni.config.FeatureToggle;
import at.hannibal2.skyhanni.config.HasLegacyId;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorBoolean;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorDropdown;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorKeybind;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigLink;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import com.google.gson.annotations.Expose;

public class ReputationHelperConfig {
    @Expose
    @ConfigOption(name="Enabled", desc="Enable features around Reputation features in the Crimson Isle.")
    @ConfigEditorBoolean
    @FeatureToggle
    public Property<Boolean> enabled = Property.of(false);
    @Expose
    @ConfigOption(name="Hide Completed", desc="Hide tasks after they've been completed.")
    @ConfigEditorBoolean
    public Property<Boolean> hideComplete = Property.of(true);
    @Expose
    @ConfigOption(name="Use Hotkey", desc="Only show the Reputation Helper while pressing the hotkey.")
    @ConfigEditorBoolean
    public boolean useHotkey = false;
    @Expose
    @ConfigOption(name="Hotkey", desc="Press this hotkey to show the Reputation Helper.")
    @ConfigEditorKeybind(defaultKey=0)
    public int hotkey = 0;
    @Expose
    @ConfigLink(owner=ReputationHelperConfig.class, field="enabled")
    public Position position = new Position(10, 10, false, true);
    @Expose
    @ConfigOption(name="Show Locations", desc="Crimson Isles waypoints for locations to get reputation.")
    @ConfigEditorDropdown
    public ShowLocationEntry showLocation = ShowLocationEntry.ONLY_HOTKEY;

    public static enum ShowLocationEntry implements HasLegacyId
    {
        ALWAYS("Always", 0),
        ONLY_HOTKEY("Only With Hotkey", 1),
        NEVER("Never", 2);

        private final String str;
        private final int legacyId;

        private ShowLocationEntry(String str, int legacyId) {
            this.str = str;
            this.legacyId = legacyId;
        }

        private ShowLocationEntry(String str) {
            this(str, -1);
        }

        @Override
        public int getLegacyId() {
            return this.legacyId;
        }

        @Override
        public String toString() {
            return this.str;
        }
    }
}

