/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.core.config.gui;

import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.data.GuiEditManager;
import at.hannibal2.skyhanni.data.OtherInventoryData;
import at.hannibal2.skyhanni.data.Vector2i;
import at.hannibal2.skyhanni.mixins.transformers.gui.AccessorGuiContainer;
import at.hannibal2.skyhanni.utils.GuiRenderUtils;
import at.hannibal2.skyhanni.utils.KeyboardManager;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.compat.GuiScreenUtils;
import at.hannibal2.skyhanni.utils.compat.SkyhanniBaseScreen;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Mouse;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u000b\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ'\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0018J'\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001f\u0010#\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\b#\u0010$J'\u0010&\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\b&\u0010\u001fJ/\u0010*\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00052\u0006\u0010)\u001a\u00020(H\u0014\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010,\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b,\u0010\rR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010-R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010.R\u0016\u0010\b\u001a\u0004\u0018\u00010\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010/R\u0016\u00100\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u0010.R\u0016\u00101\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u0010.R\u0016\u00102\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u0010.\u00a8\u00063"}, d2={"Lat/hannibal2/skyhanni/config/core/config/gui/GuiPositionEditor;", "Lat/hannibal2/skyhanni/utils/compat/SkyhanniBaseScreen;", "", "Lat/hannibal2/skyhanni/config/core/config/Position;", "positions", "", "border", "Lnet/minecraft/client/gui/inventory/GuiContainer;", "oldScreen", "<init>", "(Ljava/util/List;ILnet/minecraft/client/gui/inventory/GuiContainer;)V", "", "onGuiClosed", "()V", "mouseX", "mouseY", "", "partialTicks", "drawScreen", "(IIF)V", "hoveredPos", "renderLabels", "(I)V", "renderRectangles", "()I", "getScaledHeight", "getScaledWidth", "originalX", "priginalY", "mouseButton", "mouseClicked", "(III)V", "", "typedChar", "keyCode", "keyTyped", "(CI)V", "state", "mouseReleased", "clickedMouseButton", "", "timeSinceLastClick", "mouseClickMove", "(IIIJ)V", "handleMouseInput", "Ljava/util/List;", "I", "Lnet/minecraft/client/gui/inventory/GuiContainer;", "grabbedX", "grabbedY", "clickedPos", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nGuiPositionEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuiPositionEditor.kt\nat/hannibal2/skyhanni/config/core/config/gui/GuiPositionEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,256:1\n295#2,2:257\n543#2,6:259\n*S KotlinDebug\n*F\n+ 1 GuiPositionEditor.kt\nat/hannibal2/skyhanni/config/core/config/gui/GuiPositionEditor\n*L\n241#1:257,2\n242#1:259,6\n*E\n"})
public final class GuiPositionEditor
extends SkyhanniBaseScreen {
    @NotNull
    private final List<Position> positions;
    private final int border;
    @Nullable
    private final GuiContainer oldScreen;
    private int grabbedX;
    private int grabbedY;
    private int clickedPos;

    public GuiPositionEditor(@NotNull List<? extends Position> positions, int border, @Nullable GuiContainer oldScreen) {
        Intrinsics.checkNotNullParameter(positions, "positions");
        this.positions = positions;
        this.border = border;
        this.oldScreen = oldScreen;
        this.clickedPos = -1;
    }

    public /* synthetic */ GuiPositionEditor(List list, int n, GuiContainer guiContainer, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            guiContainer = null;
        }
        this(list, n, guiContainer);
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.clickedPos = -1;
        for (Position position : this.positions) {
            position.setClicked(false);
        }
        OtherInventoryData.close$default(OtherInventoryData.INSTANCE, false, 1, null);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        if (this.oldScreen != null) {
            GuiContainer guiContainer = this.oldScreen;
            Intrinsics.checkNotNull(guiContainer, "null cannot be cast to non-null type at.hannibal2.skyhanni.mixins.transformers.gui.AccessorGuiContainer");
            AccessorGuiContainer accessor = (AccessorGuiContainer)guiContainer;
            accessor.invokeDrawGuiContainerBackgroundLayer_skyhanni(partialTicks, -1, -1);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179140_f();
        int hoveredPos = this.renderRectangles();
        this.renderLabels(hoveredPos);
    }

    private final void renderLabels(int hoveredPos) {
        GuiRenderUtils.INSTANCE.drawStringCentered("\u00a7cSkyHanni Position Editor", this.getScaledWidth() / 2, 8);
        int displayPos = -1;
        if (this.clickedPos != -1 && this.positions.get(this.clickedPos).getClicked()) {
            displayPos = this.clickedPos;
        }
        if (displayPos == -1) {
            displayPos = hoveredPos;
        }
        if (displayPos == -1) {
            GuiRenderUtils.INSTANCE.drawStringCentered("\u00a7eTo edit hidden GUI elements set a key in /sh edit", this.getScaledWidth() / 2, 20);
            GuiRenderUtils.INSTANCE.drawStringCentered("\u00a7ethen click that key while the GUI element is visible", this.getScaledWidth() / 2, 32);
            return;
        }
        Position pos = this.positions.get(displayPos);
        String location = "\u00a77x: \u00a7e" + pos.getRawX() + "\u00a77, y: \u00a7e" + pos.getRawY() + "\u00a77, scale: \u00a7e" + NumberUtil.INSTANCE.roundTo(pos.getScale(), 2);
        GuiRenderUtils.INSTANCE.drawStringCentered("\u00a7b" + pos.internalName, this.getScaledWidth() / 2, 18);
        GuiRenderUtils.INSTANCE.drawStringCentered(location, this.getScaledWidth() / 2, 28);
        if (pos.canJumpToConfigOptions()) {
            GuiRenderUtils.INSTANCE.drawStringCentered("\u00a7aRight-Click to open associated config options", this.getScaledWidth() / 2, 38);
        }
    }

    private final int renderRectangles() {
        int hoveredPos = -1;
        GlStateManager.func_179094_E();
        this.field_146294_l = this.getScaledWidth();
        this.field_146295_m = this.getScaledHeight();
        int mouseX = Mouse.getX() * this.field_146294_l / Minecraft.func_71410_x().field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getY() * this.field_146295_m / Minecraft.func_71410_x().field_71440_d - 1;
        Iterator iterator2 = ((Iterable)this.positions).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            Position position = (Position)iterator2.next();
            int elementWidth = GuiEditManager.INSTANCE.getDummySize(position, true).getX();
            int elementHeight = GuiEditManager.INSTANCE.getDummySize(position, true).getY();
            if (position.getClicked()) {
                this.grabbedX += position.moveX(mouseX - this.grabbedX, elementWidth);
                this.grabbedY += position.moveY(mouseY - this.grabbedY, elementHeight);
            }
            int x = GuiEditManager.INSTANCE.getAbsX(position);
            int y = GuiEditManager.INSTANCE.getAbsY(position);
            elementWidth = GuiEditManager.getDummySize$default(GuiEditManager.INSTANCE, position, false, 1, null).getX();
            elementHeight = GuiEditManager.getDummySize$default(GuiEditManager.INSTANCE, position, false, 1, null).getY();
            GuiScreen.func_73734_a((int)(x - this.border), (int)(y - this.border), (int)(x + elementWidth + this.border * 2), (int)(y + elementHeight + this.border * 2), (int)-2143272896);
            if (!GuiRenderUtils.INSTANCE.isPointInRect(mouseX, mouseY, x - this.border, y - this.border, elementWidth + this.border * 2, elementHeight + this.border * 2)) continue;
            hoveredPos = index;
        }
        GlStateManager.func_179121_F();
        return hoveredPos;
    }

    private final int getScaledHeight() {
        return GuiScreenUtils.INSTANCE.getScaledWindowHeight();
    }

    private final int getScaledWidth() {
        return GuiScreenUtils.INSTANCE.getScaledWindowWidth();
    }

    protected void func_73864_a(int originalX, int priginalY, int mouseButton) throws IOException {
        super.func_73864_a(originalX, priginalY, mouseButton);
        int mouseX = Mouse.getX() * this.field_146294_l / Minecraft.func_71410_x().field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getY() * this.field_146295_m / Minecraft.func_71410_x().field_71440_d - 1;
        int n = ((Collection)this.positions).size() + -1;
        if (0 <= n) {
            do {
                int y;
                int i2 = n--;
                Position position = this.positions.get(i2);
                int elementWidth = GuiEditManager.getDummySize$default(GuiEditManager.INSTANCE, position, false, 1, null).getX();
                int elementHeight = GuiEditManager.getDummySize$default(GuiEditManager.INSTANCE, position, false, 1, null).getY();
                int x = GuiEditManager.INSTANCE.getAbsX(position);
                boolean isHovered = GuiRenderUtils.INSTANCE.isPointInRect(mouseX, mouseY, x - this.border, (y = GuiEditManager.INSTANCE.getAbsY(position)) - this.border, elementWidth + this.border * 2, elementHeight + this.border * 2);
                if (!isHovered) continue;
                if (mouseButton == 1) {
                    position.jumpToConfigOptions();
                    break;
                }
                if (position.getClicked() || mouseButton != 0) continue;
                this.clickedPos = i2;
                position.setClicked(true);
                this.grabbedX = mouseX;
                this.grabbedY = mouseY;
                break;
            } while (0 <= n);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (this.clickedPos == -1) {
            return;
        }
        Position position = this.positions.get(this.clickedPos);
        if (position.getClicked()) {
            return;
        }
        int dist = KeyboardManager.INSTANCE.isShiftKeyDown() ? 10 : 1;
        int elementWidth = GuiEditManager.INSTANCE.getDummySize(position, true).getX();
        int elementHeight = GuiEditManager.INSTANCE.getDummySize(position, true).getY();
        switch (keyCode) {
            case 208: {
                position.moveY(dist, elementHeight);
                break;
            }
            case 200: {
                position.moveY(-dist, elementHeight);
                break;
            }
            case 203: {
                position.moveX(-dist, elementWidth);
                break;
            }
            case 205: {
                position.moveX(dist, elementWidth);
                break;
            }
            case 12: {
                position.setScale(position.getScale() - 0.1f);
                break;
            }
            case 13: {
                position.setScale(position.getScale() + 0.1f);
                break;
            }
            case 74: {
                position.setScale(position.getScale() - 0.1f);
                break;
            }
            case 78: {
                position.setScale(position.getScale() + 0.1f);
            }
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        for (Position position : this.positions) {
            position.setClicked(false);
        }
    }

    protected void func_146273_a(int originalX, int priginalY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(originalX, priginalY, clickedMouseButton, timeSinceLastClick);
        for (Position position : this.positions) {
            if (!position.getClicked()) continue;
            int mouseX = Mouse.getX() * this.field_146294_l / Minecraft.func_71410_x().field_71443_c;
            int mouseY = this.field_146295_m - Mouse.getY() * this.field_146295_m / Minecraft.func_71410_x().field_71440_d - 1;
            int elementWidth = GuiEditManager.INSTANCE.getDummySize(position, true).getX();
            int elementHeight = GuiEditManager.INSTANCE.getDummySize(position, true).getY();
            this.grabbedX += position.moveX(mouseX - this.grabbedX, elementWidth);
            this.grabbedY += position.moveY(mouseY - this.grabbedY, elementHeight);
            String string2 = position.internalName;
            Intrinsics.checkNotNullExpressionValue(string2, "internalName");
            GuiEditManager.INSTANCE.handleGuiPositionMoved(string2);
        }
    }

    public void func_146274_d() {
        Position position;
        Object v0;
        int my;
        int mx;
        int mw;
        block7: {
            super.func_146274_d();
            mw = Mouse.getEventDWheel();
            if (mw == 0) {
                return;
            }
            mx = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            my = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            Iterable $this$firstOrNull$iv = this.positions;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Position it = (Position)element$iv;
                boolean bl = false;
                if (!it.getClicked()) continue;
                v0 = element$iv;
                break block7;
            }
            v0 = null;
        }
        if ((position = (Position)v0) == null) {
            Position position2;
            block8: {
                List<Position> $this$lastOrNull$iv = this.positions;
                boolean $i$f$lastOrNull = false;
                ListIterator<Position> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Position element$iv;
                    Position it = element$iv = iterator$iv.previous();
                    boolean bl = false;
                    Vector2i size = GuiEditManager.getDummySize$default(GuiEditManager.INSTANCE, it, false, 1, null);
                    if (!GuiRenderUtils.INSTANCE.isPointInRect(mx, my, GuiEditManager.INSTANCE.getAbsX(it) - this.border, GuiEditManager.INSTANCE.getAbsY(it) - this.border, size.getX() + this.border * 2, size.getY() + this.border * 2)) continue;
                    position2 = element$iv;
                    break block8;
                }
                position2 = null;
            }
            if ((position = (Position)position2) == null) {
                return;
            }
        }
        Position hovered = position;
        if (mw < 0) {
            hovered.setScale(hovered.getScale() - 0.1f);
        } else {
            hovered.setScale(hovered.getScale() + 0.1f);
        }
    }
}

