/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.api;

import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.HotmData;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.data.jsonobjects.local.HotmTree;
import at.hannibal2.skyhanni.events.mining.PowderGainEvent;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemCategory;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.SkyBlockItemModifierUtils;
import at.hannibal2.skyhanni.utils.TimeLimitedCache;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003#$%B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0013\u0010\n\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0016\u001a\u0004\u0018\u00010\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u001d\u001a\u0004\u0018\u00010\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006&"}, d2={"Lat/hannibal2/skyhanni/api/HotmAPI;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/data/jsonobjects/local/HotmTree;", "copyCurrentTree", "()Lat/hannibal2/skyhanni/data/jsonobjects/local/HotmTree;", "Lat/hannibal2/skyhanni/data/HotmData;", "getActiveMiningAbility", "()Lat/hannibal2/skyhanni/data/HotmData;", "activeMiningAbility", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "blueGoblinEgg", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "Lat/hannibal2/skyhanni/utils/TimeLimitedCache;", "Lnet/minecraft/item/ItemStack;", "", "blueEggCache", "Lat/hannibal2/skyhanni/utils/TimeLimitedCache;", "isBlueEggActive", "()Z", "Lat/hannibal2/skyhanni/api/HotmAPI$SkymallPerk;", "skymall", "Lat/hannibal2/skyhanni/api/HotmAPI$SkymallPerk;", "getSkymall", "()Lat/hannibal2/skyhanni/api/HotmAPI$SkymallPerk;", "setSkymall", "(Lat/hannibal2/skyhanni/api/HotmAPI$SkymallPerk;)V", "Lat/hannibal2/skyhanni/api/HotmAPI$MayhemPerk;", "mineshaftMayhem", "Lat/hannibal2/skyhanni/api/HotmAPI$MayhemPerk;", "getMineshaftMayhem", "()Lat/hannibal2/skyhanni/api/HotmAPI$MayhemPerk;", "setMineshaftMayhem", "(Lat/hannibal2/skyhanni/api/HotmAPI$MayhemPerk;)V", "PowderType", "SkymallPerk", "MayhemPerk", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nHotmAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HotmAPI.kt\nat/hannibal2/skyhanni/api/HotmAPI\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n295#2,2:121\n*S KotlinDebug\n*F\n+ 1 HotmAPI.kt\nat/hannibal2/skyhanni/api/HotmAPI\n*L\n22#1:121,2\n*E\n"})
public final class HotmAPI {
    @NotNull
    public static final HotmAPI INSTANCE = new HotmAPI();
    @NotNull
    private static final NEUInternalName blueGoblinEgg = NEUInternalName.Companion.asInternalName("GOBLIN_OMELETTE_BLUE_CHEESE");
    @NotNull
    private static final TimeLimitedCache<ItemStack, Boolean> blueEggCache = new TimeLimitedCache(DurationKt.toDuration(10.0, DurationUnit.SECONDS), null, 2, null);
    @Nullable
    private static SkymallPerk skymall;
    @Nullable
    private static MayhemPerk mineshaftMayhem;

    private HotmAPI() {
    }

    @Nullable
    public final HotmTree copyCurrentTree() {
        HotmTree hotmTree = HotmData.Companion.getStorage();
        return hotmTree != null ? hotmTree.deepCopy() : null;
    }

    @Nullable
    public final HotmData getActiveMiningAbility() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = HotmData.Companion.getAbilities();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                HotmData it = (HotmData)((Object)element$iv);
                boolean bl = false;
                if (!it.getEnabled()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final boolean isBlueEggActive() {
        boolean bl;
        ItemStack itemStack2 = InventoryUtils.INSTANCE.getItemInHand();
        if (itemStack2 != null) {
            ItemStack it = itemStack2;
            boolean bl2 = false;
            bl = blueEggCache.getOrPut(it, () -> HotmAPI._get_isBlueEggActive_$lambda$2$lambda$1(it)).booleanValue();
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final SkymallPerk getSkymall() {
        return skymall;
    }

    public final void setSkymall(@Nullable SkymallPerk skymallPerk) {
        skymall = skymallPerk;
    }

    @Nullable
    public final MayhemPerk getMineshaftMayhem() {
        return mineshaftMayhem;
    }

    public final void setMineshaftMayhem(@Nullable MayhemPerk mayhemPerk) {
        mineshaftMayhem = mayhemPerk;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean _get_isBlueEggActive_$lambda$2$lambda$1(ItemStack $it) {
        Intrinsics.checkNotNullParameter($it, "$it");
        if (ItemUtils.INSTANCE.getItemCategoryOrNull($it) != ItemCategory.DRILL) return false;
        List<NEUInternalName> list = SkyBlockItemModifierUtils.INSTANCE.getDrillUpgrades($it);
        if (list == null) return false;
        if (!list.contains(blueGoblinEgg)) return false;
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\u001b\u0010\r\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lat/hannibal2/skyhanni/api/HotmAPI$MayhemPerk;", "", "", "chat", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "patternName", "Ljava/lang/String;", "Ljava/util/regex/Pattern;", "chatPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getChatPattern", "()Ljava/util/regex/Pattern;", "chatPattern", "SCRAP_CHANCE", "MINING_FORTUNE", "MINING_SPEED", "COLD_RESISTANCE", "ABILITY_COOLDOWN", "1.8.9"})
    public static final class MayhemPerk
    extends Enum<MayhemPerk> {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final String patternName;
        @NotNull
        private final RepoPattern chatPattern$delegate;
        public static final /* enum */ MayhemPerk SCRAP_CHANCE;
        public static final /* enum */ MayhemPerk MINING_FORTUNE;
        public static final /* enum */ MayhemPerk MINING_SPEED;
        public static final /* enum */ MayhemPerk COLD_RESISTANCE;
        public static final /* enum */ MayhemPerk ABILITY_COOLDOWN;
        private static final /* synthetic */ MayhemPerk[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private MayhemPerk(String chat) {
            String string2 = this.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            this.patternName = StringsKt.replace$default(string2, "_", ".", false, 4, null);
            this.chatPattern$delegate = RepoPattern.Companion.pattern("mining.hotm.mayhem.chat." + this.patternName, chat);
        }

        @NotNull
        public final Pattern getChatPattern() {
            return (Pattern)this.chatPattern$delegate.getValue((Object)this, (KProperty<?>)$$delegatedProperties[0]);
        }

        public static MayhemPerk[] values() {
            return (MayhemPerk[])$VALUES.clone();
        }

        public static MayhemPerk valueOf(String value) {
            return Enum.valueOf(MayhemPerk.class, value);
        }

        @NotNull
        public static EnumEntries<MayhemPerk> getEntries() {
            return $ENTRIES;
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(MayhemPerk.class, "chatPattern", "getChatPattern()Ljava/util/regex/Pattern;", 0))};
            $$delegatedProperties = kPropertyArray;
            SCRAP_CHANCE = new MayhemPerk("Your \u00a7r\u00a79Suspicious Scrap \u00a7r\u00a77chance was buffed by your \u00a7r\u00a7aMineshaft Mayhem \u00a7r\u00a77perk!");
            MINING_FORTUNE = new MayhemPerk("You received a \u00a7r\u00a7a\u00a7r\u00a76\u2618 Mining Fortune \u00a7r\u00a77buff from your \u00a7r\u00a7aMineshaft Mayhem \u00a7r\u00a77perk!");
            MINING_SPEED = new MayhemPerk("You received a \u00a7r\u00a7a\u00a7r\u00a76\u2e15 Mining Speed \u00a7r\u00a77buff from your \u00a7r\u00a7aMineshaft Mayhem \u00a7r\u00a77perk!");
            COLD_RESISTANCE = new MayhemPerk("You received a \u00a7r\u00a7a\u00a7r\u00a7b\u2744 Cold Resistance \u00a7r\u00a77buff from your \u00a7r\u00a7aMineshaft Mayhem \u00a7r\u00a77perk!");
            ABILITY_COOLDOWN = new MayhemPerk("Your Pickaxe Ability cooldown was reduced \u00a7r\u00a77from your \u00a7r\u00a7aMineshaft Mayhem \u00a7r\u00a77perk!");
            $VALUES = mayhemPerkArray = new MayhemPerk[]{MayhemPerk.SCRAP_CHANCE, MayhemPerk.MINING_FORTUNE, MayhemPerk.MINING_SPEED, MayhemPerk.COLD_RESISTANCE, MayhemPerk.ABILITY_COOLDOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u001a\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0016\u0010\u0015J\r\u0010\u0017\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0017\u0010\u0011J\u0015\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0018\u0010\u0015J\u0015\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0019\u0010\u0015J\u0015\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001b\u0010\u0015J\r\u0010\u001c\u001a\u00020\u0013\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001e\u001a\u0004\b!\u0010 R\u001b\u0010&\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R\u001b\u0010)\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010#\u001a\u0004\b(\u0010%j\u0002\b*j\u0002\b+j\u0002\b,\u00a8\u0006-"}, d2={"Lat/hannibal2/skyhanni/api/HotmAPI$PowderType;", "", "", "displayName", "color", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "", "isHeart", "Ljava/util/regex/Pattern;", "pattern", "(Z)Ljava/util/regex/Pattern;", "Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$MiningConfig$PowderStorage;", "getStorage", "()Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$MiningConfig$PowderStorage;", "", "getCurrent", "()J", "value", "", "setCurrent", "(J)V", "addCurrent", "getTotal", "setTotal", "addTotal", "difference", "gain", "reset", "()V", "Ljava/lang/String;", "getDisplayName", "()Ljava/lang/String;", "getColor", "heartPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getHeartPattern", "()Ljava/util/regex/Pattern;", "heartPattern", "resetPattern$delegate", "getResetPattern", "resetPattern", "MITHRIL", "GEMSTONE", "GLACITE", "1.8.9"})
    public static final class PowderType
    extends Enum<PowderType> {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final String displayName;
        @NotNull
        private final String color;
        @NotNull
        private final RepoPattern heartPattern$delegate;
        @NotNull
        private final RepoPattern resetPattern$delegate;
        public static final /* enum */ PowderType MITHRIL;
        public static final /* enum */ PowderType GEMSTONE;
        public static final /* enum */ PowderType GLACITE;
        private static final /* synthetic */ PowderType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private PowderType(String displayName, String color) {
            this.displayName = displayName;
            this.color = color;
            StringBuilder stringBuilder = new StringBuilder().append("inventory.");
            String string2 = this.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            this.heartPattern$delegate = RepoPattern.Companion.pattern(stringBuilder.append(string2).append(".heart").toString(), "\u00a77" + this.displayName + " Powder: \u00a7a\u00a7.(?<powder>[\\d,]+)");
            StringBuilder stringBuilder2 = new StringBuilder().append("inventory.");
            String string3 = this.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
            this.resetPattern$delegate = RepoPattern.Companion.pattern(stringBuilder2.append(string3).append(".reset").toString(), "\\s+\u00a78- \u00a7.(?<powder>[\\d,]+) " + this.displayName + " Powder");
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final String getColor() {
            return this.color;
        }

        @NotNull
        public final Pattern getHeartPattern() {
            return (Pattern)this.heartPattern$delegate.getValue((Object)this, (KProperty<?>)$$delegatedProperties[0]);
        }

        @NotNull
        public final Pattern getResetPattern() {
            return (Pattern)this.resetPattern$delegate.getValue((Object)this, (KProperty<?>)$$delegatedProperties[1]);
        }

        @NotNull
        public final Pattern pattern(boolean isHeart) {
            return isHeart ? this.getHeartPattern() : this.getResetPattern();
        }

        @Nullable
        public final ProfileSpecificStorage.MiningConfig.PowderStorage getStorage() {
            Object object = ProfileStorageData.INSTANCE.getProfileSpecific();
            return object != null && (object = ((ProfileSpecificStorage)object).mining) != null && (object = ((ProfileSpecificStorage.MiningConfig)object).powder) != null ? object.get((Object)this) : null;
        }

        public final long getCurrent() {
            Object object = this.getStorage();
            return object != null && (object = ((ProfileSpecificStorage.MiningConfig.PowderStorage)object).available) != null ? (Long)object : 0L;
        }

        public final void setCurrent(long value) {
            block0: {
                if (this.getStorage() == null) break block0;
                this.getStorage().available = value;
            }
        }

        public final void addCurrent(long value) {
            this.setCurrent(this.getCurrent() + value);
        }

        public final long getTotal() {
            Object object = this.getStorage();
            return object != null && (object = ((ProfileSpecificStorage.MiningConfig.PowderStorage)object).total) != null ? (Long)object : 0L;
        }

        public final void setTotal(long value) {
            block0: {
                if (this.getStorage() == null) break block0;
                this.getStorage().total = value;
            }
        }

        public final void addTotal(long value) {
            this.setTotal(this.getTotal() + value);
        }

        public final void gain(long difference) {
            ChatUtils.INSTANCE.debug("Gained \u00a7a" + NumberUtil.INSTANCE.addSeparators(difference) + " \u00a7e" + this.displayName + " Powder");
            this.addTotal(difference);
            this.addCurrent(difference);
            new PowderGainEvent(this, difference).post();
        }

        public final void reset() {
            this.setCurrent(0L);
            this.setTotal(0L);
        }

        public static PowderType[] values() {
            return (PowderType[])$VALUES.clone();
        }

        public static PowderType valueOf(String value) {
            return Enum.valueOf(PowderType.class, value);
        }

        @NotNull
        public static EnumEntries<PowderType> getEntries() {
            return $ENTRIES;
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(PowderType.class, "heartPattern", "getHeartPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(PowderType.class, "resetPattern", "getResetPattern()Ljava/util/regex/Pattern;", 0))};
            $$delegatedProperties = kPropertyArray;
            MITHRIL = new PowderType("Mithril", "\u00a72");
            GEMSTONE = new PowderType("Gemstone", "\u00a7d");
            GLACITE = new PowderType("Glacite", "\u00a7b");
            $VALUES = powderTypeArray = new PowderType[]{PowderType.MITHRIL, PowderType.GEMSTONE, PowderType.GLACITE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\bR\u001b\u0010\u000e\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0011\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u000b\u001a\u0004\b\u0010\u0010\rj\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017\u00a8\u0006\u0018"}, d2={"Lat/hannibal2/skyhanni/api/HotmAPI$SkymallPerk;", "", "", "chat", "itemString", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "patternName", "Ljava/lang/String;", "Ljava/util/regex/Pattern;", "chatPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getChatPattern", "()Ljava/util/regex/Pattern;", "chatPattern", "itemPattern$delegate", "getItemPattern", "itemPattern", "MINING_SPEED", "MINING_FORTUNE", "EXTRA_POWDER", "ABILITY_COOLDOWN", "GOBLIN_CHANCE", "TITANIUM", "1.8.9"})
    public static final class SkymallPerk
    extends Enum<SkymallPerk> {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final String patternName;
        @NotNull
        private final RepoPattern chatPattern$delegate;
        @NotNull
        private final RepoPattern itemPattern$delegate;
        public static final /* enum */ SkymallPerk MINING_SPEED;
        public static final /* enum */ SkymallPerk MINING_FORTUNE;
        public static final /* enum */ SkymallPerk EXTRA_POWDER;
        public static final /* enum */ SkymallPerk ABILITY_COOLDOWN;
        public static final /* enum */ SkymallPerk GOBLIN_CHANCE;
        public static final /* enum */ SkymallPerk TITANIUM;
        private static final /* synthetic */ SkymallPerk[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SkymallPerk(String chat, String itemString) {
            String string2 = this.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            this.patternName = StringsKt.replace$default(string2, "_", ".", false, 4, null);
            this.chatPattern$delegate = RepoPattern.Companion.pattern("mining.hotm.skymall.chat." + this.patternName, chat);
            this.itemPattern$delegate = RepoPattern.Companion.pattern("mining.hotm.skymall.item." + this.patternName, itemString);
        }

        @NotNull
        public final Pattern getChatPattern() {
            return (Pattern)this.chatPattern$delegate.getValue((Object)this, (KProperty<?>)$$delegatedProperties[0]);
        }

        @NotNull
        public final Pattern getItemPattern() {
            return (Pattern)this.itemPattern$delegate.getValue((Object)this, (KProperty<?>)$$delegatedProperties[1]);
        }

        public static SkymallPerk[] values() {
            return (SkymallPerk[])$VALUES.clone();
        }

        public static SkymallPerk valueOf(String value) {
            return Enum.valueOf(SkymallPerk.class, value);
        }

        @NotNull
        public static EnumEntries<SkymallPerk> getEntries() {
            return $ENTRIES;
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(SkymallPerk.class, "chatPattern", "getChatPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(SkymallPerk.class, "itemPattern", "getItemPattern()Ljava/util/regex/Pattern;", 0))};
            $$delegatedProperties = kPropertyArray;
            MINING_SPEED = new SkymallPerk("Gain \u00a7r\u00a76\\+100\u2e15 Mining Speed\u00a7r\u00a7f\\.", "Gain \u00a76\\+100\u2e15 Mining Speed\u00a77\\.");
            MINING_FORTUNE = new SkymallPerk("Gain \u00a7r\u00a76\\+50\u2618 Mining Fortune\u00a7r\u00a7f\\.", "Gain \u00a76\\+50\u2618 Mining Fortune\u00a77\\.");
            EXTRA_POWDER = new SkymallPerk("Gain \u00a7r\u00a7a\\+15% \u00a7r\u00a7fmore Powder while mining\\.", "Gain \u00a7a\\+15% \u00a77more Powder while mining\\.");
            ABILITY_COOLDOWN = new SkymallPerk("\u00a7r\u00a7a-20%\u00a7r\u00a7f Pickaxe Ability cooldowns\\.", "\u00a7a-20%\u00a77 Pickaxe Ability cooldowns\\.");
            GOBLIN_CHANCE = new SkymallPerk("\u00a7r\u00a7a10x \u00a7r\u00a7fchance to find Golden and Diamond Goblins\\.", "\u00a7a10x \u00a77chance to find Golden and");
            TITANIUM = new SkymallPerk("Gain \u00a7r\u00a7a5x \u00a7r\u00a79Titanium \u00a7r\u00a7fdrops", "Gain \u00a7a5x \u00a79Titanium \u00a77drops\\.");
            $VALUES = skymallPerkArray = new SkymallPerk[]{SkymallPerk.MINING_SPEED, SkymallPerk.MINING_FORTUNE, SkymallPerk.EXTRA_POWDER, SkymallPerk.ABILITY_COOLDOWN, SkymallPerk.GOBLIN_CHANCE, SkymallPerk.TITANIUM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

