/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.jcajce.spec.HybridValueParameterSpec;
import org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPPad;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.RFC6637Utils;
import org.bouncycastle.openpgp.operator.jcajce.JcaJcePGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.util.Arrays;

public class JcePublicKeyKeyEncryptionMethodGenerator
extends PublicKeyKeyEncryptionMethodGenerator {
    private static final byte X_HDR = 64;
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private SecureRandom random;
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();

    public JcePublicKeyKeyEncryptionMethodGenerator(PGPPublicKey pGPPublicKey) {
        super(pGPPublicKey);
    }

    public JcePublicKeyKeyEncryptionMethodGenerator setProvider(Provider provider2) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider2));
        this.keyConverter.setProvider(provider2);
        return this;
    }

    public JcePublicKeyKeyEncryptionMethodGenerator setProvider(String string) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(string));
        this.keyConverter.setProvider(string);
        return this;
    }

    public JcePublicKeyKeyEncryptionMethodGenerator setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    @Override
    protected byte[] encryptSessionInfo(PGPPublicKey pGPPublicKey, byte[] byArray2) throws PGPException {
        try {
            PublicKey publicKey = this.keyConverter.getPublicKey(pGPPublicKey);
            if (pGPPublicKey.getAlgorithm() == 18) {
                ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)pGPPublicKey.getPublicKeyPacket().getKey();
                String string = RFC6637Utils.getKeyEncryptionOID(eCDHPublicBCPGKey.getSymmetricKeyAlgorithm()).getId();
                PublicKeyPacket publicKeyPacket = pGPPublicKey.getPublicKeyPacket();
                if (eCDHPublicBCPGKey.getCurveOID().equals((ASN1Primitive)CryptlibObjectIdentifiers.curvey25519)) {
                    return this.getEncryptSessionInfo(publicKeyPacket, "X25519", publicKey, string, eCDHPublicBCPGKey.getSymmetricKeyAlgorithm(), byArray2, RFC6637Utils.getXDHAlgorithm(publicKeyPacket), keyPairGenerator -> keyPairGenerator.initialize(255, this.random), byArray -> Arrays.prepend((byte[])byArray, (byte)64));
                }
                return this.getEncryptSessionInfo(publicKeyPacket, "EC", publicKey, string, eCDHPublicBCPGKey.getSymmetricKeyAlgorithm(), byArray2, RFC6637Utils.getAgreementAlgorithm(publicKeyPacket), keyPairGenerator -> {
                    AlgorithmParameters algorithmParameters = this.helper.createAlgorithmParameters("EC");
                    algorithmParameters.init(new X962Parameters(eCDHPublicBCPGKey.getCurveOID()).getEncoded());
                    keyPairGenerator.initialize(algorithmParameters.getParameterSpec(AlgorithmParameterSpec.class), this.random);
                }, byArray -> {
                    if (null == byArray || byArray.length < 1 || byArray[0] != 4) {
                        byArray = JcaJcePGPUtil.getX9Parameters(eCDHPublicBCPGKey.getCurveOID()).getCurve().decodePoint(byArray).getEncoded(false);
                    }
                    return byArray;
                });
            }
            if (pGPPublicKey.getAlgorithm() == 25) {
                return this.getEncryptSessionInfo(pGPPublicKey, "X25519", publicKey, NISTObjectIdentifiers.id_aes128_wrap.getId(), 7, byArray2, "X25519withSHA256HKDF", 255);
            }
            if (pGPPublicKey.getAlgorithm() == 26) {
                return this.getEncryptSessionInfo(pGPPublicKey, "X448", publicKey, NISTObjectIdentifiers.id_aes256_wrap.getId(), 9, byArray2, "X448withSHA512HKDF", 448);
            }
            Cipher cipher2 = this.helper.createPublicKeyCipher(pGPPublicKey.getAlgorithm());
            cipher2.init(1, (Key)publicKey, this.random);
            return cipher2.doFinal(byArray2);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new PGPException("illegal block size: " + illegalBlockSizeException.getMessage(), illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new PGPException("bad padding: " + badPaddingException.getMessage(), badPaddingException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("key invalid: " + invalidKeyException.getMessage(), invalidKeyException);
        }
        catch (IOException iOException) {
            throw new PGPException("unable to encode MPI: " + iOException.getMessage(), iOException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PGPException("unable to set up ephemeral keys: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    private byte[] getEncryptSessionInfo(PublicKeyPacket publicKeyPacket, String string, PublicKey publicKey, String string2, int n, byte[] byArray, String string3, KeyPairGeneratorOperation keyPairGeneratorOperation, EphPubEncoding ephPubEncoding) throws GeneralSecurityException, IOException, PGPException {
        KeyPairGenerator keyPairGenerator = this.helper.createKeyPairGenerator(string);
        keyPairGeneratorOperation.initialize(keyPairGenerator);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        UserKeyingMaterialSpec userKeyingMaterialSpec = new UserKeyingMaterialSpec(RFC6637Utils.createUserKeyingMaterial(publicKeyPacket, new JcaKeyFingerprintCalculator()));
        Key key2 = JcaJcePGPUtil.getSecret(this.helper, publicKey, string2, string3, (AlgorithmParameterSpec)userKeyingMaterialSpec, keyPair.getPrivate());
        byte[] byArray2 = ephPubEncoding.getEphPubEncoding(SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded()).getPublicKeyData().getBytes());
        byte[] byArray3 = PGPPad.padSessionData(byArray, this.sessionKeyObfuscation);
        return JcePublicKeyKeyEncryptionMethodGenerator.getSessionInfo(byArray2, this.getWrapper(n, byArray, key2, byArray3));
    }

    private byte[] getEncryptSessionInfo(PGPPublicKey pGPPublicKey, String string, PublicKey publicKey, String string2, int n, byte[] byArray, String string3, int n2) throws GeneralSecurityException, IOException, PGPException {
        KeyPairGenerator keyPairGenerator = this.helper.createKeyPairGenerator(string);
        keyPairGenerator.initialize(n2, this.random);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        byte[] byArray2 = SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded()).getPublicKeyData().getBytes();
        HybridValueParameterSpec hybridValueParameterSpec = JcaJcePGPUtil.getHybridValueParameterSpecWithPrepend(byArray2, pGPPublicKey.getPublicKeyPacket(), string);
        Key key2 = JcaJcePGPUtil.getSecret(this.helper, publicKey, string2, string3, (AlgorithmParameterSpec)hybridValueParameterSpec, keyPair.getPrivate());
        byte[] byArray3 = new byte[byArray.length - 3];
        System.arraycopy(byArray, 1, byArray3, 0, byArray3.length);
        return JcePublicKeyKeyEncryptionMethodGenerator.getSessionInfo(byArray2, byArray[0], this.getWrapper(n, byArray, key2, byArray3));
    }

    private byte[] getWrapper(int n, byte[] byArray, Key key2, byte[] byArray2) throws PGPException, InvalidKeyException, IllegalBlockSizeException {
        Cipher cipher2 = this.helper.createKeyWrapper(n);
        cipher2.init(3, key2, this.random);
        return cipher2.wrap(new SecretKeySpec(byArray2, PGPUtil.getSymmetricCipherName(byArray[0])));
    }

    @FunctionalInterface
    private static interface EphPubEncoding {
        public byte[] getEphPubEncoding(byte[] var1);
    }

    @FunctionalInterface
    private static interface KeyPairGeneratorOperation {
        public void initialize(KeyPairGenerator var1) throws GeneralSecurityException, IOException;
    }
}

