/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.atomicfu;

import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.atomicfu.TraceBase;
import kotlinx.atomicfu.TraceFormat;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u001a\u001a\u00020\u0017\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\tJ'\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u000bJ/\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019R\u001c\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d\u00a8\u0006 "}, d2={"Lkotlinx/atomicfu/TraceImpl;", "Lkotlinx/atomicfu/TraceBase;", "", "event", "", "append", "(Ljava/lang/Object;)V", "event1", "event2", "(Ljava/lang/Object;Ljava/lang/Object;)V", "event3", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "event4", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "", "toString", "()Ljava/lang/String;", "Lkotlinx/atomicfu/TraceFormat;", "format", "Lkotlinx/atomicfu/TraceFormat;", "Ljava/util/concurrent/atomic/AtomicInteger;", "index", "Ljava/util/concurrent/atomic/AtomicInteger;", "", "mask", "I", "size", "", "trace", "[Ljava/lang/Object;", "<init>", "(ILkotlinx/atomicfu/TraceFormat;)V", "atomicfu"})
final class TraceImpl
extends TraceBase {
    @NotNull
    private final TraceFormat format;
    private final int size;
    private final int mask;
    @NotNull
    private final Object[] trace;
    @NotNull
    private final AtomicInteger index;

    public TraceImpl(int size2, @NotNull TraceFormat format) {
        Intrinsics.checkNotNullParameter(format, "format");
        this.format = format;
        if (!(size2 >= 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.size = Integer.highestOneBit((size2 << 1) - 1);
        this.mask = this.size - 1;
        this.trace = new Object[this.size];
        this.index = new AtomicInteger(0);
    }

    @Override
    public void append(@NotNull Object event) {
        Intrinsics.checkNotNullParameter(event, "event");
        int i = this.index.getAndIncrement();
        this.trace[i & this.mask] = event;
    }

    @Override
    public void append(@NotNull Object event1, @NotNull Object event2) {
        Intrinsics.checkNotNullParameter(event1, "event1");
        Intrinsics.checkNotNullParameter(event2, "event2");
        int i = this.index.getAndAdd(2);
        this.trace[i & this.mask] = event1;
        this.trace[i + 1 & this.mask] = event2;
    }

    @Override
    public void append(@NotNull Object event1, @NotNull Object event2, @NotNull Object event3) {
        Intrinsics.checkNotNullParameter(event1, "event1");
        Intrinsics.checkNotNullParameter(event2, "event2");
        Intrinsics.checkNotNullParameter(event3, "event3");
        int i = this.index.getAndAdd(3);
        this.trace[i & this.mask] = event1;
        this.trace[i + 1 & this.mask] = event2;
        this.trace[i + 2 & this.mask] = event3;
    }

    @Override
    public void append(@NotNull Object event1, @NotNull Object event2, @NotNull Object event3, @NotNull Object event4) {
        Intrinsics.checkNotNullParameter(event1, "event1");
        Intrinsics.checkNotNullParameter(event2, "event2");
        Intrinsics.checkNotNullParameter(event3, "event3");
        Intrinsics.checkNotNullParameter(event4, "event4");
        int i = this.index.getAndAdd(4);
        this.trace[i & this.mask] = event1;
        this.trace[i + 1 & this.mask] = event2;
        this.trace[i + 2 & this.mask] = event3;
        this.trace[i + 3 & this.mask] = event4;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int index = this.index.get();
        int start2 = index & this.mask;
        int i = index > this.size ? index - this.size : 0;
        int pos = start2;
        int cnt = 0;
        do {
            Object s;
            if ((s = this.trace[pos]) == null) continue;
            if (cnt++ > 0) {
                $this$toString_u24lambda_u240.append('\n');
            }
            $this$toString_u24lambda_u240.append(this.format.format(i, s));
            ++i;
        } while ((pos = pos + 1 & this.mask) != start2);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

