/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.vigilance.impl.nightconfig.toml;

import gg.skytils.vigilance.impl.nightconfig.core.CommentedConfig;
import gg.skytils.vigilance.impl.nightconfig.core.io.CharacterInput;
import gg.skytils.vigilance.impl.nightconfig.core.io.CharsWrapper;
import gg.skytils.vigilance.impl.nightconfig.core.io.ParsingException;
import gg.skytils.vigilance.impl.nightconfig.toml.StringParser;
import gg.skytils.vigilance.impl.nightconfig.toml.Toml;
import gg.skytils.vigilance.impl.nightconfig.toml.TomlFormat;
import gg.skytils.vigilance.impl.nightconfig.toml.TomlParser;
import gg.skytils.vigilance.impl.nightconfig.toml.ValueParser;
import java.util.ArrayList;
import java.util.List;

final class TableParser {
    private static final char[] KEY_END = new char[]{'\t', ' ', '=', '.', '\n', '\r', ']', ':'};

    static CommentedConfig parseInline(CharacterInput input2, TomlParser parser) {
        char after;
        CommentedConfig config2 = (CommentedConfig)TomlFormat.instance().createConfig();
        do {
            char keyFirst;
            if ((keyFirst = Toml.readNonSpaceChar(input2, false)) == '}') {
                return config2;
            }
            String key2 = TableParser.parseKey(input2, keyFirst, parser);
            char sep = Toml.readNonSpaceChar(input2, false);
            TableParser.checkInvalidSeparator(sep, key2, parser);
            Object value = ValueParser.parse(input2, parser);
            Object previous = parser.getParsingMode().put(config2.valueMap(), key2, value);
            TableParser.checkDuplicateKey(key2, previous, true);
            after = Toml.readNonSpaceChar(input2, false);
            if (after != '}') continue;
            return config2;
        } while (after == ',');
        throw new ParsingException("Invalid entry separator '" + after + "' in inline table.");
    }

    static <T extends CommentedConfig> T parseNormal(CharacterInput input2, TomlParser parser, T config2) {
        while (true) {
            ArrayList<CharsWrapper> commentsList;
            int keyFirst;
            if ((keyFirst = Toml.readUseful(input2, commentsList = new ArrayList<CharsWrapper>(2))) == -1 || keyFirst == 91) {
                parser.setComment(commentsList);
                return config2;
            }
            List<String> key2 = TableParser.parseDottedKey(input2, (char)keyFirst, parser);
            Object value = ValueParser.parse(input2, parser);
            Object previous = parser.getParsingMode().put(config2, key2, value);
            TableParser.checkDuplicateKey(key2, previous, parser.configWasEmpty());
            int after = Toml.readNonSpace(input2, false);
            if (after == -1) {
                return config2;
            }
            if (after == 35) {
                CharsWrapper comment = Toml.readLine(input2);
                commentsList.add(comment);
            } else if (after != 10 && after != 13) {
                throw new ParsingException("Invalid character '" + (char)after + "' after table entry \"" + key2 + "\" = " + value);
            }
            parser.setComment(commentsList);
            config2.setComment(key2, parser.consumeComment());
        }
    }

    private static void checkDuplicateKey(Object key2, Object previousValue, boolean emptyConfig) {
        if (previousValue != null && emptyConfig) {
            throw new ParsingException("Invalid TOML data: entry \"" + key2 + "\" defined twice in its table.");
        }
    }

    private static void checkInvalidSeparator(char sep, String key2, TomlParser parser) {
        if (!Toml.isKeyValueSeparator(sep, parser.isLenientWithSeparators())) {
            throw new ParsingException("Invalid separator '" + sep + "'after key \"" + key2 + "\" in some table.");
        }
    }

    static CommentedConfig parseNormal(CharacterInput input2, TomlParser parser) {
        return TableParser.parseNormal(input2, parser, (CommentedConfig)TomlFormat.instance().createConfig());
    }

    static List<String> parseTableName(CharacterInput input2, TomlParser parser, boolean array) {
        char separator;
        List<String> list = parser.createList();
        do {
            char after;
            char firstChar;
            if ((firstChar = Toml.readNonSpaceChar(input2, false)) == ']') {
                throw new ParsingException("Tables names must not be empty.");
            }
            String key2 = TableParser.parseKey(input2, firstChar, parser);
            list.add(key2);
            separator = Toml.readNonSpaceChar(input2, false);
            if (separator != ']') continue;
            if (array && (after = input2.readChar()) != ']') {
                throw new ParsingException("Invalid declaration of an element of an array of tables: it ends by ]" + after + " but should end by ]]");
            }
            after = Toml.readNonSpaceChar(input2, false);
            if (after == '#') {
                CharsWrapper comment = Toml.readLine(input2);
                parser.setComment(comment);
            } else if (after != '\n' && after != '\r') {
                throw new ParsingException("Invalid character '" + after + "' after a table declaration.");
            }
            return list;
        } while (separator == '.');
        throw new ParsingException("Invalid separator '" + separator + "' in table name.");
    }

    static List<String> parseDottedKey(CharacterInput input2, char firstChar, TomlParser parser) {
        List<String> list = parser.createList();
        char first2 = firstChar;
        while (true) {
            String part2 = TableParser.parseKey(input2, first2, parser);
            list.add(part2);
            char sep = Toml.readNonSpaceChar(input2, false);
            if (Toml.isKeyValueSeparator(sep, parser.isLenientWithSeparators())) {
                return list;
            }
            if (sep != '.') {
                throw new ParsingException("Invalid character '" + sep + "' after key " + list);
            }
            first2 = Toml.readNonSpaceChar(input2, false);
        }
    }

    static String parseKey(CharacterInput input2, char firstChar, TomlParser parser) {
        if (firstChar == '\"') {
            return StringParser.parseBasic(input2, parser);
        }
        if (firstChar == '\'') {
            return StringParser.parseLiteral(input2, parser);
        }
        CharsWrapper restOfKey = input2.readCharsUntil(KEY_END);
        String bareKey = new CharsWrapper.Builder(restOfKey.length() + 1).append(firstChar).append(restOfKey).toString();
        if (bareKey.isEmpty()) {
            throw new ParsingException("Empty bare keys aren't allowed.");
        }
        if (!Toml.isValidBareKey(bareKey, parser.isLenientWithBareKeys())) {
            throw new ParsingException("Invalid bare key: " + bareKey);
        }
        return bareKey;
    }

    private TableParser() {
    }
}

